/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.BroadcastReciver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import java.io.File;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppStoreMainView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppHttpDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppLocalDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.ViewDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.ViewDataManager3;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;

public class PackageInstalledReceiver
extends BroadcastReceiver
implements AppStoreConstant {
    private static Context mContext = null;
    private static Handler removedPackagehandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    AppBean appBean = null;
                    String pkgName = msg.obj.toString();
                    appBean = new AppBeanDao(mContext).getAppByPkgName(pkgName);
                    ViewDataManager.removeNativeApp(mContext, appBean);
                    break;
                }
            }
        }
    };

    public void onReceive(final Context context, Intent intent) {
        mContext = context;
        LogUtils.logDebug(intent.getAction() + " " + intent.getDataString());
        String action = intent.getAction();
        if ("android.intent.action.PACKAGE_ADDED".equals(intent.getAction())) {
            AppBean appBean;
            removedPackagehandler.removeMessages(0);
            LogUtils.logDebug("android.intent.action.PACKAGE_ADDED ");
            String pkg = this.getPkgNameFromIntent(intent);
            AppBean appBean2 = appBean = EUExAppStoreMgr.isVisibleAppStroe ? new AppBeanDao(context).getAppByPkgName(pkg) : ViewDataManager3.getInstance().getAppBean();
            if (appBean != null) {
                new AppBeanDao(context).updateAppState(appBean.getAppId(), 4, null);
                appBean.setState(4);
                String newAppVersion = AppUtils.gatNativeAppLocalVersionName(context, pkg);
                new AppBeanDao(context).updateAppVer(appBean, newAppVersion);
                appBean.setInstallVersion(newAppVersion);
                new AppBeanDao(context).updateNewAppState(appBean.getAppId(), 3);
                appBean.setNewApp(3);
                new AsyncTask<Object, Void, Void>(){

                    protected Void doInBackground(Object ... params) {
                        AppHttpDataManager.appInstallReport(context, appBean, EUExAppStoreMgr.getRootWData());
                        return null;
                    }
                }.execute(new Object[0]);
                LogUtils.logDebug("ANDROID_PACKAGE_ADDED pkgName:" + pkg + " " + appBean.getNewApp());
                AppStoreMainView mMyAppActivity = AppStoreMainView.getInstance();
                if (mMyAppActivity != null) {
                    mMyAppActivity.refreshLocalAppData();
                }
                mContext.sendBroadcast(AppStoreUtils.getNotifyDownloadIntent(mContext.getPackageName(), appBean.getAppId()));
                new AsyncTask<Object, Void, Void>(){

                    protected Void doInBackground(Object ... params) {
                        String apkPath = AppLocalDataManager.getApkPath(context, appBean.getAppId());
                        File apkFile = new File(apkPath);
                        apkFile.delete();
                        return null;
                    }
                }.execute(new Object[0]);
                if (!EUExAppStoreMgr.isVisibleAppStroe) {
                    EUExAppStoreMgr.cbLoadWidget(1, ViewDataManager3.getInstance().getAppBean(), null);
                }
            }
        } else if ("android.intent.action.PACKAGE_REMOVED".equals(intent.getAction())) {
            LogUtils.logDebug("android.intent.action.PACKAGE_REMOVED");
            String packageName = this.getPkgNameFromIntent(intent);
            if (TextUtils.isEmpty((CharSequence)packageName)) {
                return;
            }
            Message msg = new Message();
            msg.what = 0;
            msg.obj = packageName;
            removedPackagehandler.sendMessageDelayed(msg, 3000L);
        } else if ("android.intent.action.PACKAGE_REPLACED".equals(intent.getAction())) {
            removedPackagehandler.removeMessages(0);
        }
    }

    private String getPkgNameFromIntent(Intent intent) {
        String[] infoList;
        String pkgName = "";
        String packageInfo = intent.getDataString();
        LogUtils.logDebug("packageInfo:" + packageInfo);
        if (!TextUtils.isEmpty((CharSequence)packageInfo) && (infoList = packageInfo.split(":")) != null && infoList.length > 1) {
            pkgName = infoList[1];
        }
        return pkgName;
    }
}

