/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppListViewBaseActivity;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppStoreMainView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.adapter.AppListViewAdapter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppStoteDataParser;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoreURLMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoteHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreTokenUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.DialogView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.XListView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStatusVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.UserInfoVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class CategoryAppListActivity
extends AppListViewBaseActivity
implements AppStoreConstant {
    private XListView list;
    private TextView title;
    private AppListViewAdapter adapter;
    private ImageView back;
    private Context mContext;
    private JSONObject searchAppListParams = new JSONObject();
    private String indexIdDown;
    private String categoryName;
    private WWidgetData mWgtData;
    private AsyncTask<Void, Void, ArrayList<AppBean>> asyncTask = null;
    private AsyncTask<Void, Void, ArrayList<AppBean>> asyncTaskPullDown = null;
    private AsyncTask<Void, Void, ArrayList<AppBean>> asyncTaskPullUp = null;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_app_listview"));
        this.mContext = this;
        try {
            Intent intent = this.getIntent();
            this.categoryName = intent.getStringExtra("categoryName");
            this.mWgtData = (WWidgetData)intent.getParcelableExtra("currentWidgetData");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        String softToken = AppStoreTokenUtils.getSoftToken((Context)this);
        if (softToken == null || softToken.length() == 0) {
            Toast.makeText((Context)this, (CharSequence)EUExUtil.getString((String)"plugin_appstore_soft_token_null"), (int)0).show();
            this.finish();
            return;
        }
        this.title = (TextView)this.findViewById(EUExUtil.getResIdID((String)"centerTitle"));
        this.list = (XListView)this.findViewById(EUExUtil.getResIdID((String)"appListView"));
        this.list.setPullLoadEnable(true);
        this.list.setPullRefreshEnable(true);
        this.list.setXListViewListener(new ListViewIXListViewListener(this.list));
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        String time = sdf.format(new Date());
        this.list.setRefreshTime(time);
        this.back = (ImageView)this.findViewById(EUExUtil.getResIdID((String)"back"));
        this.back.setImageResource(EUExUtil.getResDrawableID((String)"plugin_appstoremgr_back"));
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CategoryAppListActivity.this.finish();
            }
        });
        this.title.setText((CharSequence)this.categoryName);
        View titleLayout = this.findViewById(EUExUtil.getResIdID((String)"title"));
        if (AppStoreMainView.TITLE_HEIGHT > 0) {
            ViewGroup.LayoutParams lp = titleLayout.getLayoutParams();
            lp.height = AppStoreMainView.TITLE_HEIGHT;
            titleLayout.setLayoutParams(lp);
        }
        try {
            this.searchAppListParams.put("softToken", (Object)softToken);
            this.searchAppListParams.put("pageSize", (Object)"10");
            this.searchAppListParams.put("appType", (Object)this.categoryName);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (this.adapter == null) {
            this.downloadAppList(this.searchAppListParams, UserInfoVO.toSpKeyString() + this.categoryName);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }

    private void downloadAppList(final JSONObject appListParamsJson, final String cacheKey) {
        final String resCache = SharedPrefUtils.getString(this.mContext, "main_prefs", cacheKey, "");
        if (!NetworkUtils.isOnline(this.mContext) && TextUtils.isEmpty((CharSequence)resCache)) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            return;
        }
        if (this.asyncTask != null) {
            return;
        }
        this.asyncTask = new AsyncTask<Void, Void, ArrayList<AppBean>>(){
            Dialog progressDialog = null;

            protected void onPreExecute() {
                this.progressDialog = DialogView.showLoadingDialog(CategoryAppListActivity.this.mContext, EUExUtil.getString((String)"plugin_appstore_load_app_list"));
                this.progressDialog.show();
            }

            protected ArrayList<AppBean> doInBackground(Void ... params) {
                ArrayList<AppBean> appList = null;
                try {
                    String response = AppStoteHttpURLConnection.downLoadAppList(AppStoreURLMgr.getUrlSearchList(), CategoryAppListActivity.this.mContext, CategoryAppListActivity.this.mWgtData, appListParamsJson).getResult();
                    if (!TextUtils.isEmpty((CharSequence)response)) {
                        appList = AppStoteDataParser.parseAppListWithKey("appList", response);
                        SharedPrefUtils.putString(CategoryAppListActivity.this.mContext, "main_prefs", cacheKey, response);
                    } else if (!AppStatusVO.isForceConnected() && !TextUtils.isEmpty((CharSequence)resCache)) {
                        appList = AppStoteDataParser.parseAppListWithKey("appList", resCache);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return appList;
            }

            protected void onPostExecute(ArrayList<AppBean> result) {
                if (this.isCancelled()) {
                    CategoryAppListActivity.this.asyncTask = null;
                    return;
                }
                if (this.progressDialog != null) {
                    this.progressDialog.dismiss();
                }
                if (result == null || result.size() == 0) {
                    Toast.makeText((Context)CategoryAppListActivity.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_data"), (int)0).show();
                    CategoryAppListActivity.this.asyncTask = null;
                    return;
                }
                try {
                    int leng = result.size() - 1;
                    CategoryAppListActivity.this.indexIdDown = result.get(leng).getIndexId();
                    if (null == CategoryAppListActivity.this.adapter) {
                        CategoryAppListActivity.this.adapter = new AppListViewAdapter(CategoryAppListActivity.this.mContext, CategoryAppListActivity.this.mWgtData, result);
                        CategoryAppListActivity.this.list.setAdapter((ListAdapter)CategoryAppListActivity.this.adapter);
                        CategoryAppListActivity.this.downloadStateRcv.updateAdapter(CategoryAppListActivity.this.adapter);
                    } else {
                        CategoryAppListActivity.this.adapter.reload(result);
                    }
                }
                catch (Exception e) {
                    Toast.makeText((Context)CategoryAppListActivity.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_data"), (int)0).show();
                    e.printStackTrace();
                }
                CategoryAppListActivity.this.asyncTask = null;
            }
        };
        this.asyncTask.execute((Object[])new Void[0]);
    }

    private void refreshData(final XListView listView, final JSONObject jsonParams) {
        if (!NetworkUtils.isOnline(this.mContext)) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            listView.stopRefresh();
            return;
        }
        if (this.asyncTaskPullDown != null) {
            return;
        }
        this.asyncTaskPullDown = new AsyncTask<Void, Void, ArrayList<AppBean>>(){

            protected ArrayList<AppBean> doInBackground(Void ... params) {
                String response = AppStoteHttpURLConnection.downLoadAppList(AppStoreURLMgr.getUrlSearchList(), CategoryAppListActivity.this.mContext, CategoryAppListActivity.this.mWgtData, jsonParams).getResult();
                ArrayList<AppBean> niceApps = AppStoteDataParser.parseAppListWithKey("appList", response);
                return niceApps;
            }

            protected void onPostExecute(final ArrayList<AppBean> result) {
                if (this.isCancelled()) {
                    CategoryAppListActivity.this.asyncTaskPullDown = null;
                    return;
                }
                CategoryAppListActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (result == null || result.size() == 0) {
                            listView.stopRefresh();
                            CategoryAppListActivity.this.asyncTaskPullDown = null;
                            return;
                        }
                        if (CategoryAppListActivity.this.adapter != null) {
                            CategoryAppListActivity.this.adapter.reload(result);
                        } else {
                            CategoryAppListActivity.this.adapter = new AppListViewAdapter(CategoryAppListActivity.this.mContext, CategoryAppListActivity.this.mWgtData, result);
                            listView.setAdapter((ListAdapter)CategoryAppListActivity.this.adapter);
                            CategoryAppListActivity.this.downloadStateRcv.updateAdapter(CategoryAppListActivity.this.adapter);
                        }
                        listView.stopRefresh();
                        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
                        String time = sdf.format(new Date());
                        listView.setRefreshTime(time);
                    }
                });
                CategoryAppListActivity.this.asyncTaskPullDown = null;
            }
        };
        this.asyncTaskPullDown.execute((Object[])new Void[0]);
    }

    private void loadMoreData(final XListView listView, final JSONObject pramsJson) {
        if (!NetworkUtils.isOnline(this.mContext)) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            listView.stopLoadMore();
            return;
        }
        if (this.asyncTaskPullUp != null) {
            return;
        }
        this.asyncTaskPullUp = new AsyncTask<Void, Void, ArrayList<AppBean>>(){

            protected ArrayList<AppBean> doInBackground(Void ... params) {
                String response = AppStoteHttpURLConnection.downLoadAppList(AppStoreURLMgr.getUrlSearchList(), CategoryAppListActivity.this.mContext, CategoryAppListActivity.this.mWgtData, pramsJson).getResult();
                ArrayList<AppBean> niceApps = AppStoteDataParser.parseAppListWithKey("appList", response);
                return niceApps;
            }

            protected void onPostExecute(final ArrayList<AppBean> result) {
                if (this.isCancelled()) {
                    CategoryAppListActivity.this.asyncTaskPullUp = null;
                    return;
                }
                CategoryAppListActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (result == null || result.size() == 0) {
                            listView.stopLoadMore();
                            Toast.makeText((Context)CategoryAppListActivity.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_more_data"), (int)0).show();
                            CategoryAppListActivity.this.asyncTaskPullUp = null;
                            return;
                        }
                        int length = result.size() - 1;
                        CategoryAppListActivity.this.indexIdDown = ((AppBean)result.get(length)).getIndexId();
                        if (CategoryAppListActivity.this.adapter != null) {
                            CategoryAppListActivity.this.adapter.addList(result);
                        } else {
                            CategoryAppListActivity.this.adapter = new AppListViewAdapter(CategoryAppListActivity.this.mContext, CategoryAppListActivity.this.mWgtData, result);
                            listView.setAdapter((ListAdapter)CategoryAppListActivity.this.adapter);
                            CategoryAppListActivity.this.downloadStateRcv.updateAdapter(CategoryAppListActivity.this.adapter);
                        }
                        listView.stopLoadMore();
                    }
                });
                CategoryAppListActivity.this.asyncTaskPullUp = null;
            }
        };
        this.asyncTaskPullUp.execute((Object[])new Void[0]);
    }

    class ListViewIXListViewListener
    implements XListView.IXListViewListener {
        XListView mListView;

        public ListViewIXListViewListener(XListView listView) {
            this.mListView = listView;
        }

        @Override
        public void onRefresh() {
            JSONObject pullDownParamsJson = CategoryAppListActivity.this.searchAppListParams;
            try {
                pullDownParamsJson.put("action", (Object)"up");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            CategoryAppListActivity.this.refreshData(this.mListView, pullDownParamsJson);
        }

        @Override
        public void onLoadMore() {
            JSONObject upDownParamsJson = CategoryAppListActivity.this.searchAppListParams;
            try {
                upDownParamsJson.put("action", (Object)"down");
                upDownParamsJson.put("indexId", (Object)CategoryAppListActivity.this.indexIdDown);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            CategoryAppListActivity.this.loadMoreData(this.mListView, upDownParamsJson);
        }
    }
}

