/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.apptile;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.AsyncTask;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ExpandableListAdapter;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppListBaseView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.apptile.TileListMgrAdapter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppStoteDataParser;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppTaskList;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoreURLMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoteHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreTokenUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ViewFrameConfig;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ViewUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.DialogView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.XExpandableListView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class TileListMgrView
extends AppListBaseView
implements AppStoreConstant {
    public static int TITLE_HEIGHT = 0;
    public static int AD_HEIGHT = 0;
    public static int PAGER_TOP = 10;
    public static int ROWS = 3;
    public static int DEFAULT_ITEM_HEIGHT = 130;
    public static final int ACTION_ADD_APP_CODE = 0;
    public static final int GRID_ITEMS_PER_PAGER = 8;
    private XExpandableListView mTileListMgrGridView;
    private TileListMgrAdapter tileMgrAdapter;
    public static String IS_VISIBLE = "";
    public static final String TAG = "TileListMgrActivity";
    public static final String INTENT_KEY_URL = "url";
    private static AppTaskList appsTaskList = new AppTaskList();
    private ViewFrameConfig mViewFrameConfig = new ViewFrameConfig();
    private int mainActivityHeight;
    private EUExAppStoreMgr mEuExAppStoreMgr;
    private WWidgetData mWgtData;
    private Context mContext;

    public TileListMgrView(Context context, EUExAppStoreMgr appStoreMgr, WWidgetData mWidgetData, ViewFrameConfig vConfig, int height, float scale) {
        super(context);
        this.mContext = context;
        EUExUtil.init((Context)context);
        this.mEuExAppStoreMgr = appStoreMgr;
        this.mWgtData = mWidgetData;
        this.mViewFrameConfig = vConfig;
        this.mainActivityHeight = height;
        this.init(scale);
    }

    private void init(float scale) {
        LayoutInflater.from((Context)this.mContext).inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_more_tiles_layout"), (ViewGroup)this, true);
        this.setupNewUI();
        this.downloadTileList();
        if (scale == 0.0f) {
            final View contextView = ((Activity)this.mContext).getWindow().getDecorView();
            ViewTreeObserver vto = contextView.getViewTreeObserver();
            vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    int height = contextView.getMeasuredHeight();
                    int width = contextView.getMeasuredWidth();
                    LogUtils.logDebug("onGlobalLayoutheight==" + height + " width==" + width);
                    TITLE_HEIGHT = TileListMgrView.this.mainActivityHeight - height;
                    System.out.println("mainActivityHeight:" + TileListMgrView.this.mainActivityHeight + " height:" + height);
                    contextView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            });
        } else {
            TITLE_HEIGHT = (int)(this.mViewFrameConfig.y * scale);
            System.out.println("TITLE_HEIGHT:" + TITLE_HEIGHT + " scale:" + scale);
        }
    }

    private void downloadTileList() {
        new AsyncTask<Void, Void, List<AppBean>>(){
            Dialog progressDialog = null;

            protected void onPreExecute() {
                this.progressDialog = DialogView.showLoadingDialog(TileListMgrView.this.mContext, EUExUtil.getString((String)"plugin_appstore_load_app_list"));
                this.progressDialog.show();
            }

            protected List<AppBean> doInBackground(Void ... params) {
                JSONObject jsonParam = new JSONObject();
                try {
                    jsonParam.put("softToken", (Object)AppStoreTokenUtils.getSoftToken(TileListMgrView.this.mContext));
                    jsonParam.put("iswantTiles", (Object)"F");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                String result = AppStoteHttpURLConnection.downLoadAppList(AppStoreURLMgr.getUrlSearchList(), TileListMgrView.this.mContext, TileListMgrView.this.mWgtData, jsonParam).getResult();
                ArrayList<AppBean> appList = AppStoteDataParser.parseAppListWithKey("appList", result);
                return appList;
            }

            protected void onPostExecute(List<AppBean> appList) {
                TileListMgrView.this.refreshAppTileData(appList);
                this.progressDialog.cancel();
            }
        }.execute((Object[])new Void[0]);
    }

    private void setupNewUI() {
        this.mTileListMgrGridView = (XExpandableListView)this.findViewById(EUExUtil.getResIdID((String)"more_app_tile_expandview"));
        this.mTileListMgrGridView.setPullLoadEnable(false);
        this.mTileListMgrGridView.setPullRefreshEnable(false);
    }

    private void updateTilseUI(List<AppBean> appList) {
        if (null == this.tileMgrAdapter) {
            List<AppBean> installList = AppBean.filterInstallApp(this.mContext, appList);
            if (null == installList || 0 == installList.size()) {
                ViewUtils.showToast(this.mContext, EUExUtil.getString((String)"plugin_appstore_hint_no_data"), 0);
            }
            this.tileMgrAdapter = new TileListMgrAdapter(this.mContext, installList, this.mTileListMgrGridView);
            this.mTileListMgrGridView.setAdapter((ExpandableListAdapter)this.tileMgrAdapter);
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (this.mEuExAppStoreMgr != null) {
            this.mEuExAppStoreMgr.closeMoreTiles(new String[0]);
        }
        super.onDetachedFromWindow();
    }

    private void refreshAppTileData(List<AppBean> appList) {
        this.updateTilseUI(appList);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                if (appsTaskList != null && !appsTaskList.isEmpty()) {
                    LogUtils.logDebug("onBackKeyDown with AppTaskList isn't null");
                    return true;
                }
                LogUtils.logDebug("onBackKeyDown");
                return false;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                return false;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public AppTaskList getAppsTaskList() {
        return appsTaskList;
    }

    public static AppTaskList getAppsTaskList2() {
        return appsTaskList;
    }

    public void setEUExAppStoreMgr(EUExAppStoreMgr uexAppStoreMgr) {
        this.mEuExAppStoreMgr = uexAppStoreMgr;
    }

    public void finishWidget(String appId) {
        this.mEuExAppStoreMgr.cbToFinishWidget(appId);
    }
}

