/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.encryption;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;

public class RC4Encryption
implements AppStoreConstant {
    private static final String F_KEY = "982398e4^$%^&%^&%^&%&^$#$#sdfsda90239%^)f8y99e7we98\t\t\t yhfdsuyf892yr98ghwequifyh879esa6yf83g2ui1rfgtvbiygf\t\t\t 9218374e8923yhr32hjfklsdahfjsadhjkfsadfbhdjkdsahfuy\t\t\t 28973yr^%UBFG%^&*IO^bjk789234y6cxzv98324df96621378*\t\t\t ^&$69879872364327848e^$%^$*(&(&wrtf32fuihewr87ft872";
    private static final String F_ENDSTR = "3G2WIN Safe Guard";
    private static final int[] sk = new int[]{137, 114, 170, 76, 12, 86, 207, 97, 54, 1, 15, 171, 49, 84, 139, 73, 128, 196, 144, 122, 53, 9, 157, 102, 150, 29, 61, 246, 179, 159, 131, 156, 85, 11, 163, 123, 237, 74, 116, 165, 66, 75, 168, 234, 22, 166, 224, 120, 162, 37, 28, 71, 239, 25, 112, 130, 124, 226, 175, 103, 223, 161, 173, 26, 154, 143, 247, 221, 51, 92, 132, 225, 78, 42, 10, 195, 87, 248, 242, 99, 187, 17, 153, 7, 67, 121, 214, 2, 80, 65, 245, 183, 215, 30, 222, 110, 250, 252, 208, 167, 63, 188, 44, 190, 129, 189, 50, 23, 14, 126, 241, 146, 140, 34, 212, 21, 182, 57, 48, 104, 113, 135, 6, 148, 160, 20, 115, 191, 58, 147, 3, 33, 69, 194, 151, 193, 47, 117, 111, 39, 19, 206, 46, 192, 38, 91, 253, 56, 27, 40, 105, 45, 184, 18, 145, 200, 164, 70, 98, 155, 88, 149, 62, 201, 4, 209, 13, 232, 106, 210, 142, 43, 32, 180, 90, 16, 95, 218, 82, 118, 100, 186, 231, 35, 220, 138, 96, 83, 174, 158, 198, 55, 109, 217, 176, 136, 185, 172, 229, 202, 0, 204, 177, 197, 211, 64, 254, 31, 141, 24, 203, 152, 108, 8, 133, 205, 219, 52, 213, 107, 236, 41, 233, 89, 59, 178, 249, 228, 238, 227, 79, 244, 169, 216, 77, 235, 255, 181, 134, 93, 243, 94, 101, 119, 72, 81, 251, 240, 60, 230, 199, 36, 125, 68, 5, 127};

    private static void swap(int[] pInts, int i, int j) {
        int temp = pInts[i];
        pInts[i] = pInts[j];
        pInts[j] = temp;
    }

    private static void re_S(int[] S) {
        int i = sk.length;
        System.arraycopy(sk, 0, S, 0, i);
    }

    private static void re_T(int[] T, String key) {
        int keylen = key.length();
        byte[] keys = key.getBytes();
        for (int i = 0; i < 256; ++i) {
            int k = i % keylen;
            T[i] = keys[k];
        }
    }

    private static void re_Sbox(int[] S, int[] T) {
        int j = 0;
        for (int i = 0; i < 256; ++i) {
            j = (j + S[i] + T[i]) % 256;
            RC4Encryption.swap(S, i, j);
        }
    }

    private static void re_RC4(int[] S, String key) {
        int[] T = new int[256];
        RC4Encryption.re_S(S);
        RC4Encryption.re_T(T, key);
        RC4Encryption.re_Sbox(S, T);
    }

    private static int RC4(int[] src, int n, int[] dest, String key) {
        int[] S = new int[256];
        RC4Encryption.re_RC4(S, key);
        int j = 0;
        int i = 0;
        for (int nIndex = 0; nIndex < n; ++nIndex) {
            i = (i + 1) % 256;
            j = (j + S[i]) % 256;
            RC4Encryption.swap(S, i, j);
            int t = (S[i] + S[j] % 256) % 256;
            dest[nIndex] = src[nIndex] ^ S[t];
        }
        return n;
    }

    public static byte[] encryption(byte[] pBuffer, int n, String pKey) {
        int ch;
        ByteArrayInputStream in = new ByteArrayInputStream(pBuffer);
        int[] newInt = new int[in.available()];
        int[] resInt = new int[in.available()];
        int i = 0;
        while ((ch = in.read()) != -1) {
            newInt[i] = ch;
            ++i;
        }
        RC4Encryption.RC4(newInt, n, resInt, pKey);
        byte[] newData = new byte[n];
        for (int k = 0; k < n; ++k) {
            newData[k] = (byte)resInt[k];
        }
        return newData;
    }

    public static byte[] htmlEncryption(byte[] src) {
        int n = src.length;
        if (RC4Encryption.stricmp(n, F_ENDSTR, src)) {
            return RC4Encryption.encryption(src, n - F_ENDSTR.length(), F_KEY);
        }
        return null;
    }

    private static boolean stricmp(int size, String endStr, byte[] inByte) {
        if (size <= endStr.length() || endStr == null || endStr.length() == 0 || inByte == null || inByte.length == 0) {
            return false;
        }
        try {
            int i = endStr.getBytes("utf-8").length;
            int k = inByte.length;
            byte[] testByte = new byte[i];
            System.arraycopy(inByte, k - i, testByte, 0, i);
            String test = new String(testByte, "utf-8");
            if (endStr.equals(test)) {
                return true;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return false;
    }
}

