/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.imageloader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;

public class BytesArrayFactory {
    private static BytesArrayFactory factory;
    private LinkedList<BytesArray> linkedList;
    private int maxSize;

    private BytesArrayFactory(int maxSize) {
        this.maxSize = maxSize;
        this.linkedList = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BytesArrayFactory getInstance(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException(" BytesArrayFactory size can't less than zero!");
        }
        if (factory != null) return factory;
        Class<BytesArrayFactory> clazz = BytesArrayFactory.class;
        synchronized (BytesArrayFactory.class) {
            if (factory != null) return factory;
            factory = new BytesArrayFactory(maxSize);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return factory;
        }
    }

    public static BytesArrayFactory getDefaultInstance() {
        return BytesArrayFactory.getInstance(10);
    }

    public synchronized BytesArray requestBytesArray() {
        BytesArray array = null;
        array = this.linkedList.size() > 0 ? this.linkedList.removeFirst() : new BytesArray();
        return array;
    }

    public synchronized BytesArray requestBytesArray(int size) {
        BytesArray array = null;
        if (this.linkedList.size() > 0) {
            array = this.linkedList.removeFirst();
            array.ensureCapacity(size);
        } else {
            array = new BytesArray(size);
        }
        return array;
    }

    public synchronized void releaseBytesArray(BytesArray array) {
        if (array != null && this.linkedList.size() < this.maxSize) {
            this.linkedList.addLast(array);
            array.reset();
        }
    }

    public synchronized int computeSize() {
        int size = 0;
        for (BytesArray array : this.linkedList) {
            size += array.capacity();
        }
        LogUtils.logDebug("BytesArrayManager itemSize:" + this.linkedList.size() + "  totalSize:" + size / 1024 + "KB");
        return size;
    }

    public static class BytesArray
    extends ByteArrayOutputStream {
        public BytesArray() {
            super(4096);
        }

        public BytesArray(int capacity) {
            super(capacity);
        }

        public BytesArray(byte[] buffer, int length) {
            super(0);
            if (buffer == null) {
                throw new NullPointerException("NullPointer");
            }
            if (length > buffer.length) {
                throw new IllegalArgumentException("Length can't large than array's length");
            }
            this.buf = buffer;
            this.count = length;
        }

        public byte[] getData() {
            return this.buf;
        }

        public void setCount(int count) {
            if (count < 0 || count > this.buf.length) {
                throw new IllegalArgumentException("count can't less than zero or large than " + this.buf.length);
            }
            this.count = count;
        }

        public int capacity() {
            return this.buf.length;
        }

        public int offset() {
            return 0;
        }

        public void ensureCapacity(int size) {
            if (size <= this.buf.length) {
                return;
            }
            byte[] newbuf = new byte[size];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }

        public ByteArrayInputStream asInputStream() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }

        public boolean readInputStream(InputStream is, int offset, int length) {
            if (is == null) {
                throw new NullPointerException("NullPointer!");
            }
            if (offset < 0 || length < 0) {
                throw new IllegalArgumentException("skip and length error!");
            }
            boolean isRead = false;
            try {
                is.skip(offset);
                int readCount = is.read(this.buf, 0, length);
                if (readCount == length) {
                    isRead = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return isRead;
        }
    }
}

