/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.utils;

import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.zywx.wbpalmstar.base.zip.CnZipInputStream;
import org.zywx.wbpalmstar.base.zip.ZipEntry;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;

public class FileUtils
implements AppStoreConstant {
    public static File rename(File tmpFile) {
        if (tmpFile == null) {
            return null;
        }
        if (tmpFile.exists()) {
            if (!tmpFile.getAbsolutePath().endsWith(".zip")) {
                String path = tmpFile.getAbsolutePath();
                File newFile = new File(path = path.substring(0, path.lastIndexOf(".")) + ".zip");
                if (tmpFile.renameTo(newFile)) {
                    tmpFile = newFile;
                }
            }
            return tmpFile;
        }
        return null;
    }

    public static File renameApk(File tmpFile) {
        return FileUtils.rename(tmpFile, "apk");
    }

    public static void DeleteFile(File file) {
        if (file.isFile()) {
            file.delete();
            return;
        }
        if (file.isDirectory()) {
            File[] childFile = file.listFiles();
            if (childFile == null || childFile.length == 0) {
                file.delete();
                return;
            }
            for (File f : childFile) {
                FileUtils.DeleteFile(f);
            }
            file.delete();
        }
    }

    public static File rename(File tmpFile, String suffix) {
        if (tmpFile == null) {
            return null;
        }
        if (tmpFile.exists()) {
            if (!tmpFile.getAbsolutePath().endsWith(".zip")) {
                String path = tmpFile.getAbsolutePath();
                File newFile = new File(path = path.substring(0, path.lastIndexOf(".")) + "." + suffix);
                if (tmpFile.renameTo(newFile)) {
                    tmpFile = newFile;
                }
            }
            return tmpFile;
        }
        return null;
    }

    public static FileInputStream getFileInputStream(String fileName) {
        FileInputStream fis = null;
        if (!TextUtils.isEmpty((CharSequence)fileName)) {
            File file = new File(fileName);
            try {
                fis = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return fis;
    }

    public static String getSdDir() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    public static File[] getListFilesFromDir(String dirPath) {
        File[] filesList = null;
        File fileDir = new File(dirPath);
        if (fileDir.isDirectory()) {
            filesList = fileDir.listFiles();
        }
        return filesList;
    }

    public static boolean isExistConfigFile(File fileDir) {
        boolean isExistConfigFile = false;
        if (fileDir.isDirectory()) {
            File configFile = new File(fileDir, "config.xml");
            isExistConfigFile = configFile.exists();
        }
        return isExistConfigFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String unzip(InputStream inputStream, String decompression, String encoding) {
        if (encoding == null || encoding.equals("")) {
            encoding = "utf-8";
        }
        String installPath = null;
        File dir = new File(decompression);
        CnZipInputStream zis = null;
        FileOutputStream out = null;
        try {
            zis = new CnZipInputStream(inputStream, encoding);
            ZipEntry file = zis.getNextEntry();
            installPath = dir.getAbsolutePath() + "/" + file.getName();
            byte[] c = new byte[1024];
            while (file != null) {
                File files;
                String zename = file.getName();
                if (file.isDirectory()) {
                    files = new File(dir.getAbsolutePath() + "/" + zename);
                    files.mkdirs();
                } else {
                    int slen;
                    files = new File(dir.getAbsolutePath() + "/" + zename).getParentFile();
                    if (!files.exists()) {
                        files.mkdirs();
                    }
                    out = new FileOutputStream(dir.getAbsolutePath() + "/" + zename);
                    while ((slen = zis.read(c, 0, c.length)) != -1) {
                        out.write(c, 0, slen);
                    }
                    out.close();
                }
                file = zis.getNextEntry();
            }
        }
        catch (Exception e) {
            installPath = null;
            e.printStackTrace();
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return installPath;
    }

    public static File createExternalCacheFile(Context context, AppBean appBean) {
        String sdCard;
        String mPath;
        File filePath = null;
        if (Environment.getExternalStorageState().equals("mounted") && !(filePath = new File(mPath = (sdCard = FileUtils.getSdDir()) + "/widgetone/temp/download/")).exists()) {
            filePath.mkdirs();
        }
        return new File(filePath, appBean.getAppId() + ".tmp");
    }

    public static boolean isExistSdcard() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static long getSDFreeSize() {
        File path = Environment.getExternalStorageDirectory();
        StatFs sf = new StatFs(path.getPath());
        long blockSize = sf.getBlockSize();
        long freeBlocks = sf.getAvailableBlocks();
        return freeBlocks * blockSize / 1024L / 1024L;
    }

    public static long getSDAllSize() {
        File path = Environment.getExternalStorageDirectory();
        StatFs sf = new StatFs(path.getPath());
        long blockSize = sf.getBlockSize();
        long allBlocks = sf.getBlockCount();
        return allBlocks * blockSize / 1024L / 1024L;
    }
}

