/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import java.lang.reflect.Field;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;

public class CircleProgress
extends View {
    private Paint paint = new Paint();
    private RectF mOval;
    private int roundColor;
    private int roundProgressColor;
    private int textColor;
    private float textSize;
    private float roundWidth;
    private int maxValue;
    private int progress;
    private boolean textIsDisplayable;
    private int style;
    public static final int STROKE = 0;
    public static final int FILL = 1;
    private static final int DEFAULT_STYLE = 0;
    private static final int DEFAULT_ROUND_COLOR = -65536;
    private static final int DEFAULT_ROUND_PROGRESS_COLOR = -16711936;
    private static final int DEFAULT_TEXT_COLOR = -16711936;
    private static final int DEFAULT_TEXT_SIZE = 15;
    private static final int DEFAULT_ROUND_WIDTH = 5;
    private static final int DEFAULT_MAX_VALUE = 100;
    private static final boolean DEFAULT_TEXT_DISPLAYABLE = true;
    private static final String CUSTOM_CLASS = "plugin_appstoremgr_circle_progress_";
    private static final String ROUND_COLOR = "plugin_appstoremgr_round_color";
    private static final String ROUND_PROGRESS_COLOR = "plugin_appstoremgr_round_progress_color";
    private static final String ROUND_WIDTH = "plugin_appstoremgr_round_width";
    private static final String TEXT_COLOR = "plugin_appstoremgr_text_color";
    private static final String TEXT_SIZE = "plugin_appstoremgr_text_size";
    private static final String MAX_VALUE = "plugin_appstoremgr_max_value";
    private static final String TEXT_DISPLAYABLE = "plugin_appstoremgr_text_is_displayable";
    private static final String STYLE = "plugin_appstoremgr_style";
    private static final String RES_TYPE = "styleable";
    private boolean isPause = false;

    public CircleProgress(Context context) {
        this(context, null);
    }

    public CircleProgress(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public static Object getResourceId(Context context, String name, String type) {
        String className = context.getPackageName() + ".R";
        try {
            Class<?> cls = Class.forName(className);
            for (Class<?> childClass : cls.getClasses()) {
                String simple = childClass.getSimpleName();
                if (!simple.equals(type)) continue;
                for (Field field : childClass.getFields()) {
                    String fieldName = field.getName();
                    if (!fieldName.equals(name)) continue;
                    return field.get(null);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public CircleProgress(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int[] styleAttrs = new int[]{EUExUtil.getResAttrID((String)ROUND_COLOR), EUExUtil.getResAttrID((String)ROUND_PROGRESS_COLOR), EUExUtil.getResAttrID((String)ROUND_WIDTH), EUExUtil.getResAttrID((String)TEXT_COLOR), EUExUtil.getResAttrID((String)TEXT_SIZE), EUExUtil.getResAttrID((String)MAX_VALUE), EUExUtil.getResAttrID((String)TEXT_DISPLAYABLE), EUExUtil.getResAttrID((String)STYLE)};
        TypedArray mTypedArray = context.obtainStyledAttributes(attrs, styleAttrs);
        this.roundColor = mTypedArray.getColor(((Integer)CircleProgress.getResourceId(context, "plugin_appstoremgr_circle_progress_plugin_appstoremgr_round_color", RES_TYPE)).intValue(), -65536);
        this.roundProgressColor = mTypedArray.getColor(((Integer)CircleProgress.getResourceId(context, "plugin_appstoremgr_circle_progress_plugin_appstoremgr_round_progress_color", RES_TYPE)).intValue(), -16711936);
        this.roundWidth = mTypedArray.getDimension(((Integer)CircleProgress.getResourceId(context, "plugin_appstoremgr_circle_progress_plugin_appstoremgr_round_width", RES_TYPE)).intValue(), 5.0f);
        this.textColor = mTypedArray.getColor(((Integer)CircleProgress.getResourceId(context, "plugin_appstoremgr_circle_progress_plugin_appstoremgr_text_color", RES_TYPE)).intValue(), -16711936);
        this.textSize = mTypedArray.getDimension(((Integer)CircleProgress.getResourceId(context, "plugin_appstoremgr_circle_progress_plugin_appstoremgr_text_size", RES_TYPE)).intValue(), 15.0f);
        this.maxValue = mTypedArray.getInteger(((Integer)CircleProgress.getResourceId(context, "plugin_appstoremgr_circle_progress_plugin_appstoremgr_max_value", RES_TYPE)).intValue(), 100);
        this.textIsDisplayable = mTypedArray.getBoolean(((Integer)CircleProgress.getResourceId(context, "plugin_appstoremgr_circle_progress_plugin_appstoremgr_text_is_displayable", RES_TYPE)).intValue(), true);
        this.style = mTypedArray.getInt(((Integer)CircleProgress.getResourceId(context, "plugin_appstoremgr_circle_progress_plugin_appstoremgr_style", RES_TYPE)).intValue(), 0);
        mTypedArray.recycle();
    }

    protected void onSizeChanged(int w, int h, int ow, int oh) {
        super.onSizeChanged(w, h, ow, oh);
        this.mOval = new RectF(0.0f, 0.0f, (float)w, (float)h);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int centre = this.getWidth() / 2;
        int radius = (int)((float)centre - this.roundWidth / 2.0f);
        this.paint.setColor(this.roundColor);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(this.roundWidth);
        this.paint.setAntiAlias(true);
        canvas.drawCircle((float)centre, (float)centre, (float)radius, this.paint);
        if (!this.isPause) {
            this.paint.setStrokeWidth(0.0f);
            this.paint.setStyle(Paint.Style.FILL);
            this.paint.setColor(this.textColor);
            this.paint.setTextSize(this.textSize);
            this.paint.setTypeface(Typeface.DEFAULT_BOLD);
            int percent = (int)((float)this.progress / (float)this.maxValue * 100.0f);
            float textWidth = this.paint.measureText(percent + "%");
            if (this.textIsDisplayable && this.style == 0) {
                canvas.drawText(percent + "%", (float)centre - textWidth / 2.0f, (float)centre + this.textSize / 2.0f, this.paint);
            }
        } else {
            Bitmap pauseBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)EUExUtil.getResDrawableID((String)"plugin_appstoremgr_app_down_pause"));
            pauseBitmap = Bitmap.createScaledBitmap((Bitmap)pauseBitmap, (int)((int)(this.mOval.right - this.mOval.left) / 2), (int)((int)(this.mOval.bottom - this.mOval.top) / 2), (boolean)false);
            canvas.drawBitmap(pauseBitmap, (this.mOval.right - this.mOval.left - (float)pauseBitmap.getWidth()) / 2.0f, (this.mOval.bottom - this.mOval.top - (float)pauseBitmap.getHeight()) / 2.0f, this.paint);
        }
        this.paint.setStrokeWidth(this.roundWidth);
        this.paint.setColor(this.roundProgressColor);
        RectF oval = new RectF((float)(centre - radius), (float)(centre - radius), (float)(centre + radius), (float)(centre + radius));
        switch (this.style) {
            case 0: {
                this.paint.setStyle(Paint.Style.STROKE);
                canvas.drawArc(oval, 0.0f, (float)(360 * this.progress / this.maxValue), false, this.paint);
                break;
            }
            case 1: {
                this.paint.setStyle(Paint.Style.FILL_AND_STROKE);
                if (this.progress == 0) break;
                canvas.drawArc(oval, 0.0f, (float)(360 * this.progress / this.maxValue), true, this.paint);
            }
        }
    }

    public void setPause(boolean isPause) {
        this.isPause = isPause;
    }

    public synchronized int getMax() {
        return this.maxValue;
    }

    public synchronized void setMax(int max) {
        if (max < 0) {
            throw new IllegalArgumentException("max not less than 0");
        }
        this.maxValue = max;
    }

    public synchronized int getProgress() {
        return this.progress;
    }

    public synchronized void setProgress(int progress) {
        if (progress < 0) {
            throw new IllegalArgumentException("progress not less than 0");
        }
        if (progress > this.maxValue) {
            progress = this.maxValue;
        }
        if (progress <= this.maxValue) {
            this.progress = progress;
            this.postInvalidate();
        }
    }

    public int getCricleColor() {
        return this.roundColor;
    }

    public void setCricleColor(int cricleColor) {
        this.roundColor = cricleColor;
    }

    public int getCricleProgressColor() {
        return this.roundProgressColor;
    }

    public void setCricleProgressColor(int cricleProgressColor) {
        this.roundProgressColor = cricleProgressColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
    }

    public float getRoundWidth() {
        return this.roundWidth;
    }

    public void setRoundWidth(float roundWidth) {
        this.roundWidth = roundWidth;
    }
}

