/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;

public class XListViewFooter
extends LinearLayout {
    public static final int STATE_NORMAL = 0;
    public static final int STATE_READY = 1;
    public static final int STATE_LOADING = 2;
    private Context mContext;
    private View mContentView;
    private View mProgressBar;
    private TextView mHintView;

    public XListViewFooter(Context context) {
        super(context);
        this.initView(context);
    }

    public XListViewFooter(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public void setState(int state) {
        this.mHintView.setVisibility(4);
        this.mProgressBar.setVisibility(4);
        this.mHintView.setVisibility(4);
        if (state == 1) {
            this.show();
            this.mHintView.setVisibility(0);
            this.mHintView.setText(EUExUtil.getResStringID((String)"xlistview_footer_hint_ready"));
        } else if (state == 2) {
            this.show();
            this.mProgressBar.setVisibility(0);
        } else {
            this.hide();
            this.mHintView.setVisibility(8);
            this.mHintView.setText(EUExUtil.getResStringID((String)"xlistview_footer_hint_normal"));
        }
    }

    public void setBottomMargin(int height) {
        if (height < 0) {
            return;
        }
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mContentView.getLayoutParams();
        lp.bottomMargin = height;
        this.mContentView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public int getBottomMargin() {
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mContentView.getLayoutParams();
        return lp.bottomMargin;
    }

    public void normal() {
        this.mHintView.setVisibility(0);
        this.mProgressBar.setVisibility(8);
    }

    public void loading() {
        this.mHintView.setVisibility(8);
        this.mProgressBar.setVisibility(0);
    }

    public void hide() {
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mContentView.getLayoutParams();
        lp.height = 0;
        this.mContentView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public void show() {
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mContentView.getLayoutParams();
        lp.height = -2;
        this.mContentView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    private void initView(Context context) {
        this.mContext = context;
        LinearLayout moreView = (LinearLayout)LayoutInflater.from((Context)this.mContext).inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_xlistview_footer"), null);
        this.addView((View)moreView);
        moreView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.mContentView = moreView.findViewById(EUExUtil.getResIdID((String)"xlistview_footer_content"));
        this.mProgressBar = moreView.findViewById(EUExUtil.getResIdID((String)"xlistview_footer_progressbar"));
        this.mHintView = (TextView)moreView.findViewById(EUExUtil.getResIdID((String)"xlistview_footer_hint_textview"));
    }
}

