/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.io.File;
import java.util.ArrayList;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.BroadcastReciver.DownloadStateAppInfoReceiver;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView.AppInfoBaseView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView.AppInfoDetailsView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView.AppInfoDiscussView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppStoreMainView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDownLoadDb;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppLocalDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppTaskList;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.ViewDataManager2;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.MyHorizontalScrollView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStoreOptionVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class AppInfoView
extends AppInfoBaseView
implements AppStoreConstant {
    public static final String TAG = "AppInfoActivityTAG";
    private MyHorizontalScrollView scrollView;
    private ArrayList<String> myTitleList = new ArrayList();
    private ViewPager mViewPager;
    private boolean isTitleClick = false;
    private View titleLayout;
    private TextView title;
    private TextView downloadPercent;
    private ImageView back;
    private AppBean mAppBean;
    private ProgressBar appState;
    private Context mContext;
    private ArrayList<AppInfoBaseView> fragmentsList;
    private EUExAppStoreMgr mEuExAppStoreMgr;
    private WWidgetData mWgtData;
    private DownloadStateAppInfoReceiver downloadStatusRcv;

    public AppInfoView(Context context, EUExAppStoreMgr appStoreMgr, WWidgetData widgetData, AppBean appBean) {
        super(context);
        this.mContext = context;
        this.mEuExAppStoreMgr = appStoreMgr;
        this.mWgtData = widgetData;
        this.mAppBean = appBean;
        LayoutInflater.from((Context)this.mContext).inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_app_info_main"), (ViewGroup)this, true);
        this.mViewPager = (ViewPager)this.findViewById(EUExUtil.getResIdID((String)"viewpager"));
        this.scrollView = (MyHorizontalScrollView)this.findViewById(EUExUtil.getResIdID((String)"scrollView"));
        this.title = (TextView)this.findViewById(EUExUtil.getResIdID((String)"centerTitle"));
        this.downloadPercent = (TextView)this.findViewById(EUExUtil.getResIdID((String)"downloadPercent"));
        this.back = (ImageView)this.findViewById(EUExUtil.getResIdID((String)"back"));
        this.appState = (ProgressBar)this.findViewById(EUExUtil.getResIdID((String)"appState"));
        this.back.setImageResource(EUExUtil.getResDrawableID((String)"plugin_appstoremgr_back"));
        this.titleLayout = this.findViewById(EUExUtil.getResIdID((String)"title"));
        if (AppStoreMainView.TITLE_HEIGHT > 0) {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.titleLayout.getLayoutParams();
            lp.height = AppStoreMainView.TITLE_HEIGHT;
            this.titleLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        if (AppStoreOptionVO.isShowAllViewsInWeb()) {
            this.titleLayout.setVisibility(8);
        }
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AppInfoView.this.mEuExAppStoreMgr != null) {
                    AppInfoView.this.mEuExAppStoreMgr.closeAppDetial(new String[0]);
                }
            }
        });
        this.fragmentsList = new ArrayList();
        AppInfoDetailsView detialsTab = new AppInfoDetailsView(this.mContext, this.mAppBean);
        AppInfoDiscussView discussTab = new AppInfoDiscussView(this.mContext, this.mEuExAppStoreMgr, this.mAppBean, this.mWgtData);
        this.fragmentsList.add(detialsTab);
        this.fragmentsList.add(discussTab);
        this.myTitleList.add(0, EUExUtil.getString((String)"plugin_appstore_app_details"));
        this.myTitleList.add(1, EUExUtil.getString((String)"plugin_appstore_ueser_evalute"));
        this.scrollView.setAnim(true);
        this.scrollView.setPager(this.mViewPager);
        this.scrollView.setAllTitle1(this.myTitleList, this);
        TabPagerAdapter adaa = new TabPagerAdapter(this.mViewPager, this.fragmentsList);
        this.mViewPager.setAdapter((PagerAdapter)adaa);
        this.mViewPager.setCurrentItem(0);
        this.mViewPager.setOffscreenPageLimit(2);
        this.mViewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageSelected(int index) {
                AppInfoView.this.scrollView.setViewPager(index);
                ((AppInfoBaseView)AppInfoView.this.fragmentsList.get(index)).setUserVisibleHint(true);
            }

            public void onPageScrolled(int arg0, float arg1, int arg2) {
            }

            public void onPageScrollStateChanged(int arg0) {
            }
        });
        this.initAppDetailData();
        this.onStart();
    }

    private void initAppDetailData() {
        this.title.setText((CharSequence)this.mAppBean.getAppName());
        int p = AppLocalDataManager.getProgress(this.mContext, this.mAppBean.getAppId());
        if (p != 100) {
            this.appState.setProgress(p);
            this.downloadPercent.setText((CharSequence)(p + "%"));
        }
        this.appState.setClickable(false);
        String appId = this.mAppBean.getAppId();
        AppBean localApp = new AppBeanDao(this.mContext).getAppBean(appId);
        this.appState.setOnClickListener((View.OnClickListener)new AddAppListener(this.mAppBean));
        switch (this.mAppBean.getType()) {
            case 1: {
                if (localApp != null) {
                    this.downloadPercent.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_installed"));
                    this.appState.setClickable(false);
                    break;
                }
                this.downloadPercent.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_not_install"));
                break;
            }
            case 3: {
                if (localApp != null && localApp.getState() == 4 && localApp.getNewApp() != 2 && AppUtils.isWidgetInstalled(appId)) {
                    this.downloadPercent.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_install_complete"));
                    this.appState.setClickable(false);
                    break;
                }
                if (localApp != null && localApp.getState() == 4 && localApp.getNewApp() == 2) {
                    this.downloadPercent.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_to_be_updated"));
                    break;
                }
                if (localApp != null && localApp.getState() == 2) break;
                this.downloadPercent.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_not_install"));
                break;
            }
            case 2: 
            case 4: {
                if (localApp != null && localApp.getState() == 4 && localApp.getNewApp() != 2 && AppUtils.isNativeAppInstalled(this.mContext, localApp.getPackageName())) {
                    this.downloadPercent.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_install_complete"));
                    this.appState.setClickable(false);
                    break;
                }
                if (localApp != null && localApp.getState() == 4 && localApp.getNewApp() == 2) {
                    this.downloadPercent.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_to_be_updated"));
                    break;
                }
                if (localApp != null && localApp.getState() == 2) break;
                this.downloadPercent.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_not_install"));
            }
        }
    }

    protected void onStart() {
        if (null == this.downloadStatusRcv) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("plugin_appstore_notify_download_status");
            this.downloadStatusRcv = new DownloadStateAppInfoReceiver(this.mContext, this.mAppBean, this.appState, this.downloadPercent);
            this.mContext.registerReceiver((BroadcastReceiver)this.downloadStatusRcv, intentFilter);
        }
    }

    @Override
    public void onDetachedFromWindow() {
        if (this.downloadStatusRcv != null) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.downloadStatusRcv);
            this.downloadStatusRcv = null;
        }
        if (this.mEuExAppStoreMgr != null) {
            this.mEuExAppStoreMgr.closeAppDetial(new String[0]);
        }
        super.onDetachedFromWindow();
    }

    public boolean isTitleClick() {
        return this.isTitleClick;
    }

    public void setTitleClick(boolean isTitleClick) {
        this.isTitleClick = isTitleClick;
    }

    public static class TabPagerAdapter
    extends PagerAdapter {
        private ArrayList<AppInfoBaseView> fragmentList;
        private ViewPager mViewPager;

        public TabPagerAdapter(ViewPager viewPager, ArrayList<AppInfoBaseView> fragments) {
            this.fragmentList = fragments;
            this.mViewPager = viewPager;
        }

        public Object instantiateItem(ViewGroup viewGroup, int postion) {
            View viewItem = null;
            if (postion < this.fragmentList.size()) {
                viewItem = this.fragmentList.get((int)postion).rootView;
                this.mViewPager.addView(viewItem, postion);
            }
            return viewItem;
        }

        public int getCount() {
            return this.fragmentList.size();
        }

        public AppInfoBaseView getItem(int arg0) {
            return this.fragmentList.get(arg0);
        }

        public int getItemPosition(Object object) {
            return super.getItemPosition(object);
        }

        public boolean isViewFromObject(View arg0, Object arg1) {
            return arg0 == arg1;
        }
    }

    class AddAppListener
    implements View.OnClickListener {
        AppBean appBean;

        public AddAppListener(AppBean appBean) {
            this.appBean = appBean;
        }

        public void onClick(View v) {
            String appId = this.appBean.getAppId();
            if (new AppBeanDao(AppInfoView.this.mContext).getAppBean(appId) == null) {
                new AppBeanDao(AppInfoView.this.mContext).addAppBean("app_list", this.appBean);
            } else {
                this.appBean = new AppBeanDao(AppInfoView.this.mContext).getAppBean(appId);
            }
            if (this.appBean.getType() != 1) {
                AppTaskList appsTaskList = ViewDataManager2.getAppTaskList();
                String mAppId = this.appBean.getAppId();
                AppStoreMainView.getInstance().refreshLocalAppData();
                ViewDataManager2 viewDataManager = ViewDataManager2.getInstance();
                switch (this.appBean.getType()) {
                    case 2: 
                    case 4: {
                        AppBean app1 = new AppBeanDao(AppInfoView.this.mContext).getAppBean(mAppId);
                        int state = 0;
                        if (app1 != null) {
                            state = app1.getState();
                        }
                        if (AppUtils.isNativeAppInstalled(AppInfoView.this.mContext, this.appBean.getPackageName()) && state != 4) {
                            AppUtils.changeAppStateToInstall(AppInfoView.this.mContext, AppInfoView.this.mWgtData, this.appBean);
                            break;
                        }
                        if (appsTaskList.isExistTask(mAppId, AppInfoView.this.mContext)) {
                            return;
                        }
                        String[] result = AppDownLoadDb.getFilePathFromDownload(AppInfoView.this.mContext, this.appBean.getDownloadUrl());
                        if (result != null) {
                            String path = result[0];
                            String size = result[1];
                            if (!TextUtils.isEmpty((CharSequence)path) && !TextUtils.isEmpty((CharSequence)size)) {
                                int fileSize = Integer.parseInt(size);
                                File file = new File(path);
                                if (file.exists() && file.length() == (long)fileSize) {
                                    EUExAppStoreMgr.getInstance().installApp(this.appBean, file);
                                    AppLocalDataManager.saveApkPath(AppInfoView.this.mContext, this.appBean.getAppId(), file.getAbsolutePath());
                                    AppLocalDataManager.removeProgress(AppInfoView.this.mContext, this.appBean.getAppId());
                                    return;
                                }
                            }
                        }
                        viewDataManager.launch(AppInfoView.this.mContext, this.appBean, 0);
                        break;
                    }
                    case 3: {
                        if (appsTaskList.isExistTask(mAppId, AppInfoView.this.mContext)) {
                            return;
                        }
                        if ((1 == this.appBean.getState() || 4 == this.appBean.getState()) && AppUtils.isWidgetInstalled(this.appBean.getAppId())) {
                            String[] updateInfo = new AppBeanDao(AppInfoView.this.mContext).getUpdate(this.appBean.getAppId());
                            if (updateInfo != null) {
                                String filePath = updateInfo[0];
                                String appVer = updateInfo[1];
                                if (!TextUtils.isEmpty((CharSequence)filePath) && filePath.endsWith(".zip") && !TextUtils.isEmpty((CharSequence)appVer)) {
                                    if (new File(filePath).exists()) {
                                        AppBean bean = this.appBean;
                                        bean.setCurVersion(appVer);
                                        viewDataManager.unzip(AppInfoView.this.mContext, bean, filePath, 1);
                                        return;
                                    }
                                    new AppBeanDao(AppInfoView.this.mContext).deleteUpdate(this.appBean.getAppId());
                                }
                            }
                            viewDataManager.launch(AppInfoView.this.mContext, this.appBean, 1);
                            break;
                        }
                        LogUtils.logDebug("lll==============\u5c1a\u672a\u4e0b\u8f7d\uff0c\u9a8c\u8bc1\u767b\u9646\uff0c\u5f00\u59cb\u4e0b\u8f7d");
                        String[] result = AppDownLoadDb.getFilePathFromDownload(AppInfoView.this.mContext, this.appBean.getDownloadUrl());
                        if (result != null) {
                            String path = result[0];
                            String size = result[1];
                            if (!TextUtils.isEmpty((CharSequence)path) && !TextUtils.isEmpty((CharSequence)size)) {
                                int fileSize = Integer.parseInt(size);
                                File file = new File(path);
                                if (file.exists() && file.length() == (long)fileSize) {
                                    viewDataManager.unzip(AppInfoView.this.mContext, this.appBean, path, 0);
                                    return;
                                }
                            }
                        }
                        viewDataManager.launch(AppInfoView.this.mContext, this.appBean, 0);
                    }
                }
            } else {
                if (this.appBean.getState() != 4) {
                    AppUtils.changeAppStateToInstall(AppInfoView.this.mContext, AppInfoView.this.mWgtData, this.appBean);
                }
                AppInfoView.this.downloadPercent.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_installed"));
            }
        }
    }
}

