/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import java.util.LinkedList;
import java.util.List;
import org.zywx.wbpalmstar.base.ResoureFinder;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.imageloader.ImageLoaderManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.ChildViewPager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;

public class AppAdPagerAdapter
extends PagerAdapter
implements AppStoreConstant {
    public static final String TAG = "AppAdPagerAdapter";
    private Context mContext;
    public static boolean flag;
    private Recycle mRecycle;
    private ImageLoaderManager loaderManager;
    private List<AppBean> brandADs;
    private LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -1);
    private Drawable defaultItemBg;
    private ResoureFinder finder;
    private ChildViewPager mAdViewPager;

    public AppAdPagerAdapter(Context ctx, List<AppBean> imgUrlList, ChildViewPager mAdViewPager) {
        this.mContext = ctx;
        this.brandADs = imgUrlList;
        this.finder = ResoureFinder.getInstance((Context)this.mContext);
        this.defaultItemBg = this.finder.getDrawable("plugin_appstoremgr_ad_bg");
        this.loaderManager = ImageLoaderManager.initImageLoaderManager(this.mContext);
        this.mAdViewPager = mAdViewPager;
        this.setAdViewRoll(this.brandADs.size());
        this.mRecycle = new Recycle();
    }

    private void setAdViewRoll(int size) {
        boolean mIsRoll = 1 != this.brandADs.size();
        this.mAdViewPager.setRoll(mIsRoll);
    }

    public void refreshAdData(List<AppBean> imgUrlList) {
        this.brandADs = imgUrlList;
        this.setAdViewRoll(this.brandADs.size());
        this.notifyDataSetChanged();
    }

    public String getItem(int position) {
        return this.brandADs.size() == 0 ? "" : this.brandADs.get(position % this.brandADs.size()).getAdvImageUrl();
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        ImageView imageView = (ImageView)object;
        ((ViewPager)container).removeView((View)imageView);
        this.mRecycle.releaseView((View)imageView);
    }

    public int getCount() {
        if (this.brandADs.size() != 0) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    public int getActualCount() {
        return this.brandADs.size();
    }

    public int getItemPosition(Object object) {
        return -2;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        ImageView imageView = (ImageView)this.mRecycle.requestView();
        String url = null;
        AppBean advBean = null;
        try {
            advBean = this.brandADs.get(position % this.brandADs.size());
            url = advBean.getAdvImageUrl();
        }
        catch (Exception e) {
            LogUtils.logDebug("no AD at the position : " + position + " Exception : " + e.getClass().getName() + " Message:" + e.getMessage());
        }
        ((ViewPager)container).addView((View)imageView, (ViewGroup.LayoutParams)this.lp);
        NetworkUtils.asyncLoadImage(this.mContext, imageView, url, this.defaultItemBg, this.loaderManager, false);
        return imageView;
    }

    public void onADPageClick(int position, EUExAppStoreMgr appStoreMgr) {
        String tempLinkUrl = null;
        AppBean advBean = null;
        try {
            advBean = this.brandADs.get(position % this.brandADs.size());
            tempLinkUrl = advBean.getAdvImageLink();
        }
        catch (Exception e) {
            LogUtils.logDebug("no AD at the position : " + position + " Exception : " + e.getClass().getName() + " Message:" + e.getMessage());
        }
        String advLinkUrl = tempLinkUrl;
        LogUtils.logDebug("AD OnClick: " + advLinkUrl);
        if (!TextUtils.isEmpty((CharSequence)advLinkUrl)) {
            AppUtils.startWidgetWithBrowser(this.mContext, advLinkUrl, 0, null);
            if (appStoreMgr != null) {
                appStoreMgr.cbStartWebView();
            }
        }
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == (View)object;
    }

    public static interface OnPageItemClickListener {
        public void onPageItemClick(ViewGroup var1, View var2, int var3);
    }

    private class Recycle {
        private LinkedList<View> mContainer = new LinkedList();

        private Recycle() {
        }

        public View requestView() {
            if (this.mContainer.size() > 0) {
                return this.mContainer.removeFirst();
            }
            ImageView imageView = new ImageView(AppAdPagerAdapter.this.mContext);
            imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            imageView.setImageDrawable(AppAdPagerAdapter.this.defaultItemBg);
            return imageView;
        }

        public void releaseView(View imageView) {
            imageView.setTag(null);
            imageView.setOnClickListener(null);
            this.mContainer.addLast(imageView);
        }
    }
}

