/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.http;

import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.Http;

public class HX509TrustManager
implements X509TrustManager {
    private static X509TrustManager mDefaultTrustManager;
    private X509TrustManager mTrustManager;

    public HX509TrustManager(KeyStore ksP12) throws Exception {
        TrustManagerFactory tfactory = TrustManagerFactory.getInstance(Http.algorithm);
        tfactory.init(ksP12);
        TrustManager[] trustMgr = tfactory.getTrustManagers();
        if (trustMgr.length == 0) {
            throw new NoSuchAlgorithmException("no trust manager found");
        }
        this.mTrustManager = (X509TrustManager)trustMgr[0];
        if (mDefaultTrustManager == null) {
            TrustManagerFactory defaultTfactory = TrustManagerFactory.getInstance(Http.algorithm);
            defaultTfactory.init((KeyStore)null);
            TrustManager[] defaultTrustMgr = defaultTfactory.getTrustManagers();
            if (defaultTrustMgr.length == 0) {
                throw new NoSuchAlgorithmException("no default trust manager found");
            }
            mDefaultTrustManager = (X509TrustManager)defaultTrustMgr[0];
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (Http.isCheckTrustCert()) {
            try {
                this.mTrustManager.checkClientTrusted(chain, authType);
            }
            catch (Exception e) {
                e.printStackTrace();
                mDefaultTrustManager.checkClientTrusted(chain, authType);
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (Http.isCheckTrustCert()) {
            try {
                if (chain != null && chain.length == 1) {
                    chain[0].checkValidity();
                } else {
                    this.mTrustManager.checkServerTrusted(chain, authType);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                mDefaultTrustManager.checkServerTrusted(chain, authType);
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] certs = this.mTrustManager.getAcceptedIssuers();
        return certs;
    }
}

