/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.view;

import android.app.Activity;
import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView.AppInfoView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppListMainView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;

public class MyHorizontalScrollView
extends HorizontalScrollView {
    private int displayWidth;
    private ViewPager viewPager;
    private int width;
    private int scrollViewWidth;
    private int left;
    private int right;
    private boolean isAnim;
    private List<String> titleList = new ArrayList<String>();
    private Activity mContext;
    private LinearLayout horizontalLayout;
    private int currentIndex;
    private int oldIndex;

    public MyHorizontalScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = (Activity)context;
        this.initView(this.mContext);
    }

    public MyHorizontalScrollView(Context context) {
        super(context);
        this.mContext = (Activity)context;
        this.initView(this.mContext);
    }

    private void initView(Activity context) {
        DisplayMetrics metric = new DisplayMetrics();
        context.getWindowManager().getDefaultDisplay().getMetrics(metric);
        this.displayWidth = metric.widthPixels;
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (MyHorizontalScrollView.this.horizontalLayout == null) {
                    MyHorizontalScrollView.this.horizontalLayout = (LinearLayout)MyHorizontalScrollView.this.getChildAt(0);
                }
                if (MyHorizontalScrollView.this.horizontalLayout.getChildCount() > 0) {
                    MyHorizontalScrollView.this.width = MyHorizontalScrollView.this.horizontalLayout.getChildAt(0).getWidth();
                    MyHorizontalScrollView.this.scrollViewWidth = MyHorizontalScrollView.this.getWidth();
                    LogUtils.logError("width = " + MyHorizontalScrollView.this.width);
                    MyHorizontalScrollView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
    }

    public void setPager(ViewPager viewPager) {
        this.viewPager = viewPager;
    }

    public void setViewPager(int arg0) {
        LogUtils.logDebug("left = " + this.left);
        int leftCenterX = arg0 * this.width + this.width / 2 - this.left;
        LogUtils.logDebug("leftCenterX = " + leftCenterX);
        int rightCenterX = this.right - (arg0 * this.width + this.width / 2);
        LogUtils.logDebug("rightCenterX = " + rightCenterX);
        int center = this.displayWidth / 2;
        LogUtils.logDebug("center = " + center);
        int scollX = leftCenterX - center;
        LogUtils.logDebug("scollX = " + scollX);
        this.currentIndex = arg0;
        this.setLine();
        this.scrollBy(scollX, 0);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.left = l;
        this.right = this.left + this.scrollViewWidth;
    }

    public boolean isAnim() {
        return this.isAnim;
    }

    public void setAnim(boolean isAnim) {
        this.isAnim = isAnim;
    }

    public void setAllTitle(ArrayList<String> list, final AppListMainView context) {
        this.titleList.clear();
        this.titleList.addAll(list);
        if (this.horizontalLayout == null) {
            this.horizontalLayout = (LinearLayout)this.getChildAt(0);
        }
        this.horizontalLayout.removeAllViews();
        for (int i = 0; i < list.size(); ++i) {
            View view = this.mContext.getLayoutInflater().inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_title_item"), null);
            TextView textView = (TextView)view.findViewById(EUExUtil.getResIdID((String)"item_text"));
            textView.setWidth(this.displayWidth / list.size());
            view.setTag((Object)i);
            textView.setText((CharSequence)list.get(i));
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int item = (Integer)v.getTag();
                    context.setTitleClick(true);
                    MyHorizontalScrollView.this.viewPager.setCurrentItem(item, true);
                }
            });
            this.horizontalLayout.addView(view);
        }
        this.currentIndex = 0;
        this.setLine();
    }

    public void setAllTitle1(ArrayList<String> list, final AppInfoView context) {
        this.titleList.clear();
        this.titleList.addAll(list);
        if (this.horizontalLayout == null) {
            this.horizontalLayout = (LinearLayout)this.getChildAt(0);
        }
        this.horizontalLayout.removeAllViews();
        for (int i = 0; i < list.size(); ++i) {
            View view = this.mContext.getLayoutInflater().inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_title_item"), null);
            TextView textView = (TextView)view.findViewById(EUExUtil.getResIdID((String)"item_text"));
            textView.setWidth(this.displayWidth / list.size());
            view.setTag((Object)i);
            textView.setText((CharSequence)list.get(i));
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int item = (Integer)v.getTag();
                    context.setTitleClick(true);
                    MyHorizontalScrollView.this.viewPager.setCurrentItem(item, true);
                }
            });
            this.horizontalLayout.addView(view);
        }
        this.currentIndex = 0;
        this.setLine();
    }

    private void setLine() {
        this.horizontalLayout.getChildAt(this.oldIndex).findViewById(EUExUtil.getResIdID((String)"line")).setVisibility(8);
        this.horizontalLayout.getChildAt(this.currentIndex).findViewById(EUExUtil.getResIdID((String)"line")).setVisibility(0);
        this.oldIndex = this.currentIndex;
    }
}

