/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.view;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;

public class PageIndicator
extends LinearLayout {
    private LinearLayout.LayoutParams lp;
    private static final int SIZE = 8;
    private static final int MARGIN = 4;

    public PageIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initViews(context);
    }

    public PageIndicator(Context context) {
        super(context);
        this.initViews(context);
    }

    public void initViews(Context context) {
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        int size = (int)(dm.density * 8.0f);
        int margin = (int)(dm.density * 4.0f);
        this.lp = new LinearLayout.LayoutParams(size, size);
        this.lp.setMargins(margin, margin, margin, margin);
    }

    public void initViews() {
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        int size = (int)(dm.density * 8.0f * 2.0f);
        int margin = (int)(dm.density * 4.0f / 2.0f);
        this.lp = new LinearLayout.LayoutParams(size, size);
        this.lp.setMargins(margin, margin, margin, margin);
    }

    public void setTotalPageSize(int size) {
        if (size == this.getChildCount()) {
            return;
        }
        if (size > this.getChildCount()) {
            while (this.getChildCount() < size) {
                ImageView imageView = new ImageView(this.getContext());
                this.addView((View)imageView, this.getChildCount() - 1, (ViewGroup.LayoutParams)this.lp);
            }
        } else {
            while (this.getChildCount() > size) {
                this.removeViewAt(this.getChildCount() - 1);
            }
        }
    }

    public void addPage() {
        ImageView imageView = new ImageView(this.getContext());
        this.addView((View)imageView, this.getChildCount() - 1, (ViewGroup.LayoutParams)this.lp);
    }

    public void removePage() {
        this.removeViewAt(this.getChildCount() - 1);
    }

    public int getPageCount() {
        return this.getChildCount();
    }

    public void setCurrentPage(int index) {
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            View view = this.getChildAt(i);
            if (i == index) {
                view.setBackgroundResource(EUExUtil.getResDrawableID((String)"plugin_appstoremgr_indicator_current"));
                continue;
            }
            view.setBackgroundResource(EUExUtil.getResDrawableID((String)"plugin_appstoremgr_indicator_normal"));
        }
    }
}

