/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Scroller;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.apptile.AppTileListAdapterScroll;

public class ScrollLayout
extends ViewGroup
implements AppTileListAdapterScroll.OnDataChangeListener {
    private AppTileListAdapterScroll mAdapter;
    private int lineCount = 1;
    private int colCount = 1;
    private int itemPerPage = 1;
    private int childWidth = 0;
    private int childHeight = 0;
    private int screenWidth = 0;
    private int totalItem = 0;
    private int totalPage = 0;
    private int mCurScreen;
    private int mDefaultScreen = 0;
    private float mLastMotionX;
    private Scroller mScroller;
    private int startX = 0;
    private boolean isEditting;
    private OnPageChangedListener pageChangedListener;
    private OnAddOrDeletePage onAddPage;

    public ScrollLayout(Context context) {
        super(context);
        this.init(context);
    }

    public ScrollLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ScrollLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.mScroller = new Scroller(context);
        this.mCurScreen = this.mDefaultScreen;
        if (this.mAdapter != null) {
            this.refreView();
        }
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        child.setClickable(true);
        if (child.getVisibility() != 0) {
            child.setVisibility(0);
        }
        super.addView(child, index, params);
        int pages = (int)Math.ceil((double)this.getChildCount() * 1.0 / (double)this.itemPerPage);
        if (pages > this.totalPage) {
            if (this.onAddPage != null) {
                this.onAddPage.onAddOrDeletePage(this.totalPage, true);
            }
            this.totalPage = pages;
        }
    }

    public void refreView() {
        this.removeAllViews();
        for (int i = 0; i < this.mAdapter.getCount(); ++i) {
            this.addView(this.getView(i));
        }
        this.totalPage = (int)Math.ceil((double)this.getChildCount() * 1.0 / (double)this.itemPerPage);
        this.requestLayout();
    }

    public void removeView(View view) {
        super.removeView(view);
        int pages = (int)Math.ceil((double)this.getChildCount() * 1.0 / (double)this.itemPerPage);
        if (pages < this.totalPage) {
            if (this.onAddPage != null) {
                this.onAddPage.onAddOrDeletePage(this.totalPage, false);
            }
            this.totalPage = pages;
        }
    }

    public void removeViewAt(int index) {
        super.removeViewAt(index);
        int pages = (int)Math.ceil((double)this.getChildCount() * 1.0 / (double)this.itemPerPage);
        if (pages < this.totalPage) {
            this.totalPage = pages;
            if (this.onAddPage != null) {
                this.onAddPage.onAddOrDeletePage(this.totalPage, false);
            }
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        float x = ev.getX();
        switch (action) {
            case 0: {
                this.startX = (int)x;
                if (!this.mScroller.isFinished()) break;
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                }
                this.mLastMotionX = x;
                this.startX = (int)x;
                break;
            }
            case 2: {
                int deltaX = (int)(this.mLastMotionX - x);
                if (this.mCurScreen < 0 || this.mCurScreen > this.totalPage - 1) break;
                this.mLastMotionX = x;
                this.scrollBy(deltaX, 0);
                break;
            }
            case 1: {
                float distance = ev.getRawX() - (float)this.startX;
                if (distance > (float)(this.screenWidth / 6) && this.mCurScreen > 0) {
                    this.snapToScreen(this.mCurScreen - 1);
                } else if (distance < (float)(-this.screenWidth / 6) && this.mCurScreen < this.totalPage - 1) {
                    this.snapToScreen(this.mCurScreen + 1);
                } else {
                    this.snapToScreen(this.mCurScreen);
                }
                this.startX = 0;
                break;
            }
        }
        super.dispatchTouchEvent(ev);
        return true;
    }

    private View getView(int position) {
        View view = null;
        if (this.mAdapter != null) {
            view = this.mAdapter.getView(position);
        }
        return view;
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            this.scrollTo(this.mScroller.getCurrX(), this.mScroller.getCurrY());
            this.postInvalidate();
        }
    }

    public int getColCount() {
        return this.colCount;
    }

    public int getCurrentPage() {
        return this.mCurScreen;
    }

    public OnAddOrDeletePage getOnCaculatePage() {
        return this.onAddPage;
    }

    public OnPageChangedListener getOnPageChangedListener() {
        return this.pageChangedListener;
    }

    public int getRowCount() {
        return this.lineCount;
    }

    public AppTileListAdapterScroll getSaAdapter() {
        return this.mAdapter;
    }

    public int getTotalItem() {
        return this.totalItem;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    @Override
    public void ondataChange() {
        this.refreView();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            if (childView.getVisibility() == 8) continue;
            this.childWidth = childView.getMeasuredWidth();
            this.childHeight = childView.getMeasuredHeight();
            int page = i / this.itemPerPage;
            int row = i / this.colCount % this.lineCount;
            int col = i % this.colCount;
            int left = page * this.screenWidth + col * this.childWidth;
            int top = row * this.childHeight;
            childView.layout(left, top, left + this.childWidth, top + childView.getMeasuredHeight());
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        View.MeasureSpec.getMode((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        View.MeasureSpec.getMode((int)heightMeasureSpec);
        this.screenWidth = width;
        int usedWidth = width - (this.colCount - 1);
        int usedheight = height - (this.lineCount - 1);
        int childWidth = usedWidth / this.colCount;
        int childHeight = usedheight / this.lineCount;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int childWidthSpec = ScrollLayout.getChildMeasureSpec((int)View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000), (int)20, (int)childWidth);
            int childHeightSpec = ScrollLayout.getChildMeasureSpec((int)View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000), (int)20, (int)childHeight);
            child.measure(childWidthSpec, childHeightSpec);
        }
        this.scrollTo(this.mCurScreen * width, 0);
    }

    public void setColCount(int colCount) {
        this.colCount = colCount;
        this.itemPerPage = this.colCount * this.lineCount;
    }

    public boolean isEditting() {
        return this.isEditting;
    }

    public void setOnAddPage(OnAddOrDeletePage onAddPage) {
        this.onAddPage = onAddPage;
    }

    public void setOnPageChangedListener(OnPageChangedListener pageChangedListener) {
        this.pageChangedListener = pageChangedListener;
    }

    public void setLineCount(int lineCount) {
        this.lineCount = lineCount;
        this.itemPerPage = this.colCount * this.lineCount;
    }

    public void setAdapter(AppTileListAdapterScroll saAdapter) {
        this.mAdapter = saAdapter;
        this.mAdapter.setOnDataChangeListener(this);
    }

    public void setTotalItem(int totalItem) {
        this.totalItem = totalItem;
    }

    private void snapToScreen(int whichScreen) {
        whichScreen = Math.max(-1, Math.min(whichScreen, this.getChildCount()));
        if (this.getScrollX() != whichScreen * this.getWidth()) {
            int delta = whichScreen * this.getWidth() - this.getScrollX();
            if (this.pageChangedListener != null) {
                this.pageChangedListener.onPage2Other(this.totalPage, this.mCurScreen, whichScreen);
            }
            this.mScroller.startScroll(this.getScrollX(), 0, delta, 0, 500);
            this.mCurScreen = whichScreen;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void delItem(int delPos) {
        this.removeViewAt(delPos);
        this.mAdapter.delete(delPos);
        if (this.getChildCount() % this.itemPerPage == 0) {
            this.snapToScreen(this.totalPage - 1);
        }
    }

    public static interface OnPageChangedListener {
        public void onPage2Other(int var1, int var2, int var3);
    }

    public static interface OnAddOrDeletePage {
        public void onAddOrDeletePage(int var1, boolean var2);
    }
}

