/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView;

import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.Toast;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.BroadcastReciver.DownloadStateAppListReceiver;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppListBaseView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.CategoryTab;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.adapter.AppListViewAdapter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppStoteDataParser;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoteHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreTokenUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.DialogView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.XListView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStatusVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class AppListTab
extends AppListBaseView
implements AppStoreConstant {
    protected View rootView;
    protected XListView appListView;
    protected Context mContext;
    protected AppListViewAdapter appListAdapter;
    protected JSONObject appListParamsJson = new JSONObject();
    protected String indexIdDown;
    protected WWidgetData mWgtData;
    protected String downloadAppUrl;
    protected String cacheKey;
    protected AsyncTask<Void, Void, ArrayList<AppBean>> asyncTask = null;
    protected AsyncTask<Void, Void, ArrayList<AppBean>> asyncTaskPullDown = null;
    protected AsyncTask<Void, Void, ArrayList<AppBean>> asyncTaskPullUp = null;
    private DownloadStateAppListReceiver updateListViewRc;

    public AppListTab(Context context, WWidgetData mWData, String downloadAppUrl, String cacheKey) {
        super(context);
        this.mContext = context;
        this.mWgtData = mWData;
        this.downloadAppUrl = downloadAppUrl;
        this.cacheKey = cacheKey;
    }

    @Override
    public void setUserVisibleHint(boolean isVisibleToUser) {
        if (isVisibleToUser) {
            if (this.appListAdapter == null) {
                this.downloadAppList(this.appListParamsJson);
            } else {
                this.appListAdapter.notifyDataSetChanged();
            }
        }
    }

    public void onCreate() {
        String softToken = AppStoreTokenUtils.getSoftToken(this.mContext);
        if (softToken == null || softToken.length() == 0) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_soft_token_null"), (int)0).show();
            return;
        }
        try {
            this.appListParamsJson.put("softToken", (Object)softToken);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void onStart() {
        if (null == this.updateListViewRc) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("plugin_appstore_notify_download_status");
            this.updateListViewRc = new DownloadStateAppListReceiver();
            this.mContext.registerReceiver((BroadcastReceiver)this.updateListViewRc, intentFilter);
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.appListAdapter != null) {
            this.appListAdapter.notifyDataSetChanged();
            if (this.updateListViewRc != null) {
                this.updateListViewRc.updateAdapter(this.appListAdapter);
            }
        }
    }

    public View onCreateView() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        if (!(this instanceof CategoryTab)) {
            this.rootView = inflater.inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_app_listview"), (ViewGroup)this, false);
            View titleLayout = this.rootView.findViewById(EUExUtil.getResIdID((String)"title"));
            titleLayout.setVisibility(8);
            this.appListView = (XListView)this.rootView.findViewById(EUExUtil.getResIdID((String)"appListView"));
            this.appListView.setPullRefreshEnable(true);
            this.appListView.setXListViewListener(new ListViewIXListViewListener(this.appListView));
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            String time = sdf.format(new Date());
            this.appListView.setRefreshTime(time);
        } else {
            this.rootView = inflater.inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_category_listview"), (ViewGroup)this, false);
        }
        return this.rootView;
    }

    protected void downloadAppList(final JSONObject appListParams) {
        LogUtils.logDebug(true, "downloadAppList url:" + this.downloadAppUrl + " cacheKey:" + this.cacheKey);
        final String resCache = SharedPrefUtils.getString(this.mContext, "main_prefs", this.cacheKey, "");
        if (!NetworkUtils.isOnline(this.mContext) && TextUtils.isEmpty((CharSequence)resCache)) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            return;
        }
        if (this.asyncTask != null) {
            return;
        }
        this.asyncTask = new AsyncTask<Void, Void, ArrayList<AppBean>>(){
            Dialog progressDialog = null;

            protected void onPreExecute() {
                this.progressDialog = DialogView.showLoadingDialog(AppListTab.this.mContext, EUExUtil.getString((String)"plugin_appstore_load_app_list"));
                this.progressDialog.show();
            }

            protected ArrayList<AppBean> doInBackground(Void ... params) {
                ArrayList<AppBean> appList = null;
                try {
                    String response = AppStoteHttpURLConnection.downLoadAppList(AppListTab.this.downloadAppUrl, AppListTab.this.mContext, AppListTab.this.mWgtData, appListParams).getResult();
                    if (!TextUtils.isEmpty((CharSequence)response)) {
                        appList = AppStoteDataParser.parseAppListWithKey("appList", response);
                        SharedPrefUtils.putString(AppListTab.this.mContext, "main_prefs", AppListTab.this.cacheKey, response);
                    } else if (!AppStatusVO.isForceConnected() && !TextUtils.isEmpty((CharSequence)resCache)) {
                        appList = AppStoteDataParser.parseAppListWithKey("appList", resCache);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return appList;
            }

            protected void onPostExecute(ArrayList<AppBean> result) {
                if (this.isCancelled()) {
                    AppListTab.this.asyncTask = null;
                    return;
                }
                if (this.progressDialog != null) {
                    this.progressDialog.dismiss();
                }
                if (result == null) {
                    Toast.makeText((Context)AppListTab.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
                    AppListTab.this.asyncTask = null;
                    return;
                }
                try {
                    if (result.size() != 0) {
                        int leng = result.size() - 1;
                        AppListTab.this.indexIdDown = result.get(leng).getIndexId();
                    } else {
                        LogUtils.logDebug(true, "app list size = 0");
                        Toast.makeText((Context)AppListTab.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_data"), (int)0).show();
                    }
                    if (null == AppListTab.this.appListAdapter) {
                        AppListTab.this.appListAdapter = new AppListViewAdapter(AppListTab.this.mContext, AppListTab.this.mWgtData, result);
                        AppListTab.this.appListView.setAdapter((ListAdapter)AppListTab.this.appListAdapter);
                        AppListTab.this.downloadStateRcv.updateAdapter(AppListTab.this.appListAdapter);
                    } else {
                        AppListTab.this.appListAdapter.reload(result);
                    }
                }
                catch (Exception e) {
                    Toast.makeText((Context)AppListTab.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_data"), (int)0).show();
                    e.printStackTrace();
                }
                AppListTab.this.asyncTask = null;
            }
        };
        this.asyncTask.execute((Object[])new Void[0]);
    }

    private void refreshData(final XListView listView, final JSONObject jsonParams) {
        if (!NetworkUtils.isOnline(this.mContext)) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            listView.stopRefresh();
            return;
        }
        if (this.asyncTaskPullDown != null) {
            return;
        }
        this.asyncTaskPullDown = new AsyncTask<Void, Void, ArrayList<AppBean>>(){

            protected ArrayList<AppBean> doInBackground(Void ... params) {
                String response = AppStoteHttpURLConnection.downLoadAppList(AppListTab.this.downloadAppUrl, AppListTab.this.mContext, AppListTab.this.mWgtData, jsonParams).getResult();
                ArrayList<AppBean> appList = AppStoteDataParser.parseAppListWithKey("appList", response);
                return appList;
            }

            protected void onPostExecute(ArrayList<AppBean> result) {
                if (this.isCancelled()) {
                    AppListTab.this.asyncTaskPullDown = null;
                    return;
                }
                if (null == result) {
                    listView.stopRefresh();
                    Toast.makeText((Context)AppListTab.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_app_refresh_fail"), (int)0).show();
                    AppListTab.this.asyncTaskPullUp = null;
                    return;
                }
                if (AppListTab.this.appListAdapter != null) {
                    AppListTab.this.appListAdapter.reload(result);
                } else {
                    AppListTab.this.appListAdapter = new AppListViewAdapter(AppListTab.this.mContext, AppListTab.this.mWgtData, result);
                    listView.setAdapter((ListAdapter)AppListTab.this.appListAdapter);
                    AppListTab.this.downloadStateRcv.updateAdapter(AppListTab.this.appListAdapter);
                }
                listView.stopRefresh();
                SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
                String time = sdf.format(new Date());
                listView.setRefreshTime(time);
                AppListTab.this.asyncTaskPullDown = null;
            }
        };
        this.asyncTaskPullDown.execute((Object[])new Void[0]);
    }

    private void loadMoreData(final XListView listView, final JSONObject jsonParams) {
        if (!NetworkUtils.isOnline(this.mContext)) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            listView.stopLoadMore();
            return;
        }
        if (this.asyncTaskPullUp != null) {
            return;
        }
        this.asyncTaskPullUp = new AsyncTask<Void, Void, ArrayList<AppBean>>(){

            protected ArrayList<AppBean> doInBackground(Void ... params) {
                String response = AppStoteHttpURLConnection.downLoadAppList(AppListTab.this.downloadAppUrl, AppListTab.this.mContext, AppListTab.this.mWgtData, jsonParams).getResult();
                ArrayList<AppBean> appList = AppStoteDataParser.parseAppListWithKey("appList", response);
                return appList;
            }

            protected void onPostExecute(ArrayList<AppBean> result) {
                if (this.isCancelled()) {
                    AppListTab.this.asyncTaskPullUp = null;
                    return;
                }
                if (result == null || result.size() == 0) {
                    listView.stopLoadMore();
                    Toast.makeText((Context)AppListTab.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_more_data"), (int)0).show();
                    AppListTab.this.asyncTaskPullUp = null;
                    return;
                }
                int length = result.size() - 1;
                AppListTab.this.indexIdDown = result.get(length).getIndexId();
                if (AppListTab.this.appListAdapter != null) {
                    AppListTab.this.appListAdapter.addList(result);
                } else {
                    AppListTab.this.appListAdapter = new AppListViewAdapter(AppListTab.this.mContext, AppListTab.this.mWgtData, result);
                    listView.setAdapter((ListAdapter)AppListTab.this.appListAdapter);
                    AppListTab.this.downloadStateRcv.updateAdapter(AppListTab.this.appListAdapter);
                }
                listView.stopLoadMore();
                AppListTab.this.asyncTaskPullUp = null;
            }
        };
        this.asyncTaskPullUp.execute((Object[])new Void[0]);
    }

    class ListViewIXListViewListener
    implements XListView.IXListViewListener {
        XListView mListView;

        public ListViewIXListViewListener(XListView listView) {
            this.mListView = listView;
        }

        @Override
        public void onRefresh() {
            JSONObject jsonPullDown = AppListTab.this.appListParamsJson;
            if (!AppListTab.this.cacheKey.equals("rank_prefs")) {
                try {
                    jsonPullDown.put("action", (Object)"up");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            AppListTab.this.refreshData(this.mListView, jsonPullDown);
        }

        @Override
        public void onLoadMore() {
            if (!AppListTab.this.cacheKey.equals("rank_prefs")) {
                JSONObject jsonUpDown = AppListTab.this.appListParamsJson;
                try {
                    jsonUpDown.put("action", (Object)"down");
                    jsonUpDown.put("indexId", (Object)AppListTab.this.indexIdDown);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                AppListTab.this.loadMoreData(this.mListView, jsonUpDown);
            }
        }
    }
}

