/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView;

import android.app.Dialog;
import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import java.util.ArrayList;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppListTab;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.adapter.CategoryListTabAdapter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppStoteDataParser;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoteHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.DialogView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStatusVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.UserInfoVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class CategoryTab
extends AppListTab
implements AppStoreConstant {
    protected static final String TAG = "CategoryTab";
    private ListView list;
    private Context mContext;
    private CategoryListTabAdapter adapter;
    private WWidgetData mWgtData;
    protected View rootView;
    private AsyncTask<Void, Void, ArrayList<AppBean>> asyncTask = null;

    public CategoryTab(Context context, WWidgetData mWData) {
        super(context, mWData, null, null);
        this.mContext = context;
        this.mWgtData = mWData;
        this.onCreateView();
    }

    @Override
    public void setUserVisibleHint(boolean isVisibleToUser) {
        if (isVisibleToUser && this.adapter == null) {
            this.downloadCategoryList();
        }
    }

    @Override
    public View onCreateView() {
        this.rootView = super.onCreateView();
        this.list = (ListView)this.rootView.findViewById(EUExUtil.getResIdID((String)"categoryListView"));
        return this.rootView;
    }

    public void downloadCategoryList() {
        final String resCacheKey = UserInfoVO.toSpKeyString() + "category_prefs";
        final String resCache = SharedPrefUtils.getString(this.mContext, "main_prefs", resCacheKey, "");
        if (!NetworkUtils.isOnline(this.mContext) && TextUtils.isEmpty((CharSequence)resCache)) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            return;
        }
        if (this.asyncTask != null) {
            return;
        }
        this.asyncTask = new AsyncTask<Void, Void, ArrayList<AppBean>>(){
            Dialog progressDialog = null;

            protected void onPreExecute() {
                this.progressDialog = DialogView.showLoadingDialog(CategoryTab.this.mContext, EUExUtil.getString((String)"plugin_appstore_load_category_list"));
                this.progressDialog.show();
            }

            protected ArrayList<AppBean> doInBackground(Void ... params) {
                ArrayList<AppBean> categoryList = null;
                String response = AppStoteHttpURLConnection.downLoadCategoryList(CategoryTab.this.mContext, CategoryTab.this.mWgtData).getResult();
                if (!TextUtils.isEmpty((CharSequence)response)) {
                    categoryList = AppStoteDataParser.parseAppListWithKey("appTypeList", response);
                    SharedPrefUtils.putString(CategoryTab.this.mContext, "main_prefs", resCacheKey, response);
                } else if (!AppStatusVO.isForceConnected() && !TextUtils.isEmpty((CharSequence)resCache)) {
                    categoryList = AppStoteDataParser.parseAppListWithKey("appTypeList", resCache);
                }
                return categoryList;
            }

            protected void onPostExecute(ArrayList<AppBean> result) {
                if (this.isCancelled()) {
                    CategoryTab.this.asyncTask = null;
                    return;
                }
                if (this.progressDialog != null) {
                    this.progressDialog.dismiss();
                }
                if (result == null) {
                    Toast.makeText((Context)CategoryTab.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_data"), (int)0).show();
                    Log.w((String)CategoryTab.TAG, (String)"result==null");
                    CategoryTab.this.asyncTask = null;
                }
                try {
                    if (result.size() == 0) {
                        Toast.makeText((Context)CategoryTab.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_data"), (int)0).show();
                        Log.w((String)CategoryTab.TAG, (String)"no apps");
                        CategoryTab.this.asyncTask = null;
                    }
                    if (CategoryTab.this.adapter != null) {
                        CategoryTab.this.adapter.reload(result);
                    } else {
                        CategoryTab.this.adapter = new CategoryListTabAdapter(CategoryTab.this.mContext, result, CategoryTab.this.mWgtData);
                        CategoryTab.this.list.setAdapter((ListAdapter)CategoryTab.this.adapter);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                CategoryTab.this.asyncTask = null;
            }
        };
        this.asyncTask.execute((Object[])new Void[0]);
    }
}

