/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RatingBar;
import android.widget.TextView;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import org.zywx.wbpalmstar.base.ResoureFinder;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppStoreMainView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.adapter.AppGridViewAdapter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDownLoadDb;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppLocalDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppTaskList;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.ViewDataManager2;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.imageloader.ImageLoaderManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.HeaderGridView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStoreOptionVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class AppListViewAdapter
extends BaseAdapter
implements AppStoreConstant {
    private Context mContext;
    private LayoutInflater mInflater;
    private ImageLoaderManager loaderManager;
    private LinkedList<AppBean> apps = new LinkedList();
    private Drawable defaultItemBg;
    private ResoureFinder finder;
    private ListViewHolder holder = null;
    private WWidgetData mWWidgetData;

    public AppListViewAdapter(Context context, WWidgetData mWidgetData, ArrayList<AppBean> result) {
        this.mContext = context;
        this.mWWidgetData = mWidgetData;
        this.mInflater = LayoutInflater.from((Context)this.mContext);
        if (result != null && result.size() > 0) {
            for (AppBean appBean : result) {
                this.apps.add(appBean);
            }
        }
        this.finder = ResoureFinder.getInstance((Context)this.mContext);
        this.defaultItemBg = this.finder.getDrawable("plugin_appstoremgr_icon_bg");
        this.loaderManager = ImageLoaderManager.initImageLoaderManager(this.mContext);
        this.notifyDataSetChanged();
    }

    public void addList(ArrayList<AppBean> appList) {
        if (appList == null) {
            return;
        }
        for (AppBean ranking : appList) {
            this.apps.addLast(ranking);
        }
        this.notifyDataSetChanged();
    }

    public void reload(ArrayList<AppBean> result) {
        this.apps.clear();
        if (result != null) {
            for (AppBean ranking : result) {
                this.apps.add(ranking);
            }
        }
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.apps.size();
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            this.holder = new ListViewHolder();
            convertView = this.mInflater.inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_app_listview_item"), null);
            this.holder.appIcon = (ImageView)convertView.findViewById(EUExUtil.getResIdID((String)"imageView"));
            this.holder.appName = (TextView)convertView.findViewById(EUExUtil.getResIdID((String)"appName"));
            this.holder.appDownloadCnt = (TextView)convertView.findViewById(EUExUtil.getResIdID((String)"appDownloadCnt"));
            this.holder.appScore = (RatingBar)convertView.findViewById(EUExUtil.getResIdID((String)"appScore"));
            this.holder.downloadState = (Button)convertView.findViewById(EUExUtil.getResIdID((String)"downloadState"));
            convertView.setTag((Object)this.holder);
        } else {
            this.holder = (ListViewHolder)convertView.getTag();
        }
        AppBean app = this.apps.get(position);
        this.holder.appName.setText((CharSequence)app.getAppName());
        this.holder.appDownloadCnt.setText((CharSequence)(app.getDownloadNum() + " " + EUExUtil.getString((String)"plugin_appstore_download_time")));
        float startLevel = 0.0f;
        try {
            startLevel = Float.parseFloat(app.getStartLevel());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.holder.appScore.setRating(startLevel);
        if (!AppStoreOptionVO.isShowDiscuss()) {
            this.holder.appScore.setVisibility(8);
        }
        String appId = app.getAppId();
        AppBean localAppBean = new AppBeanDao(this.mContext).getAppBean(appId);
        this.holder.downloadState.setOnClickListener((View.OnClickListener)new AddAppListener(app, this.mWWidgetData));
        switch (app.getType()) {
            case 1: {
                if (localAppBean != null) {
                    this.holder.downloadState.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_installed"));
                    this.holder.downloadState.setClickable(false);
                    break;
                }
                this.holder.downloadState.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_not_install"));
                this.holder.downloadState.setClickable(true);
                break;
            }
            case 3: {
                if (localAppBean != null && localAppBean.getState() == 4 && localAppBean.getNewApp() != 2 && AppUtils.isWidgetInstalled(appId)) {
                    this.holder.downloadState.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_installed"));
                    this.holder.downloadState.setClickable(false);
                    break;
                }
                if (localAppBean != null && localAppBean.getState() == 4 && localAppBean.getNewApp() == 2) {
                    this.holder.downloadState.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_to_be_updated"));
                    this.holder.downloadState.setClickable(true);
                    break;
                }
                if (localAppBean != null && localAppBean.getState() == 2) {
                    this.holder.downloadState.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_downloading"));
                    this.holder.downloadState.setClickable(true);
                    break;
                }
                this.holder.downloadState.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_not_install"));
                this.holder.downloadState.setClickable(true);
                break;
            }
            case 2: 
            case 4: {
                if (localAppBean != null && localAppBean.getState() == 4 && localAppBean.getNewApp() != 2 && AppUtils.isNativeAppInstalled(this.mContext, localAppBean.getPackageName())) {
                    this.holder.downloadState.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_installed"));
                    this.holder.downloadState.setClickable(false);
                    break;
                }
                if (localAppBean != null && localAppBean.getState() == 4 && localAppBean.getNewApp() == 2) {
                    this.holder.downloadState.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_to_be_updated"));
                    this.holder.downloadState.setClickable(true);
                    break;
                }
                if (localAppBean != null && localAppBean.getState() == 2) {
                    this.holder.downloadState.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_downloading"));
                    this.holder.downloadState.setClickable(true);
                    break;
                }
                this.holder.downloadState.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_not_install"));
                this.holder.downloadState.setClickable(true);
            }
        }
        String url = app.getIconLoc();
        NetworkUtils.asyncLoadImage(this.mContext, this.holder.appIcon, url, this.defaultItemBg, this.loaderManager);
        convertView.setOnClickListener((View.OnClickListener)new AppListener(app));
        return convertView;
    }

    public Object getItem(int position) {
        return null;
    }

    class AppListener
    implements View.OnClickListener {
        private AppBean appBean;

        public AppListener(AppBean appBean) {
            this.appBean = appBean;
        }

        public void onClick(View v) {
            if (!AppStoreOptionVO.isShowAllViewsInWeb()) {
                EUExAppStoreMgr.getInstance().openAppDetail(this.appBean);
            } else if (EUExAppStoreMgr.getInstance() != null) {
                EUExAppStoreMgr.getInstance().onAppDetialClick(this.appBean);
            }
        }
    }

    class AddAppListener
    implements View.OnClickListener {
        private AppBean appBean;
        private WWidgetData mWidgetData;

        public AddAppListener(AppBean appBean, WWidgetData mWidgetData) {
            this.appBean = appBean;
            this.mWidgetData = mWidgetData;
        }

        public void onClick(View v) {
            HeaderGridView gridView = AppStoreMainView.getInstance().getMyAppListGridView();
            String appId = this.appBean.getAppId();
            int oldState = this.appBean.getState();
            if (null == new AppBeanDao(AppListViewAdapter.this.mContext).getAppBean(appId)) {
                new AppBeanDao(AppListViewAdapter.this.mContext).addAppBean("app_list", this.appBean);
                this.appBean = new AppBeanDao(AppListViewAdapter.this.mContext).getAppBean(appId);
            } else {
                this.appBean = new AppBeanDao(AppListViewAdapter.this.mContext).getAppBean(appId);
            }
            if (this.appBean != null) {
                AppStoreMainView.getInstance().refreshLocalAppData();
                AppGridViewAdapter appsListAdapter = (AppGridViewAdapter)gridView.getWrapedAdapter();
                if (this.appBean.getType() != 1) {
                    AppTaskList appsTaskList = ViewDataManager2.getAppTaskList();
                    String mAppId = this.appBean.getAppId();
                    ViewDataManager2 viewDataManager = ViewDataManager2.getInstance();
                    switch (this.appBean.getType()) {
                        case 2: 
                        case 4: {
                            if (AppUtils.isNativeAppInstalled(AppListViewAdapter.this.mContext, this.appBean.getPackageName()) && oldState != 4) {
                                AppUtils.changeAppStateToInstall(AppListViewAdapter.this.mContext, this.mWidgetData, this.appBean);
                                AppListViewAdapter.this.notifyDataSetChanged();
                                break;
                            }
                            if (appsTaskList.isExistTask(mAppId, AppListViewAdapter.this.mContext)) {
                                return;
                            }
                            String[] result = AppDownLoadDb.getFilePathFromDownload(AppListViewAdapter.this.mContext, this.appBean.getDownloadUrl());
                            if (result != null) {
                                String path = result[0];
                                String size = result[1];
                                if (!TextUtils.isEmpty((CharSequence)path) && !TextUtils.isEmpty((CharSequence)size)) {
                                    int fileSize = Integer.parseInt(size);
                                    File file = new File(path);
                                    if (file.exists() && file.length() == (long)fileSize) {
                                        EUExAppStoreMgr.getInstance().installApp(this.appBean, file);
                                        AppLocalDataManager.saveApkPath(AppListViewAdapter.this.mContext, this.appBean.getAppId(), file.getAbsolutePath());
                                        AppLocalDataManager.removeProgress(AppListViewAdapter.this.mContext, this.appBean.getAppId());
                                        AppListViewAdapter.this.notifyDataSetChanged();
                                        return;
                                    }
                                }
                            }
                            viewDataManager.launch(AppListViewAdapter.this.mContext, this.appBean, 0);
                            break;
                        }
                        case 3: {
                            if (appsTaskList.isExistTask(mAppId, AppListViewAdapter.this.mContext)) {
                                return;
                            }
                            if ((1 == this.appBean.getState() || 4 == this.appBean.getState()) && AppUtils.isWidgetInstalled(this.appBean.getAppId())) {
                                String[] updateInfo = new AppBeanDao(AppListViewAdapter.this.mContext).getUpdate(this.appBean.getAppId());
                                if (updateInfo != null) {
                                    String filePath = updateInfo[0];
                                    String appVer = updateInfo[1];
                                    if (!TextUtils.isEmpty((CharSequence)filePath) && filePath.endsWith(".zip") && !TextUtils.isEmpty((CharSequence)appVer)) {
                                        if (new File(filePath).exists()) {
                                            AppBean bean = this.appBean;
                                            bean.setInstallVersion(appVer);
                                            viewDataManager.unzip(AppListViewAdapter.this.mContext, bean, filePath, 1);
                                            AppListViewAdapter.this.notifyDataSetChanged();
                                            return;
                                        }
                                        new AppBeanDao(AppListViewAdapter.this.mContext).deleteUpdate(this.appBean.getAppId());
                                    }
                                }
                                viewDataManager.launch(AppListViewAdapter.this.mContext, this.appBean, 1);
                                break;
                            }
                            String[] result = AppDownLoadDb.getFilePathFromDownload(AppListViewAdapter.this.mContext, this.appBean.getDownloadUrl());
                            if (result != null) {
                                String path = result[0];
                                String size = result[1];
                                if (!TextUtils.isEmpty((CharSequence)path) && !TextUtils.isEmpty((CharSequence)size)) {
                                    int fileSize = Integer.parseInt(size);
                                    File file = new File(path);
                                    if (file.exists() && file.length() == (long)fileSize) {
                                        viewDataManager.unzip(AppListViewAdapter.this.mContext, this.appBean, path, 0);
                                        AppListViewAdapter.this.notifyDataSetChanged();
                                        return;
                                    }
                                }
                            }
                            viewDataManager.launch(AppListViewAdapter.this.mContext, this.appBean, 0);
                        }
                    }
                } else if (this.appBean.getState() != 4) {
                    AppUtils.changeAppStateToInstall(AppListViewAdapter.this.mContext, this.mWidgetData, this.appBean);
                }
                appsListAdapter.notifyDataSetChanged();
                AppListViewAdapter.this.notifyDataSetChanged();
            } else {
                LogUtils.logErrorO("can not get appBean from db!");
            }
        }
    }

    private class ListViewHolder {
        public TextView appName;
        public TextView appDownloadCnt;
        public ImageView appIcon;
        public RatingBar appScore;
        public Button downloadState;

        private ListViewHolder() {
        }
    }
}

