/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.apptile;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import org.zywx.wbpalmstar.base.ResoureFinder;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.apptile.AppTileMainView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppTileBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.imageloader.ImageLoaderManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ViewUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.HeaderGridView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppTileBean;

public class AppTileListAdapter
extends BaseAdapter
implements AppStoreConstant {
    public static final String TAG = "AppsSubModuleListAdapter";
    private List<AppTileBean> list = new ArrayList<AppTileBean>();
    public LayoutInflater inflater;
    private Drawable defaultItemBg;
    private ResoureFinder finder;
    private int destSize = 0;
    private float density = 1.0f;
    private HeaderGridView mGridView = null;
    private static boolean isShowDeleteView = false;
    public int mChildsInParent;
    private Context mContext;
    private AppTileMainView mAppTileMainView;
    private ImageLoaderManager loaderManager;
    private boolean isAddTileIconIcon = true;
    private boolean isHomePage = true;
    private boolean isAddTileIconFirst = false;

    private void setAppTileList(List<AppTileBean> beans) {
        this.list.clear();
        if (this.isAddTileIconFirst) {
            if (this.isAddTileIconIcon) {
                this.list.add(new AppTileBean());
            }
            if (beans != null && beans.size() > 0) {
                this.list.addAll(beans);
            }
        } else {
            if (beans != null && beans.size() > 0) {
                this.list.addAll(beans);
            }
            if (this.isAddTileIconIcon) {
                this.list.add(new AppTileBean());
            }
        }
    }

    public AppTileListAdapter(AppTileMainView appTileMainView, Context context, List<AppTileBean> beans, HeaderGridView gridView, JSONObject optionJson) {
        this.mContext = context;
        this.inflater = LayoutInflater.from((Context)context);
        this.finder = ResoureFinder.getInstance((Context)context);
        this.isHomePage = optionJson.optBoolean("IS_HOME_PAGE", this.isHomePage);
        this.isAddTileIconIcon = optionJson.optBoolean("IS_SHOW_ADD_TILE_ICON", this.isAddTileIconIcon);
        this.isAddTileIconFirst = optionJson.optBoolean("IS_ADD_TILE_ICON_FIRST", this.isAddTileIconFirst);
        this.defaultItemBg = this.finder.getDrawable("plugin_appstoremgr_icon_bg");
        this.loaderManager = ImageLoaderManager.initImageLoaderManager(this.mContext);
        this.density = context.getResources().getDisplayMetrics().density;
        this.destSize = (int)(48.0f * this.density);
        this.mGridView = gridView;
        this.setAppTileList(beans);
        if (this.isHomePage) {
            this.mAppTileMainView = appTileMainView;
            this.mAppTileMainView.getDeltetAppOkButton().setOnClickListener((View.OnClickListener)new DelTileCompleteClick());
        }
    }

    public int getCount() {
        return this.list.size();
    }

    public AppTileBean getItem(int position) {
        return this.list.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public void removeItemAtPostion(int postion) {
        if (postion < 0 || postion > this.getCount() - 1) {
            return;
        }
        this.list.remove(postion);
        this.notifyDataSetChanged();
    }

    public int indexOfBindView(View view) {
        return this.list.indexOf(view);
    }

    private boolean isAddTileIcon(int position) {
        if (this.isAddTileIconFirst) {
            return 0 == position && this.isAddTileIconIcon;
        }
        return this.list.size() - 1 == position && this.isAddTileIconIcon;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        TileViewHolder holder = null;
        AppTileBean appTile = this.getItem(position);
        int tileWidth = 0;
        int tileHeight = 0;
        if (convertView == null) {
            holder = new TileViewHolder();
            convertView = this.inflater.inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_tile_grid_item"), null, false);
            holder.tileIconName = convertView.findViewById(EUExUtil.getResIdID((String)"plugin_appstore_tile_icon_name"));
            holder.ivTileIcon = (ImageView)convertView.findViewById(EUExUtil.getResIdID((String)"plugin_appstoremgr_tile_icon"));
            holder.tvTileName = (TextView)convertView.findViewById(EUExUtil.getResIdID((String)"plugin_appstoremgr_tile_name"));
            holder.ivDelIcon = (ImageView)convertView.findViewById(EUExUtil.getResIdID((String)"plugin_appstoremgr_del_tile_icon"));
            holder.pushIcon = (TextView)convertView.findViewById(EUExUtil.getResIdID((String)"plugin_appstoremgr_push_icon"));
            holder.ivAddHomeMarker = (ImageView)convertView.findViewById(EUExUtil.getResIdID((String)"plugin_appstoremgr_tile_add_home_icon"));
            AppTileBean localTile = new AppTileBeanDao(this.mContext).getSpecifyTile("app_tile_list", appTile.getAppId(), appTile.getTileName());
            if (!this.isHomePage && localTile != null && AppTileBean.isShowAtHomeMark(localTile)) {
                holder.ivAddHomeMarker.setVisibility(0);
            }
            tileWidth = SharedPrefUtils.getInt(this.mContext, "pluginAppStoreTileViewConfig", "pluginAppStoreTileWidth", 0);
            tileHeight = SharedPrefUtils.getInt(this.mContext, "pluginAppStoreTileViewConfig", "pluginAppStoreTileHeight", 0);
            convertView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(tileWidth, tileHeight));
            convertView.setPadding(convertView.getPaddingLeft(), convertView.getPaddingTop(), convertView.getPaddingRight(), (int)((float)tileHeight * 0.04f));
            RelativeLayout.LayoutParams rLayoutParams = (RelativeLayout.LayoutParams)holder.tileIconName.getLayoutParams();
            rLayoutParams.topMargin = (int)((float)tileHeight * 0.12f);
            rLayoutParams.bottomMargin = (int)((float)tileHeight * 0.04f);
            holder.tileIconName.setLayoutParams((ViewGroup.LayoutParams)rLayoutParams);
            int iconSize = Math.min((int)((float)tileHeight * 0.56f), (int)((float)tileWidth * 0.7f));
            holder.ivTileIcon.setLayoutParams((ViewGroup.LayoutParams)ViewUtils.getLinearLayoutParams(iconSize, iconSize, 17));
            int nameHight = (int)((float)tileHeight * 0.2f);
            LinearLayout.LayoutParams lParams = ViewUtils.getLinearLayoutParams(-1, nameHight, 17);
            lParams.topMargin = (int)((float)tileHeight * 0.08f);
            holder.tvTileName.setLayoutParams((ViewGroup.LayoutParams)lParams);
            convertView.setTag((Object)holder);
        } else {
            holder = (TileViewHolder)convertView.getTag();
        }
        convertView.setOnClickListener((View.OnClickListener)new TileClickListener(this.list, this.mGridView, holder.ivDelIcon, position));
        convertView.setOnLongClickListener((View.OnLongClickListener)new OnLongClick(position, this.list.get(position)));
        if (this.isAddTileIcon(position)) {
            holder.ivTileIcon.setBackgroundDrawable(this.finder.getDrawable("plugin_appstoremgr_add_tile"));
            holder.ivTileIcon.setImageDrawable(null);
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)holder.ivTileIcon.getLayoutParams();
            layoutParams.topMargin = (int)((float)tileHeight * 0.06f);
            holder.ivTileIcon.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            holder.tvTileName.setVisibility(8);
            holder.ivDelIcon.setVisibility(8);
            holder.pushIcon.setVisibility(4);
        } else {
            holder.ivDelIcon.setVisibility(ViewUtils.isShowTileDelBtn(isShowDeleteView, this.getItem(position)) ? 0 : 8);
            String iconLoc = appTile.getIcon();
            NetworkUtils.asyncLoadImage(this.mContext, holder.ivTileIcon, iconLoc, this.defaultItemBg, this.loaderManager);
            holder.tvTileName.setText((CharSequence)appTile.getTileName());
            if (holder.tvTileName.getVisibility() != 0) {
                holder.tvTileName.setVisibility(0);
            }
            holder.ivDelIcon.setOnClickListener((View.OnClickListener)new DeleteClickListener(appTile, holder.ivTileIcon));
        }
        return convertView;
    }

    private void chengeViewStatus(boolean isShowDel, View delOkBtn) {
        delOkBtn.setVisibility(isShowDel ? 0 : 8);
        isShowDeleteView = isShowDel;
        this.notifyDataSetChanged();
    }

    private View getAddHomeMark(int pos) {
        View view = null;
        if (this.mGridView != null) {
            view = this.mGridView.getChildAt(pos).findViewById(EUExUtil.getResIdID((String)"plugin_appstoremgr_tile_add_home_icon"));
        }
        return view;
    }

    private void addOrRemoveTileFromHome(int pos, AppTileBean appTile) {
        View viewMark = this.getAddHomeMark(pos);
        if (4 == viewMark.getVisibility()) {
            AppTileBeanDao appTileBeanDao = new AppTileBeanDao(this.mContext);
            appTile.setAddHomePage("true");
            if (!appTileBeanDao.addTile("app_tile_list", appTile)) {
                appTileBeanDao.updateTileAddHomePage("app_tile_list", appTile);
            }
            viewMark.setVisibility(0);
        }
    }

    public List<AppTileBean> getData() {
        return this.list;
    }

    class TileClickListener
    implements View.OnClickListener {
        private List<AppTileBean> appTileBeans;
        GridView gridView;
        ImageView deleteView;
        int position;

        public TileClickListener(List<AppTileBean> beans, GridView gridView, ImageView deleteView, int pos) {
            this.appTileBeans = beans;
            this.gridView = gridView;
            this.deleteView = deleteView;
            this.position = pos;
        }

        public void onClick(View view) {
            try {
                if (this.deleteView != null && this.deleteView.getVisibility() == 0) {
                    return;
                }
                System.out.println("============ App Name: " + this.appTileBeans.get(this.position).getAppName());
                if (!isShowDeleteView) {
                    if (AppTileListAdapter.this.isAddTileIcon(this.position)) {
                        AppTileListAdapter.this.mAppTileMainView.getEUExAppStoreMgrInstance().openMoreTiles(new String[0]);
                    } else {
                        EUExAppStoreMgr.getInstance().onTileClick(this.appTileBeans.get(this.position).getJsonStr());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class DeleteClickListener
    implements View.OnClickListener {
        AppTileBean appTile;
        View convertView;
        int position;
        ImageView appIcon;

        public DeleteClickListener(AppTileBean bean, ImageView image) {
            this.appTile = bean;
            this.appIcon = image;
        }

        public void onClick(View v) {
            this.appTile.setAddHomePage("false");
            new AppTileBeanDao(AppTileListAdapter.this.mContext).updateTileAddHomePage("app_tile_list", this.appTile);
            AppTileListAdapter.this.mAppTileMainView.refreshLocalAppTileData();
        }
    }

    class DelTileCompleteClick
    implements View.OnClickListener {
        DelTileCompleteClick() {
        }

        public void onClick(View v) {
            AppTileListAdapter.this.chengeViewStatus(false, v);
        }
    }

    class OnLongClick
    implements View.OnLongClickListener {
        private int pos;
        private AppTileBean appTile;

        public OnLongClick(int pos, AppTileBean appTile) {
            this.pos = pos;
            this.appTile = appTile;
        }

        public boolean onLongClick(View v) {
            if (AppTileListAdapter.this.isHomePage) {
                if (AppTileListAdapter.this.isAddTileIcon(this.pos)) {
                    return false;
                }
                if (!isShowDeleteView) {
                    AppTileListAdapter.this.chengeViewStatus(true, (View)AppTileListAdapter.this.mAppTileMainView.getDeltetAppOkButton());
                }
            } else {
                AppTileListAdapter.this.addOrRemoveTileFromHome(this.pos, this.appTile);
            }
            return true;
        }
    }

    public static class TileViewHolder {
        public View tileIconName;
        public TextView tvTileName;
        public ImageView ivTileIcon;
        public ImageView ivAddHomeMarker;
        public ImageView ivDelIcon;
        public TextView pushIcon;
    }
}

