/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.apptile;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.zywx.wbpalmstar.base.ResoureFinder;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppStoreMainView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.apptile.AppTileMainView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.apptile.SubAppDetailsListView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.apptile.SubAppListMgrView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDownLoadDb;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppLocalDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppTaskList;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppTileBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.ViewDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.ViewDataManager2;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.imageloader.ImageLoaderManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.CircleProgress;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.XExpandableListView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppTileBean;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class SubAppListMgrAdapter
extends BaseExpandableListAdapter
implements XExpandableListView.HeaderAdapter,
AppStoreConstant {
    private Context mContext;
    private LayoutInflater mInflater;
    private ImageLoaderManager loaderManager;
    private LinkedList<AppBean> apps = new LinkedList();
    private Drawable defaultItemBg;
    private ResoureFinder finder;
    private AppListViewHolder mAppListViewHolder = null;
    private XExpandableListView mExpandableListView;
    private int lastExpandItem = -1;
    private AppListViewHolder lastAppListViewHolder = null;
    private SubAppDetailsListView mDetailsListView = null;
    private WWidgetData mWWidgetData;
    private SparseIntArray groupStatusMap = new SparseIntArray();

    public SubAppListMgrAdapter(Context con, WWidgetData mWidgetData, List<AppBean> result, XExpandableListView listView) {
        this.mContext = con;
        this.mWWidgetData = mWidgetData;
        this.mExpandableListView = listView;
        this.mInflater = LayoutInflater.from((Context)this.mContext);
        if (result != null && result.size() > 0) {
            for (AppBean appBean : result) {
                this.apps.add(appBean);
            }
        }
        this.finder = ResoureFinder.getInstance((Context)this.mContext);
        this.defaultItemBg = this.finder.getDrawable("plugin_appstoremgr_icon_bg");
        this.loaderManager = ImageLoaderManager.initImageLoaderManager(this.mContext);
        this.mDetailsListView = new SubAppDetailsListView(this.mContext);
    }

    public void addList(List<AppBean> rankings) {
        if (rankings == null) {
            return;
        }
        for (AppBean ranking : rankings) {
            this.apps.addLast(ranking);
        }
        this.notifyDataSetChanged();
    }

    public void reload(List<AppBean> result) {
        this.apps.clear();
        if (result != null) {
            for (AppBean ranking : result) {
                this.apps.addFirst(ranking);
            }
        }
        this.notifyDataSetChanged();
    }

    private void drawDownloadBtnInstalled() {
        this.mAppListViewHolder.downloadState.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_installed"));
        this.mAppListViewHolder.downloadState.setTextColor(EUExUtil.getResColorID((String)"plugin_appstoremgr_download_installed_color"));
        this.mAppListViewHolder.downloadState.setBackgroundResource(EUExUtil.getResDrawableID((String)"plugin_appstoremgr_sub_app_installed_bt"));
        this.mAppListViewHolder.downloadState.setClickable(false);
    }

    private void drawDownloadBtn(String text) {
        this.mAppListViewHolder.downloadState.setText((CharSequence)text);
        this.mAppListViewHolder.downloadState.setTextColor(EUExUtil.getResColorID((String)"plugin_appstoremgr_download_main_color"));
        this.mAppListViewHolder.downloadState.setBackgroundResource(EUExUtil.getResDrawableID((String)"plugin_appstoremgr_sub_app_download_bt"));
        this.mAppListViewHolder.downloadState.setClickable(true);
    }

    private void drawDownloading(AppBean appBean) {
        int progress = AppLocalDataManager.getProgress(this.mContext, appBean.getAppId());
        if (ViewDataManager.downloadTaskRun(appBean)) {
            if (progress < 100) {
                this.mAppListViewHolder.downloadState.setVisibility(8);
                this.mAppListViewHolder.rbPercent.setVisibility(0);
                this.mAppListViewHolder.rbPercent.setProgress(progress);
            }
        } else {
            int index = AppStoreMainView.APP_PAUSE_LIST.indexOf(appBean);
            if (index > -1 && progress < 100) {
                this.mAppListViewHolder.downloadState.setVisibility(8);
                this.mAppListViewHolder.rbPercent.setVisibility(0);
                this.mAppListViewHolder.rbPercent.setPause(true);
            } else {
                AppLocalDataManager.removeProgress(this.mContext, appBean.getAppId());
                if (appBean.getNewApp() == 2) {
                    new AppBeanDao(this.mContext).updateAppState(appBean.getAppId(), 4, appBean.getInstallPath());
                    this.notifyDataSetChanged();
                } else {
                    this.mAppListViewHolder.rbPercent.setVisibility(8);
                    this.mAppListViewHolder.rbPercent.setPause(false);
                }
            }
        }
    }

    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        this.mAppListViewHolder = new AppListViewHolder();
        convertView = this.mInflater.inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_sub_app_listview_item"), null);
        this.mAppListViewHolder.appIcon = (ImageView)convertView.findViewById(EUExUtil.getResIdID((String)"imageView"));
        this.mAppListViewHolder.appName = (TextView)convertView.findViewById(EUExUtil.getResIdID((String)"appName"));
        this.mAppListViewHolder.appDetails = (RelativeLayout)convertView.findViewById(EUExUtil.getResIdID((String)"appDetails"));
        this.mAppListViewHolder.appDetailsIcon = (ImageView)convertView.findViewById(EUExUtil.getResIdID((String)"appDetailsIv"));
        this.mAppListViewHolder.downloadState = (Button)convertView.findViewById(EUExUtil.getResIdID((String)"downloadState"));
        this.mAppListViewHolder.rbPercent = (CircleProgress)convertView.findViewById(EUExUtil.getResIdID((String)"plugin_appstoremgr_app_download_indicator"));
        convertView.setTag((Object)this.mAppListViewHolder);
        AppBean app = this.apps.get(groupPosition);
        this.mAppListViewHolder.appName.setText((CharSequence)app.getAppName());
        AppBean localApp = new AppBeanDao(this.mContext).getAppBean(app.getAppId());
        if (AppUtils.isAppInstalled(this.mContext, app)) {
            app.setState(4);
            if (null == localApp) {
                new AppBeanDao(this.mContext).addAppBean("app_list", app);
                localApp = new AppBeanDao(this.mContext).getAppBean(app.getAppId());
            } else if (localApp.getState() != 4 && localApp.getState() != 2) {
                localApp.setState(4);
                new AppBeanDao(this.mContext).updateAppState(localApp.getAppId(), 4, null);
            }
        }
        this.mAppListViewHolder.appDetails.setOnClickListener((View.OnClickListener)new AppDetailsListener(app, this.mAppListViewHolder, groupPosition));
        this.mAppListViewHolder.downloadState.setOnClickListener((View.OnClickListener)new DownloadBtnListener(app, this.mWWidgetData));
        switch (app.getType()) {
            case 1: {
                if (localApp != null) {
                    this.drawDownloadBtnInstalled();
                    break;
                }
                this.drawDownloadBtn(EUExUtil.getString((String)"plugin_appstore_install_app"));
                break;
            }
            case 3: {
                if (localApp != null && localApp.getState() == 4 && localApp.getNewApp() != 2 && AppUtils.isWidgetInstalled(app.getAppId())) {
                    this.drawDownloadBtnInstalled();
                    break;
                }
                if (localApp != null && localApp.getState() == 4 && localApp.getNewApp() == 2 && AppUtils.isWidgetInstalled(app.getAppId())) {
                    this.drawDownloadBtn(EUExUtil.getString((String)"plugin_appstore_app_upgrade"));
                    break;
                }
                if (localApp != null && localApp.getState() == 2) {
                    app.setNewApp(localApp.getNewApp());
                    this.drawDownloading(app);
                    break;
                }
                this.drawDownloadBtn(EUExUtil.getString((String)"plugin_appstore_install_app"));
                break;
            }
            case 2: 
            case 4: {
                if (localApp != null && localApp.getState() == 4 && localApp.getNewApp() != 2 && AppUtils.isAppInstalled(this.mContext, localApp)) {
                    this.drawDownloadBtnInstalled();
                    break;
                }
                if (localApp != null && localApp.getState() == 4 && localApp.getNewApp() == 2 && AppUtils.isAppInstalled(this.mContext, localApp)) {
                    this.drawDownloadBtn(EUExUtil.getString((String)"plugin_appstore_app_upgrade"));
                    break;
                }
                if (localApp != null && localApp.getState() == 2) {
                    this.drawDownloading(app);
                    break;
                }
                this.drawDownloadBtn(EUExUtil.getString((String)"plugin_appstore_install_app"));
            }
        }
        String url = app.getIconLoc();
        NetworkUtils.asyncLoadImage(this.mContext, this.mAppListViewHolder.appIcon, url, this.defaultItemBg, this.loaderManager);
        this.setAppDetailsIconBackGround(this.mAppListViewHolder.appDetailsIcon, groupPosition);
        return convertView;
    }

    public void refresh(List<AppBean> beans) {
        this.apps.addAll(beans);
        this.notifyDataSetChanged();
    }

    public int getItemPosition(AppBean app) {
        return this.apps.indexOf(app);
    }

    private void setAppDetailsIconBackGround(ImageView appDetailsIcon, int groupPosition) {
        if (this.getGroupClickStatus(groupPosition) == 1) {
            appDetailsIcon.setBackgroundResource(EUExUtil.getResDrawableID((String)"plugin_appstoremgr_sub_app_details_expand"));
        } else {
            appDetailsIcon.setBackgroundResource(EUExUtil.getResDrawableID((String)"plugin_appstoremgr_sub_app_details_collapse"));
        }
    }

    public Object getChild(int groupPosition, int childPosition) {
        return null;
    }

    public long getChildId(int groupPosition, int childPosition) {
        return 0L;
    }

    private View createChildrenView(int groupPosition) {
        View view = this.mInflater.inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_sub_apps_details_listview"), null);
        return view;
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        View view = this.createChildrenView(groupPosition);
        if (null == this.mDetailsListView) {
            this.mDetailsListView = new SubAppDetailsListView(this.mContext);
        }
        view = this.mDetailsListView.updateDetailsListView(view, this.apps.get(groupPosition));
        return view;
    }

    public int getChildrenCount(int groupPosition) {
        return 1;
    }

    public Object getGroup(int groupPosition) {
        return this.apps.get(groupPosition);
    }

    public int getGroupCount() {
        return this.apps.size();
    }

    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public boolean hasStableIds() {
        return true;
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    @Override
    public int getHeaderState(int groupPosition, int childPosition) {
        int childCount = this.getChildrenCount(groupPosition);
        if (childPosition == childCount - 1) {
            return 2;
        }
        if (childPosition == -1 && !this.mExpandableListView.isGroupExpanded(groupPosition)) {
            return 0;
        }
        return 1;
    }

    @Override
    public void configureHeader(View header, int groupPosition, int childPosition, int alpha) {
    }

    @Override
    public void setGroupClickStatus(int groupPosition, int status) {
        this.groupStatusMap.put(groupPosition, status);
    }

    @Override
    public int getGroupClickStatus(int groupPosition) {
        if (this.groupStatusMap.keyAt(groupPosition) >= 0) {
            return this.groupStatusMap.get(groupPosition);
        }
        return 0;
    }

    class AppDetailsListener
    implements View.OnClickListener {
        AppBean appBean;
        AppListViewHolder holder = null;
        int groupPosition;

        public AppDetailsListener(AppBean appBean, AppListViewHolder holder, int groupPosition) {
            this.appBean = appBean;
            this.holder = holder;
            this.groupPosition = groupPosition;
        }

        public void onClick(View v) {
            this.headerViewClick(this.groupPosition);
            SubAppListMgrAdapter.this.lastExpandItem = this.groupPosition;
            SubAppListMgrAdapter.this.lastAppListViewHolder = this.holder;
        }

        private void collapseGroup(AppListViewHolder holder, int groupPosition) {
            SubAppListMgrAdapter.this.mExpandableListView.collapseGroup(groupPosition);
            SubAppListMgrAdapter.this.setGroupClickStatus(groupPosition, 0);
            SubAppListMgrAdapter.this.setAppDetailsIconBackGround(holder.appDetailsIcon, groupPosition);
        }

        private void expandGroup(AppListViewHolder holder, int groupPosition) {
            SubAppListMgrAdapter.this.mExpandableListView.expandGroup(groupPosition);
            SubAppListMgrAdapter.this.setGroupClickStatus(groupPosition, 1);
            SubAppListMgrAdapter.this.setAppDetailsIconBackGround(holder.appDetailsIcon, groupPosition);
        }

        private void headerViewClick(int groupPosition) {
            if (SubAppListMgrAdapter.this.getGroupClickStatus(groupPosition) == 1) {
                this.collapseGroup(this.holder, groupPosition);
            } else {
                if (SubAppListMgrAdapter.this.lastAppListViewHolder != null && SubAppListMgrAdapter.this.lastExpandItem != -1 && SubAppListMgrAdapter.this.lastExpandItem < SubAppListMgrAdapter.this.apps.size()) {
                    this.collapseGroup(SubAppListMgrAdapter.this.lastAppListViewHolder, SubAppListMgrAdapter.this.lastExpandItem);
                }
                this.expandGroup(this.holder, groupPosition);
            }
        }
    }

    class DownloadBtnListener
    implements View.OnClickListener {
        private AppBean appBean;
        private WWidgetData mWidgetData;

        public DownloadBtnListener(AppBean appBean, WWidgetData mWidgetData) {
            this.appBean = appBean;
            this.mWidgetData = mWidgetData;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onClick(View v) {
            XExpandableListView gridView = SubAppListMgrView.getInstance().getSubAppListGridView();
            String appId = this.appBean.getAppId();
            ArrayList<AppTileBean> tileList = this.appBean.getTilesList();
            int oldState = this.appBean.getState();
            AppBean localApp = new AppBeanDao(SubAppListMgrAdapter.this.mContext).getAppBean(appId);
            if (null == localApp) {
                new AppBeanDao(SubAppListMgrAdapter.this.mContext).addAppBean("app_list", this.appBean);
                this.appBean = new AppBeanDao(SubAppListMgrAdapter.this.mContext).getAppBean(appId);
            } else {
                this.appBean = localApp;
            }
            new AppTileBeanDao(SubAppListMgrAdapter.this.mContext).addTileList("app_tile_list", tileList);
            if (this.appBean == null) {
                LogUtils.logErrorO("can not get appBean from db!");
                return;
            }
            AppTileMainView.getInstance().refreshLocalAppTileData();
            SubAppListMgrAdapter appsListAdapter = gridView.getWrapedAdapter();
            if (this.appBean.getType() != 1) {
                AppTaskList appsTaskList = ViewDataManager2.getAppTaskList();
                String mAppId = this.appBean.getAppId();
                ViewDataManager2 viewDataManager = ViewDataManager2.getInstance();
                switch (this.appBean.getType()) {
                    case 2: 
                    case 4: {
                        if (AppUtils.isNativeAppInstalled(SubAppListMgrAdapter.this.mContext, this.appBean.getPackageName()) && oldState != 4) {
                            AppUtils.changeAppStateToInstall(SubAppListMgrAdapter.this.mContext, this.mWidgetData, this.appBean);
                            SubAppListMgrAdapter.this.notifyDataSetChanged();
                            break;
                        }
                        if (appsTaskList.isExistTask(mAppId, SubAppListMgrAdapter.this.mContext)) {
                            return;
                        }
                        String[] result = AppDownLoadDb.getFilePathFromDownload(SubAppListMgrAdapter.this.mContext, this.appBean.getDownloadUrl());
                        if (result != null) {
                            String path = result[0];
                            String size = result[1];
                            if (!TextUtils.isEmpty((CharSequence)path) && !TextUtils.isEmpty((CharSequence)size)) {
                                int fileSize = Integer.parseInt(size);
                                File file = new File(path);
                                if (file.exists() && file.length() == (long)fileSize) {
                                    EUExAppStoreMgr.getInstance().installApp(this.appBean, file);
                                    AppLocalDataManager.saveApkPath(SubAppListMgrAdapter.this.mContext, this.appBean.getAppId(), file.getAbsolutePath());
                                    AppLocalDataManager.removeProgress(SubAppListMgrAdapter.this.mContext, this.appBean.getAppId());
                                    SubAppListMgrAdapter.this.notifyDataSetChanged();
                                    return;
                                }
                            }
                        }
                        viewDataManager.launch(SubAppListMgrAdapter.this.mContext, this.appBean, 0);
                        break;
                    }
                    case 3: {
                        if (appsTaskList.isExistTask(mAppId, SubAppListMgrAdapter.this.mContext)) {
                            return;
                        }
                        if ((1 == this.appBean.getState() || 4 == this.appBean.getState()) && this.appBean.getNewApp() != 2 && AppUtils.isWidgetInstalled(this.appBean.getAppId())) {
                            String[] updateInfo = new AppBeanDao(SubAppListMgrAdapter.this.mContext).getUpdate(this.appBean.getAppId());
                            if (updateInfo == null) break;
                            String filePath = updateInfo[0];
                            String appVer = updateInfo[1];
                            if (TextUtils.isEmpty((CharSequence)filePath) || !filePath.endsWith(".zip") || TextUtils.isEmpty((CharSequence)appVer)) break;
                            if (new File(filePath).exists()) {
                                AppBean bean = this.appBean;
                                bean.setInstallVersion(appVer);
                                viewDataManager.unzip(SubAppListMgrAdapter.this.mContext, bean, filePath, 1);
                                SubAppListMgrAdapter.this.notifyDataSetChanged();
                                return;
                            }
                            new AppBeanDao(SubAppListMgrAdapter.this.mContext).deleteUpdate(this.appBean.getAppId());
                            break;
                        }
                        String[] result = AppDownLoadDb.getFilePathFromDownload(SubAppListMgrAdapter.this.mContext, this.appBean.getDownloadUrl());
                        if (result != null) {
                            String path = result[0];
                            String size = result[1];
                            if (!TextUtils.isEmpty((CharSequence)path) && !TextUtils.isEmpty((CharSequence)size)) {
                                int fileSize = Integer.parseInt(size);
                                File file = new File(path);
                                if (file.exists() && file.length() == (long)fileSize) {
                                    viewDataManager.unzip(SubAppListMgrAdapter.this.mContext, this.appBean, path, 0);
                                    SubAppListMgrAdapter.this.notifyDataSetChanged();
                                    return;
                                }
                            }
                        }
                        SubAppListMgrAdapter.this.notifyDataSetChanged();
                        viewDataManager.launch(SubAppListMgrAdapter.this.mContext, this.appBean, 0);
                        break;
                    }
                }
            } else {
                AppUtils.changeAppStateToInstall(SubAppListMgrAdapter.this.mContext, this.mWidgetData, this.appBean);
            }
            appsListAdapter.notifyDataSetChanged();
            SubAppListMgrAdapter.this.notifyDataSetChanged();
        }
    }

    private class AppListViewHolder {
        public TextView appName;
        public ImageView appIcon;
        public RelativeLayout appDetails;
        public ImageView appDetailsIcon;
        public Button downloadState;
        public CircleProgress rbPercent;

        private AppListViewHolder() {
        }
    }
}

