/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.data;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppStoreMainView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDownLoadDb;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppLocalDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.MyAsyncTask;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoteHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.FileUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.RemoveDupByTimeVO;

public class AppDownTask
extends MyAsyncTask
implements AppStoreConstant {
    public AppBean appBean;
    private long length;
    protected long count;
    private boolean isWait = false;
    private boolean isVisibleAppStroe = true;
    private boolean confirm = true;
    protected int type = -1;
    protected Context mContext;
    protected RemoveDupByTimeVO lastDownloadVO = new RemoveDupByTimeVO();
    private boolean notifyState = true;
    private static int notifyStateTimeout = 0;
    private Handler notifyDownloadStatusHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    AppDownTask.this.mContext.sendBroadcast(AppStoreUtils.getNotifyDownloadIntent(AppDownTask.this.mContext.getPackageName(), AppDownTask.this.appBean.getAppId()));
                    notifyStateTimeout = 2000;
                    AppDownTask.this.notifyState = true;
                    break;
                }
            }
        }
    };

    public AppDownTask(Context mContext, AppBean appBean, int inType, boolean isVisibleAppStroe, boolean confirm) {
        if (appBean == null) {
            throw new NullPointerException("new AppDownTask params can not be null...");
        }
        this.type = inType;
        this.appBean = appBean;
        this.mContext = mContext;
        this.isVisibleAppStroe = isVisibleAppStroe;
        this.confirm = confirm;
    }

    public AppBean getAppBean() {
        return this.appBean;
    }

    public String getTaskId() {
        String taskId = "";
        if (this.appBean != null) {
            taskId = this.appBean.getAppId();
        }
        return taskId;
    }

    public void setWait(boolean wait) {
        this.isWait = wait;
    }

    public boolean getWait() {
        return this.isWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doInBackground(Object ... params) {
        block62: {
            boolean readIs = true;
            HttpURLConnection conn = null;
            InputStream is = null;
            File tmpFile = null;
            RandomAccessFile fos = null;
            FileInputStream fis = null;
            long fileSize = 0L;
            String downloadUrl = (String)params[0];
            try {
                if (AppStoreMainView.APP_PAUSE_LIST.indexOf(this.appBean) > -1) {
                    AppStoreMainView.APP_PAUSE_LIST.remove(this.appBean);
                }
                new AppBeanDao(this.mContext).updateAppState(this.appBean.getAppId(), 2, null);
                LogUtils.logDebug(true, "status: " + this.getStatus() + " url: " + downloadUrl);
                String[] res = AppDownLoadDb.selectTaskFromDB(this.mContext, downloadUrl);
                this.type = "0".equals((String)params[1]) ? 0 : 1;
                if (res != null) {
                    fileSize = Integer.parseInt(res[1]);
                    this.count = Integer.parseInt(res[2]);
                    tmpFile = new File(res[0]);
                } else {
                    tmpFile = FileUtils.createExternalCacheFile(this.mContext, this.appBean);
                    LogUtils.logDebug(true, "download tmpFile:" + tmpFile.getAbsolutePath());
                    if (tmpFile.exists()) {
                        tmpFile.delete();
                    }
                    tmpFile.createNewFile();
                }
                if (fileSize > 0L && fileSize == this.count) {
                    if (tmpFile.exists()) {
                        LogUtils.logDebug(true, "AppDownTask \u6587\u4ef6\u5b58\u5728\uff0c\u91cd\u547d\u540d");
                        tmpFile = AppUtils.isNativeApp(this.appBean.getType()) ? FileUtils.renameApk(tmpFile) : FileUtils.rename(tmpFile);
                        File file = tmpFile;
                        return file;
                    }
                    LogUtils.logDebug(true, "AppDownTask \u6587\u4ef6\u4e0d\u5b58\u5728");
                    AppDownLoadDb.deleteTaskFromDB(this.mContext, downloadUrl);
                    this.count = 0L;
                }
                conn = AppStoteHttpURLConnection.getHttpURLConnection(this.mContext, downloadUrl, 5000, 60000);
                conn.setInstanceFollowRedirects(true);
                LogUtils.logDebugO(true, "load sub app getHttpURLConnection");
                if (conn != null) {
                    if (this.count > 0L) {
                        conn.setRequestProperty("RANGE", "bytes=" + this.count + "-");
                    }
                    conn.connect();
                    try {
                        this.length = conn.getContentLength();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    int code = conn.getResponseCode();
                    if (code >= 200 && code < 300) {
                        is = conn.getInputStream();
                        if (is != null) {
                            if (this.length == -1L) {
                                this.length = is.available();
                            }
                            this.length += this.count;
                            AppDownLoadDb.addTaskToDB(this.mContext, downloadUrl, tmpFile.getPath(), this.length, (String)params[2]);
                            byte[] buffer = new byte[8096];
                            int actualSize = -1;
                            fos = new RandomAccessFile(tmpFile, "rw");
                            if (this.count > 0L) {
                                fos.seek(this.count);
                            }
                            int downloadPercent = 0;
                            while (!this.isCancelled() && readIs && (actualSize = is.read(buffer)) != -1) {
                                fos.write(buffer, 0, actualSize);
                                if (this.length > 0L) {
                                    this.count += (long)actualSize;
                                    downloadPercent = (int)(100L * this.count / this.length);
                                    long nowTime = System.currentTimeMillis();
                                    if (nowTime - this.lastDownloadVO.time >= 800L || -1 == this.lastDownloadVO.actionId && 0 == downloadPercent) {
                                        this.lastDownloadVO.actionId = downloadPercent;
                                        this.lastDownloadVO.time = nowTime;
                                        this.publishProgress(new Integer[]{downloadPercent});
                                    }
                                    AppLocalDataManager.saveProgress(this.mContext, this.appBean.getAppId(), downloadPercent);
                                    continue;
                                }
                                LogUtils.logDebugO(true, "load sub app getContentLength <= 0");
                            }
                            if (downloadPercent >= 100) {
                                tmpFile = AppUtils.isNativeApp(this.appBean.getType()) ? FileUtils.renameApk(tmpFile) : FileUtils.rename(tmpFile);
                                AppDownLoadDb.updateTaskFromDB(this.mContext, downloadUrl, tmpFile.getAbsolutePath(), this.count);
                            }
                        }
                    } else {
                        LogUtils.logDebug(true, "download error code = " + code);
                    }
                    String filePath = tmpFile.getAbsolutePath();
                    if (tmpFile.exists() && !filePath.endsWith(".tmp")) {
                        File file = tmpFile;
                        return file;
                    }
                    break block62;
                }
                LogUtils.logDebugO(true, "load sub app getHttpURLConnection is null.");
                readIs = false;
            }
            catch (Exception e) {
                LogUtils.oe("download sub app catch", e);
                readIs = false;
                e.printStackTrace();
            }
            finally {
                LogUtils.logDebugO(true, "download sub app finally, appId:" + this.appBean.getAppId() + " downloadPercent = " + AppLocalDataManager.getProgress(this.mContext, this.appBean.getAppId()) + " isCancelled:" + this.isCancelled() + " readIs:" + readIs);
                if (!readIs) {
                    EUExAppStoreMgr.cbLoadWidget(0, this.appBean, "");
                }
                AppDownLoadDb.updateTaskFromDB(this.mContext, downloadUrl, this.count);
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    fis = null;
                }
                if (conn != null) {
                    conn.disconnect();
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    fos = null;
                }
            }
        }
        return null;
    }

    private void showProgressRightnow() {
        notifyStateTimeout = 0;
        this.notifyState = true;
    }

    @Override
    public void handleOnPreLoad(MyAsyncTask task) {
        LogUtils.logDebug(true, "AppDownTask handleOnPreLoad");
        if (this.type == 0 && this.appBean != null) {
            int progress = AppLocalDataManager.getProgress(this.mContext, this.appBean.getAppId());
            if (this.isVisibleAppStroe) {
                this.showProgressRightnow();
                if (100 == progress) {
                    AppLocalDataManager.saveProgress(this.mContext, this.appBean.getAppId(), progress);
                }
            } else {
                if (this.confirm) {
                    EUExAppStoreMgr.onStartDownload();
                }
                if (0L == this.count && progress > 0) {
                    progress = 0;
                }
            }
            this.showProgress(this.appBean, progress, false);
        }
    }

    @Override
    public void handleOnUpdateProgress(MyAsyncTask task, int percent) {
        if (this.type == 0) {
            if (this.isVisibleAppStroe && 100 == percent) {
                this.showProgressRightnow();
            }
            if (!this.isVisibleAppStroe) {
                Intent intent = new Intent();
                intent.setAction("downloadPercent");
                intent.putExtra("percent", percent);
                intent.putExtra("appId", this.appBean.getAppId());
                intent.setPackage(this.mContext.getPackageName());
                this.mContext.sendBroadcast(intent);
            }
            this.showProgress(this.appBean, percent, false);
        }
    }

    @Override
    public void handleOnCanceled(MyAsyncTask task) {
        LogUtils.logDebugO(true, "download sub app handleOnCanceled.");
        LogUtils.logDebug(true, " AppDownTask handleOnCanceled, taskId: " + this.getTaskId() + ", isCancelled: " + this.isCancelled());
        if (AppStoreMainView.APP_PAUSE_LIST.indexOf(this.appBean) == -1) {
            AppStoreMainView.APP_PAUSE_LIST.add(this.appBean);
        }
        try {
            if (this.isVisibleAppStroe) {
                this.showProgressRightnow();
            }
            this.showProgress(this.appBean, AppLocalDataManager.getProgress(this.mContext, this.appBean.getAppId()), true);
        }
        catch (Exception e) {
            LogUtils.oe("app down task handle canceled exception:", e);
        }
    }

    @Override
    public void handleOnCompleted(MyAsyncTask task, Object result) {
        LogUtils.logDebug(true, "AppDownTask handleOnCompleted");
    }

    public boolean equals(Object o) {
        AppDownTask task;
        if (o != null && o instanceof AppDownTask && (task = (AppDownTask)o).getTaskId().equals(this.getTaskId())) {
            return true;
        }
        return super.equals(o);
    }

    private void showProgress(AppBean appBean, int progress, boolean isPause) {
        LogUtils.logDebug(true, "appId:" + appBean.getAppId() + " progress: " + progress);
        if (this.confirm) {
            if (this.isVisibleAppStroe) {
                if (this.notifyState) {
                    this.notifyState = false;
                    Message msg = new Message();
                    msg.what = 1;
                    msg.arg1 = progress;
                    this.notifyDownloadStatusHandler.sendMessageDelayed(msg, (long)notifyStateTimeout);
                }
            } else {
                EUExAppStoreMgr.cbGetProgress(progress);
            }
        }
    }
}

