/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.data;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import java.io.File;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.DataHelper;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDownLoadDb;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppStoteDataParser;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoreURLMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoteHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreTokenUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.FileUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.GetAppEvaluteVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.GetAppListVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.GetAppVersionVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.GetTilesVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.SubmitAppEvaluteVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class AppHttpDataManager
implements AppStoreConstant {
    private static AsyncTask<Void, Void, Void> getAppListAsyncTask = null;

    public static boolean getAppList(Context mContext, String info, EUExAppStoreMgr mEUExAppStoreMgr, WWidgetData mWidgetData) {
        boolean flg = true;
        GetAppListVO mGetAppsListVO = (GetAppListVO)DataHelper.gson.fromJson(info, GetAppListVO.class);
        String type = mGetAppsListVO.getType();
        String url = "";
        boolean isInstall = false;
        int appSrc = 0;
        JSONObject jsonParams = new JSONObject();
        try {
            jsonParams.put("softToken", (Object)AppStoreTokenUtils.getSoftToken(mContext));
            jsonParams.put("pageSize", (Object)mGetAppsListVO.getPageSize());
            jsonParams.put("indexId", (Object)mGetAppsListVO.getIndexId());
            if ("greatAppList".equals(type)) {
                url = AppStoreURLMgr.getUrlGreatAppList();
            } else if ("rankAppList".equals(type)) {
                url = AppStoreURLMgr.getUrlRankingList();
            } else if ("appTypeList".equals(type)) {
                String appType = "";
                url = AppStoreURLMgr.getUrlSearchList();
                jsonParams.put("appType", (Object)appType);
            } else if ("appList".equals(type)) {
                url = AppStoreURLMgr.getUrlSearchList();
            } else if ("installAppList".equals(type)) {
                url = AppStoreURLMgr.getUrlInstallAppList();
                isInstall = true;
                appSrc = 0;
            } else if ("installAppFromAllList".equals(type)) {
                url = AppStoreURLMgr.getUrlSearchList();
                isInstall = true;
                appSrc = 1;
            } else if ("searchAppList".equals(type)) {
                url = AppStoreURLMgr.getUrlSearchList();
                if (!TextUtils.isEmpty((CharSequence)mGetAppsListVO.getKey())) {
                    jsonParams.put("keyWords", (Object)mGetAppsListVO.getKey());
                }
            } else {
                flg = false;
            }
            if (!"".equals(url)) {
                AppHttpDataManager.downloadAppListInfo(mContext, url, mEUExAppStoreMgr, 0, "appList", isInstall, mWidgetData, jsonParams, appSrc);
            } else {
                LogUtils.logErrorO("Get appList url is null! Maybe not call open!");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return flg;
    }

    public static void getTiles(final Context mContext, final EUExAppStoreMgr mEUExAppStoreMgr, final WWidgetData mWidgetData, final GetTilesVO mGetTilesVO) {
        new AsyncTask<Void, Void, String>(){
            JSONObject jsonParams = null;

            protected void onPreExecute() {
                this.jsonParams = AppStoteDataParser.changeSoftTokenToJson(mContext);
                if (null != mGetTilesVO) {
                    try {
                        this.jsonParams.put("pageSize", (Object)mGetTilesVO.getPageSize());
                        this.jsonParams.put("indexId", (Object)mGetTilesVO.getIndexId());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            protected String doInBackground(Void ... params) {
                return AppStoteHttpURLConnection.downLoadAppList(mContext, mWidgetData, AppStoreURLMgr.getUrlGetTiles(), this.jsonParams, "appList").getResult();
            }

            protected void onPostExecute(String params) {
                mEUExAppStoreMgr.cbGetTiles(params);
            }
        }.execute((Object[])new Void[0]);
    }

    public static void getCategoryList(Context mContext, EUExAppStoreMgr mEUExAppStoreMgr, WWidgetData mWidgetData) {
        JSONObject jsonParams = new JSONObject();
        AppHttpDataManager.downloadAppListInfo(mContext, AppStoreURLMgr.getUrlCategoryList(), mEUExAppStoreMgr, 1, "appTypeList", false, mWidgetData, jsonParams, 0);
    }

    private static boolean isAppFullPackageDownloading(Context mContext, String url) {
        boolean download = false;
        String[] res = AppDownLoadDb.selectTaskFromDB(mContext, url);
        if (null != res) {
            int fileSize = Integer.parseInt(res[1]);
            int downSize = Integer.parseInt(res[2]);
            String pkgType = res[4];
            download = fileSize != downSize && "upgrade".equals(pkgType);
        }
        return download;
    }

    private static void downloadAppListInfo(final Context mContext, final String url, final EUExAppStoreMgr mEUExAppStoreMgr, final int type, final String listKey, final boolean isInstall, final WWidgetData mWidgetData, final JSONObject jsonParams, final int appSrc) {
        int wait;
        if (!NetworkUtils.isOnline(mContext)) {
            AppHttpDataManager.getAppListInfoCallBack(mContext, mEUExAppStoreMgr, type, "fail", EUExUtil.getString((String)"plugin_appstore_hint_error_network"), isInstall);
            return;
        }
        for (wait = 0; getAppListAsyncTask != null && wait < 10; ++wait) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (wait >= 9) {
            return;
        }
        getAppListAsyncTask = new AsyncTask<Void, Void, Void>(){
            private int reportCount = 0;
            boolean isGetAgain = false;

            protected void onPreExecute() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doInBackground(Void ... params) {
                AsyncTask asyncTask = getAppListAsyncTask;
                synchronized (asyncTask) {
                    String response = "";
                    response = AppStoteHttpURLConnection.downLoadAppList(url, mContext, mWidgetData, jsonParams).getResult();
                    String msg = "";
                    String status = "";
                    if (!TextUtils.isEmpty((CharSequence)response)) {
                        try {
                            JSONObject appListResultJson = new JSONObject(response);
                            status = appListResultJson.optString("status", "fail");
                            String key = "ok".equals(status) ? listKey : "info";
                            msg = appListResultJson.optString(key);
                            if (isInstall && "ok".equals(status)) {
                                JSONArray appListFromNet = new JSONArray(msg);
                                JSONArray appListToWeb = new JSONArray();
                                for (int i = 0; i < appListFromNet.length(); ++i) {
                                    final JSONObject jsonItem = appListFromNet.getJSONObject(i);
                                    AppBean appBean = AppStoteDataParser.parseAppBean(jsonItem);
                                    if (appBean.getType() == -1) continue;
                                    boolean isAppInstall = AppUtils.isAppInstalled(mContext, appBean);
                                    if (isAppInstall || !isAppInstall && AppHttpDataManager.isAppFullPackageDownloading(mContext, appBean.getDownloadUrl())) {
                                        jsonItem.put("state", (Object)"1");
                                        appListToWeb.put((Object)jsonItem);
                                        continue;
                                    }
                                    if (0 != appSrc) continue;
                                    new AsyncTask<Object, Object, Object>(){

                                        protected void onPreExecute() {
                                            reportCount++;
                                        }

                                        protected Object doInBackground(Object ... params) {
                                            return AppHttpDataManager.appUninstallReport(mContext, mWidgetData, jsonItem.optString("appId"));
                                        }

                                        protected void onPostExecute(Object params) {
                                            reportCount--;
                                        }
                                    }.execute(new Object[0]);
                                }
                                if (AppStoreUtils.isFirstGetInstallAppList(mContext) && 0 == appSrc) {
                                    int i;
                                    File[] files = FileUtils.getListFilesFromDir(AppStoreUtils.getWidgetSavePath());
                                    for (i = 0; i < files.length; ++i) {
                                        boolean isNeedInstallReport = false;
                                        if (files[i].isDirectory() && FileUtils.isExistConfigFile(files[i])) {
                                            if (0 == appListToWeb.length()) {
                                                isNeedInstallReport = true;
                                            } else {
                                                for (int j = 0; j < appListToWeb.length(); ++j) {
                                                    String appId = appListToWeb.getJSONObject(j).optString("appId");
                                                    if (files[i].getName().equals(appId)) break;
                                                    isNeedInstallReport = true;
                                                }
                                            }
                                        }
                                        if (!isNeedInstallReport) continue;
                                        new AsyncTask<Object, Object, Object>(){

                                            protected void onPreExecute() {
                                                isGetAgain = true;
                                                reportCount++;
                                            }

                                            protected Object doInBackground(Object ... params) {
                                                AppBean appBean = AppBean.getInstallReportAppBeanByAppId((String)params[0]);
                                                return AppHttpDataManager.appInstallReport(mContext, appBean, mWidgetData);
                                            }

                                            protected void onPostExecute(Object params) {
                                                reportCount--;
                                            }
                                        }.execute(new Object[]{files[i].getName()});
                                    }
                                    AppStoreUtils.setFirstGetInstallAppList(mContext, false);
                                    if (this.isGetAgain) {
                                        i = 0;
                                        while (this.reportCount != 0 && i < 10) {
                                            try {
                                                Thread.sleep(200L);
                                                ++i;
                                            }
                                            catch (InterruptedException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                        response = AppStoteHttpURLConnection.downLoadAppList(url, mContext, mWidgetData, jsonParams).getResult();
                                        JSONObject jsonObject = new JSONObject(response);
                                        status = jsonObject.optString("status", "fail");
                                        key = "ok".equals(status) ? listKey : "info";
                                        msg = jsonObject.optString(key);
                                        AppHttpDataManager.getAppListInfoCallBack(mContext, mEUExAppStoreMgr, type, "ok".equals(status) ? "ok" : "fail", msg, isInstall);
                                    }
                                }
                                msg = appListToWeb.toString();
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    } else {
                        status = "fail";
                        msg = EUExUtil.getString((String)"plugin_appstore_hint_error_network");
                    }
                    if (!this.isGetAgain) {
                        AppHttpDataManager.getAppListInfoCallBack(mContext, mEUExAppStoreMgr, type, "ok".equals(status) ? "ok" : "fail", msg, isInstall);
                    }
                    return null;
                }
            }

            protected void onPostExecute(Void params) {
                if (this.isCancelled()) {
                    getAppListAsyncTask = null;
                    return;
                }
                getAppListAsyncTask = null;
            }
        };
        getAppListAsyncTask.execute((Object[])new Void[0]);
    }

    private static void getAppListInfoCallBack(Context mContext, EUExAppStoreMgr mEUExAppStoreMgr, int cbType, String status, String info, boolean isGetInstallList) {
        JSONObject json = new JSONObject();
        try {
            json.put("status", (Object)status);
            if (info.startsWith("[")) {
                JSONArray appListArray = new JSONArray(info);
                if (0 == cbType) {
                    for (int i = 0; i < appListArray.length(); ++i) {
                        JSONObject jsonItem = appListArray.getJSONObject(i);
                        AppBean appBean = AppStoteDataParser.parseAppBean(jsonItem);
                        if (appBean.getType() == -1) continue;
                        boolean isAppInstall = AppUtils.isAppInstalled(mContext, appBean);
                        if (isAppInstall || !isAppInstall && AppHttpDataManager.isAppFullPackageDownloading(mContext, appBean.getDownloadUrl())) {
                            jsonItem.put("state", (Object)"1");
                        } else {
                            jsonItem.put("state", (Object)"0");
                        }
                        String installVer = AppUtils.getAppLocalVersion(mContext, appBean);
                        if (TextUtils.isEmpty((CharSequence)installVer)) continue;
                        jsonItem.put("installVersion", (Object)installVer);
                    }
                }
                json.put("info", (Object)appListArray);
            } else {
                json.put("info", (Object)info);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (0 == cbType) {
            mEUExAppStoreMgr.cbGetAppList(json.toString());
        } else {
            mEUExAppStoreMgr.cbGetCategoryList(json.toString());
        }
    }

    public static AppBean getAppDetialFormAppBean(String appId, Context mContext, WWidgetData mWidgetData) {
        String responseAppDetail = AppHttpDataManager.getAppDetail(appId, mContext, mWidgetData);
        return AppStoteDataParser.parseAppDetailData("appDetail", responseAppDetail);
    }

    public static String getAppDetail(String appId, Context mContext, WWidgetData mWidgetData) {
        String url = AppStoreURLMgr.getUrlAppDetial();
        JSONObject jsonParams = new JSONObject();
        try {
            jsonParams.put("softToken", (Object)AppStoreTokenUtils.getSoftToken(mContext));
            url = url + "/" + appId;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String detailKey = "appList";
        String responseAppDetail = AppStoteHttpURLConnection.downLoadAppList(mContext, mWidgetData, url, jsonParams, detailKey).getResult();
        return responseAppDetail;
    }

    public static String appInstallReport(Context mContext, AppBean appBean, WWidgetData mWidgetData) {
        String result = "";
        if (AppDownLoadDb.isInstallReport(mContext, appBean.getDownloadUrl())) {
            String url = AppStoreURLMgr.getUrlReportAppVersion();
            JSONObject json = new JSONObject();
            try {
                json.put("version", (Object)AppUtils.getAppInstallVersion(appBean));
                json.put("softToken", (Object)AppStoreTokenUtils.getSoftToken(mContext));
                json.put("subAppId", (Object)appBean.getAppId());
                result = AppStoteHttpURLConnection.sendPostRequestByFrom(mContext, mWidgetData, url, json).getResult();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String appUninstallReport(Context mContext, WWidgetData mWidgetData, String appId) {
        JSONObject json = new JSONObject();
        String result = "";
        try {
            String url = AppStoreURLMgr.getUrlReportAppDel();
            json.put("subAppId", (Object)appId);
            result = AppStoteHttpURLConnection.sendPostRequestByFrom(mContext, mWidgetData, url, json).getResult();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void getAppVersionInfo(final Context mContext, final EUExAppStoreMgr mEUExAppStoreMgr, final WWidgetData mWidgetData, GetAppVersionVO versionVO) {
        JSONObject jsonParams = new JSONObject();
        try {
            if (!TextUtils.isEmpty((CharSequence)versionVO.appId)) {
                jsonParams.put("appId", (Object)versionVO.appId);
            } else {
                jsonParams.put("appId", (Object)mWidgetData.m_appId);
            }
            jsonParams.put("tenantAccount", (Object)AppStoreUtils.getTenantAccount(mContext));
            jsonParams.put("platform", (Object)"android");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        final String url = AppStoreURLMgr.getUrlGetAppVersionInfo() + "?" + AppStoteDataParser.getJsonObj(jsonParams);
        new AsyncTask<String, Void, String>(){

            protected void onPreExecute() {
            }

            protected String doInBackground(String ... params) {
                return AppStoteDataParser.changeToV3Result(AppStoteHttpURLConnection.sendGetRequest(mContext, mWidgetData, url), "info").getResult();
            }

            protected void onPostExecute(String params) {
                mEUExAppStoreMgr.cbGetAppVersionInfo(params);
            }
        }.execute((Object[])new String[0]);
    }

    public static void submitAppEvalute(final Context context, final WWidgetData mWgtData, final SubmitAppEvaluteVO evaluteVO, final AppStoteHttpURLConnection.HttpRequestMgr httpRequestMgr) throws JSONException {
        new AsyncTask<Void, Void, String>(){
            JSONObject json = new JSONObject();

            protected void onPreExecute() {
                try {
                    this.json.put("username", (Object)evaluteVO.getUserName());
                    this.json.put("evaluteInfo", (Object)evaluteVO.getEvaluteInfo());
                    this.json.put("appId", (Object)evaluteVO.getAppId());
                    this.json.put("comeFrom", (Object)"client");
                    this.json.put("starLevel", (Object)evaluteVO.getStarLevel());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            protected String doInBackground(Void ... params) {
                String result = "";
                result = AppStoteHttpURLConnection.sendPostRequestByFrom(context, mWgtData, AppStoreURLMgr.getUrlSubmitAppEvalute(), this.json).getResult();
                return result;
            }

            protected void onPostExecute(String result) {
                httpRequestMgr.onRequestComplete(result);
            }
        }.execute((Object[])new Void[0]);
    }

    public static void getAppEvalute(final Context context, final WWidgetData mWgtData, final GetAppEvaluteVO evaluteVO, final AppStoteHttpURLConnection.HttpRequestMgr httpRequestMgr) {
        new AsyncTask<Void, Void, String>(){
            JSONObject json = new JSONObject();

            protected void onPreExecute() {
                try {
                    this.json.put("appId", (Object)evaluteVO.getAppId());
                    this.json.put("pageSize", (Object)"10");
                    if (!TextUtils.isEmpty((CharSequence)evaluteVO.getAction())) {
                        this.json.put("action", (Object)evaluteVO.getAction());
                    }
                    if (!TextUtils.isEmpty((CharSequence)evaluteVO.getStartIndex())) {
                        int startIndex = Integer.parseInt(evaluteVO.getStartIndex());
                        this.json.put("indexId", startIndex);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            protected String doInBackground(Void ... params) {
                return AppStoteHttpURLConnection.downLoadAppList(AppStoreURLMgr.getUrlGetAppEvalute(), context, mWgtData, this.json).getResult();
            }

            protected void onPostExecute(String result) {
                httpRequestMgr.onRequestComplete(result);
            }
        }.execute((Object[])new Void[0]);
    }
}

