/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.data;

import android.content.Context;
import android.text.TextUtils;
import java.io.File;
import java.util.List;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppTileBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.FileUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStatusVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppTileBean;

public class AppLocalDataManager
implements AppStoreConstant {
    public static List<AppBean> refrshAppData(Context mContext, List<AppBean> netApps, List<AppBean> localApps, boolean isNetworkData) {
        List<AppBean> resultAppList = netApps;
        try {
            if (resultAppList != null) {
                if (isNetworkData) {
                    int localAppsSize = 0;
                    int netAppsSize = resultAppList.size();
                    if (localApps != null) {
                        localAppsSize = localApps.size();
                        if (netAppsSize == 0) {
                            new AppBeanDao(mContext).deleteAllFromTable("t_apps");
                            new AppBeanDao(mContext).deleteAllFromTable("app_list");
                        } else if (localAppsSize == 0) {
                            new AppBeanDao(mContext).addAppList("app_list", resultAppList);
                            resultAppList = new AppBeanDao(mContext).getAppBeanList();
                        }
                    }
                    for (int i = 0; i < localAppsSize; ++i) {
                        File fi;
                        String tmpPath;
                        AppBean localApp = localApps.get(i);
                        String localAppId = localApp.getAppId();
                        boolean isExistApp = false;
                        for (int j = 0; j < netAppsSize; ++j) {
                            AppBean netApp = resultAppList.get(j);
                            String netAppId = netApp.getAppId();
                            if (!localAppId.equals(netAppId)) continue;
                            isExistApp = true;
                            String installVersion = AppUtils.getAppLocalVersion(mContext, netApp);
                            if (TextUtils.isEmpty((CharSequence)installVersion)) {
                                installVersion = AppUtils.getAppInstallVersion(netApp);
                            }
                            netApp.setInstallVersion(installVersion);
                            new AppBeanDao(mContext).updateAppLocatData(netApp);
                            String maxVersion = netApp.getMaxVersion();
                            int re = maxVersion.compareTo(installVersion);
                            if (re > 0) {
                                new AppBeanDao(mContext).updateNewAppState(localAppId, 2);
                                break;
                            }
                            new AppBeanDao(mContext).updateNewAppState(localAppId, 3);
                            break;
                        }
                        if (isExistApp) continue;
                        AppBean appBean = new AppBeanDao(mContext).getAppBean(localAppId);
                        new AppBeanDao(mContext).deleteApp("app_list", localAppId);
                        AppLocalDataManager.removePauseState(mContext, localAppId);
                        AppLocalDataManager.removeProgress(mContext, appBean.getAppId());
                        if (3 != appBean.getType() || TextUtils.isEmpty((CharSequence)(tmpPath = appBean.getInstallPath())) || !(fi = new File(tmpPath)).exists()) continue;
                        FileUtils.DeleteFile(fi);
                    }
                    for (AppBean app1 : resultAppList) {
                        AppBean app2 = new AppBeanDao(mContext).getAppBean(app1.getAppId());
                        if (app2 != null) continue;
                        new AppBeanDao(mContext).addAppBean("app_list", app1);
                    }
                    resultAppList = new AppBeanDao(mContext).getAppBeanList();
                }
                for (int i = 0; i < resultAppList.size(); ++i) {
                    AppBean appBean = resultAppList.get(i);
                    if (!AppUtils.isNativeApp(appBean.getType()) || appBean.getState() == 4 || !AppUtils.isNativeAppInstalled(mContext, appBean.getPackageName())) continue;
                    new AppBeanDao(mContext).updateAppState(appBean.getAppId(), 4, null);
                }
                resultAppList = new AppBeanDao(mContext).getAppBeanList();
            } else {
                LogUtils.logDebug(true, "myAppList is null, use local data");
                if (!AppStatusVO.isForceConnected()) {
                    resultAppList = localApps;
                }
            }
        }
        catch (Exception e) {
            LogUtils.oe("refreshMyAppData", e);
            e.printStackTrace();
        }
        return resultAppList;
    }

    public static void refrshAppTileData(Context mContext, List<AppTileBean> serverTilesList, List<AppTileBean> localTilesList) {
        AppTileBeanDao mAppTileBeanDao = new AppTileBeanDao(mContext);
        List<AppTileBean> tileList = serverTilesList;
        int localSize = localTilesList.size();
        int serverSize = serverTilesList.size();
        if (0 == serverSize) {
            mAppTileBeanDao.deleteAllFromTable("app_tile_list");
        } else if (localSize == 0) {
            mAppTileBeanDao.addTileList("app_tile_list", serverTilesList);
        } else {
            for (int i = 0; i < localSize; ++i) {
                AppTileBean localtile = localTilesList.get(i);
                if (localtile == null) continue;
                boolean isExist = false;
                for (int j = 0; j < serverSize; ++j) {
                    AppTileBean serverTile = serverTilesList.get(j);
                    if (!localtile.equals(serverTile)) continue;
                    isExist = true;
                    mAppTileBeanDao.updateTile("app_tile_list", serverTile);
                    tileList.remove(serverTile);
                    break;
                }
                if (isExist) continue;
                mAppTileBeanDao.deleteTile("app_tile_list", localtile);
            }
            mAppTileBeanDao.addTileList("app_tile_list", tileList);
        }
    }

    public static void saveApkPath(Context context, String key, String filePath) {
        SharedPrefUtils.putString(context, "apkPath", key, filePath);
    }

    public static String getApkPath(Context context, String key) {
        return SharedPrefUtils.getString(context, "apkPath", key, "");
    }

    public static void savePauseState(Context context, String appId, boolean pause) {
        SharedPrefUtils.putBoolean(context, "pause_prefs", appId, pause);
    }

    public static void removePauseState(Context context, String appId) {
        SharedPrefUtils.remove(context, "pause_prefs", appId);
    }

    public static boolean getPauseState(Context context, String appId) {
        return SharedPrefUtils.getBoolean(context, "pause_prefs", appId, false);
    }

    public static void saveProgress(Context context, String appId, int progress) {
        SharedPrefUtils.putInt(context, "down_prefs", appId, progress);
    }

    public static void removeProgress(Context context, String appId) {
        SharedPrefUtils.remove(context, "down_prefs", appId);
    }

    public static int getProgress(Context context, String appId) {
        return SharedPrefUtils.getInt(context, "down_prefs", appId, 0);
    }
}

