/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.data;

import android.content.Context;
import android.widget.Toast;
import java.util.LinkedList;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDownTask;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppLocalDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;

public class AppTaskList
implements AppStoreConstant {
    private LinkedList<AppDownTask> taskList = new LinkedList();
    private Toast mToast = null;
    private int MAX_THREAD = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExistTask(String taskId, Context context) {
        if (this.mToast == null) {
            this.mToast = Toast.makeText((Context)context, (CharSequence)EUExUtil.getString((String)"plugin_appstore_load_app_pause"), (int)0);
        }
        AppTaskList appTaskList = this;
        synchronized (appTaskList) {
            int size = this.taskList.size();
            for (int i = 0; i < size; ++i) {
                if (!this.taskList.get(i).getTaskId().equals(taskId)) continue;
                AppBean appBean = this.taskList.get((int)i).appBean;
                boolean isDownloaded = this.taskList.get((int)i).appBean.getState() == 1;
                AppDownTask task = this.taskList.get(i);
                task.setWait(!task.getWait());
                task.cancel(true);
                LogUtils.logDebug(true, "isExistTask " + appBean.getAppName() + ":task iscancel: " + task.isCancelled() + " state:" + this.taskList.get((int)i).appBean.getState());
                AppLocalDataManager.savePauseState(context, taskId, true);
                new AppBeanDao(context).updateAppState(appBean.getAppId(), 2, null);
                if (!isDownloaded && task.isCancelled()) {
                    this.mToast.show();
                }
                return true;
            }
        }
        AppLocalDataManager.savePauseState(context, taskId, false);
        return false;
    }

    public boolean isEmpty() {
        return this.taskList.size() == 0;
    }

    public void addTask(AppDownTask downTask) {
        LogUtils.logDebug(true, "AppDownTask:" + downTask.hashCode());
        if (this.taskList.size() > this.MAX_THREAD) {
            downTask.setWait(true);
        }
        this.taskList.add(downTask);
    }

    public void removeTask(AppDownTask task) {
        this.taskList.remove(task);
        if (this.taskList.size() > this.MAX_THREAD) {
            this.taskList.get(this.MAX_THREAD).setWait(false);
        }
    }

    public AppBean getTaskInfoByAppId(String appId) {
        for (AppDownTask task : this.taskList) {
            if (!task.getTaskId().equals(appId)) continue;
            return task.getAppBean();
        }
        return null;
    }

    public AppDownTask getTask(int index) {
        if (index < 0) {
            return null;
        }
        return this.taskList.get(index);
    }

    public int size() {
        return this.taskList.size();
    }

    public int indexOf(AppDownTask task) {
        return this.taskList.indexOf(task);
    }

    public AppDownTask getFirst() {
        return this.taskList.getFirst();
    }
}

