/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.data;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDbHelper;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppTileBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.UserInfoVO;

public class AppTileBeanDao
implements AppStoreConstant {
    private AppDbHelper dbHelper;

    public AppTileBeanDao(Context context) {
        this.dbHelper = new AppDbHelper(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllFromTable(String table) {
        SQLiteDatabase db = null;
        try {
            db = this.dbHelper.getWritableDatabase();
            String sql = "DELETE FROM " + table;
            db.execSQL(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (db != null) {
                db.close();
                db = null;
            }
        }
    }

    public void addTileList(String table, List<AppTileBean> list) {
        if (list == null || list.size() < 1) {
            return;
        }
        try {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                AppTileBean appTileBean = list.get(i);
                if (appTileBean == null) continue;
                this.addTile(table, appTileBean);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTile(String table, AppTileBean appTileBean) {
        SQLiteDatabase db = null;
        boolean isAdd = false;
        try {
            db = this.dbHelper.getWritableDatabase();
            String sql = "SELECT * FROM " + table + " WHERE " + UserInfoVO.toDbSqlString() + " and " + "tile_app_id" + " = '" + appTileBean.getAppId() + "' and " + "tile_name" + " = '" + appTileBean.getTileName() + "'";
            Cursor c = db.rawQuery(sql, new String[0]);
            if (!c.moveToNext()) {
                ContentValues cv = new ContentValues(7);
                cv.put("tile_json_str", appTileBean.getJsonStr());
                cv.put("tile_id", appTileBean.getId());
                cv.put("tile_app_id", appTileBean.getAppId());
                cv.put("tile_app_name", appTileBean.getAppName());
                cv.put("tile_name", appTileBean.getTileName());
                cv.put("tile_icon", appTileBean.getIcon());
                cv.put("tile_link_url", appTileBean.getLinkUrl());
                cv.put("tile_start_page", appTileBean.getStartPage());
                cv.put("tile_version", appTileBean.getVersion());
                cv.put("defaultTab", appTileBean.getDefaultTab());
                cv.put("tile_add_home_page", appTileBean.getAddHomePage());
                cv.put("tenantAccount", UserInfoVO.getTenantAccount());
                cv.put("domainName", UserInfoVO.getDomainName());
                cv.put("loginName", UserInfoVO.getUserName());
                long dd = db.insert("app_tile_list", null, cv);
                isAdd = true;
                LogUtils.logDebug(true, "addTile:" + dd);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            db.close();
        }
        return isAdd;
    }

    public List<AppTileBean> getAppTileList() {
        String sql = "SELECT * FROM app_tile_list WHERE " + UserInfoVO.toDbSqlString();
        return this.getAppTilesList(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AppTileBean> getAppTilesList(String sql) {
        ArrayList<AppTileBean> list = new ArrayList<AppTileBean>();
        SQLiteDatabase db = null;
        Cursor cursor = null;
        try {
            db = this.dbHelper.getReadableDatabase();
            cursor = db.rawQuery(sql, new String[0]);
            if (cursor != null) {
                int tileJsonIndex = cursor.getColumnIndex("tile_json_str");
                int tileIdIndex = cursor.getColumnIndex("tile_id");
                int appIdIndex = cursor.getColumnIndex("tile_app_id");
                int appNameIndex = cursor.getColumnIndex("tile_app_name");
                int tileNameIndex = cursor.getColumnIndex("tile_name");
                int iconUrlIndex = cursor.getColumnIndex("tile_icon");
                int linkUrlIndex = cursor.getColumnIndex("tile_link_url");
                int startPageIndex = cursor.getColumnIndex("tile_start_page");
                int verIndex = cursor.getColumnIndex("tile_version");
                int defaultTabIndex = cursor.getColumnIndex("defaultTab");
                int addHomePage = cursor.getColumnIndex("tile_add_home_page");
                while (cursor.moveToNext()) {
                    AppTileBean appTile = new AppTileBean();
                    appTile.setJsonStr(cursor.getString(tileJsonIndex));
                    appTile.setId(cursor.getString(tileIdIndex));
                    appTile.setAppId(cursor.getString(appIdIndex));
                    appTile.setAppName(cursor.getString(appNameIndex));
                    appTile.setTileName(cursor.getString(tileNameIndex));
                    appTile.setIcon(cursor.getString(iconUrlIndex));
                    appTile.setLinkUrl(cursor.getString(linkUrlIndex));
                    appTile.setStartPage(cursor.getString(startPageIndex));
                    appTile.setVersion(cursor.getString(verIndex));
                    appTile.setDefaultTab(cursor.getString(defaultTabIndex));
                    appTile.setAddHomePage(cursor.getString(addHomePage));
                    list.add(appTile);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (db != null) {
                db.close();
            }
        }
        return list;
    }

    public List<AppTileBean> getTileListByAppId(String tabName, String appId) {
        String sql = "SELECT * FROM " + tabName + " WHERE " + UserInfoVO.toDbSqlString() + " and " + "tile_app_id" + " = '" + appId + "' ORDER BY " + "tile_id";
        return this.getAppTilesList(sql);
    }

    public AppTileBean getSpecifyTile(String tabName, String appId, String tileName) {
        List<Object> list = new ArrayList();
        String sql = "SELECT * FROM " + tabName + " WHERE " + UserInfoVO.toDbSqlString() + " and " + "tile_app_id" + " = '" + appId + "' and " + "tile_name" + " = '" + tileName + "' ORDER BY " + "tile_id";
        list = this.getAppTilesList(sql);
        AppTileBean appTileBean = null;
        if (list != null && list.size() > 0) {
            appTileBean = (AppTileBean)list.get(0);
        }
        return appTileBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTile(String tabName, AppTileBean tile) {
        SQLiteDatabase db = null;
        try {
            db = this.dbHelper.getWritableDatabase();
            String sql = " SET tile_json_str = '" + tile.getJsonStr() + "', " + "tile_id" + " = '" + tile.getId() + "', " + "tile_icon" + " = '" + tile.getIcon() + "', " + "tile_link_url" + " = '" + tile.getLinkUrl() + "', " + "tile_start_page" + " = '" + tile.getStartPage() + "', " + "defaultTab" + " = '" + tile.getDefaultTab() + "', " + "tile_version" + " = '" + tile.getVersion() + "' " + " WHERE " + UserInfoVO.toDbSqlString() + " and " + "tile_app_id" + " = '" + tile.getAppId() + "' AND " + "tile_name" + " = '" + tile.getTileName() + "'";
            LogUtils.logDebug(true, "updateTile sql" + sql);
            db.execSQL(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTile(String tabName, AppTileBean tile) {
        SQLiteDatabase db = null;
        try {
            db = this.dbHelper.getWritableDatabase();
            String appId = tile.getAppId();
            String tileName = tile.getTileName();
            if (!TextUtils.isEmpty((CharSequence)appId) && !TextUtils.isEmpty((CharSequence)tileName)) {
                String deleteSql = "DELETE FROM " + tabName + " WHERE " + UserInfoVO.toDbSqlString() + " and " + "tile_app_id" + " = '" + appId + "' and " + "tile_name" + " = '" + tileName + "'";
                db.execSQL(deleteSql);
                LogUtils.logDebug(true, "===== deleteSql== " + deleteSql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTileAddHomePage(String tabName, AppTileBean tile) {
        SQLiteDatabase db = null;
        try {
            db = this.dbHelper.getWritableDatabase();
            String appId = tile.getAppId();
            String tileName = tile.getTileName();
            if (!TextUtils.isEmpty((CharSequence)appId) && !TextUtils.isEmpty((CharSequence)tileName)) {
                String sql = "UPDATE " + tabName + " SET " + "tile_add_home_page" + " = '" + tile.getAddHomePage() + "' WHERE " + UserInfoVO.toDbSqlString() + " and " + "tile_app_id" + " = '" + tile.getAppId() + "' AND " + "tile_name" + " = '" + tile.getTileName() + "'";
                db.execSQL(sql);
                LogUtils.logDebug(true, "===== updateTileAddHomePage== " + sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }
}

