/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.http;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.EUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppStoteDataParser;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoreURLMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.Http;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.InputStreamUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LanguageUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.HttpRequrstInputVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.HttpRequrstResultVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class AppStoteHttpURLConnection
implements AppStoreConstant {
    private static void addHttpURLConnectionHeader(Context context, WWidgetData mWData, HttpURLConnection connection, String url, String contentType) {
        String cookie;
        connection.addRequestProperty("Accept", "*/*");
        connection.addRequestProperty("Accept-Language", LanguageUtils.getLanguage(context) + ";" + "q=" + 1.0f);
        if (mWData != null) {
            connection.setRequestProperty("channel", mWData.m_channelCode);
            connection.addRequestProperty("varifyApp", AppStoreUtils.getAppVerifyCode(mWData));
            connection.addRequestProperty("appverify", AppStoreUtils.getAppVerifyCode(mWData));
            connection.addRequestProperty("x-mas-app-id", mWData.m_appId);
        }
        if (!TextUtils.isEmpty((CharSequence)(cookie = AppStoteHttpURLConnection.getCookie(url)))) {
            connection.setRequestProperty("Cookie", cookie);
        }
        if (!TextUtils.isEmpty((CharSequence)contentType)) {
            connection.setRequestProperty("Content-Type", contentType);
        }
    }

    private static void writeFormByUriEncode(PrintWriter writer, JSONObject json) {
        Iterator it = json.keys();
        String key = "";
        String value = "";
        StringBuffer sbBuffer = new StringBuffer();
        while (it.hasNext()) {
            key = (String)it.next();
            value = json.optString(key);
            if (TextUtils.isEmpty((CharSequence)value)) {
                value = "default";
            }
            sbBuffer.append(AppStoteHttpURLConnection.uriEncode(key, "")).append("=").append(AppStoteHttpURLConnection.uriEncode(value, "")).append("&");
        }
        int strLen = sbBuffer.length();
        if (strLen >= 1) {
            sbBuffer.deleteCharAt(strLen - 1);
        }
        writer.append(sbBuffer.toString());
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setHttpRequestConfig(Context context, WWidgetData wData, String url, HttpURLConnection httpConnection, HttpRequrstInputVO inputVO, String requestMethod) {
        String contentType = inputVO.getContentType();
        AppStoteHttpURLConnection.addHttpURLConnectionHeader(context, wData, httpConnection, url, contentType);
        String data = "";
        LogUtils.logDebugO(true, "httpRequest header:" + httpConnection.getRequestProperties().toString());
        OutputStream outputStream = null;
        PrintWriter writer = null;
        try {
            httpConnection.setInstanceFollowRedirects(true);
            httpConnection.setRequestMethod(requestMethod);
            httpConnection.connect();
            if (inputVO.getDataJson() != null || !TextUtils.isEmpty((CharSequence)inputVO.getDataStr())) {
                outputStream = httpConnection.getOutputStream();
                if ("application/x-www-form-urlencoded".equals(contentType)) {
                    writer = new PrintWriter(new OutputStreamWriter(outputStream, "utf-8"));
                    JSONObject dataJson = inputVO.getDataJson();
                    if (dataJson != null) {
                        AppStoteHttpURLConnection.writeFormByUriEncode(writer, inputVO.getDataJson());
                        data = dataJson.toString();
                    }
                } else {
                    data = inputVO.getDataStr();
                    if (!TextUtils.isEmpty((CharSequence)data)) {
                        byte[] buffer = data.getBytes();
                        outputStream.write(buffer, 0, buffer.length);
                        outputStream.flush();
                    }
                }
            }
            LogUtils.logDebugO(true, "httpRequest data:" + data);
        }
        catch (Exception e) {
            LogUtils.oe("sendHttpRequest:" + url + ":", e);
            e.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                outputStream = null;
            }
            if (writer != null) {
                writer.close();
                writer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpRequrstResultVO sendHttpRequest(Context mCtx, WWidgetData wData, String url, HttpRequrstInputVO inputVO, String requestMethod) {
        LogUtils.logDebugO(true, "sendHttpRequest url:" + url);
        HttpURLConnection httpConnection = AppStoteHttpURLConnection.getHttpURLConnection(mCtx, url, 30000, 30000);
        HttpRequrstResultVO result = new HttpRequrstResultVO();
        if (httpConnection != null) {
            String responseRes = "";
            int responseCode = -1;
            AppStoteHttpURLConnection.setHttpRequestConfig(mCtx, wData, url, httpConnection, inputVO, requestMethod);
            try {
                responseCode = httpConnection.getResponseCode();
                LogUtils.logDebugO(true, "responseCode = " + responseCode + " url:" + url);
                responseRes = InputStreamUtils.InputStreamTOString(httpConnection.getInputStream());
                LogUtils.logDebugO(true, " res:" + responseRes + " url:" + url);
                AppStoteHttpURLConnection.handleCookie(mCtx, url, httpConnection.getHeaderFields());
            }
            catch (Exception e) {
                LogUtils.oe("sendHttpRequest:" + url + ":", e);
                e.printStackTrace();
            }
            finally {
                result.setResult(responseRes);
                result.setResponseCode(responseCode);
                try {
                    httpConnection.disconnect();
                    httpConnection = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            LogUtils.logError("sendHttpRequest get HttpRequrstResult error\uff1a" + url);
        }
        return result;
    }

    public static HttpRequrstResultVO sendGetRequest(Context ctx, WWidgetData mWData, String url) {
        return AppStoteHttpURLConnection.sendHttpRequest(ctx, mWData, url, new HttpRequrstInputVO("application/json;charset=utf-8", "", null), "GET");
    }

    public static HttpRequrstResultVO sendPostRequestByFrom(Context ctx, WWidgetData mWData, String url, JSONObject jsonData) {
        return AppStoteHttpURLConnection.sendHttpRequest(ctx, mWData, url, new HttpRequrstInputVO("application/x-www-form-urlencoded", "", jsonData), "POST");
    }

    private static void handleCookie(Context context, String url, Map<String, List<String>> headers) {
        if (headers != null) {
            List<String> list;
            List<String> list2;
            List<String> setCookies2;
            List<String> setCookies = headers.get("Set-Cookie");
            if (null != setCookies) {
                for (String string : setCookies) {
                    AppStoteHttpURLConnection.setCookie(url, string);
                }
            }
            if (null != (setCookies2 = headers.get("Set-Cookie2"))) {
                for (String string : setCookies2) {
                    AppStoteHttpURLConnection.setCookie(url, string);
                }
            }
            if (null != (list2 = headers.get("Cookie"))) {
                for (String v : list2) {
                    AppStoteHttpURLConnection.setCookie(url, v);
                }
            }
            if (null != (list = headers.get("Cookie2"))) {
                for (String v : list) {
                    AppStoteHttpURLConnection.setCookie(url, v);
                }
            }
        }
    }

    private static final void setCookie(String inUrl, String cookie) {
        EUExAppStoreMgr.getInstance().setCookie(inUrl, cookie);
    }

    private static final String getCookie(String inUrl) {
        return EUExAppStoreMgr.getInstance().getCookie(inUrl);
    }

    public static HttpURLConnection getHttpURLConnection(Context context, String urlStr, int connectTimeout, int readTimeout) {
        URLConnection httpConnection = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)urlStr)) {
                if (urlStr.contains("?")) {
                    int index = urlStr.indexOf("?");
                    String url = urlStr.substring(0, index);
                    url = AppStoteHttpURLConnection.uriEncode(url, "/?:=&#@+$");
                    urlStr = url + urlStr.substring(index, urlStr.length());
                } else {
                    urlStr = AppStoteHttpURLConnection.uriEncode(urlStr, "/?:=&#@+$");
                }
                URL url = new URL(urlStr);
                if (urlStr.startsWith("http://")) {
                    httpConnection = (HttpURLConnection)url.openConnection();
                } else {
                    String psw = EUtil.getCertificatePsw((Context)context, (String)AppStoreUtils.getMainAppId(context));
                    httpConnection = Http.getHttpsURLConnectionWithCert(url, psw, "file:///android_asset/widget/wgtRes/clientCertificate.p12", context);
                }
            } else {
                LogUtils.logErrorO("getHttpConnection url is null!");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (httpConnection != null) {
            httpConnection.setReadTimeout(readTimeout);
            httpConnection.setConnectTimeout(connectTimeout);
        }
        return httpConnection;
    }

    public static HttpRequrstResultVO downLoadCategoryList(Context mContext, WWidgetData mWgtData) {
        JSONObject jsonParams = new JSONObject();
        HttpRequrstResultVO result = AppStoteHttpURLConnection.downLoadAppList(mContext, mWgtData, AppStoreURLMgr.getUrlCategoryList(), jsonParams, "appTypeList");
        return result;
    }

    public static HttpRequrstResultVO downLoadAppList(String baseUrl, Context mContext, WWidgetData mWgtData, JSONObject params) {
        return AppStoteHttpURLConnection.downLoadAppList(mContext, mWgtData, baseUrl, params, "appList");
    }

    public static HttpRequrstResultVO downLoadAppList(Context mContext, WWidgetData mWgtData, String baseUrl, JSONObject params, String key) {
        HttpRequrstResultVO requrstResult = new HttpRequrstResultVO();
        String keyValueStr = AppStoteDataParser.jsonToFromString(params);
        String url = baseUrl;
        if (!TextUtils.isEmpty((CharSequence)keyValueStr)) {
            url = url + "?" + keyValueStr;
        }
        requrstResult = AppStoteHttpURLConnection.sendGetRequest(mContext, mWgtData, url);
        return requrstResult;
    }

    public static String uriEncode(String url, String allow) {
        return Uri.encode((String)url, (String)allow);
    }

    public static interface HttpRequestMgr {
        public void onRequestComplete(String var1);
    }
}

