/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.widget.ImageView;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoteHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.imageloader.BytesArrayFactory;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.imageloader.ImageLoadTask;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.imageloader.ImageLoaderManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;

public class NetworkUtils
implements AppStoreConstant {
    public static final String NO_CONN = "FAIL";

    public static boolean isOnline(Context _context) {
        ConnectivityManager cm = (ConnectivityManager)_context.getSystemService("connectivity");
        return cm.getActiveNetworkInfo() != null && cm.getActiveNetworkInfo().isAvailable() && cm.getActiveNetworkInfo().isConnected();
    }

    public static String getNetName(Context activity) {
        if (activity == null) {
            return null;
        }
        String netName = null;
        try {
            NetworkInfo info;
            ConnectivityManager cm = (ConnectivityManager)activity.getApplicationContext().getSystemService("connectivity");
            if (cm != null && (info = cm.getActiveNetworkInfo()) != null && info.isAvailable()) {
                block1 : switch (info.getType()) {
                    case 0: {
                        TelephonyManager telephonyManager = (TelephonyManager)activity.getSystemService("phone");
                        switch (telephonyManager.getNetworkType()) {
                            case 1: 
                            case 2: 
                            case 4: 
                            case 7: 
                            case 11: {
                                netName = "GPRS";
                                break block1;
                            }
                            case 3: 
                            case 5: 
                            case 6: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 12: 
                            case 14: 
                            case 15: {
                                netName = "3G";
                                break block1;
                            }
                            case 13: {
                                netName = "4G";
                            }
                        }
                        break;
                    }
                    case 1: {
                        netName = "WIFI";
                    }
                }
            }
        }
        catch (SecurityException e) {
            netName = null;
        }
        return netName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] downloadImageFromNetwork(Context context, String urlStr) {
        InputStream is = null;
        byte[] data = null;
        HttpURLConnection connection = null;
        try {
            connection = AppStoteHttpURLConnection.getHttpURLConnection(context, urlStr, 30000, 30000);
            connection.setRequestMethod("GET");
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                is = connection.getInputStream();
                data = NetworkUtils.transStreamToBytes(is, 4096);
                LogUtils.logDebug(true, "downloadImageFromNetwork()  rspCode:" + responseCode + "  URL:" + urlStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
                connection = null;
            }
        }
        return data;
    }

    public static Bitmap downloadNetworkBitmap(Context context, String url) {
        LogUtils.logDebug(true, "downloadNetworkBitmap==" + url);
        byte[] data = NetworkUtils.downloadImageFromNetwork(context, url);
        if (data == null || data.length == 0) {
            return null;
        }
        return BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] transStreamToBytes(InputStream is, int buffSize) {
        if (is == null) {
            return null;
        }
        if (buffSize <= 0) {
            throw new IllegalArgumentException("buffSize can not less than zero.....");
        }
        byte[] data = null;
        byte[] buffer = new byte[buffSize];
        int actualSize = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            while ((actualSize = is.read(buffer)) != -1) {
                baos.write(buffer, 0, actualSize);
            }
            data = baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    public static void asyncLoadImage(final Context context, final ImageView imageView, final String imageUrl, final Drawable defaultImage, ImageLoaderManager loaderManager, final boolean isBackgroundDrawable) {
        if (TextUtils.isEmpty((CharSequence)imageUrl)) {
            if (isBackgroundDrawable) {
                imageView.setBackgroundDrawable(defaultImage);
            } else {
                imageView.setImageDrawable(defaultImage);
            }
            return;
        }
        imageView.setTag((Object)imageUrl);
        Bitmap bitmap = loaderManager.getCacheBitmap(imageUrl);
        if (bitmap == null) {
            loaderManager.asyncLoad(new ImageLoadTask(imageUrl){

                @Override
                protected BytesArrayFactory.BytesArray transBitmapToBytesArray(Bitmap arg0) {
                    return null;
                }

                @Override
                protected Bitmap doInBackground() {
                    Bitmap mBitmap = NetworkUtils.downloadNetworkBitmap(context, imageUrl);
                    return mBitmap;
                }
            }.addCallback(new ImageLoadTask.ImageLoadTaskCallback(){

                @Override
                public void onImageLoaded(ImageLoadTask task, Bitmap bitmap) {
                    if (bitmap != null) {
                        if (isBackgroundDrawable) {
                            imageView.setBackgroundDrawable((Drawable)new BitmapDrawable(bitmap));
                        } else {
                            imageView.setImageDrawable((Drawable)new BitmapDrawable(bitmap));
                        }
                    } else if (isBackgroundDrawable) {
                        imageView.setBackgroundDrawable(defaultImage);
                    } else {
                        imageView.setImageDrawable(defaultImage);
                    }
                }
            }));
            int sleep = 200;
            if (isBackgroundDrawable) {
                sleep = 50;
            }
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else if (isBackgroundDrawable) {
            imageView.setBackgroundDrawable((Drawable)new BitmapDrawable(bitmap));
        } else {
            imageView.setImageDrawable((Drawable)new BitmapDrawable(bitmap));
        }
    }

    public static void asyncLoadImage(Context context, ImageView imageView, String imageUrl, Drawable defaultImage, ImageLoaderManager loaderManager) {
        NetworkUtils.asyncLoadImage(context, imageView, imageUrl, defaultImage, loaderManager, true);
    }
}

