/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppStoreMainView;

public class Arcs
extends View {
    private Paint mArcPaint;
    private Paint mArcBGPaint;
    private Paint mTextPaint;
    private RectF mOval;
    private Rect mTextRect;
    private float mSweep = 0.0f;
    private int mThreshold = 100;
    private int mCurrentSpeedValue = 0;
    private boolean mUserCenter = true;
    private float density = 1.0f;
    private boolean isPause = false;

    public Arcs(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    public Arcs(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public Arcs(Context context) {
        super(context);
        this.init(context);
    }

    public void setPause(boolean isPause) {
        this.isPause = isPause;
    }

    public boolean getPause() {
        return this.isPause;
    }

    private void init(Context context) {
        EUExUtil.init((Context)context);
        this.density = AppStoreMainView.density;
        this.mArcPaint = new Paint();
        this.mArcPaint.setStyle(Paint.Style.FILL);
        this.mArcPaint.setColor(-8270634);
        this.mArcPaint.setAntiAlias(true);
        this.mArcBGPaint = new Paint();
        this.mArcBGPaint.setStyle(Paint.Style.FILL);
        this.mArcBGPaint.setColor(-15263881);
        this.mArcBGPaint.setAntiAlias(true);
        this.mTextPaint = new Paint();
        this.mTextPaint.setColor(-1);
        if (this.density < 1.5f) {
            this.mTextPaint.setTextSize(16.0f * this.density);
        } else {
            this.mTextPaint.setTextSize(16.0f * this.density / 1.5f);
        }
        this.mTextPaint.setAntiAlias(true);
        this.mTextRect = new Rect();
    }

    protected void onSizeChanged(int w, int h, int ow, int oh) {
        super.onSizeChanged(w, h, ow, oh);
        Log.i((String)"onSizeChanged w", (String)(w + ""));
        Log.i((String)"onSizeChanged h", (String)(h + ""));
        this.mOval = new RectF(0.0f, 0.0f, (float)w, (float)h);
    }

    protected void onDraw(Canvas canvas) {
        this.drawSpeed(canvas);
    }

    private void drawSpeed(Canvas canvas) {
        this.mArcBGPaint.setColor(this.isPause ? -7829368 : -15263881);
        canvas.drawArc(this.mOval, 0.0f, 360.0f, this.mUserCenter, this.mArcBGPaint);
        this.mSweep = (float)this.mCurrentSpeedValue / (float)this.mThreshold * 360.0f;
        if (this.mCurrentSpeedValue > this.mThreshold) {
            this.mArcPaint.setColor(0);
            this.mArcBGPaint.setColor(0);
        } else {
            this.mArcPaint.setColor(-16711936);
        }
        canvas.drawArc(this.mOval, -90.0f, this.mSweep, this.mUserCenter, this.mArcPaint);
        if (this.isPause) {
            Bitmap pauseBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)EUExUtil.getResDrawableID((String)"plugin_appstoremgr_app_down_pause"));
            pauseBitmap = Bitmap.createScaledBitmap((Bitmap)pauseBitmap, (int)((int)(this.mOval.right - this.mOval.left) / 2), (int)((int)(this.mOval.bottom - this.mOval.top) / 2), (boolean)false);
            canvas.drawBitmap(pauseBitmap, (this.mOval.right - this.mOval.left - (float)pauseBitmap.getWidth()) / 2.0f, (this.mOval.bottom - this.mOval.top - (float)pauseBitmap.getHeight()) / 2.0f, this.mArcPaint);
        } else {
            this.setText(canvas, this.mCurrentSpeedValue + "%");
        }
        this.invalidate();
    }

    public int getCurrentSpeedValue() {
        return this.mCurrentSpeedValue;
    }

    public void setCurrentSpeedValue(int currentSpeedValue) {
        this.mCurrentSpeedValue = currentSpeedValue;
    }

    private void setText(Canvas canvas, String text) {
        float width = this.mOval.right - this.mOval.left;
        float height = this.mOval.bottom - this.mOval.top;
        this.mTextPaint.getTextBounds(text, 0, text.length() - 1, this.mTextRect);
        float textWidth = this.mTextPaint.measureText(text);
        int textHeight = this.mTextRect.height();
        canvas.drawText(this.mCurrentSpeedValue + "%", (width - textWidth) / 2.0f, (height + (float)textHeight) / 2.0f, this.mTextPaint);
    }

    public void setProgress(int progress) {
        this.mCurrentSpeedValue = progress;
    }
}

