/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.vo;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppTileOptionVO;

public class AppTileBean
implements Parcelable,
AppStoreConstant {
    private String jsonStr = "";
    private String id = "";
    private String appId = "";
    private String appName = "";
    private String name = "";
    private String iconUrl = "";
    private String linkUrl = "";
    private String startPage = "";
    private String version = "";
    private String defaultTab = "false";
    private String addHomePage = "false";
    public static final Parcelable.Creator<AppTileBean> CREATOR = new Parcelable.Creator<AppTileBean>(){

        public AppTileBean[] newArray(int size) {
            return new AppTileBean[size];
        }

        public AppTileBean createFromParcel(Parcel source) {
            return new AppTileBean(source);
        }
    };

    public AppTileBean() {
    }

    public String getJsonStr() {
        return this.jsonStr;
    }

    public void setJsonStr(String jsonStr) {
        this.jsonStr = jsonStr;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTileName() {
        return this.name;
    }

    public void setTileName(String name) {
        this.name = name;
    }

    public String getIcon() {
        return this.iconUrl;
    }

    public void setIcon(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getLinkUrl() {
        return this.linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public String getStartPage() {
        return this.startPage;
    }

    public void setStartPage(String startPage) {
        this.startPage = startPage;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDefaultTab(String defaultTab) {
        this.defaultTab = defaultTab;
    }

    public String getDefaultTab() {
        return this.defaultTab;
    }

    public String getAddHomePage() {
        return this.addHomePage;
    }

    public void setAddHomePage(String strValue) {
        this.addHomePage = strValue;
    }

    public boolean equals(AppTileBean tile) {
        return this.getAppId().equals(tile.getAppId()) && this.getTileName().equals(tile.getTileName());
    }

    public boolean needUpgrade(AppTileBean tile) {
        return Integer.parseInt(tile.getVersion()) > Integer.parseInt(this.getVersion());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.jsonStr);
        dest.writeString(this.id);
        dest.writeString(this.appId);
        dest.writeString(this.appName);
        dest.writeString(this.name);
        dest.writeString(this.iconUrl);
        dest.writeString(this.linkUrl);
        dest.writeString(this.startPage);
        dest.writeString(this.version);
        dest.writeString(this.defaultTab);
        dest.writeString(this.addHomePage);
    }

    public AppTileBean(Parcel source) {
        this.jsonStr = source.readString();
        this.id = source.readString();
        this.appId = source.readString();
        this.appName = source.readString();
        this.name = source.readString();
        this.iconUrl = source.readString();
        this.linkUrl = source.readString();
        this.startPage = source.readString();
        this.version = source.readString();
        this.defaultTab = source.readString();
        this.addHomePage = source.readString();
    }

    public String toString() {
        return "AppTiles [jsonStr:" + this.jsonStr + ", id:" + this.id + ", appId:" + this.appId + ", appName:" + this.appName + ", name:" + this.name + ",icon:" + this.iconUrl + ", tabUrl:" + this.linkUrl + ", startPage:" + this.startPage + ", version:" + this.version + ", defaultTab:" + this.defaultTab + ", addHomePage:" + this.addHomePage + "]";
    }

    public static boolean isShowTileInHome(String defaultTab) {
        return AppTileOptionVO.isShowAllTileInMain() || "true".equals(defaultTab);
    }

    private static boolean isShowTileInHome(AppTileBean appTile) {
        boolean show = false;
        if (!"false".equals(appTile.getAddHomePage())) {
            show = "not_set".equals(appTile.getAddHomePage()) ? AppTileBean.isShowTileInHome(appTile.getDefaultTab()) : true;
        }
        return show;
    }

    public static boolean isShowAtHomeMark(AppTileBean appTile) {
        return AppTileOptionVO.isShowAllTileInMain() && !"false".equals(appTile.getAddHomePage()) || "true".equals(appTile.getAddHomePage());
    }

    public static List<AppTileBean> getTileListFromAppList(List<AppBean> appList) {
        ArrayList<AppTileBean> tileList = new ArrayList<AppTileBean>();
        if (appList != null) {
            for (AppBean app : appList) {
                tileList.addAll(app.getTilesList());
            }
        }
        return tileList;
    }

    public static List<AppTileBean> getShowTileList(Context context, List<AppTileBean> tileList) {
        ArrayList<AppTileBean> showList = new ArrayList<AppTileBean>();
        for (AppTileBean appTile : tileList) {
            if (!AppTileBean.isShowTileInHome(appTile)) continue;
            showList.add(appTile);
        }
        return showList;
    }
}

