/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.zywx.wbpalmstar.base.ResoureFinder;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.BroadcastReciver.DownloadStateAppInfoReceiver;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView.adapter.AppDetailsGalleryAdapter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppStoreMainView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDownLoadDb;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppLocalDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppTaskList;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.ViewDataManager2;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.imageloader.ImageLoaderManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.MyGallery;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStoreOptionVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class AppDetailsView
extends RelativeLayout
implements AppStoreConstant {
    public static final String TAG = "AppDetailsActivityTAG";
    private static Context mContext;
    private static AppBean mAppBean;
    private TextView appName;
    private TextView appSize;
    private TextView downloadNum;
    private TextView appVersion;
    private TextView updateTime;
    private TextView developerName;
    private TextView appDiscription;
    private ImageView appIcon;
    private MyGallery gallery;
    private ImageLoaderManager loaderManager;
    private Drawable defaultIconBg;
    private ResoureFinder finder;
    private View titleLayout;
    private TextView title;
    private TextView downloadPercent;
    private ImageView back;
    private ProgressBar appState;
    private DownloadStateAppInfoReceiver downloadStatusRcv;
    private WWidgetData mWgtData;
    private EUExAppStoreMgr mEuExAppStoreMgr;
    private View rootView;

    public AppDetailsView(Context context, EUExAppStoreMgr appStoreMgr, WWidgetData widgetData, AppBean appBean) {
        super(context);
        mContext = context;
        this.mEuExAppStoreMgr = appStoreMgr;
        this.mWgtData = widgetData;
        mAppBean = appBean;
        this.rootView = LayoutInflater.from((Context)mContext).inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_app_details_activity"), (ViewGroup)this, true);
        this.loaderManager = ImageLoaderManager.initImageLoaderManager(mContext);
        this.initView();
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AppDetailsView.this.mEuExAppStoreMgr != null) {
                    AppDetailsView.this.mEuExAppStoreMgr.closeAppDetial(new String[0]);
                }
            }
        });
        this.initAppDetailData();
        this.onStart();
    }

    private void initView() {
        this.title = (TextView)this.rootView.findViewById(EUExUtil.getResIdID((String)"centerTitle"));
        this.downloadPercent = (TextView)this.rootView.findViewById(EUExUtil.getResIdID((String)"downloadPercent"));
        this.back = (ImageView)this.rootView.findViewById(EUExUtil.getResIdID((String)"back"));
        this.appState = (ProgressBar)this.rootView.findViewById(EUExUtil.getResIdID((String)"appState"));
        this.back.setImageResource(EUExUtil.getResDrawableID((String)"plugin_appstoremgr_back"));
        this.titleLayout = this.rootView.findViewById(EUExUtil.getResIdID((String)"title"));
        if (AppStoreMainView.TITLE_HEIGHT > 0) {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.titleLayout.getLayoutParams();
            lp.height = AppStoreMainView.TITLE_HEIGHT;
            this.titleLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        if (AppStoreOptionVO.isShowAllViewsInWeb()) {
            this.titleLayout.setVisibility(8);
        }
        this.gallery = (MyGallery)this.rootView.findViewById(EUExUtil.getResIdID((String)"myGallery"));
        this.appName = (TextView)this.rootView.findViewById(EUExUtil.getResIdID((String)"appName"));
        this.appSize = (TextView)this.rootView.findViewById(EUExUtil.getResIdID((String)"appSize"));
        this.downloadNum = (TextView)this.rootView.findViewById(EUExUtil.getResIdID((String)"downloadNum"));
        this.appVersion = (TextView)this.rootView.findViewById(EUExUtil.getResIdID((String)"appVersion"));
        this.updateTime = (TextView)this.rootView.findViewById(EUExUtil.getResIdID((String)"updateTime"));
        this.developerName = (TextView)this.rootView.findViewById(EUExUtil.getResIdID((String)"developerName"));
        this.appDiscription = (TextView)this.rootView.findViewById(EUExUtil.getResIdID((String)"appDiscription"));
        this.appIcon = (ImageView)this.rootView.findViewById(EUExUtil.getResIdID((String)"imageView"));
        this.appName.setText((CharSequence)mAppBean.getAppName());
        this.appSize.setText((CharSequence)(mAppBean.getAppSize() + "M"));
        this.downloadNum.setText((CharSequence)(mAppBean.getDownloadNum() + " " + EUExUtil.getString((String)"plugin_appstore_download_time")));
        this.appVersion.setText((CharSequence)AppUtils.getAppInstallVersion(mAppBean));
        this.updateTime.setText((CharSequence)mAppBean.getUpdateTime());
        this.developerName.setText((CharSequence)mAppBean.getAppCreator());
        this.appDiscription.setText((CharSequence)mAppBean.getAppDiscription());
        this.finder = ResoureFinder.getInstance((Context)mContext);
        this.defaultIconBg = this.finder.getDrawable("plugin_appstoremgr_icon_bg");
        String iconUrl = mAppBean.getIconLoc();
        NetworkUtils.asyncLoadImage(mContext, this.appIcon, iconUrl, this.defaultIconBg, this.loaderManager);
        ArrayList<Object> shortImgList = new ArrayList();
        shortImgList = mAppBean.getShortImgList();
        shortImgList.ensureCapacity(4);
        AppDetailsGalleryAdapter dd = new AppDetailsGalleryAdapter(mContext);
        int length = shortImgList.size();
        for (int i = 0; i < length; ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("image", shortImgList.get(i));
            dd.addObject(map);
        }
        this.gallery.setAdapter(dd);
        if (0 == shortImgList.size()) {
            View gallery_layout = this.rootView.findViewById(EUExUtil.getResIdID((String)"gallery_layout"));
            gallery_layout.setVisibility(8);
            ImageView gallery_divider = (ImageView)this.rootView.findViewById(EUExUtil.getResIdID((String)"my_gallery_divider"));
            gallery_divider.setVisibility(8);
        }
    }

    public int dimension2Pixels(int dime, Activity acti) {
        DisplayMetrics metrics = new DisplayMetrics();
        Display display = acti.getWindowManager().getDefaultDisplay();
        display.getMetrics(metrics);
        int res = (int)((float)dime * metrics.density);
        return res;
    }

    protected void onStart() {
        if (null == this.downloadStatusRcv) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("plugin_appstore_notify_download_status");
            this.downloadStatusRcv = new DownloadStateAppInfoReceiver(mContext, mAppBean, this.appState, this.downloadPercent);
            mContext.registerReceiver((BroadcastReceiver)this.downloadStatusRcv, intentFilter);
        }
    }

    public void onDetachedFromWindow() {
        if (this.downloadStatusRcv != null) {
            mContext.unregisterReceiver((BroadcastReceiver)this.downloadStatusRcv);
            this.downloadStatusRcv = null;
        }
        if (this.mEuExAppStoreMgr != null) {
            this.mEuExAppStoreMgr.closeAppDetial(new String[0]);
        }
        super.onDetachedFromWindow();
    }

    private void initAppDetailData() {
        this.title.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_app_details"));
        int p = AppLocalDataManager.getProgress(mContext, mAppBean.getAppId());
        if (p != 100) {
            this.appState.setProgress(p);
            this.downloadPercent.setText((CharSequence)(p + "%"));
        }
        this.appState.setClickable(false);
        String appId = mAppBean.getAppId();
        AppBean localAppBean = new AppBeanDao(mContext).getAppBean(appId);
        this.appState.setOnClickListener((View.OnClickListener)new AddAppListener(mAppBean));
        switch (mAppBean.getType()) {
            case 1: {
                if (localAppBean != null) {
                    this.downloadPercent.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_installed"));
                    this.appState.setClickable(false);
                    break;
                }
                this.downloadPercent.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_not_install"));
                break;
            }
            case 3: {
                if (localAppBean != null && localAppBean.getState() == 4 && localAppBean.getNewApp() != 2 && AppUtils.isWidgetInstalled(appId)) {
                    this.downloadPercent.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_install_complete"));
                    this.appState.setClickable(false);
                    break;
                }
                if (localAppBean != null && localAppBean.getState() == 4 && localAppBean.getNewApp() == 2) {
                    this.downloadPercent.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_to_be_updated"));
                    break;
                }
                if (localAppBean != null && localAppBean.getState() == 2) break;
                this.downloadPercent.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_not_install"));
                break;
            }
            case 2: 
            case 4: {
                if (localAppBean != null && localAppBean.getState() == 4 && localAppBean.getNewApp() != 2 && AppUtils.isNativeAppInstalled(mContext, localAppBean.getPackageName())) {
                    this.downloadPercent.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_install_complete"));
                    this.appState.setClickable(false);
                    break;
                }
                if (localAppBean != null && localAppBean.getState() == 4 && localAppBean.getNewApp() == 2) {
                    this.downloadPercent.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_to_be_updated"));
                    break;
                }
                if (localAppBean != null && localAppBean.getState() == 2) break;
                this.downloadPercent.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_not_install"));
            }
        }
    }

    class AddAppListener
    implements View.OnClickListener {
        AppBean appBean;

        public AddAppListener(AppBean appBean) {
            this.appBean = appBean;
        }

        public void onClick(View v) {
            String appId = this.appBean.getAppId();
            if (new AppBeanDao(mContext).getAppBean(appId) == null) {
                new AppBeanDao(mContext).addAppBean("app_list", this.appBean);
            } else {
                this.appBean = new AppBeanDao(mContext).getAppBean(appId);
            }
            AppStoreMainView.getInstance().refreshLocalAppData();
            if (this.appBean.getType() != 1) {
                AppTaskList appsTaskList = ViewDataManager2.getAppTaskList();
                String mAppId = this.appBean.getAppId();
                ViewDataManager2 viewDataManager = ViewDataManager2.getInstance();
                switch (this.appBean.getType()) {
                    case 2: 
                    case 4: {
                        AppBean app1 = new AppBeanDao(mContext).getAppBean(mAppId);
                        int state = 0;
                        if (app1 != null) {
                            state = app1.getState();
                        }
                        if (AppUtils.isNativeAppInstalled(mContext, this.appBean.getPackageName()) && state != 4) {
                            AppUtils.changeAppStateToInstall(mContext, AppDetailsView.this.mWgtData, this.appBean);
                            break;
                        }
                        if (appsTaskList.isExistTask(mAppId, mContext)) {
                            return;
                        }
                        String[] result = AppDownLoadDb.getFilePathFromDownload(mContext, this.appBean.getDownloadUrl());
                        if (result != null) {
                            String path = result[0];
                            String size = result[1];
                            if (!TextUtils.isEmpty((CharSequence)path) && !TextUtils.isEmpty((CharSequence)size)) {
                                int fileSize = Integer.parseInt(size);
                                File file = new File(path);
                                if (file.exists() && file.length() == (long)fileSize) {
                                    EUExAppStoreMgr.getInstance().installApp(this.appBean, file);
                                    AppLocalDataManager.saveApkPath(mContext, this.appBean.getAppId(), file.getAbsolutePath());
                                    AppLocalDataManager.removeProgress(mContext, this.appBean.getAppId());
                                    return;
                                }
                            }
                        }
                        viewDataManager.launch(mContext, this.appBean, 0);
                        break;
                    }
                    case 3: {
                        if (appsTaskList.isExistTask(mAppId, mContext)) {
                            return;
                        }
                        if ((1 == this.appBean.getState() || 4 == this.appBean.getState()) && AppUtils.isWidgetInstalled(this.appBean.getAppId())) {
                            String[] updateInfo = new AppBeanDao(mContext).getUpdate(this.appBean.getAppId());
                            if (updateInfo != null) {
                                String filePath = updateInfo[0];
                                String appVer = updateInfo[1];
                                if (!TextUtils.isEmpty((CharSequence)filePath) && filePath.endsWith(".zip") && !TextUtils.isEmpty((CharSequence)appVer)) {
                                    if (new File(filePath).exists()) {
                                        AppBean bean = this.appBean;
                                        bean.setInstallVersion(appVer);
                                        viewDataManager.unzip(mContext, bean, filePath, 1);
                                        return;
                                    }
                                    new AppBeanDao(mContext).deleteUpdate(this.appBean.getAppId());
                                }
                            }
                            viewDataManager.launch(mContext, this.appBean, 1);
                            break;
                        }
                        LogUtils.logDebug("lll==============\u5c1a\u672a\u4e0b\u8f7d\uff0c\u5f00\u59cb\u4e0b\u8f7d");
                        String[] result = AppDownLoadDb.getFilePathFromDownload(mContext, this.appBean.getDownloadUrl());
                        if (result != null) {
                            String path = result[0];
                            String size = result[1];
                            if (!TextUtils.isEmpty((CharSequence)path) && !TextUtils.isEmpty((CharSequence)size)) {
                                int fileSize = Integer.parseInt(size);
                                File file = new File(path);
                                if (file.exists() && file.length() == (long)fileSize) {
                                    viewDataManager.unzip(mContext, this.appBean, path, 0);
                                    return;
                                }
                            }
                        }
                        viewDataManager.launch(mContext, this.appBean, 0);
                    }
                }
            } else if (this.appBean.getState() != 4) {
                AppUtils.changeAppStateToInstall(mContext, AppDetailsView.this.mWgtData, this.appBean);
            }
        }
    }
}

