/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView;

import android.app.Dialog;
import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.Toast;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppListBaseView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.adapter.AppListViewAdapter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppStoteDataParser;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoreURLMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoteHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreTokenUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.DialogView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.XListView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStatusVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class AppListView
extends AppListBaseView
implements AppStoreConstant {
    private EUExAppStoreMgr mEUExAppStoreMgr;
    public static final String TAG = "AppListActivity";
    private XListView list;
    private AppListViewAdapter adapter;
    private Context mContext;
    private JSONObject searchAppListParams = new JSONObject();
    private String indexIdDown;
    private WWidgetData mWgtData;
    private AsyncTask<Void, Void, ArrayList<AppBean>> asyncTask = null;
    private AsyncTask<Void, Void, ArrayList<AppBean>> asyncTaskPullDown = null;
    private AsyncTask<Void, Void, ArrayList<AppBean>> asyncTaskPullUp = null;

    public AppListView(Context context, EUExAppStoreMgr mEUExAppStoreMgr, WWidgetData mWidgetData) {
        super(context);
        this.mContext = context;
        this.mWgtData = mWidgetData;
        this.mEUExAppStoreMgr = mEUExAppStoreMgr;
        LayoutInflater mInflater = LayoutInflater.from((Context)this.mContext);
        View rootView = mInflater.inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_app_listview"), (ViewGroup)this, true);
        String softToken = AppStoreTokenUtils.getSoftToken(context);
        this.list = (XListView)rootView.findViewById(EUExUtil.getResIdID((String)"appListView"));
        this.list.setPullLoadEnable(true);
        this.list.setPullRefreshEnable(true);
        this.list.setXListViewListener(new ListViewIXListViewListener(this.list));
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        String time = sdf.format(new Date());
        this.list.setRefreshTime(time);
        View titleLayout = rootView.findViewById(EUExUtil.getResIdID((String)"title"));
        titleLayout.setVisibility(8);
        try {
            this.searchAppListParams.put("softToken", (Object)softToken);
            this.searchAppListParams.put("pageSize", (Object)"10");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (this.adapter == null) {
            this.downloadAppList(this.searchAppListParams, "appList_prefs");
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (this.mEUExAppStoreMgr != null) {
            this.mEUExAppStoreMgr.closeAppStore(new String[0]);
        }
        super.onDetachedFromWindow();
    }

    private void downloadAppList(final JSONObject appListParamsJson, final String cacheKey) {
        final String resCache = SharedPrefUtils.getString(this.mContext, "main_prefs", cacheKey, "");
        if (!NetworkUtils.isOnline(this.mContext) && TextUtils.isEmpty((CharSequence)resCache)) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            return;
        }
        if (this.asyncTask != null) {
            return;
        }
        this.asyncTask = new AsyncTask<Void, Void, ArrayList<AppBean>>(){
            Dialog progressDialog = null;

            protected void onPreExecute() {
                this.progressDialog = DialogView.showLoadingDialog(AppListView.this.mContext, EUExUtil.getString((String)"plugin_appstore_load_app_list"));
                this.progressDialog.show();
            }

            protected ArrayList<AppBean> doInBackground(Void ... params) {
                ArrayList<AppBean> appList = null;
                try {
                    String response = AppStoteHttpURLConnection.downLoadAppList(AppStoreURLMgr.getUrlSearchList(), AppListView.this.mContext, AppListView.this.mWgtData, appListParamsJson).getResult();
                    if (!TextUtils.isEmpty((CharSequence)response)) {
                        appList = AppStoteDataParser.parseAppListWithKey("appList", response);
                        SharedPrefUtils.putString(AppListView.this.mContext, "main_prefs", cacheKey, response);
                    } else if (!AppStatusVO.isForceConnected() && !TextUtils.isEmpty((CharSequence)resCache)) {
                        appList = AppStoteDataParser.parseAppListWithKey("appList", resCache);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return appList;
            }

            protected void onPostExecute(ArrayList<AppBean> result) {
                if (this.isCancelled()) {
                    AppListView.this.asyncTask = null;
                    return;
                }
                if (this.progressDialog != null) {
                    this.progressDialog.dismiss();
                }
                if (result == null || result.size() == 0) {
                    Toast.makeText((Context)AppListView.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_data"), (int)0).show();
                    AppListView.this.asyncTask = null;
                    return;
                }
                try {
                    int leng = result.size() - 1;
                    AppListView.this.indexIdDown = result.get(leng).getIndexId();
                    if (null == AppListView.this.adapter) {
                        AppListView.this.adapter = new AppListViewAdapter(AppListView.this.mContext, AppListView.this.mWgtData, result);
                        AppListView.this.list.setAdapter((ListAdapter)AppListView.this.adapter);
                        AppListView.this.downloadStateRcv.updateAdapter(AppListView.this.adapter);
                    } else {
                        AppListView.this.adapter.reload(result);
                    }
                }
                catch (Exception e) {
                    Toast.makeText((Context)AppListView.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_data"), (int)0).show();
                    e.printStackTrace();
                }
                AppListView.this.asyncTask = null;
            }
        };
        this.asyncTask.execute((Object[])new Void[0]);
    }

    public void refreshData(final XListView listView, final JSONObject jsonPullDownJson) {
        if (!NetworkUtils.isOnline(this.mContext)) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            listView.stopRefresh();
            return;
        }
        if (this.asyncTaskPullDown != null) {
            return;
        }
        this.asyncTaskPullDown = new AsyncTask<Void, Void, ArrayList<AppBean>>(){

            protected ArrayList<AppBean> doInBackground(Void ... params) {
                String response = AppStoteHttpURLConnection.downLoadAppList(AppStoreURLMgr.getUrlSearchList(), AppListView.this.mContext, AppListView.this.mWgtData, jsonPullDownJson).getResult();
                ArrayList<AppBean> niceApps = AppStoteDataParser.parseAppListWithKey("appList", response);
                return niceApps;
            }

            protected void onPostExecute(ArrayList<AppBean> result) {
                if (this.isCancelled()) {
                    AppListView.this.asyncTaskPullDown = null;
                    return;
                }
                if (result == null || result.size() == 0) {
                    listView.stopRefresh();
                    AppListView.this.asyncTaskPullDown = null;
                    return;
                }
                if (AppListView.this.adapter != null) {
                    AppListView.this.adapter.reload(result);
                } else {
                    AppListView.this.adapter = new AppListViewAdapter(AppListView.this.mContext, AppListView.this.mWgtData, result);
                    listView.setAdapter((ListAdapter)AppListView.this.adapter);
                    AppListView.this.downloadStateRcv.updateAdapter(AppListView.this.adapter);
                }
                listView.stopRefresh();
                SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
                String time = sdf.format(new Date());
                listView.setRefreshTime(time);
                AppListView.this.asyncTaskPullDown = null;
            }
        };
        this.asyncTaskPullDown.execute((Object[])new Void[0]);
    }

    public void loadMoreData(final XListView listView, final JSONObject jsonUpDownJson) {
        if (!NetworkUtils.isOnline(this.mContext)) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            listView.stopLoadMore();
            return;
        }
        if (this.asyncTaskPullUp != null) {
            return;
        }
        this.asyncTaskPullUp = new AsyncTask<Void, Void, ArrayList<AppBean>>(){

            protected ArrayList<AppBean> doInBackground(Void ... params) {
                String response = AppStoteHttpURLConnection.downLoadAppList(AppStoreURLMgr.getUrlSearchList(), AppListView.this.mContext, AppListView.this.mWgtData, jsonUpDownJson).getResult();
                ArrayList<AppBean> apps = AppStoteDataParser.parseAppListWithKey("appList", response);
                return apps;
            }

            protected void onPostExecute(ArrayList<AppBean> result) {
                if (this.isCancelled()) {
                    AppListView.this.asyncTaskPullUp = null;
                    return;
                }
                if (result == null || result.size() == 0) {
                    listView.stopLoadMore();
                    Toast.makeText((Context)AppListView.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_more_data"), (int)0).show();
                    AppListView.this.asyncTaskPullUp = null;
                    return;
                }
                int length = result.size() - 1;
                AppListView.this.indexIdDown = result.get(length).getIndexId();
                if (AppListView.this.adapter != null) {
                    AppListView.this.adapter.addList(result);
                } else {
                    AppListView.this.adapter = new AppListViewAdapter(AppListView.this.mContext, AppListView.this.mWgtData, result);
                    listView.setAdapter((ListAdapter)AppListView.this.adapter);
                    AppListView.this.downloadStateRcv.updateAdapter(AppListView.this.adapter);
                }
                listView.stopLoadMore();
                AppListView.this.asyncTaskPullUp = null;
            }
        };
        this.asyncTaskPullUp.execute((Object[])new Void[0]);
    }

    class ListViewIXListViewListener
    implements XListView.IXListViewListener {
        XListView mListView;

        public ListViewIXListViewListener(XListView listView) {
            this.mListView = listView;
        }

        @Override
        public void onRefresh() {
            JSONObject jsonPullDownJson = AppListView.this.searchAppListParams;
            try {
                jsonPullDownJson.put("action", (Object)"up");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            AppListView.this.refreshData(this.mListView, jsonPullDownJson);
        }

        @Override
        public void onLoadMore() {
            JSONObject jsonUpDownJson = AppListView.this.searchAppListParams;
            try {
                jsonUpDownJson.put("action", (Object)"down");
                jsonUpDownJson.put("indexId", (Object)AppListView.this.indexIdDown);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            AppListView.this.loadMoreData(this.mListView, jsonUpDownJson);
        }
    }
}

