/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.data;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.AsyncTask;
import android.text.TextUtils;
import java.io.File;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppStoreMainView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDownLoadDb;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDownTask;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppHttpDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppLocalDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppStoteDataParser;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppTaskList;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.MyAsyncTask;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.upgrade.GrayRelease;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.FileUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ViewUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.EMMStartUpVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class ViewDataManager
implements AppStoreConstant {
    private Context mContext;
    private static AppTaskList mAppTaskList = new AppTaskList();
    private AppBean mAppBean;
    private AppDownTask updateDownTask;
    private WWidgetData mWgtData;
    protected ViewDataMgrCallBack mViewDataMgrCallBack;
    private LinkedList<AsyncTask<Void, Void, Object>> unzipTaskList = new LinkedList();

    public ViewDataManager(Context context, WWidgetData mWData) {
        this.mContext = context;
        this.mWgtData = mWData;
    }

    public Context getContext() {
        return this.mContext;
    }

    public AppBean getAppBean() {
        return this.mAppBean;
    }

    public static AppTaskList getAppTaskList() {
        return mAppTaskList;
    }

    public ViewDataMgrCallBack getViewDataMgrCallBack() {
        return this.mViewDataMgrCallBack;
    }

    public static boolean downloadTaskRun(AppBean appBean) {
        boolean run = false;
        int size = mAppTaskList.size();
        for (int i = 0; i < size; ++i) {
            if (appBean == null || null == mAppTaskList.getTask(i) || !appBean.getAppId().equals(mAppTaskList.getTask(i).getTaskId())) continue;
            run = true;
        }
        return run;
    }

    @TargetApi(value=11)
    protected void launch(Context context, AppBean appBean, final int mType, final boolean isUpdate, final String pkgType, final EMMStartUpVO startUpInfo, boolean isVisibleAppStroe, final ViewDataMgrCallBack mViewDataMgrCallBack) {
        this.mAppBean = appBean;
        switch (mType) {
            case 0: {
                if (!NetworkUtils.isOnline(context)) {
                    ViewUtils.showToast(context, EUExUtil.getString((String)"plugin_appstore_not_force"), 0);
                    return;
                }
                new AppBeanDao(context).updateAppState(appBean.getAppId(), 2, null);
                mViewDataMgrCallBack.onStartDownload();
                break;
            }
            case 1: {
                if (this.updateDownTask != null) {
                    LogUtils.logDebug("update downTask status:" + this.updateDownTask.getStatus());
                }
                if (this.updateDownTask != null && AsyncTask.Status.FINISHED != this.updateDownTask.getStatus()) {
                    return;
                }
                mViewDataMgrCallBack.openApp(this.mContext, appBean);
                LogUtils.logDebug("AppDownTask doInBackground TYPE_ACTION_APP_OPEN");
                return;
            }
        }
        if (AppStoreMainView.isDownloadRunning(appBean.getAppId())) {
            LogUtils.logDebugO("update downloadTask is Running: " + appBean.getAppId());
            return;
        }
        AppDownTask appDownTask = new AppDownTask(context, appBean, mType, isVisibleAppStroe, true){

            @Override
            protected void onPreExecute() {
                super.onPreExecute();
            }

            @Override
            protected Object doInBackground(Object ... params) {
                LogUtils.logDebug("AppDownTask doInBackground type:" + mType);
                Object result = null;
                switch (mType) {
                    case 0: {
                        mAppTaskList.addTask(this);
                        AppHttpDataManager.appInstallReport(this.mContext, this.appBean, ViewDataManager.this.mWgtData);
                        LogUtils.logDebugO("sub app download url:" + this.appBean.getDownloadUrl());
                        result = super.doInBackground(this.appBean.getDownloadUrl(), "0", pkgType);
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                return result;
            }

            @Override
            public void handleOnCanceled(MyAsyncTask task) {
                super.handleOnCanceled(task);
                mAppTaskList.removeTask(this);
                LogUtils.logDebug("handleOnCanceled " + this.getStatus());
            }

            @Override
            public void handleOnCompleted(MyAsyncTask task, Object result) {
                super.handleOnCompleted(task, result);
                mAppTaskList.removeTask(this);
                LogUtils.logDebug("handleOnCompleted " + this.getStatus());
                if (null == result && 0 == this.type) {
                    mViewDataMgrCallBack.downAppFail(this.mContext, this.appBean, startUpInfo, isUpdate);
                    return;
                }
                if (AppUtils.isNativeApp(this.appBean.getType())) {
                    File file;
                    if (result instanceof File && (file = (File)result) != null && file.exists()) {
                        new AppBeanDao(this.mContext).updateAppState(this.appBean.getAppId(), 1, null);
                        EUExAppStoreMgr.getInstance().installApp(this.appBean, file);
                        AppLocalDataManager.saveApkPath(this.mContext, this.appBean.getAppId(), file.getAbsolutePath());
                        AppLocalDataManager.removeProgress(this.mContext, this.appBean.getAppId());
                    }
                } else {
                    switch (this.type) {
                        case 0: {
                            if (!(result instanceof File)) break;
                            File file = (File)result;
                            new AppBeanDao(this.mContext).updateAppState(this.appBean.getAppId(), 1, null);
                            ViewDataManager.this.unzip(this.mContext, this.appBean, file.getAbsolutePath(), this.type, isUpdate, startUpInfo, mViewDataMgrCallBack);
                            break;
                        }
                    }
                }
            }
        };
        appDownTask.executeOnExecutor(Executors.newCachedThreadPool(), new Object[0]);
    }

    public void checkUpdate(Context context, EUExAppStoreMgr storeMgr, AppBean appBean, EMMStartUpVO emmStartUpVO, String result) {
        if (emmStartUpVO.hasNewAppUrl()) {
            storeMgr.cbCheckUpdate(2, result);
            this.hasNewAppHandler(context, appBean, emmStartUpVO, false, EUExUtil.getString((String)"plugin_appstore_cancel"), null, false);
        } else {
            storeMgr.cbCheckUpdate(1, null);
        }
    }

    private void hasNewAppHandler(Context context, AppBean appBean, EMMStartUpVO mEmmStartUpInfo, boolean isCheckAppStatus, String negativeBtnText, String info, boolean isOpenApp) {
        AppBean appBeanTemp = new AppBean();
        try {
            appBeanTemp = (AppBean)appBean.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        appBeanTemp.setInstallVersion(mEmmStartUpInfo.getNewVersion());
        GrayRelease.saveGrayReleaseStrategyId(context, mEmmStartUpInfo, appBeanTemp.getAppId());
        if (!mEmmStartUpInfo.getNeedConfirm() && mEmmStartUpInfo.getForceUpdate()) {
            this.update(context, appBeanTemp, 0, mEmmStartUpInfo, EUExAppStoreMgr.isVisibleAppStroe, this.mViewDataMgrCallBack);
            return;
        }
        if (mEmmStartUpInfo.getNeedConfirm()) {
            this.showUpdateDialog(context, appBeanTemp, mEmmStartUpInfo, isCheckAppStatus, EUExAppStoreMgr.isVisibleAppStroe, this.mViewDataMgrCallBack, negativeBtnText, info, isOpenApp);
        }
    }

    public void checkUpdate(Context context, AppBean appBean, EMMStartUpVO mEmmStartUpInfo, boolean isCheckAppStatus, boolean isVisibleAppStroe, ViewDataMgrCallBack mViewDataMgrCallBack, String negativeBtnText, String info) {
        if (mEmmStartUpInfo.hasNewAppUrl()) {
            this.hasNewAppHandler(context, appBean, mEmmStartUpInfo, isCheckAppStatus, negativeBtnText, info, true);
        } else if (isCheckAppStatus) {
            AppUtils.checkAppStatus(context, appBean, mEmmStartUpInfo);
        }
    }

    public void checkUpdate(Context context, AppBean appBean, String jsonStr, boolean isCheckAppStatus, boolean isVisibleAppStroe, ViewDataMgrCallBack mViewDataMgrCallBack) {
        if (TextUtils.isEmpty((CharSequence)jsonStr) || jsonStr.equals("{}")) {
            return;
        }
        try {
            EMMStartUpVO mEmmStartUpInfo = AppStoteDataParser.parseEmmStartUpInfo(jsonStr);
            this.checkUpdate(context, appBean, mEmmStartUpInfo, isCheckAppStatus, isVisibleAppStroe, mViewDataMgrCallBack, EUExUtil.getString((String)"plugin_appstore_cancel"), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showUpdateDialog(final Context context, final AppBean appBean, final EMMStartUpVO mEmmStartUpInfo, final boolean isCheckAppStatus, final boolean isVisibleAppStroe, final ViewDataMgrCallBack mViewDataMgrCallBack, final String negativeBtnText, final String info, final boolean isOpenApp) {
        if (context instanceof Activity) {
            Activity uiThread = (Activity)context;
            Runnable showDialog = new Runnable(){

                @Override
                public void run() {
                    AlertDialog.Builder builder = new AlertDialog.Builder(context);
                    builder.setTitle((CharSequence)EUExUtil.getString((String)"plugin_appstore_upgrade_prompt"));
                    String msg = mEmmStartUpInfo.getUpdateHints();
                    if (TextUtils.isEmpty((CharSequence)msg)) {
                        msg = context.getString(EUExUtil.getResStringID((String)"plugin_app_market_update_file_default_msg"));
                    }
                    builder.setMessage((CharSequence)msg);
                    builder.setPositiveButton((CharSequence)EUExUtil.getString((String)"plugin_appstore_app_upgrade"), (DialogInterface.OnClickListener)new PositiveListener(context, appBean, mEmmStartUpInfo, isVisibleAppStroe, mViewDataMgrCallBack, isOpenApp));
                    if (!mEmmStartUpInfo.getForceUpdate()) {
                        builder.setNegativeButton((CharSequence)negativeBtnText, (DialogInterface.OnClickListener)new NegativeListener(context, appBean, false, mEmmStartUpInfo, info));
                    } else {
                        builder.setNegativeButton((CharSequence)EUExUtil.getString((String)"plugin_appstore_exit_app"), (DialogInterface.OnClickListener)new NegativeListener(context, appBean, true, mEmmStartUpInfo, info));
                    }
                    AlertDialog dialog = builder.create();
                    dialog.setCanceledOnTouchOutside(false);
                    dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                        public void onCancel(DialogInterface dialog) {
                            if (isCheckAppStatus) {
                                AppUtils.checkAppStatus(context, appBean, mEmmStartUpInfo);
                            }
                        }
                    });
                    try {
                        dialog.show();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            uiThread.runOnUiThread(showDialog);
        }
    }

    private void finishWidget(String appId) {
        if (EUExAppStoreMgr.getInstance() != null) {
            EUExAppStoreMgr.getInstance().cbToFinishWidget(appId);
        }
    }

    @TargetApi(value=11)
    protected void unzip(final Context context, final AppBean appBean, final String filePath, final int type, final boolean isUpdate, final EMMStartUpVO startUpInfo, final ViewDataMgrCallBack mViewDataMgrCallBack) {
        long fileSize;
        if (!FileUtils.isExistSdcard()) {
            ViewUtils.showToast(context, EUExUtil.getString((String)"plugin_appstore_no_sd_card"), 0);
            return;
        }
        long sdFree = FileUtils.getSDFreeSize() * 1024L * 1024L;
        if (!TextUtils.isEmpty((CharSequence)filePath) && new File(filePath).exists() && sdFree < (fileSize = new File(filePath).length())) {
            ViewUtils.showToast(context, EUExUtil.getString((String)"plugin_appstore_not_enough_storage"), 0);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)filePath) || !new File(filePath).exists()) {
            LogUtils.logDebug("unzip filePath is invalid");
            return;
        }
        new AsyncTask<Void, Void, String>(){
            Dialog dialog;

            protected void onPreExecute() {
                if (ViewDataManager.this.isShowPrompt(isUpdate, startUpInfo)) {
                    EUExAppStoreMgr.cbLoadWidget(5, appBean, "");
                }
            }

            protected String doInBackground(Void ... params) {
                String installPath = null;
                installPath = AppUtils.installSubWidget(context, ViewDataManager.this, appBean.getAppId(), filePath, AppStoreUtils.getWidgetSavePath(), null);
                if (TextUtils.isEmpty((CharSequence)installPath) || !new File(installPath).exists()) {
                    mViewDataMgrCallBack.unzipFail(context, appBean, startUpInfo, isUpdate);
                    return null;
                }
                String configFile = installPath + "config.xml";
                String installVer = AppUtils.getWidgetLocalVersion(configFile);
                appBean.setInstallVersion(installVer);
                appBean.setState(4);
                appBean.setInstallPath(installPath);
                LogUtils.logDebug(" unzip doInBackground path : " + filePath);
                AppDownLoadDb.deleteUpdateFromDb(context, appBean.getDownloadUrl());
                GrayRelease.checkGrayReleaseNewVersion(context, appBean);
                switch (type) {
                    case 0: {
                        new AppBeanDao(context).addAppBean("t_apps", appBean);
                        new AppBeanDao(context).updateAppState(appBean.getAppId(), appBean.getState(), appBean.getInstallPath());
                        new AppBeanDao(context).updateAppVer(appBean, installVer);
                        new AppBeanDao(context).updateNewAppState(appBean.getAppId(), 3);
                        break;
                    }
                    case 1: {
                        LogUtils.logDebug(" unzip TYPE_OPEN Version: " + appBean.getInstallVersion());
                        new AppBeanDao(context).updateAppVer(appBean, installVer);
                        new AppBeanDao(context).deleteUpdate(appBean.getAppId());
                        new AppBeanDao(context).updateNewAppState(appBean.getAppId(), 3);
                        break;
                    }
                }
                return installPath;
            }

            protected void onPostExecute(String result) {
                mViewDataMgrCallBack.unzipPostExecute(context, appBean, result, filePath, this.dialog, type, isUpdate, startUpInfo);
            }
        }.executeOnExecutor((Executor)Executors.newCachedThreadPool(), (Object[])new Void[0]);
    }

    @TargetApi(value=11)
    private void update(final Context context, final AppBean mAppBean, int type, final EMMStartUpVO mEmmStartUpInfo, boolean isVisibleAppStroe, final ViewDataMgrCallBack mCallBack) {
        if (AppStoreMainView.isDownloadRunning(mAppBean.getAppId())) {
            LogUtils.logDebugO("update downloadTask is Running: " + mAppBean.getAppId());
            return;
        }
        this.updateDownTask = new AppDownTask(context, mAppBean, type, isVisibleAppStroe, mEmmStartUpInfo.getNeedConfirm()){

            @Override
            protected Object doInBackground(Object ... params) {
                AppHttpDataManager.appInstallReport(context, mAppBean, ViewDataManager.this.mWgtData);
                final String updateUrl = mEmmStartUpInfo.getNewAppUrl();
                Object object = super.doInBackground(updateUrl, "1", mEmmStartUpInfo.getPkgType());
                if (null != object && object instanceof File) {
                    final File file = (File)object;
                    new AsyncTask<Void, Object, String>(){

                        protected String doInBackground(Void ... params) {
                            AppBean appDetial = AppHttpDataManager.getAppDetialFormAppBean(mAppBean.getAppId(), context, ViewDataManager.this.mWgtData);
                            return AppUtils.getAppUpgradeVersion(appDetial);
                        }

                        protected void onPostExecute(String params) {
                            if (!TextUtils.isEmpty((CharSequence)params)) {
                                new AppBeanDao(context).addUpdate(mAppBean, params, updateUrl, file.getAbsolutePath());
                            }
                        }
                    }.executeOnExecutor((Executor)Executors.newCachedThreadPool(), (Object[])new Void[0]);
                }
                return object;
            }

            @Override
            public void handleOnCompleted(MyAsyncTask task, Object result) {
                AppStoreMainView.APP_DOWNLOAD_LIST.remove(mAppBean.getAppId());
                if (result == null) {
                    return;
                }
                if (result instanceof File) {
                    File file = (File)result;
                    ViewDataManager.this.unzip(context, mAppBean, file.getAbsolutePath(), 0, true, mEmmStartUpInfo, mCallBack);
                }
            }

            @Override
            public void handleOnCanceled(MyAsyncTask task) {
                super.handleOnCanceled(task);
                AppStoreMainView.APP_DOWNLOAD_LIST.remove(mAppBean.getAppId());
            }
        };
        AppStoreMainView.APP_DOWNLOAD_LIST.put(mAppBean.getAppId(), mAppBean);
        this.updateDownTask.executeOnExecutor(Executors.newCachedThreadPool(), new Object[0]);
    }

    void addTask(AsyncTask<Void, Void, Object> task) {
        if (this.unzipTaskList.size() > 0) {
            // empty if block
        }
        this.unzipTaskList.add(task);
    }

    public static void removeNativeApp(Context context, AppBean appBean) {
        String appId = "";
        if (appBean != null) {
            new AppBeanDao(context).updateAppState(appBean.getAppId(), 0, null);
            appId = appBean.getAppId();
            int newApp = appBean.getNewApp();
            LogUtils.logDebug("removePackagepkgName: " + appBean.getPackageName() + " " + newApp);
            new AppBeanDao(context).deleteApp("app_list", appId);
            AppStoreMainView mMyAppActivity = AppStoreMainView.getInstance();
            if (mMyAppActivity != null) {
                mMyAppActivity.refreshLocalAppData();
            }
            if (!EUExAppStoreMgr.isVisibleAppStroe) {
                new AppBeanDao(context).deleteApp("app_list", appBean.getAppId());
                EUExAppStoreMgr.getInstance().jsCallback("uexAppStoreMgr.cbDeleteMyApps", 0, 0, 1);
            }
            AppUtils.delAppCacheData(context, EUExAppStoreMgr.getRootWData(), appBean);
        }
    }

    @TargetApi(value=11)
    public void onWebAppClicked(final Context context, final WWidgetData mWgtData, final AppBean appBean, boolean isAppInstall) {
        if (!isAppInstall) {
            new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... params) {
                    AppHttpDataManager.appInstallReport(context, appBean, mWgtData);
                    return null;
                }
            }.executeOnExecutor((Executor)Executors.newCachedThreadPool(), (Object[])new Void[0]);
        }
        AppUtils.openApp(context, appBean, AppStoreUtils.getOpenSubAppInfo(context, appBean.getAppId()), true);
    }

    protected boolean isShowPrompt(boolean isUpdate, EMMStartUpVO startUpInfo) {
        boolean needConfirm = true;
        if (startUpInfo != null) {
            needConfirm = startUpInfo.getNeedConfirm();
        }
        return !isUpdate || needConfirm;
    }

    public static interface ViewDataMgrCallBack {
        public void onStartDownload();

        public void openApp(Context var1, AppBean var2);

        public void downAppFail(Context var1, AppBean var2, EMMStartUpVO var3, boolean var4);

        public void unzipFail(Context var1, AppBean var2, EMMStartUpVO var3, boolean var4);

        public void unzipPostExecute(Context var1, AppBean var2, String var3, String var4, Dialog var5, int var6, boolean var7, EMMStartUpVO var8);
    }

    class NegativeListener
    implements DialogInterface.OnClickListener {
        private Context mContext;
        private AppBean appBean;
        private boolean isForceUpdate;
        private EMMStartUpVO mEmmStartUpInfo;
        private String info;

        public NegativeListener(Context mContext, AppBean appBean, boolean forceUpdate, EMMStartUpVO mEmmStartUpInfo, String info) {
            this.mContext = mContext;
            this.appBean = appBean;
            this.isForceUpdate = forceUpdate;
            this.mEmmStartUpInfo = mEmmStartUpInfo;
            this.info = info;
        }

        public void onClick(DialogInterface dialog, int which) {
            dialog.cancel();
            if (this.isForceUpdate) {
                ViewDataManager.this.finishWidget(this.appBean.getAppId());
            } else if (2 == this.appBean.getType()) {
                AppUtils.openApp(this.mContext, this.appBean, this.info, false);
            }
            GrayRelease.freeGrayReleaseVersion(this.mContext, this.appBean, this.mEmmStartUpInfo);
        }
    }

    class PositiveListener
    implements DialogInterface.OnClickListener {
        private Context mContext;
        private AppBean appBean;
        private EMMStartUpVO startUpInfo;
        private boolean isVisibleAppStroe;
        private ViewDataMgrCallBack viewDataMgrCallBack;

        public PositiveListener(Context context, AppBean appBean, EMMStartUpVO startUpInfo, boolean isVisibleAppStroe, ViewDataMgrCallBack viewDataMgrCallBack, boolean isOpenApp) {
            this.mContext = context;
            this.appBean = appBean;
            this.startUpInfo = startUpInfo;
            this.isVisibleAppStroe = isVisibleAppStroe;
            this.viewDataMgrCallBack = viewDataMgrCallBack;
        }

        public void onClick(DialogInterface dialog, int which) {
            dialog.dismiss();
            Intent intent = new Intent("org.zywx.emm.widgetupdate.event.ack.action");
            intent.putExtra("appId", this.appBean.getAppId());
            intent.putExtra("type", "doUpdateWithConfirm");
            intent.setPackage(this.mContext.getPackageName());
            this.mContext.sendBroadcast(intent);
            ViewDataManager.this.finishWidget(this.appBean.getAppId());
            AppBean app = this.appBean;
            app.setDownloadUrl(this.startUpInfo.getNewAppUrl());
            app.setState(0);
            new AppBeanDao(this.mContext).updateAppState(this.appBean.getAppId(), 0, this.appBean.getInstallPath());
            ViewDataManager.this.launch(this.mContext, app, 0, true, this.startUpInfo.getPkgType(), this.startUpInfo, this.isVisibleAppStroe, this.viewDataMgrCallBack);
        }
    }
}

