/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.data;

import android.annotation.TargetApi;
import android.app.Dialog;
import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import java.io.File;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDownLoadDb;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppHttpDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.ViewDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.upgrade.GrayRelease;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.EMMStartUpVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class ViewDataManager3
extends ViewDataManager
implements AppStoreConstant {
    private static ViewDataManager3 mViewDataManager3;
    private LinkedList<AsyncTask<Void, Void, Object>> unzipTaskList = new LinkedList();

    public ViewDataManager3(Context context, WWidgetData mWData) {
        super(context, mWData);
        if (null == mViewDataManager3) {
            mViewDataManager3 = this;
            EUExUtil.init((Context)context);
            this.mViewDataMgrCallBack = new ViewDataManager.ViewDataMgrCallBack(){

                @Override
                public void onStartDownload() {
                    LogUtils.logDebug("ViewDataManager3 onStartDownload");
                    EUExAppStoreMgr.onStartDownload();
                }

                @Override
                public void openApp(Context context, AppBean appBean) {
                    LogUtils.logDebug("mViewDataMgrCallBack openApp type:" + appBean.getType());
                    switch (appBean.getType()) {
                        case 2: 
                        case 4: {
                            AppUtils.openApp(context, appBean, AppStoreUtils.getOpenSubAppInfo(context, appBean.getAppId()), true);
                            break;
                        }
                        case 3: {
                            EUExAppStoreMgr.cbLoadWidget(1, appBean, "");
                            break;
                        }
                        default: {
                            LogUtils.logErrorO("ViewDataManager3 lunch open app type error");
                        }
                    }
                }

                @Override
                public void downAppFail(Context context, AppBean appBean, EMMStartUpVO startUpInfo, boolean isUpdate) {
                    if (ViewDataManager3.this.isShowPrompt(isUpdate, startUpInfo)) {
                        EUExAppStoreMgr.cbLoadWidget(0, appBean, EUExUtil.getString((String)"plugin_appstore_download_fail"));
                    }
                    new AppBeanDao(context).updateAppState(appBean.getAppId(), 0, null);
                    GrayRelease.freeGrayReleaseVersion(context, appBean, startUpInfo);
                }

                @Override
                public void unzipPostExecute(Context context, AppBean appBean, String unzipResult, String filePath, Dialog dialog, int actionType, boolean isUpdate, EMMStartUpVO startUpInfo) {
                    new File(filePath).delete();
                    EUExAppStoreMgr.cbLoadWidget(6, appBean, "");
                    switch (actionType) {
                        case 0: {
                            if (unzipResult == null) {
                                LogUtils.logError("TYPE_DOWNLOAD unZip error: " + unzipResult);
                                if (ViewDataManager3.this.isShowPrompt(isUpdate, startUpInfo)) {
                                    EUExAppStoreMgr.cbLoadWidget(0, appBean, "");
                                }
                                return;
                            }
                            int loadStatus = isUpdate ? 2 : 1;
                            EUExAppStoreMgr.cbLoadWidget(loadStatus, appBean, "");
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                }

                @Override
                public void unzipFail(Context context, AppBean appBean, EMMStartUpVO startUpInfo, boolean isUpdate) {
                    LogUtils.logDebug("unzip failed");
                    if (ViewDataManager3.this.isShowPrompt(isUpdate, startUpInfo)) {
                        EUExAppStoreMgr.cbLoadWidget(0, appBean, EUExUtil.getString((String)"plugin_appstore_install_fail"));
                    }
                    if (startUpInfo != null) {
                        GrayRelease.freeGrayReleaseVersion(context, appBean, startUpInfo);
                    }
                }
            };
        }
    }

    public static ViewDataManager3 getInstance() {
        if (null == mViewDataManager3) {
            mViewDataManager3 = new ViewDataManager3(EUExAppStoreMgr.getInstance().mBrowserContext, EUExAppStoreMgr.getRootWData());
        }
        return mViewDataManager3;
    }

    public void launch(Context context, AppBean appBean, int type, boolean isUpdate, String pkgType) {
        this.launch(context, appBean, type, isUpdate, pkgType, null, false, this.mViewDataMgrCallBack);
    }

    public void unzip(Context context, AppBean appBean, String filePath, int type, boolean isUpdate) {
        this.unzip(context, appBean, filePath, type, isUpdate, null, this.mViewDataMgrCallBack);
    }

    @Override
    void addTask(AsyncTask<Void, Void, Object> task) {
        if (this.unzipTaskList.size() > 0) {
            // empty if block
        }
        this.unzipTaskList.add(task);
    }

    private boolean onWebAppClicked(Context context, WWidgetData mWgtData, AppBean appBean) {
        boolean isAppInstall = AppUtils.isWebAppInstall(context, appBean.getAppId());
        this.onWebAppClicked(context, mWgtData, appBean, isAppInstall);
        return isAppInstall;
    }

    @Override
    public void onWebAppClicked(final Context context, final WWidgetData mWgtData, final AppBean appBean, boolean isAppInstall) {
        if (!isAppInstall) {
            new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... params) {
                    AppHttpDataManager.appInstallReport(context, appBean, mWgtData);
                    return null;
                }
            }.execute((Object[])new Void[0]);
        }
    }

    @TargetApi(value=11)
    public static void loadWidget(final Context context, final WWidgetData mWData, final AppBean appBean) {
        boolean isSaveAppInfo = false;
        final ViewDataManager3 viewDataManager = ViewDataManager3.getInstance();
        if (appBean.getType() != 1) {
            String appId = appBean.getAppId();
            if ((1 == appBean.getState() || 4 == appBean.getState()) && AppUtils.isAppInstalled(context, appBean)) {
                String[] updateInfo = new AppBeanDao(context).getUpdate(appBean.getAppId());
                if (updateInfo != null) {
                    String filePath = updateInfo[0];
                    String appVer = updateInfo[1];
                    if (!TextUtils.isEmpty((CharSequence)filePath) && filePath.endsWith(".zip") && !TextUtils.isEmpty((CharSequence)appVer)) {
                        if (new File(filePath).exists()) {
                            AppBean bean = appBean;
                            bean.setInstallVersion(appVer);
                            viewDataManager.unzip(context, bean, filePath, 1, true);
                            return;
                        }
                        new AppBeanDao(context).deleteUpdate(appBean.getAppId());
                    }
                }
                viewDataManager.launch(context, appBean, 1, false, "upgrade");
            } else {
                LogUtils.logDebug("begin loading...");
                if (ViewDataManager3.getAppTaskList().isExistTask(appId, context)) {
                    return;
                }
                LogUtils.logDebug("start getAppDetial AsyncTask");
                EUExAppStoreMgr.onStartDownload();
                isSaveAppInfo = true;
                new AsyncTask<Void, Void, AppBean>(){

                    protected void onPreExecute() {
                        LogUtils.logDebug("getAppDetial onPreExecute");
                    }

                    protected AppBean doInBackground(Void ... params) {
                        LogUtils.logDebug("getAppDetial doInBackground");
                        return AppHttpDataManager.getAppDetialFormAppBean(appBean.getAppId(), context, mWData);
                    }

                    protected void onPostExecute(AppBean appDetial) {
                        LogUtils.logDebug("getAppDetial onPostExecute");
                        if (appDetial != null && !TextUtils.isEmpty((CharSequence)appDetial.getDownloadUrl())) {
                            appBean.setDownloadUrl(appDetial.getDownloadUrl());
                            appBean.setPackageName(appDetial.getPackageName());
                            String[] result = AppDownLoadDb.getFilePathFromDownload(context, appBean.getDownloadUrl());
                            if (result != null) {
                                String path = result[0];
                                String size = result[1];
                                if (!TextUtils.isEmpty((CharSequence)path) && !TextUtils.isEmpty((CharSequence)size)) {
                                    int fileSize = Integer.parseInt(size);
                                    File file = new File(path);
                                    if (file.exists() && file.length() == (long)fileSize) {
                                        switch (appBean.getType()) {
                                            case 2: 
                                            case 4: {
                                                EUExAppStoreMgr.getInstance().installApp(appBean, new File(path));
                                                break;
                                            }
                                            case 3: {
                                                viewDataManager.unzip(context, appBean, path, 0, false);
                                            }
                                        }
                                        return;
                                    }
                                }
                            }
                            viewDataManager.launch(context, appBean, 0, false, "upgrade");
                        } else {
                            LogUtils.logDebugO("get app detial fail loadwidget!");
                            EUExAppStoreMgr.cbLoadWidget(0, appBean, "");
                        }
                    }
                }.executeOnExecutor((Executor)Executors.newCachedThreadPool(), (Object[])new Void[0]);
            }
        } else {
            EUExAppStoreMgr.cbLoadWidget(1, appBean, "");
            boolean bl = isSaveAppInfo = !viewDataManager.onWebAppClicked(context, mWData, appBean);
        }
        if (isSaveAppInfo) {
            new AppBeanDao(context).addAppBean("app_list", appBean);
        }
    }
}

