/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.utils;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import java.io.File;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.base.BUtility;
import org.zywx.wbpalmstar.base.ResoureFinder;
import org.zywx.wbpalmstar.engine.DataHelper;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppStoteDataParser;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.encryption.AppEncryption;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.encryption.MD5Encryption;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.encryption.RC4Encryption;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoteHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.HexConverter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStatusVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.GridVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class AppStoreUtils
implements AppStoreConstant {
    private static String widgetSavePath = "";
    private static String widgetDataParentPath = "";

    public static String getMainAppId(Context context) {
        return SharedPrefUtils.getString(context, "app", "appid", "undefined");
    }

    public static String getMainAppKey() {
        String appKey = EUExUtil.getString((String)"appkey");
        appKey = AppEncryption.decodeStr(appKey);
        return appKey;
    }

    public static boolean isMCMExist() {
        boolean isExist = false;
        try {
            Class.forName("org.zywx.wbpalmstar.plugin.uexmcm.EUexMCM");
            isExist = true;
            LogUtils.logDebug("MCM is exist ");
        }
        catch (ClassNotFoundException e) {
            LogUtils.logDebug("MCM is not exist: " + e.getMessage());
        }
        return isExist;
    }

    public static String getAppVerifyCode(WWidgetData mWData) {
        String timeStamp = System.currentTimeMillis() + "";
        String appVerifyCode = mWData.m_appId + ":" + mWData.m_appkey + ":" + timeStamp;
        appVerifyCode = MD5Encryption.getMD5Code(appVerifyCode) + ";" + timeStamp;
        return appVerifyCode;
    }

    public static boolean isFirstGetInstallAppList(Context context) {
        return SharedPrefUtils.getBoolean(context, "app", "firstGetInstallAppList", true);
    }

    public static void setFirstGetInstallAppList(Context context, boolean value) {
        SharedPrefUtils.putBoolean(context, "app", "firstGetInstallAppList", value);
    }

    public static Bundle getAppInforBundle(AppBean appBean, WWidgetData mWidgetData) {
        Bundle bundle = new Bundle();
        bundle.putParcelable("appBean", (Parcelable)appBean);
        bundle.putParcelable("currentWidgetData", (Parcelable)mWidgetData);
        return bundle;
    }

    public static void saveOpenSubAppInfo(Context context, String appId, String info) {
        SharedPrefUtils.putString(context, "open_sub_app_info", appId, info);
    }

    public static String getOpenSubAppInfo(Context context, String appId) {
        return SharedPrefUtils.getString(context, "open_sub_app_info", appId, "");
    }

    public static String setWebUrlParams(String url, String param) {
        String nameValueStr = "";
        if (!TextUtils.isEmpty((CharSequence)param)) {
            try {
                JSONObject json = new JSONObject(param);
                nameValueStr = AppStoteDataParser.jsonToFromString(json);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        StringBuilder urlBuilder = new StringBuilder(url);
        if (!TextUtils.isEmpty((CharSequence)nameValueStr)) {
            urlBuilder.append("?").append(nameValueStr);
        }
        return urlBuilder.toString();
    }

    public static Intent getNotifyDownloadIntent(String packageName, String appId) {
        Intent intent = new Intent();
        if (!TextUtils.isEmpty((CharSequence)packageName)) {
            intent.setPackage(packageName);
        }
        intent.setAction("plugin_appstore_notify_download_status");
        intent.putExtra("plugin_appstore_notify_download_status_appId", appId);
        return intent;
    }

    public static String getWidgetSavePath() {
        return widgetSavePath;
    }

    public static String getWidgetDataSavePath(String appId) {
        return widgetDataParentPath + appId + "/";
    }

    private static void initWidgetPath(WWidgetData wData) {
        widgetSavePath = BUtility.makeRealPath((String)"wgts://", (String)wData.getWidgetPath(), (int)wData.m_wgtType);
        String mainDataPath = BUtility.makeRealPath((String)"wgt://", (String)wData.getWidgetPath(), (int)wData.m_wgtType);
        try {
            int index = mainDataPath.indexOf("apps");
            widgetDataParentPath = mainDataPath.substring(0, index + "apps".length() + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getCertificatepath(Context context, boolean isUpdateWidget) {
        String cPath = null;
        cPath = isUpdateWidget ? context.getFilesDir().getPath() + "/widget/wgtRes/clientCertificate.p12" : "file:///android_asset/widget/wgtRes/clientCertificate.p12";
        return cPath;
    }

    private static void initCertInfo(Context context) {
        String certPath = null;
        String certPsw = null;
        if (AppStatusVO.isCertificate()) {
            certPath = AppStoreUtils.getCertificatepath(context, AppStatusVO.isIncreUpdate());
            certPsw = EUExUtil.getCertificatePsw((Context)context, (String)AppStoreUtils.getMainAppId(context));
        }
        AppStoteHttpURLConnection.setCertificate(AppStatusVO.isCertificate(), certPath, certPsw);
    }

    public static void initAppStore(Context context, WWidgetData wData) {
        SharedPrefUtils.putString(context, "app", "appid", wData.m_appId);
        AppStoreUtils.initAppStatus(context);
        AppStoreUtils.initCertInfo(context);
        AppStoreUtils.initWidgetPath(wData);
    }

    private static void initAppStatus(Context context) {
        try {
            String appstatus = ResoureFinder.getInstance().getString(context, "appstatus");
            LogUtils.logDebug("appstatusStr: " + appstatus);
            byte[] appstatusToByte = HexConverter.hexStringToBinary(appstatus);
            String appstatusDecrypt = new String(RC4Encryption.encryption(appstatusToByte, appstatusToByte.length, AppStoreUtils.getMainAppId(context)));
            LogUtils.logDebugO("appstatusDecrypt: " + appstatusDecrypt);
            String[] appstatuss = appstatusDecrypt.split(",");
            if (appstatuss == null || appstatuss.length == 0) {
                return;
            }
            if ("0".equals(appstatuss[0])) {
                AppStatusVO.setStartReport(false);
                return;
            }
            if ("0".equals(appstatuss[1])) {
                AppStatusVO.setWidgetStatus(false);
            }
            if ("0".equals(appstatuss[2])) {
                AppStatusVO.setAppUpdate(false);
            }
            if ("0".equals(appstatuss[3])) {
                AppStatusVO.setWidgetParam(false);
            }
            if ("0".equals(appstatuss[4])) {
                AppStatusVO.setWidgetPush(false);
            }
            if ("0".equals(appstatuss[5])) {
                AppStatusVO.setWidgetAnalytics(false);
            }
            if ("1".equals(appstatuss[6])) {
                AppStatusVO.setAuthMam(true);
            }
            if ("1".equals(appstatuss[7])) {
                AppStatusVO.setCheckRoot(true);
            }
            if ("1".equals(appstatuss[8])) {
                AppStatusVO.setCertificate(true);
            }
            if ("1".equals(appstatuss[9])) {
                AppStatusVO.setIncreUpdate(true);
            }
            if ("1".equals(appstatuss[10])) {
                AppStatusVO.setMdmStatus(true);
            }
            if ("1".equals(appstatuss[11])) {
                AppStatusVO.setMcmStatus(true);
            }
            if ("0".equals(appstatuss[12])) {
                LogUtils.logDebug("isForceConnected: false");
                AppStatusVO.setForceConnected(false);
            }
            if ("1".equals(appstatuss[13])) {
                AppStatusVO.setCheckAppSign(true);
            }
            if ("1".equals(appstatuss[14])) {
                AppStatusVO.setCheckService(true);
            }
            if ("1".equals(appstatuss[15])) {
                AppStatusVO.setOfflineLogin(true);
            }
            if ("1".equals(appstatuss[16])) {
                AppStatusVO.setSaveDataToBox(true);
            }
        }
        catch (Exception e) {
            LogUtils.oe("checkAppStatus", e);
        }
    }

    public static String getConfigPathByAppId(String appId) {
        return widgetSavePath + appId + File.separator + "config.xml";
    }

    public static String getWidgetInstallPath(String appId) {
        return widgetSavePath + appId;
    }

    public static String getTenantAccount(Context context) {
        String tenantAccountEncryption = "";
        String tenantAccount = "";
        tenantAccount = SharedPrefUtils.getString(context, "app", "tenantAccount", "");
        tenantAccountEncryption = AppStoreUtils.decryptTenantAccount(context, tenantAccount);
        return tenantAccountEncryption;
    }

    private static String decryptTenantAccount(Context context, String taEncryption) {
        String tenantAccount = "";
        if (!TextUtils.isEmpty((CharSequence)taEncryption)) {
            String mainAppId = SharedPrefUtils.getString(context, "app", "appid", "undefined");
            byte[] tenantAccountByte = HexConverter.hexStringToBinary(taEncryption);
            tenantAccount = new String(RC4Encryption.encryption(tenantAccountByte, tenantAccountByte.length, mainAppId));
        }
        return tenantAccount;
    }

    public static String getGridHost(Context context, String jwtKey) {
        String gridInfo;
        String gridHost = SharedPrefUtils.getString(context, "gridlist", "currentGridIP");
        if (TextUtils.isEmpty((CharSequence)gridHost) && !TextUtils.isEmpty((CharSequence)(gridInfo = SharedPrefUtils.getString(context, "gridlist", jwtKey)))) {
            gridHost = ((GridVO)DataHelper.gson.fromJson((String)gridInfo, GridVO.class)).url;
            SharedPrefUtils.putString(context, "gridlist", "currentGridIP", gridHost);
        }
        return gridHost;
    }

    public static void setAppServiceInfo(Context context, String appId, JSONObject serviceJson) {
        int serviceType = serviceJson.optInt("serviceType");
        String jwtKey = serviceJson.optString("jwtKey");
        SharedPrefUtils.putInt(context, "appServiceInfo" + appId, "serviceType", serviceType);
        SharedPrefUtils.putString(context, "appServiceInfo" + appId, "jwtKey", jwtKey);
    }

    public static int getServiceTypeForAppid(Context context, String appId) {
        return SharedPrefUtils.getInt(context, "appServiceInfo" + appId, "serviceType", 0);
    }

    public static String getJwtKeyForAppid(Context context, String appId) {
        return SharedPrefUtils.getString(context, "appServiceInfo" + appId, "jwtKey", "");
    }
}

