/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.utils;

import android.os.Handler;
import android.os.Looper;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class FastOperationsThrottle {
    private static final String TAG = "FastOperationsThrottle";
    private static final boolean isDebug = false;
    private static volatile FastOperationsThrottle mInstance;
    private Map<Object, OperationVO> operationsMap;
    private Timer controlTimer;

    private FastOperationsThrottle(Map<Object, OperationVO> operationsMap) {
        this.operationsMap = operationsMap;
        this.controlTimer = new Timer(TAG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FastOperationsThrottle getInstance() {
        if (mInstance != null) return mInstance;
        Class<FastOperationsThrottle> clazz = FastOperationsThrottle.class;
        synchronized (FastOperationsThrottle.class) {
            if (mInstance != null) return mInstance;
            mInstance = new FastOperationsThrottle(new HashMap<Object, OperationVO>());
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public synchronized void submitOperation(final Object objIdentifier, ThrottleType throttleType, long periodMs, final Runnable runnable) {
        long startTime = System.currentTimeMillis();
        this.log("submitOperation start: " + startTime);
        if (runnable == null || throttleType == null) {
            long endTime = System.currentTimeMillis();
            this.log("submitOperation end: " + endTime);
            this.log("submitOperation cost: " + (endTime - startTime));
            return;
        }
        final Looper runnerLooper = Looper.myLooper();
        TimerTask newTimerTask = new TimerTask(){

            @Override
            public void run() {
                new Handler(runnerLooper).post(new Runnable(){

                    @Override
                    public void run() {
                        runnable.run();
                        FastOperationsThrottle.this.removeOperationFromMap(objIdentifier);
                    }
                });
            }
        };
        if (this.containsOperation(objIdentifier)) {
            if (ThrottleType.PERIOD_FIRST.equals((Object)throttleType)) {
                long endTime = System.currentTimeMillis();
                this.log("submitOperation end: " + endTime);
                this.log("submitOperation cost: " + (endTime - startTime));
                return;
            }
            if (ThrottleType.PERIOD_LAST.equals((Object)throttleType)) {
                OperationVO operationVO = this.getOperation(objIdentifier);
                TimerTask timerTask = operationVO.getTimerTask();
                timerTask.cancel();
                operationVO.setTimerTask(newTimerTask);
                this.controlTimer.schedule(newTimerTask, periodMs);
                long endTime = System.currentTimeMillis();
                this.log("submitOperation end: " + endTime);
                this.log("submitOperation cost: " + (endTime - startTime));
                return;
            }
        } else {
            this.addOperationToMap(objIdentifier, new OperationVO(objIdentifier, newTimerTask, periodMs, throttleType));
            this.controlTimer.schedule(newTimerTask, periodMs);
        }
        long endTime = System.currentTimeMillis();
        this.log("submitOperation end: " + endTime);
        this.log("submitOperation cost: " + (endTime - startTime));
    }

    private void addOperationToMap(Object objIdentifier, OperationVO operationVO) {
        this.operationsMap.put(objIdentifier, operationVO);
    }

    private void removeOperationFromMap(Object objIdentifier) {
        this.operationsMap.remove(objIdentifier);
    }

    private boolean containsOperation(Object objIdentifier) {
        return this.operationsMap.containsKey(objIdentifier);
    }

    private OperationVO getOperation(Object objIdentifier) {
        return this.operationsMap.get(objIdentifier);
    }

    private void log(String log) {
    }

    public static enum ThrottleType {
        PERIOD_FIRST,
        PERIOD_LAST;

    }

    public static class OperationVO {
        private Object objectIdentifier;
        private TimerTask timerTask;
        private long periodMs;
        private ThrottleType throttleType;

        public OperationVO(Object objectIdentifier, TimerTask timerTask, long periodMs, ThrottleType throttleType) {
            this.objectIdentifier = objectIdentifier;
            this.timerTask = timerTask;
            this.periodMs = periodMs;
            this.throttleType = throttleType;
        }

        public Object getObjectIdentifier() {
            return this.objectIdentifier;
        }

        public void setObjectIdentifier(Object objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
        }

        public TimerTask getTimerTask() {
            return this.timerTask;
        }

        public void setTimerTask(TimerTask timerTask) {
            this.timerTask = timerTask;
        }

        public long getPeriodMs() {
            return this.periodMs;
        }

        public void setPeriodMs(long periodMs) {
            this.periodMs = periodMs;
        }

        public ThrottleType getThrottleType() {
            return this.throttleType;
        }

        public void setThrottleType(ThrottleType throttleType) {
            this.throttleType = throttleType;
        }
    }
}

