/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.view;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.webkit.CookieManager;
import android.webkit.MimeTypeMap;
import android.webkit.URLUtil;
import android.widget.Toast;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.ECallback;

public class EDownloadDialog
extends ProgressDialog
implements Runnable {
    public URL mClient;
    public HttpURLConnection mConnection;
    public InputStream mInStream;
    private String url;
    public String userAgent;
    public String contentDisposition;
    public String mimetype;
    public long contentLength;
    public File mTmpFile;
    public boolean mFromStop;
    public ECallback mCallBack;
    private Handler mProgressHandler = new Handler(){

        public void handleMessage(Message msg) {
            EDownloadDialog.this.setProgress(msg.what);
            if (100 == msg.what) {
                this.sendEmptyMessageDelayed(-1, 1000L);
            } else if (-1 == msg.what) {
                EDownloadDialog.this.downloadDone();
            } else if (-2 == msg.what) {
                Toast.makeText((Context)EDownloadDialog.this.getContext(), (CharSequence)((String)msg.obj), (int)0).show();
            } else if (-3 == msg.what) {
                EDownloadDialog.this.stopDownload();
            }
        }
    };
    private int downLoaderSise = 0;

    public EDownloadDialog(Context context, String url, String userAgent) {
        super(context);
        this.userAgent = userAgent;
        this.init(url);
    }

    public EDownloadDialog(Context context, int theme, String url) {
        super(context, theme);
        this.init(url);
    }

    public void setDoneCallback(ECallback callback) {
        this.mCallBack = callback;
    }

    private void init(String inUrl) {
        this.url = inUrl;
        String suffix = this.makeFileSuffix(this.url);
        MimeTypeMap mtm = MimeTypeMap.getSingleton();
        this.mimetype = mtm.getMimeTypeFromExtension(suffix);
        if (null == this.mimetype) {
            // empty if block
        }
        this.setProgress(0);
        this.setIcon(EUExUtil.getResDrawableID((String)"icon"));
        this.setCancelable(false);
        this.setTitle(EUExUtil.getString((String)"platform_downloading_file"));
        this.setProgressStyle(1);
        this.setMax(100);
        this.setButton(EUExUtil.getString((String)"cancel"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                EDownloadDialog.this.mFromStop = true;
                EDownloadDialog.this.stopDownload();
            }
        });
    }

    public void show() {
        super.show();
        new Thread(this).start();
    }

    private void stopDownload() {
        this.dismiss();
        try {
            if (null != this.mInStream) {
                this.mInStream.close();
            }
            if (null != this.mConnection) {
                this.mConnection.disconnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null != this.mCallBack) {
            this.mCallBack.callback(null);
        }
    }

    @Override
    public void run() {
        try {
            if (!Environment.getExternalStorageState().equals("mounted")) {
                this.mProgressHandler.sendMessage(this.mProgressHandler.obtainMessage(-2, (Object)EUExUtil.getString((String)"error_sdcard_is_not_available")));
                this.mProgressHandler.sendEmptyMessage(-3);
                return;
            }
            this.mClient = new URL(this.url);
            this.mConnection = (HttpURLConnection)this.mClient.openConnection();
            this.mConnection.setRequestMethod("GET");
            this.mConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
            String cookie = this.getCookie(this.url);
            if (null != cookie) {
                this.mConnection.setRequestProperty("Cookie", cookie);
            }
            this.mConnection.setUseCaches(false);
            this.mConnection.setRequestProperty("Connection", "Keep-Alive");
            this.mConnection.setRequestProperty("Charset", "utf-8");
            this.mConnection.setRequestProperty("User-Agent", this.userAgent);
            this.mConnection.setReadTimeout(30000);
            this.mConnection.setConnectTimeout(30000);
            this.mConnection.setInstanceFollowRedirects(false);
            this.mConnection.connect();
            int responseCode = this.mConnection.getResponseCode();
            if (200 == responseCode) {
                this.saveToFile();
            } else {
                this.mProgressHandler.sendMessage(this.mProgressHandler.obtainMessage(-2, (Object)EUExUtil.getString((String)"platform_connect_failed")));
                this.mProgressHandler.sendEmptyMessage(-3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (!this.mFromStop) {
                this.mProgressHandler.sendMessage(this.mProgressHandler.obtainMessage(-2, (Object)EUExUtil.getString((String)"platform_download_failed")));
            }
            this.mProgressHandler.sendEmptyMessage(-3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile() {
        OutputStream outStream = null;
        try {
            File tm;
            File target;
            String cLength;
            this.mInStream = this.mConnection.getInputStream();
            if (this.mInStream == null) {
                return;
            }
            String encoding = this.mConnection.getContentEncoding();
            if ("gzip".equalsIgnoreCase(encoding)) {
                this.mInStream = new GZIPInputStream(this.mInStream);
            } else if ("deflate".equalsIgnoreCase(encoding)) {
                this.mInStream = new DeflaterInputStream(this.mInStream);
            }
            if (this.contentLength <= 0L && (cLength = this.mConnection.getHeaderField("Content-Length")) != null) {
                this.contentLength = Long.parseLong(cLength);
            }
            if (!(target = new File((tm = Environment.getExternalStorageDirectory()).getAbsoluteFile() + "/Download/")).exists()) {
                target.mkdirs();
            }
            String extension = null;
            if (this.mimetype != null) {
                MimeTypeMap mtm = MimeTypeMap.getSingleton();
                extension = mtm.getExtensionFromMimeType(this.mimetype);
            }
            if (extension == null) {
                String fileName = URLUtil.guessFileName((String)this.url, (String)this.contentDisposition, (String)this.mimetype);
                if (!TextUtils.isEmpty((CharSequence)fileName)) {
                    fileName.replaceAll("/", "");
                    this.mTmpFile = new File(target, fileName);
                }
            } else {
                this.mTmpFile = new File(tm.getAbsoluteFile() + "/Download/" + System.currentTimeMillis() + "." + extension);
            }
            outStream = new FileOutputStream(this.mTmpFile);
            byte[] buffer = new byte[3072];
            while (true) {
                int numread;
                if ((numread = this.mInStream.read(buffer)) == -1) break;
                outStream.write(buffer, 0, numread);
                this.downLoaderSise += numread;
                int p = (int)((float)this.downLoaderSise / (float)this.contentLength * 100.0f);
                this.mProgressHandler.sendEmptyMessage(p);
            }
            this.mProgressHandler.sendEmptyMessage(100);
            if (this.contentLength <= 0L) {
                this.mProgressHandler.sendEmptyMessage(100);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void downloadDone() {
        this.stopDownload();
        Intent installIntent = new Intent("android.intent.action.VIEW");
        String filename = this.mTmpFile.getAbsolutePath();
        Uri path = Uri.parse((String)filename);
        if (path.getScheme() == null) {
            path = Uri.fromFile((File)new File(filename));
        }
        String suffix = this.makeFileSuffix(filename).toLowerCase(Locale.US);
        this.mimetype = MimeTypeMap.getSingleton().getMimeTypeFromExtension(suffix);
        installIntent.setDataAndType(path, this.mimetype);
        installIntent.setFlags(0x10000000);
        try {
            this.getContext().startActivity(installIntent);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mProgressHandler.sendMessage(this.mProgressHandler.obtainMessage(-2, (Object)EUExUtil.getString((String)"can_not_find_suitable_app_perform_this_operation")));
        }
    }

    private String makeFileSuffix(String url) {
        int index = url.lastIndexOf(".");
        if (index < 0) {
            return null;
        }
        return url.substring(index + 1);
    }

    private final String getCookie(String inUrl) {
        return CookieManager.getInstance().getCookie(inUrl);
    }
}

