/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.BroadcastReciver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.widget.ProgressBar;
import android.widget.TextView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppLocalDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ConstantUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;

public class DownloadStateAppInfoReceiver
extends BroadcastReceiver
implements ConstantUtils {
    private int percent;
    private ProgressBar mProgressBar;
    private TextView downloadPercent;
    private AppBean mAppBean;
    private Context mContext;

    public DownloadStateAppInfoReceiver(Context mContext, AppBean appBean, ProgressBar progressBar, TextView downloadPercent) {
        this.mContext = mContext;
        this.mAppBean = appBean;
        this.mProgressBar = progressBar;
        this.downloadPercent = downloadPercent;
    }

    public void onReceive(Context context, Intent intent) {
        String action;
        if (context.getPackageName().equals(intent.getPackage()) && (action = intent.getAction()).equals("plugin_appstore_notify_download_status")) {
            try {
                String appId = intent.getStringExtra("plugin_appstore_notify_download_status_appId");
                if (appId.equals(this.mAppBean.getAppId())) {
                    this.percent = AppLocalDataManager.getProgress(this.mContext, this.mAppBean.getAppId());
                    if (this.percent >= 100) {
                        this.mProgressBar.setProgress(0);
                        this.mProgressBar.setClickable(false);
                        this.downloadPercent.setText((CharSequence)"\u5b89\u88c5\u5b8c\u6210");
                    } else if (this.percent != 0 || new AppBeanDao(this.mContext).getAppBean(appId).getState() == 2) {
                        this.mProgressBar.setProgress(this.percent);
                        this.downloadPercent.setText((CharSequence)(String.valueOf(this.percent) + "%"));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

