/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RatingBar;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.HashMap;
import org.zywx.wbpalmstar.base.ResoureFinder;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView.AppInfoBaseView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView.adapter.AppDetailsGalleryAdapter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.imageloader.ImageLoaderManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ConstantUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.MyGallery;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;

public class AppInfoDetailsView
extends AppInfoBaseView
implements ConstantUtils {
    public static final String TAG = "AppDetailsViewTAG";
    private static Context mContext;
    private static AppBean mAppBean;
    private TextView appName;
    private TextView appSize;
    private TextView downloadNum;
    private TextView appVersion;
    private TextView updateTime;
    private TextView developerName;
    private TextView appDiscription;
    private ImageView appIcon;
    private MyGallery gallery;
    private RatingBar appScore;
    private ImageLoaderManager loaderManager;
    private Drawable defaultIconBg;

    public AppInfoDetailsView(Context context, AppBean appBean) {
        super(context);
        mContext = context;
        mAppBean = appBean;
        this.loaderManager = ImageLoaderManager.initImageLoaderManager(mContext);
        this.defaultIconBg = ResoureFinder.getInstance((Context)mContext).getDrawable("plugin_appstoremgr_icon_bg");
        this.onCreateView();
    }

    public View onCreateView() {
        this.rootView = LayoutInflater.from((Context)mContext).inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_app_details_details_fragment"), (ViewGroup)this, false);
        this.gallery = (MyGallery)this.rootView.findViewById(EUExUtil.getResIdID((String)"myGallery"));
        this.appName = (TextView)this.rootView.findViewById(EUExUtil.getResIdID((String)"appName"));
        this.appSize = (TextView)this.rootView.findViewById(EUExUtil.getResIdID((String)"appSize"));
        this.downloadNum = (TextView)this.rootView.findViewById(EUExUtil.getResIdID((String)"downloadNum"));
        this.appVersion = (TextView)this.rootView.findViewById(EUExUtil.getResIdID((String)"appVersion"));
        this.updateTime = (TextView)this.rootView.findViewById(EUExUtil.getResIdID((String)"updateTime"));
        this.developerName = (TextView)this.rootView.findViewById(EUExUtil.getResIdID((String)"developerName"));
        this.appDiscription = (TextView)this.rootView.findViewById(EUExUtil.getResIdID((String)"appDiscription"));
        this.appIcon = (ImageView)this.rootView.findViewById(EUExUtil.getResIdID((String)"imageView"));
        this.appScore = (RatingBar)this.rootView.findViewById(EUExUtil.getResIdID((String)"appScore"));
        this.appName.setText((CharSequence)mAppBean.getAppName());
        this.appSize.setText((CharSequence)(String.valueOf(mAppBean.getAppSize()) + "M"));
        this.downloadNum.setText((CharSequence)(String.valueOf(mAppBean.getDownloadNum()) + " \u6b21\u4e0b\u8f7d"));
        this.appVersion.setText((CharSequence)AppUtils.getAppInstallVersion(mAppBean));
        this.updateTime.setText((CharSequence)mAppBean.getUpdateTime());
        this.developerName.setText((CharSequence)mAppBean.getAppCreator());
        this.appDiscription.setText((CharSequence)mAppBean.getAppDiscription());
        float startLevel = 0.0f;
        try {
            startLevel = Float.parseFloat(mAppBean.getStartLevel());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.appScore.setRating(startLevel);
        String iconUrl = mAppBean.getIconLoc();
        NetworkUtils.asyncLoadImage(mContext, this.appIcon, iconUrl, this.defaultIconBg, this.loaderManager);
        ArrayList<Object> shortImgList = new ArrayList();
        shortImgList = mAppBean.getShortImgList();
        shortImgList.ensureCapacity(4);
        AppDetailsGalleryAdapter dd = new AppDetailsGalleryAdapter(mContext);
        int length = shortImgList.size();
        int i = 0;
        while (i < length) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("image", shortImgList.get(i));
            dd.addObject(map);
            ++i;
        }
        this.gallery.setAdapter(dd);
        if (shortImgList.size() == 0) {
            View gallery_layout = this.rootView.findViewById(EUExUtil.getResIdID((String)"gallery_layout"));
            gallery_layout.setVisibility(8);
            ImageView gallery_divider = (ImageView)this.rootView.findViewById(EUExUtil.getResIdID((String)"my_gallery_divider"));
            gallery_divider.setVisibility(8);
        }
        return this.rootView;
    }

    public int dimension2Pixels(int dime, Activity acti) {
        DisplayMetrics metrics = new DisplayMetrics();
        Display display = acti.getWindowManager().getDefaultDisplay();
        display.getMetrics(metrics);
        int res = (int)((float)dime * metrics.density);
        return res;
    }
}

