/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView;

import android.app.Dialog;
import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.Toast;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView.AppInfoBaseView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView.adapter.AppDiscussListViewAdapter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.DataParserUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.HttpURLConnectionUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ConstantUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.DialogView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.XListView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStatusVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStoreOptionVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class AppInfoDiscussView
extends AppInfoBaseView
implements View.OnClickListener,
ConstantUtils {
    private String TAG = "StoreDiscuss";
    private XListView list;
    private static Context mContext;
    private AppDiscussListViewAdapter adapter;
    private JSONObject getAppEvaluteParams = new JSONObject();
    private AppBean appBean;
    private String indexIdDown;
    private LinearLayout pinglun;
    private static AppInfoDiscussView mAppDiscussFragment;
    private EUExAppStoreMgr mEuExAppStoreMgr;
    private WWidgetData mWgtData;
    private AsyncTask<Void, Void, ArrayList<AppBean>> asyncTask = null;
    private AsyncTask<Void, Void, ArrayList<AppBean>> asyncTaskPullDown = null;
    private AsyncTask<Void, Void, ArrayList<AppBean>> asyncTaskPullUp = null;

    public AppInfoDiscussView(Context context, EUExAppStoreMgr appStoreMgr, AppBean appBean, WWidgetData mWData) {
        super(context);
        mContext = context;
        this.mEuExAppStoreMgr = appStoreMgr;
        this.appBean = appBean;
        this.mWgtData = mWData;
        mAppDiscussFragment = this;
        try {
            this.getAppEvaluteParams.put("appId", (Object)appBean.getAppId());
            this.getAppEvaluteParams.put("pageSize", (Object)"10");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.onCreateView();
    }

    @Override
    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        if (this.adapter == null) {
            this.downloadAppEvalute(this.getAppEvaluteParams);
        }
    }

    public View onCreateView() {
        this.rootView = LayoutInflater.from((Context)mContext).inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_app_details_discuss_listview"), (ViewGroup)this, false);
        this.pinglun = (LinearLayout)this.rootView.findViewById(EUExUtil.getResIdID((String)"pinglun"));
        this.list = (XListView)this.rootView.findViewById(EUExUtil.getResIdID((String)"listView"));
        this.list.setPullLoadEnable(true);
        this.list.setPullRefreshEnable(true);
        this.list.setXListViewListener(new ListViewIXListViewListener(this.list));
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        String time = sdf.format(new Date());
        this.list.setRefreshTime(time);
        this.pinglun.setOnClickListener((View.OnClickListener)this);
        return this.rootView;
    }

    private void downloadAppEvalute(final JSONObject appEvaluteParams) {
        final String resCache = SharedPrefUtils.getString(mContext, "main_prefs", this.appBean.getAppId(), "");
        if (!NetworkUtils.isOnline(mContext) && TextUtils.isEmpty((CharSequence)resCache)) {
            Toast.makeText((Context)mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            this.pinglun.setVisibility(0);
            return;
        }
        if (this.asyncTask != null) {
            return;
        }
        this.asyncTask = new AsyncTask<Void, Void, ArrayList<AppBean>>(){
            Dialog progressDialog = null;

            protected void onPreExecute() {
                this.progressDialog = DialogView.showLoadingDialog(mContext, "\u52a0\u8f7d\u8bc4\u8bba\u5217\u8868...");
                this.progressDialog.show();
            }

            protected ArrayList<AppBean> doInBackground(Void ... params) {
                String response = HttpURLConnectionUtils.downLoadAppList(HttpURLConnectionUtils.getUrlGetAppEvalute(), mContext, AppInfoDiscussView.this.mWgtData, appEvaluteParams).getResult();
                ArrayList<AppBean> commentList = null;
                if (!TextUtils.isEmpty((CharSequence)response)) {
                    commentList = DataParserUtils.parseAppListWithKey("evaluteList", response);
                    SharedPrefUtils.putString(mContext, "main_prefs", AppInfoDiscussView.this.appBean.getAppId(), response);
                } else {
                    LogUtils.e(AppInfoDiscussView.this.TAG, "NetworkUnavailable or appList is null");
                    if (!AppStatusVO.isForceConnected() && !TextUtils.isEmpty((CharSequence)resCache)) {
                        commentList = DataParserUtils.parseAppListWithKey("evaluteList", resCache);
                    }
                }
                return commentList;
            }

            protected void onPostExecute(ArrayList<AppBean> result) {
                if (this.isCancelled()) {
                    AppInfoDiscussView.this.asyncTask = null;
                    return;
                }
                if (this.progressDialog != null) {
                    this.progressDialog.dismiss();
                }
                if (result == null || result.size() == 0) {
                    Toast.makeText((Context)mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_data"), (int)0).show();
                    AppInfoDiscussView.this.pinglun.setVisibility(0);
                    AppInfoDiscussView.this.asyncTask = null;
                    LogUtils.i(AppInfoDiscussView.this.TAG, "no data");
                    return;
                }
                AppInfoDiscussView.this.list.setVisibility(0);
                AppInfoDiscussView.this.pinglun.setVisibility(8);
                int leng = result.size() - 1;
                AppInfoDiscussView.this.indexIdDown = result.get(leng).getIndexId();
                if (AppInfoDiscussView.this.adapter == null) {
                    AppInfoDiscussView.this.adapter = new AppDiscussListViewAdapter(mContext, AppInfoDiscussView.this.mEuExAppStoreMgr, result, AppInfoDiscussView.this.appBean);
                    AppInfoDiscussView.this.list.setAdapter((ListAdapter)AppInfoDiscussView.this.adapter);
                    LogUtils.i(AppInfoDiscussView.this.TAG, "setAdapter");
                } else {
                    LogUtils.i(AppInfoDiscussView.this.TAG, "resumeLoad");
                    AppInfoDiscussView.this.adapter.resumeLoad(result);
                }
                AppInfoDiscussView.this.asyncTask = null;
            }
        };
        this.asyncTask.execute((Object[])new Void[0]);
    }

    private void refreshData(final XListView listView, final JSONObject jsonParams) {
        if (!NetworkUtils.isOnline(mContext)) {
            Toast.makeText((Context)mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            listView.stopRefresh();
            return;
        }
        if (this.asyncTaskPullDown != null) {
            return;
        }
        this.asyncTaskPullDown = new AsyncTask<Void, Void, ArrayList<AppBean>>(){

            protected ArrayList<AppBean> doInBackground(Void ... params) {
                String response = HttpURLConnectionUtils.downLoadAppList(HttpURLConnectionUtils.getUrlGetAppEvalute(), mContext, AppInfoDiscussView.this.mWgtData, jsonParams).getResult();
                ArrayList<AppBean> commentList = DataParserUtils.parseAppListWithKey("evaluteList", response);
                return commentList;
            }

            protected void onPostExecute(ArrayList<AppBean> result) {
                if (this.isCancelled()) {
                    AppInfoDiscussView.this.asyncTaskPullDown = null;
                    return;
                }
                if (result == null || result.size() == 0) {
                    listView.stopRefresh();
                    Toast.makeText((Context)mContext, (CharSequence)"\u6682\u65e0\u8bc4\u8bba", (int)0).show();
                    AppInfoDiscussView.this.asyncTaskPullDown = null;
                }
                if (AppInfoDiscussView.this.adapter != null) {
                    AppInfoDiscussView.this.adapter.reload(result);
                } else {
                    AppInfoDiscussView.this.adapter = new AppDiscussListViewAdapter(mContext, AppInfoDiscussView.this.mEuExAppStoreMgr, result, AppInfoDiscussView.this.appBean);
                    listView.setAdapter((ListAdapter)AppInfoDiscussView.this.adapter);
                }
                listView.stopRefresh();
                SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
                String time = sdf.format(new Date());
                listView.setRefreshTime(time);
                AppInfoDiscussView.this.asyncTaskPullDown = null;
            }
        };
        this.asyncTaskPullDown.execute((Object[])new Void[0]);
    }

    private void loadMoreData(final XListView listView, final JSONObject jsonParams) {
        if (!NetworkUtils.isOnline(mContext)) {
            Toast.makeText((Context)mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            listView.stopLoadMore();
            return;
        }
        if (this.asyncTaskPullUp != null) {
            return;
        }
        this.asyncTaskPullUp = new AsyncTask<Void, Void, ArrayList<AppBean>>(){

            protected ArrayList<AppBean> doInBackground(Void ... params) {
                String response = HttpURLConnectionUtils.downLoadAppList(HttpURLConnectionUtils.getUrlGetAppEvalute(), mContext, AppInfoDiscussView.this.mWgtData, jsonParams).getResult();
                ArrayList<AppBean> evaluteList = DataParserUtils.parseAppListWithKey("evaluteList", response);
                return evaluteList;
            }

            protected void onPostExecute(ArrayList<AppBean> result) {
                if (this.isCancelled()) {
                    AppInfoDiscussView.this.asyncTaskPullUp = null;
                    return;
                }
                if (result == null || result.size() == 0) {
                    listView.stopLoadMore();
                    Toast.makeText((Context)mContext, (CharSequence)"\u6ca1\u6709\u66f4\u591a\u8bc4\u8bba", (int)0).show();
                    AppInfoDiscussView.this.asyncTaskPullUp = null;
                    return;
                }
                int length = result.size() - 1;
                AppInfoDiscussView.this.indexIdDown = result.get(length).getIndexId();
                if (AppInfoDiscussView.this.adapter != null) {
                    AppInfoDiscussView.this.adapter.addList(result);
                } else {
                    AppInfoDiscussView.this.adapter = new AppDiscussListViewAdapter(mContext, AppInfoDiscussView.this.mEuExAppStoreMgr, result, AppInfoDiscussView.this.appBean);
                    listView.setAdapter((ListAdapter)AppInfoDiscussView.this.adapter);
                }
                listView.stopLoadMore();
                AppInfoDiscussView.this.asyncTaskPullUp = null;
            }
        };
        this.asyncTaskPullUp.execute((Object[])new Void[0]);
    }

    public void onClick(View v) {
        if (v == this.pinglun) {
            if (!AppStoreOptionVO.isShowAllViewsInWeb()) {
                this.mEuExAppStoreMgr.openSubmitAppEvaluate(this.appBean.getAppId());
            } else if (this.mEuExAppStoreMgr != null) {
                this.mEuExAppStoreMgr.onSubmitAppEvaluateClick(this.appBean);
            }
        }
    }

    public void refresh() {
        this.downloadAppEvalute(this.getAppEvaluteParams);
    }

    public static AppInfoDiscussView getInstance() {
        return mAppDiscussFragment;
    }

    class ListViewIXListViewListener
    implements XListView.IXListViewListener {
        XListView mListView;

        public ListViewIXListViewListener(XListView listView) {
            this.mListView = listView;
        }

        @Override
        public void onRefresh() {
            JSONObject jsonPull = AppInfoDiscussView.this.getAppEvaluteParams;
            try {
                jsonPull.put("action", (Object)"up");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            AppInfoDiscussView.this.refreshData(this.mListView, jsonPull);
        }

        @Override
        public void onLoadMore() {
            JSONObject jsonUp = AppInfoDiscussView.this.getAppEvaluteParams;
            try {
                jsonUp.put("action", (Object)"down");
                jsonUp.put("indexId", (Object)AppInfoDiscussView.this.indexIdDown);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            AppInfoDiscussView.this.loadMoreData(this.mListView, jsonUp);
        }
    }
}

