/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RatingBar;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ConstantUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStoreOptionVO;

public class AppDiscussListViewAdapter
extends BaseAdapter
implements ConstantUtils {
    private Context mContext;
    private LayoutInflater mInflater;
    private AppBean myAppBean;
    private LinkedList<AppBean> discussList = new LinkedList();
    private AppBean appBean;
    private EUExAppStoreMgr mEuExAppStoreMgr;

    public AppDiscussListViewAdapter(Context con, EUExAppStoreMgr mEuExAppStoreMgr, List<AppBean> result, AppBean app) {
        this.mContext = con;
        this.mEuExAppStoreMgr = mEuExAppStoreMgr;
        if (result != null && result.size() > 0) {
            for (AppBean appBean : result) {
                this.discussList.add(appBean);
            }
        }
        if (app != null) {
            this.appBean = app;
        }
        this.mInflater = LayoutInflater.from((Context)this.mContext);
        this.notifyDataSetChanged();
    }

    public void addList(List<AppBean> rankings) {
        if (rankings == null) {
            return;
        }
        for (AppBean ranking : rankings) {
            this.discussList.addLast(ranking);
        }
        this.notifyDataSetChanged();
    }

    public void reload(ArrayList<AppBean> result) {
        this.discussList.clear();
        if (result != null) {
            for (AppBean ranking : result) {
                this.discussList.addFirst(ranking);
            }
        }
        this.notifyDataSetChanged();
    }

    public void resumeLoad(ArrayList<AppBean> result) {
        if (result == null) {
            return;
        }
        this.discussList.clear();
        if (result != null) {
            for (AppBean ranking : result) {
                this.discussList.add(ranking);
            }
        }
        this.notifyDataSetChanged();
    }

    public int getCount() {
        if (this.discussList == null) {
            return 0;
        }
        return 1 + this.discussList.size();
    }

    public Object getItem(int position) {
        ArrayList<AppBean> rankings = new ArrayList<AppBean>();
        if (position < this.discussList.size() + 1 && position > 0) {
            rankings.add(this.discussList.get(position - 1));
        }
        return rankings;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (position == 0) {
            convertView = this.mInflater.inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_app_details_discuss_listview_header"), null);
            convertView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (!AppStoreOptionVO.isShowAllViewsInWeb()) {
                        AppDiscussListViewAdapter.this.mEuExAppStoreMgr.openSubmitAppEvaluate(AppDiscussListViewAdapter.this.appBean.getAppId());
                    } else if (AppDiscussListViewAdapter.this.mEuExAppStoreMgr != null) {
                        AppDiscussListViewAdapter.this.mEuExAppStoreMgr.onSubmitAppEvaluateClick(AppDiscussListViewAdapter.this.appBean);
                    }
                }
            });
        } else {
            ListViewHolder holder = null;
            if (convertView == null) {
                holder = new ListViewHolder();
                convertView = this.mInflater.inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_app_details_discuss_listview_item"), null);
                holder.userName = (TextView)convertView.findViewById(EUExUtil.getResIdID((String)"userName"));
                holder.ratingTime = (TextView)convertView.findViewById(EUExUtil.getResIdID((String)"ratingTime"));
                holder.discussContent = (TextView)convertView.findViewById(EUExUtil.getResIdID((String)"discussContent"));
                holder.userScore = (RatingBar)convertView.findViewById(EUExUtil.getResIdID((String)"userScore"));
                convertView.setTag((Object)holder);
            } else {
                holder = (ListViewHolder)convertView.getTag();
            }
            if (holder == null) {
                holder = new ListViewHolder();
                convertView = this.mInflater.inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_app_details_discuss_listview_item"), null);
                holder.userName = (TextView)convertView.findViewById(EUExUtil.getResIdID((String)"userName"));
                holder.ratingTime = (TextView)convertView.findViewById(EUExUtil.getResIdID((String)"ratingTime"));
                holder.discussContent = (TextView)convertView.findViewById(EUExUtil.getResIdID((String)"discussContent"));
                holder.userScore = (RatingBar)convertView.findViewById(EUExUtil.getResIdID((String)"userScore"));
                convertView.setTag((Object)holder);
            }
            if (position > 0 && holder != null) {
                this.myAppBean = this.discussList.get(position - 1);
                holder.userName.setText((CharSequence)this.myAppBean.getAppEvaluteCreator());
                holder.ratingTime.setText((CharSequence)this.myAppBean.getAppEvaluteCreateTime());
                holder.discussContent.setText((CharSequence)this.myAppBean.getAppEvaluteInfo());
                holder.userScore.setRating(Float.parseFloat(this.myAppBean.getStartLevel()));
            }
        }
        return convertView;
    }

    private class ListViewHolder {
        public TextView userName;
        public TextView ratingTime;
        public TextView discussContent;
        public RatingBar userScore;

        private ListViewHolder() {
        }
    }
}

