/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.FilterAdapter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppListViewBaseActivity;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppStoreMainView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.adapter.AppListViewAdapter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.DataParserUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.HttpURLConnectionUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreTokenUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ConstantUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.DialogView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.UserInfoVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class AppSearchActivity
extends AppListViewBaseActivity
implements TextView.OnEditorActionListener,
View.OnFocusChangeListener,
TextWatcher,
View.OnClickListener,
ConstantUtils {
    public static final String TAG = "AppSearchActivity";
    private TextView category;
    private TextView cancel;
    private ImageView imageCategory;
    private Context mContext;
    private EditText editText;
    private TextView delete;
    private TextView gray;
    private String type = null;
    private ListView listView;
    private AppListViewAdapter adapter;
    private RelativeLayout categoryList;
    private GridView categoryGrid;
    private FilterAdapter ada;
    public static final String MAIN_PREFS = "main_prefs";
    public static final String SEARCH_RESULT_PREFS = "search_result_prefs";
    private WWidgetData mWgtData;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_app_search"));
        try {
            this.mWgtData = (WWidgetData)this.getIntent().getParcelableExtra("currentWidgetData");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        View titleLayout = this.findViewById(EUExUtil.getResIdID((String)"search_input_layout"));
        if (AppStoreMainView.TITLE_HEIGHT > 0) {
            ViewGroup.LayoutParams lp = titleLayout.getLayoutParams();
            lp.height = AppStoreMainView.TITLE_HEIGHT;
            titleLayout.setLayoutParams(lp);
        }
        this.mContext = this;
        this.cancel = (TextView)this.findViewById(EUExUtil.getResIdID((String)"cancel"));
        this.imageCategory = (ImageView)this.findViewById(EUExUtil.getResIdID((String)"imageCategory"));
        this.categoryList = (RelativeLayout)this.findViewById(EUExUtil.getResIdID((String)"categoryList"));
        this.category = (TextView)this.findViewById(EUExUtil.getResIdID((String)"category"));
        this.editText = (EditText)this.findViewById(EUExUtil.getResIdID((String)"editText"));
        this.categoryGrid = (GridView)this.findViewById(EUExUtil.getResIdID((String)"categoryGrid"));
        this.delete = (TextView)this.findViewById(EUExUtil.getResIdID((String)"login_code_del_imageView"));
        this.gray = (TextView)this.findViewById(EUExUtil.getResIdID((String)"gray"));
        this.gray.setOnClickListener((View.OnClickListener)this);
        this.listView = (ListView)this.findViewById(EUExUtil.getResIdID((String)"listView"));
        this.editText.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.editText.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.editText.addTextChangedListener((TextWatcher)this);
        this.editText.setHint((CharSequence)"\u8bf7\u8f93\u5165\u5173\u952e\u8bcd");
        this.category.setTextSize(15.0f);
        this.editText.setTextSize(15.0f);
        this.cancel.setOnClickListener((View.OnClickListener)this);
        this.imageCategory.setOnClickListener((View.OnClickListener)this);
        this.delete.setOnClickListener((View.OnClickListener)this);
        this.editText.setFocusable(true);
        this.editText.setFocusableInTouchMode(true);
        this.editText.requestFocus();
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                InputMethodManager inputManager = (InputMethodManager)AppSearchActivity.this.editText.getContext().getSystemService("input_method");
                inputManager.showSoftInput((View)AppSearchActivity.this.editText, 0);
            }
        }, 800L);
        String resultCache = this.readSharePreferFile(String.valueOf(UserInfoVO.toSpKeyString()) + SEARCH_RESULT_PREFS);
        ArrayList<AppBean> appBeanCache = DataParserUtils.parseAppListWithKey("appList", resultCache);
        this.adapter = new AppListViewAdapter((Context)this, this.mWgtData, appBeanCache);
        this.listView.setAdapter((ListAdapter)this.adapter);
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (this.adapter != null && this.downloadStateRcv != null) {
            this.downloadStateRcv.updateAdapter(this.adapter);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }

    public void performAsyncLoadAppListAction() {
        if (!NetworkUtils.isOnline(this.mContext)) {
            return;
        }
        new AsyncTask<Object, Void, List<AppBean>>(){
            Dialog progressDialog = null;

            protected void onPreExecute() {
                this.progressDialog = DialogView.showLoadingDialog(AppSearchActivity.this.mContext, "\u52a0\u8f7d\u5206\u7c7b\u5217\u8868...");
                this.progressDialog.show();
            }

            protected List<AppBean> doInBackground(Object ... params) {
                String response = HttpURLConnectionUtils.downLoadCategoryList(AppSearchActivity.this.mContext, AppSearchActivity.this.mWgtData).getResult();
                ArrayList<AppBean> remainApps = DataParserUtils.parseAppListWithKey("appTypeList", response);
                return remainApps;
            }

            protected void onPostExecute(final List<AppBean> result) {
                if (this.isCancelled()) {
                    return;
                }
                if (this.progressDialog != null) {
                    this.progressDialog.dismiss();
                }
                if (result == null || result.size() == 0) {
                    Toast.makeText((Context)AppSearchActivity.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_data"), (int)0).show();
                    return;
                }
                ((Activity)AppSearchActivity.this.mContext).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AppSearchActivity.this.categoryList.setVisibility(0);
                        AppSearchActivity.this.ada = new FilterAdapter(AppSearchActivity.this.mContext, result);
                        AppSearchActivity.this.categoryGrid.setAdapter((ListAdapter)AppSearchActivity.this.ada);
                        AppSearchActivity.this.categoryGrid.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                            public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
                                AppSearchActivity.this.type = ((AppBean)result.get(arg2)).getAppName();
                                AppSearchActivity.this.categoryList.setVisibility(8);
                                AppSearchActivity.this.imageCategory.setImageResource(EUExUtil.getResDrawableID((String)"plugin_appstoremgr_app_category"));
                                AppSearchActivity.this.category.setText((CharSequence)AppSearchActivity.this.type);
                                try {
                                    AppSearchActivity.this.type = URLEncoder.encode(AppSearchActivity.this.type, "UTF-8");
                                }
                                catch (UnsupportedEncodingException e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }
                });
            }
        }.execute(new Object[0]);
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (actionId == 3 || actionId == 0) {
            if (this.editText.getText() == null || TextUtils.isEmpty((CharSequence)this.editText.getText().toString().trim())) {
                Toast.makeText((Context)this, (CharSequence)"\u8bf7\u8f93\u5165\u641c\u7d22\u6761\u4ef6\uff01", (int)0).show();
                return true;
            }
            this.searchResult(this.editText.getText().toString().trim());
            return true;
        }
        return false;
    }

    private void searchResult(String keyWords) {
        AppSearchActivity.hideSoftKeyboard((Context)this, this.editText);
        if (!NetworkUtils.isOnline(this.mContext)) {
            return;
        }
        String softToken = AppStoreTokenUtils.getSoftToken((Context)this);
        if (softToken == null || softToken.length() == 0) {
            Toast.makeText((Context)this, (CharSequence)"softToken\u4e3a\u7a7a!", (int)0).show();
            this.finish();
            return;
        }
        JSONObject paramsJson = new JSONObject();
        try {
            paramsJson.put("softToken", (Object)softToken);
            if (this.type != null) {
                paramsJson.put("appType", (Object)this.type);
            }
            paramsJson.put("keyWords", (Object)keyWords);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        new AsyncTask<Object, Void, List<AppBean>>(){
            Dialog progressDialog = null;

            protected void onPreExecute() {
                this.progressDialog = DialogView.showLoadingDialog(AppSearchActivity.this.mContext, "\u52a0\u8f7d\u5e94\u7528\u5217\u8868...");
                this.progressDialog.show();
            }

            protected List<AppBean> doInBackground(Object ... params) {
                String response = HttpURLConnectionUtils.downLoadAppList(HttpURLConnectionUtils.getUrlSearchList(), AppSearchActivity.this.mContext, AppSearchActivity.this.mWgtData, (JSONObject)params[0]).getResult();
                ArrayList<AppBean> remainApp = DataParserUtils.parseAppListWithKey("appList", response);
                AppSearchActivity.this.writeToSharePreferFile(String.valueOf(UserInfoVO.toSpKeyString()) + AppSearchActivity.SEARCH_RESULT_PREFS, response);
                return remainApp;
            }

            protected void onPostExecute(List<AppBean> result) {
                ArrayList<AppBean> resultAppBeansList = new ArrayList<AppBean>();
                if (result != null && result.size() > 0) {
                    for (AppBean appBean : result) {
                        resultAppBeansList.add(appBean);
                    }
                }
                if (this.isCancelled()) {
                    return;
                }
                if (this.progressDialog != null) {
                    this.progressDialog.dismiss();
                }
                if (result == null || result.size() == 0) {
                    Toast.makeText((Context)AppSearchActivity.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_data"), (int)0).show();
                    return;
                }
                if (AppSearchActivity.this.adapter == null) {
                    AppSearchActivity.this.adapter = new AppListViewAdapter((Context)AppSearchActivity.this, AppSearchActivity.this.mWgtData, resultAppBeansList);
                    AppSearchActivity.this.listView.setAdapter((ListAdapter)AppSearchActivity.this.adapter);
                    AppSearchActivity.this.downloadStateRcv.updateAdapter(AppSearchActivity.this.adapter);
                } else {
                    AppSearchActivity.this.adapter.reload(resultAppBeansList);
                }
            }
        }.execute(new Object[]{paramsJson});
    }

    public void afterTextChanged(Editable s) {
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.editText.getText().length() > 0) {
            this.delete.setVisibility(0);
            this.cancel.setText((CharSequence)"\u641c\u7d22");
        } else {
            this.delete.setVisibility(8);
            this.cancel.setText((CharSequence)"\u53d6\u6d88");
        }
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (hasFocus) {
            this.editText.setHint(null);
        } else {
            this.delete.setVisibility(8);
        }
    }

    @Override
    protected void onDestroy() {
        AppSearchActivity.hideSoftKeyboard((Context)this, this.editText);
        super.onDestroy();
    }

    protected void onPause() {
        AppSearchActivity.hideSoftKeyboard((Context)this, this.editText);
        super.onPause();
    }

    public void onClick(View v) {
        if (v == this.cancel) {
            if (this.cancel.getText().equals("\u641c\u7d22")) {
                this.searchResult(this.editText.getText().toString().trim());
            } else {
                this.finish();
            }
        } else if (v == this.imageCategory) {
            if (this.categoryList.getVisibility() == 8) {
                this.imageCategory.setImageResource(EUExUtil.getResDrawableID((String)"plugin_appstoremgr_app_category_up"));
                this.performAsyncLoadAppListAction();
            } else {
                this.imageCategory.setImageResource(EUExUtil.getResDrawableID((String)"plugin_appstoremgr_app_category"));
                this.categoryList.setVisibility(8);
            }
        } else if (v == this.delete) {
            this.editText.setText((CharSequence)"");
        } else if (v == this.gray) {
            this.categoryList.setVisibility(8);
            this.imageCategory.setImageResource(EUExUtil.getResDrawableID((String)"plugin_appstoremgr_app_category"));
            this.type = null;
            this.category.setText((CharSequence)"\u5168\u90e8\u7c7b\u522b");
        }
    }

    public static void hideSoftKeyboard(Context context, EditText editText) {
        editText.setText((CharSequence)"");
        editText.clearFocus();
        InputMethodManager manager = (InputMethodManager)context.getSystemService("input_method");
        manager.hideSoftInputFromWindow(editText.getWindowToken(), 0);
    }

    private void writeToSharePreferFile(String key, String result) {
        SharedPrefUtils.putString(this.mContext, MAIN_PREFS, key, result);
    }

    private String readSharePreferFile(String key) {
        return SharedPrefUtils.getString(this.mContext, MAIN_PREFS, key, "");
    }
}

