/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView.adapter.AppAdPagerAdapter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppListBaseView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.adapter.AppGridViewAdapter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppLocalDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppTaskList;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.ViewDataManager2;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.HttpURLConnectionUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ConstantUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ViewFrameConfig;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.ChildViewPager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.HeaderGridView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.PageIndicator;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStoreOptionVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class AppStoreMainView
extends AppListBaseView
implements ViewDataManager2.AppStoreDataCallback,
ConstantUtils {
    protected static final long AD_SLIDE_DELAY_TIME = 10000L;
    public static int TITLE_HEIGHT = 0;
    public static int AD_HEIGHT = 0;
    public static int PAGER_TOP = 10;
    public static int ROWS = 3;
    public static int DEFAULT_ITEM_HEIGHT = 130;
    public static final int ACTION_ADD_APP_CODE = 0;
    public static final int GRID_ITEMS_PER_PAGER = 8;
    public static final List<AppBean> APP_PAUSE_LIST = new ArrayList<AppBean>();
    public static final HashMap<String, AppBean> APP_DOWNLOAD_LIST = new HashMap();
    private static AppStoreMainView mAppStoreMainView = null;
    private AsyncTask<Void, Integer, Void> showAdTask = null;
    private HeaderGridView mMyAppListGridView;
    private Button mDelAppBtn;
    private TextView mEnterMCMTextView;
    private LinearLayout mMCMTitleLayout;
    private View mAdViewPagerLayout;
    private ChildViewPager mAdViewPager;
    private PageIndicator mAdPageIndicator;
    private int currentPageState = 0;
    private AppAdPagerAdapter adPagerAdapter;
    private AppGridViewAdapter appsListAdapter;
    private LayoutInflater mInflater;
    private View.OnClickListener mMCMOnClickListener;
    public static String IS_VISIBLE = "";
    public static final String TAG = "AppStoreMainView";
    public static final String INTENT_KEY_URL = "url";
    public static float density = 1.0f;
    private ViewFrameConfig mViewFrameConfig = new ViewFrameConfig();
    private int mainViewHeight;
    private static EUExAppStoreMgr mAppStoreMgr;
    private WWidgetData mWgtData;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (AppStoreMainView.this.mAdViewPager == null) {
                        return;
                    }
                    if (AppStoreMainView.this.currentPageState == 0 && AppStoreMainView.this.mAdViewPager.getAdapter() != null) {
                        int current = AppStoreMainView.this.mAdViewPager.getCurrentItem();
                        AppStoreMainView.this.mAdViewPager.setCurrentItem(current + 1, true);
                    }
                    if (AppStoreMainView.this.adPagerAdapter.getActualCount() == 1) break;
                    AppStoreMainView.this.handler.sendEmptyMessageDelayed(1, 10000L);
                }
            }
        }
    };

    public AppStoreMainView(Context context, EUExAppStoreMgr appStoreMgr, WWidgetData mWidgetData, ViewFrameConfig config, int viewHight, float htmlScale) {
        super(context);
        mAppStoreMainView = this;
        mAppStoreMgr = appStoreMgr;
        this.mInflater = LayoutInflater.from((Context)this.mContext);
        EUExUtil.init((Context)this.mContext);
        DisplayMetrics dm = new DisplayMetrics();
        dm = this.mContext.getApplicationContext().getResources().getDisplayMetrics();
        density = dm.density;
        this.mainViewHeight = viewHight;
        this.mViewFrameConfig = config;
        this.mWgtData = mWidgetData;
        this.init(htmlScale);
    }

    private boolean isShowMCMDocument() {
        boolean isMCMExist = AppStoreUtils.isMCMExist();
        boolean optionShowMCM = AppStoreOptionVO.isShowMCMDocument();
        return optionShowMCM ? isMCMExist : false;
    }

    @Override
    public void refreshLocalData() {
        this.refreshLocalAppData();
    }

    private void init(float scale) {
        this.setupNewUI();
        new ViewDataManager2(this.mContext, this.mWgtData, mAppStoreMgr, this);
        ViewDataManager2.performAsyncLoadMyAppListDataAction(this.mContext, this.mWgtData, HttpURLConnectionUtils.getUrlInstallAppList(), this, this.isShowMCMDocument(), AppStoreOptionVO.isShowAdView(), false);
        if (scale == 0.0f) {
            final View contextView = ((Activity)this.mContext).getWindow().getDecorView();
            ViewTreeObserver vto = contextView.getViewTreeObserver();
            vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    int height = contextView.getMeasuredHeight();
                    int width = contextView.getMeasuredWidth();
                    Log.i((String)AppStoreMainView.TAG, (String)("onGlobalLayoutheight==" + height + " width==" + width));
                    TITLE_HEIGHT = AppStoreMainView.this.mainViewHeight - height;
                    LogUtils.logDebug(true, "mainActivityHeight:" + AppStoreMainView.this.mainViewHeight + " height:" + height);
                    contextView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            });
        } else {
            TITLE_HEIGHT = (int)(this.mViewFrameConfig.y * scale);
            System.out.println("TITLE_HEIGHT:" + TITLE_HEIGHT + " scale:" + scale);
        }
    }

    private void setupNewUI() {
        View mainView = this.mInflater.inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_myapp_main_layout"), (ViewGroup)this, true);
        this.mMCMOnClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (v == AppStoreMainView.this.mEnterMCMTextView) {
                    mAppStoreMgr.cbStartMCM("");
                } else {
                    Object obj = v.getTag();
                    if (obj != null && obj instanceof AppBean) {
                        AppBean appBean = (AppBean)obj;
                        mAppStoreMgr.cbStartMCM(appBean.getMcmDocumentTitleJsonData());
                    }
                }
            }
        };
        this.mMyAppListGridView = (HeaderGridView)mainView.findViewById(EUExUtil.getResIdID((String)"myapp_headergridview"));
        this.mDelAppBtn = (Button)mainView.findViewById(EUExUtil.getResIdID((String)"plugin_appstoremgr_del_app_ok_button"));
        this.mAdViewPagerLayout = this.mInflater.inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_adv_viewpager_layout"), null);
        this.mAdViewPager = (ChildViewPager)this.mAdViewPagerLayout.findViewById(EUExUtil.getResIdID((String)"ad_viewpager"));
        this.mAdViewPager.setBackgroundColor(-1);
        this.mAdPageIndicator = (PageIndicator)this.mAdViewPagerLayout.findViewById(EUExUtil.getResIdID((String)"ad_page_indictor"));
        this.mAdViewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrollStateChanged(int state) {
                AppStoreMainView.this.currentPageState = state;
            }

            public void onPageScrolled(int arg0, float arg1, int arg2) {
            }

            public void onPageSelected(int index) {
                AppStoreMainView.this.currentPageState = 0;
                int pageCount = AppStoreMainView.this.adPagerAdapter.getActualCount();
                if (pageCount != 0) {
                    int nowIndex = index % pageCount;
                    AppStoreMainView.this.mAdPageIndicator.setCurrentPage(nowIndex);
                    AppStoreMainView.this.mAdViewPager.setmIndex(nowIndex);
                }
            }
        });
        this.mAdViewPager.setOnSingleTouchListener(new ChildViewPager.OnSingleTouchListener(){

            @Override
            public void onSingleTouch(int position) {
                ((AppAdPagerAdapter)AppStoreMainView.this.mAdViewPager.getAdapter()).onADPageClick(position, mAppStoreMgr);
            }
        });
        if (!AppStoreOptionVO.isShowAdView()) {
            this.mAdViewPagerLayout.setVisibility(8);
            this.mAdViewPager.setVisibility(8);
            this.mAdPageIndicator.setVisibility(8);
        }
        this.mMyAppListGridView.addHeaderView(this.mAdViewPagerLayout);
        this.mEnterMCMTextView = new TextView(this.mContext);
        this.mEnterMCMTextView.setGravity(5);
        this.mEnterMCMTextView.setTextColor(this.getResources().getColorStateList(EUExUtil.getResColorID((String)"plugin_appstoremgr_mcmtitle_item_text_color_selector")));
        this.mEnterMCMTextView.setClickable(true);
        this.mEnterMCMTextView.setText((CharSequence)"\u70b9\u51fb\u8fdb\u5165\u6587\u6863\u4e2d\u5fc3>>   ");
        this.mEnterMCMTextView.setOnClickListener(this.mMCMOnClickListener);
        this.mMyAppListGridView.addHeaderView((View)this.mEnterMCMTextView);
        this.mMCMTitleLayout = new LinearLayout(this.mContext);
        this.mMCMTitleLayout.setOrientation(1);
        this.mMyAppListGridView.addHeaderView((View)this.mMCMTitleLayout);
        if (!this.isShowMCMDocument()) {
            this.mEnterMCMTextView.setVisibility(8);
            this.mMCMTitleLayout.setVisibility(8);
        }
    }

    private void refreshAllData(ViewDataManager2.AppStoreData data, boolean isNetworkData) {
        if (data == null) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_data"), (int)0).show();
            this.refreshMyAppData(null, isNetworkData);
            this.handler.removeMessages(1);
            return;
        }
        if (AppStoreOptionVO.isShowAdView()) {
            this.refreshAdData(data.adList);
        }
        if (this.isShowMCMDocument()) {
            this.refreshMCMData(data.mcmTitleList);
        }
        this.refreshMyAppData(data.appList, isNetworkData);
    }

    private void refreshAdData(List<AppBean> adList) {
        if (adList == null || adList.size() <= 0) {
            this.handler.removeMessages(1);
            this.mAdViewPagerLayout.setVisibility(8);
            LogUtils.i(TAG, "refreshAdData: AD list is not exist");
            return;
        }
        this.mAdViewPagerLayout.setVisibility(0);
        List<AppBean> brandADs = adList;
        int adPageSize = brandADs.size();
        if (this.adPagerAdapter == null) {
            this.adPagerAdapter = new AppAdPagerAdapter(this.mContext, brandADs, this.mAdViewPager);
            this.mAdViewPager.setAdapter(this.adPagerAdapter);
        } else {
            this.adPagerAdapter.refreshAdData(brandADs);
        }
        this.mAdPageIndicator.setTotalPageSize(adPageSize);
        int maxSize = 65535;
        int pos = maxSize / 2 - maxSize / 2 % adPageSize;
        this.mAdViewPager.setCurrentItem(pos, true);
        this.handler.sendEmptyMessage(1);
    }

    private void refreshMCMData(List<AppBean> mcmTitleList) {
        if (mcmTitleList == null || mcmTitleList.size() == 0) {
            this.mMCMTitleLayout.setVisibility(8);
            LogUtils.i(TAG, "mcmTitleList is empty");
            return;
        }
        this.mMCMTitleLayout.setVisibility(0);
        this.mMCMTitleLayout.removeAllViews();
        int i = 0;
        while (i < mcmTitleList.size()) {
            AppBean appBean = mcmTitleList.get(i);
            TextView mcmTitleItem = (TextView)View.inflate((Context)this.mContext, (int)EUExUtil.getResLayoutID((String)"plugin_appstoremgr_mcmtitle_item"), null);
            mcmTitleItem.setText((CharSequence)appBean.getMcmDocumentTitle());
            mcmTitleItem.setTextSize(16.0f);
            mcmTitleItem.setSingleLine(true);
            mcmTitleItem.setTag((Object)appBean);
            mcmTitleItem.setEms(13);
            mcmTitleItem.setEllipsize(TextUtils.TruncateAt.END);
            mcmTitleItem.setOnClickListener(this.mMCMOnClickListener);
            this.mMCMTitleLayout.addView((View)mcmTitleItem);
            ++i;
        }
    }

    private void refreshMyAppData(List<AppBean> resultAppList, boolean isNetworkData) {
        try {
            List<AppBean> localApps = new AppBeanDao(this.mContext).getAppBeanList();
            List<AppBean> appList = AppLocalDataManager.refrshAppData(this.mContext, resultAppList, localApps, isNetworkData);
            if (this.appsListAdapter == null) {
                this.appsListAdapter = new AppGridViewAdapter(this.mContext, appList, this.mMyAppListGridView, this.mWgtData, this);
                this.mMyAppListGridView.setAdapter((ListAdapter)this.appsListAdapter);
                if (this.downloadStateRcv != null) {
                    this.downloadStateRcv.updateAdapter(this.appsListAdapter);
                }
            } else {
                this.appsListAdapter.refresh(appList);
            }
        }
        catch (Exception e) {
            LogUtils.oe("refreshMyAppData", e);
            e.printStackTrace();
        }
    }

    public void refreshLocalAppData() {
        List<AppBean> apps = new AppBeanDao(this.mContext).getAppBeanList();
        this.refreshMyAppData(apps, false);
    }

    public void setVisible(String isVisible) {
    }

    @Override
    public void callBackAllRes(final ViewDataManager2.AppStoreData result) {
        ((Activity)this.mContext).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (result == null) {
                    AppStoreMainView.this.refreshAllData(null, false);
                    return;
                }
                if (AppStoreOptionVO.isShowAdView()) {
                    AppStoreMainView.this.refreshAdData(result.adList);
                }
                if (AppStoreMainView.this.isShowMCMDocument()) {
                    AppStoreMainView.this.refreshMCMData(result.mcmTitleList);
                }
                AppStoreMainView.this.refreshMyAppData(result.appList, true);
                mAppStoreMgr.cbOpenHomePage();
            }
        });
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                AppTaskList appsTaskList = ViewDataManager2.getAppTaskList();
                if (appsTaskList != null && !appsTaskList.isEmpty()) {
                    LogUtils.i(TAG, "onBackKeyDown with AppTaskList isn't null");
                    return true;
                }
                LogUtils.i(TAG, "onBackKeyDown");
                return false;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                return false;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    @Override
    public void onResume() {
        this.currentPageState = 0;
        if (this.downloadStateRcv != null) {
            this.downloadStateRcv.updateAdapter(this.appsListAdapter);
        }
        if (this.appsListAdapter != null) {
            this.appsListAdapter.notifyDataSetChanged();
        }
    }

    public static AppStoreMainView getInstance() {
        return mAppStoreMainView;
    }

    @Override
    protected void onDetachedFromWindow() {
        LogUtils.logDebug(true, "onDetachedFromWindow");
        if (this.showAdTask != null) {
            this.showAdTask.cancel(true);
            this.showAdTask = null;
        }
        super.onDetachedFromWindow();
    }

    public Button getDeltetAppOkButton() {
        return this.mDelAppBtn;
    }

    public void adClick(String url) {
        mAppStoreMgr.adPicClick(url);
    }

    public EUExAppStoreMgr getEUExAppStoreMgrInstance() {
        return mAppStoreMgr;
    }

    public HeaderGridView getMyAppListGridView() {
        return this.mMyAppListGridView;
    }

    public static boolean isDownloadRunning(String appId) {
        return APP_DOWNLOAD_LIST.containsKey(appId);
    }
}

