/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zywx.wbpalmstar.base.ResoureFinder;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppStoreMainView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDownLoadDb;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDownTask;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppLocalDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppTaskList;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.ViewDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.ViewDataManager2;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.imageloader.ImageLoaderManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ConstantUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.Arcs;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.HeaderGridView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStoreOptionVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class AppGridViewAdapter
extends BaseAdapter
implements ConstantUtils {
    public static final String TAG = "AppsListAdapter";
    private List<AppBean> list = new ArrayList<AppBean>();
    public LayoutInflater inflater;
    private Drawable grayCover;
    private Drawable defaultItemBg;
    private ResoureFinder finder;
    private Map<String, View> ViewMap = new HashMap<String, View>();
    private HeaderGridView mGridView = null;
    private boolean isShowDeleteView = false;
    public int mChildsInParent;
    private Context mContext;
    private AppStoreMainView mAppStoreMainView;
    private AppTaskList mAppTaskList;
    private boolean containNewApp;
    private ViewDataManager2 viewDataManager;
    private ImageLoaderManager loaderManager;
    private WWidgetData mWgtData;

    private void setAppList(List<AppBean> beans) {
        this.list.clear();
        if (AppStoreOptionVO.isShowAddBtn()) {
            if (AppStoreOptionVO.isShowAddBtnFirst()) {
                this.list.add(new AppBean());
                if (beans != null && beans.size() > 0) {
                    this.list.addAll(beans);
                }
            } else {
                if (beans != null && beans.size() > 0) {
                    this.list.addAll(beans);
                }
                this.list.add(new AppBean());
            }
        } else if (beans != null && beans.size() > 0) {
            this.list.addAll(beans);
        }
    }

    public AppGridViewAdapter(Context context, List<AppBean> beans, HeaderGridView gridView, WWidgetData mWData, AppStoreMainView mainView) {
        this.mWgtData = mWData;
        this.mContext = context;
        this.inflater = LayoutInflater.from((Context)context);
        this.finder = ResoureFinder.getInstance((Context)context);
        this.grayCover = this.finder.getDrawable("platform_myspace_grid_item_cover");
        this.defaultItemBg = this.finder.getDrawable("plugin_appstoremgr_icon_bg");
        this.loaderManager = ImageLoaderManager.initImageLoaderManager(this.mContext);
        this.mGridView = gridView;
        this.setAppList(beans);
        this.mAppStoreMainView = mainView;
        this.mAppTaskList = ViewDataManager2.getAppTaskList();
        this.mAppStoreMainView.getDeltetAppOkButton().setOnClickListener((View.OnClickListener)new CompleteClick());
        this.containNewApp = AppUtils.checkNewApp(this.mContext);
        this.viewDataManager = ViewDataManager2.getInstance();
    }

    public void refresh(List<AppBean> beans) {
        this.setAppList(beans);
        this.mAppTaskList = ViewDataManager2.getAppTaskList();
        this.mAppStoreMainView.getDeltetAppOkButton().setOnClickListener((View.OnClickListener)new CompleteClick());
        this.containNewApp = AppUtils.checkNewApp(this.mContext);
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.list.size();
    }

    public AppBean getItem(int position) {
        return this.list.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public void removeItemAtPostion(int postion) {
        if (postion < 0 || postion > this.getCount() - 1) {
            return;
        }
        this.list.remove(postion);
        this.notifyDataSetChanged();
    }

    public int indexOfBindView(View view) {
        return this.list.indexOf(view);
    }

    public View getBindViewByAppId(String appId) {
        if (appId == null) {
            return null;
        }
        return this.ViewMap.get(appId);
    }

    private boolean isAddAppIcon(int position) {
        boolean isAdd = false;
        if (AppStoreOptionVO.isShowAddBtn()) {
            isAdd = AppStoreOptionVO.isShowAddBtnFirst() ? position == 0 : this.list.size() - 1 == position;
        }
        return isAdd;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;
        AppBean appBean = this.getItem(position);
        if (convertView == null) {
            holder = new ViewHolder();
            convertView = this.inflater.inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_grid_item"), null);
            holder.ivIcon = (ImageView)convertView.findViewById(EUExUtil.getResIdID((String)"plugin_appstoremgr_app_icon"));
            holder.tvLabel = (TextView)convertView.findViewById(EUExUtil.getResIdID((String)"plugin_appstoremgr_app_name"));
            holder.rbPercent = (Arcs)convertView.findViewById(EUExUtil.getResIdID((String)"plugin_appstoremgr_app_download_indicator"));
            holder.delIcon = (ImageView)convertView.findViewById(EUExUtil.getResIdID((String)"plugin_appstoremgr_del_app_icon"));
            holder.newAppIcon = (ImageView)convertView.findViewById(EUExUtil.getResIdID((String)"plugin_appstoremgr_new_app_icon"));
            holder.pushIcon = (TextView)convertView.findViewById(EUExUtil.getResIdID((String)"plugin_appstoremgr_push_icon"));
            holder.updateIcon = (ImageView)convertView.findViewById(EUExUtil.getResIdID((String)"plugin_appstoremgr_app_update_icon"));
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        convertView.setOnClickListener((View.OnClickListener)new GrideItemClickListener(this.list, holder.delIcon, position));
        convertView.setOnLongClickListener((View.OnLongClickListener)new OnLongClick(position));
        if (this.isAddAppIcon(position)) {
            holder.ivIcon.setBackgroundDrawable(this.finder.getDrawable("plugin_appstoremgr_add_app"));
            holder.ivIcon.setImageDrawable(null);
            holder.tvLabel.setText((CharSequence)"\u6dfb\u52a0\u5e94\u7528");
            holder.delIcon.setVisibility(8);
            holder.pushIcon.setVisibility(4);
            holder.updateIcon.setVisibility(4);
            holder.newAppIcon.setVisibility(this.containNewApp ? 0 : 8);
            holder.rbPercent.setVisibility(8);
        } else {
            AppBean app = new AppBeanDao(this.mContext).getAppBean(appBean.getAppId());
            if (app != null) {
                if (app.getNewApp() == 2 && app.getState() == 4) {
                    holder.updateIcon.setVisibility(0);
                } else {
                    holder.updateIcon.setVisibility(4);
                }
            }
            holder.delIcon.setVisibility(this.isShowDeleteView ? 0 : 8);
            if (holder.newAppIcon.getVisibility() == 0) {
                holder.newAppIcon.setVisibility(8);
            }
            if (appBean.getState() == 4 && AppUtils.isAppInstalled(this.mContext, appBean) || appBean.getType() == 1) {
                holder.ivIcon.setImageDrawable(null);
            } else {
                holder.ivIcon.setImageDrawable(this.grayCover);
            }
            int progress = AppLocalDataManager.getProgress(this.mContext, appBean.getAppId());
            if (ViewDataManager.downloadTaskRun(appBean)) {
                if (progress < 100) {
                    holder.rbPercent.setVisibility(0);
                    holder.rbPercent.setProgress(AppLocalDataManager.getProgress(this.mContext, appBean.getAppId()));
                    if (holder.rbPercent.getPause()) {
                        holder.rbPercent.setPause(false);
                    }
                }
            } else {
                int index = AppStoreMainView.APP_PAUSE_LIST.indexOf(appBean);
                if (index > -1 && progress < 100) {
                    holder.rbPercent.setVisibility(0);
                    holder.rbPercent.setPause(true);
                } else {
                    if (!AppUtils.isAppInstalled(this.mContext, appBean)) {
                        AppLocalDataManager.removeProgress(this.mContext, appBean.getAppId());
                    }
                    if (appBean.getNewApp() == 2) {
                        new AppBeanDao(this.mContext).updateAppState(appBean.getAppId(), 4, appBean.getInstallPath());
                        this.notifyDataSetChanged();
                    }
                    holder.rbPercent.setVisibility(8);
                    holder.rbPercent.setPause(false);
                }
            }
            String iconLoc = appBean.getIconLoc();
            NetworkUtils.asyncLoadImage(this.mContext, holder.ivIcon, iconLoc, this.defaultItemBg, this.loaderManager);
            this.ViewMap.put(appBean.getAppId(), convertView);
            holder.tvLabel.setText((CharSequence)appBean.getAppName());
            holder.delIcon.setOnClickListener((View.OnClickListener)new DeleteClick(appBean, holder.ivIcon));
        }
        return convertView;
    }

    private void chengeViewStatus(boolean isShowDel) {
        if (this.mGridView != null) {
            this.isShowDeleteView = isShowDel;
            this.mAppStoreMainView.getDeltetAppOkButton().setVisibility(isShowDel ? 0 : 8);
            this.notifyDataSetChanged();
        }
    }

    public List<AppBean> getData() {
        return this.list;
    }

    class CompleteClick
    implements View.OnClickListener {
        CompleteClick() {
        }

        public void onClick(View v) {
            AppGridViewAdapter.this.chengeViewStatus(false);
        }
    }

    class DeleteClick
    implements View.OnClickListener {
        AppBean appBean;
        View convertView;
        int position;
        ImageView appIcon;

        public DeleteClick(AppBean bean, ImageView image) {
            this.appBean = bean;
            this.appIcon = image;
        }

        public void onClick(View v) {
            int i = 0;
            int size = AppGridViewAdapter.this.mAppTaskList.size();
            while (i < size) {
                AppDownTask task = AppGridViewAdapter.this.mAppTaskList.getTask(i);
                if (task != null && this.appBean.getAppId().equals(task.getTaskId())) {
                    AppGridViewAdapter.this.mAppTaskList.getTask(i).cancel(true);
                }
                ++i;
            }
            String appId = this.appBean.getAppId();
            AppBean app = new AppBeanDao(AppGridViewAdapter.this.mContext).getAppBean(appId);
            if (app == null) {
                Log.i((String)AppGridViewAdapter.TAG, (String)(String.valueOf(appId) + "\u5e94\u7528\u5df2\u7ecf\u4e0d\u5b58\u5728"));
                return;
            }
            AppUtils.deleteApp(AppGridViewAdapter.this.mContext, AppGridViewAdapter.this.mWgtData, this.appBean);
            if (!AppUtils.isNativeApp(this.appBean.getType())) {
                AppGridViewAdapter.this.list.remove(this.appBean);
                AppGridViewAdapter.this.notifyDataSetChanged();
            }
        }
    }

    class GrideItemClickListener
    implements View.OnClickListener {
        private List<AppBean> appBeans;
        private ImageView deleteView;
        private int position;

        public GrideItemClickListener(List<AppBean> beans, ImageView deleteView, int pos) {
            this.appBeans = beans;
            this.deleteView = deleteView;
            this.position = pos;
        }

        public void onClick(View view) {
            try {
                if (this.deleteView != null && this.deleteView.getVisibility() == 0) {
                    return;
                }
                LogUtils.logDebug(true, "GrideItemClickListener App Name: " + this.appBeans.get(this.position).getAppName());
                if (AppGridViewAdapter.this.isAddAppIcon(this.position)) {
                    if (!AppGridViewAdapter.this.isShowDeleteView) {
                        AppGridViewAdapter.this.mAppStoreMainView.getEUExAppStoreMgrInstance().enterAppStore(new String[0]);
                    }
                } else {
                    AppTaskList appsTaskList = ViewDataManager2.getAppTaskList();
                    AppBean appBean = this.appBeans.get(this.position);
                    String appId = appBean.getAppId();
                    if (appBean != null) {
                        switch (appBean.getType()) {
                            case 1: {
                                AppGridViewAdapter.this.viewDataManager.onWebAppClicked(AppGridViewAdapter.this.mContext, AppGridViewAdapter.this.mWgtData, appBean);
                                break;
                            }
                            case 2: 
                            case 4: {
                                AppBean app1 = new AppBeanDao(AppGridViewAdapter.this.mContext).getAppBean(appId);
                                int state = 0;
                                if (app1 != null) {
                                    state = app1.getState();
                                }
                                if (AppUtils.isNativeAppInstalled(AppGridViewAdapter.this.mContext, appBean.getPackageName())) {
                                    if (4 == state) {
                                        AppUtils.openApp(AppGridViewAdapter.this.mContext, appBean, AppStoreUtils.getOpenSubAppInfo(AppGridViewAdapter.this.mContext, appId), true);
                                        break;
                                    }
                                    AppUtils.changeAppStateToInstall(AppGridViewAdapter.this.mContext, AppGridViewAdapter.this.mWgtData, appBean);
                                    AppGridViewAdapter.this.notifyDataSetChanged();
                                    break;
                                }
                                if (appsTaskList.isExistTask(appId, AppGridViewAdapter.this.mContext)) {
                                    return;
                                }
                                String[] result = AppDownLoadDb.getFilePathFromDownload(AppGridViewAdapter.this.mContext, appBean.getDownloadUrl());
                                if (result != null) {
                                    String path = result[0];
                                    String size = result[1];
                                    if (!TextUtils.isEmpty((CharSequence)path) && !TextUtils.isEmpty((CharSequence)size)) {
                                        int fileSize = Integer.parseInt(size);
                                        File file = new File(path);
                                        if (file.exists() && file.length() == (long)fileSize) {
                                            AppUtils.installApp(AppGridViewAdapter.this.mContext, file);
                                            AppLocalDataManager.saveApkPath(AppGridViewAdapter.this.mContext, appBean.getAppId(), file.getAbsolutePath());
                                            AppLocalDataManager.removeProgress(AppGridViewAdapter.this.mContext, appBean.getAppId());
                                            return;
                                        }
                                    }
                                }
                                AppGridViewAdapter.this.viewDataManager.launch(AppGridViewAdapter.this.mContext, appBean, 0);
                                break;
                            }
                            case 3: {
                                if ((1 == appBean.getState() || 4 == appBean.getState()) && AppUtils.isWidgetInstalled(appBean.getAppId())) {
                                    String[] updateInfo = new AppBeanDao(AppGridViewAdapter.this.mContext).getUpdate(appBean.getAppId());
                                    if (updateInfo != null) {
                                        String filePath = updateInfo[0];
                                        String appVer = updateInfo[1];
                                        if (!TextUtils.isEmpty((CharSequence)filePath) && filePath.endsWith(".zip") && !TextUtils.isEmpty((CharSequence)appVer)) {
                                            if (new File(filePath).exists()) {
                                                AppBean bean = appBean;
                                                bean.setCurVersion(appVer);
                                                AppGridViewAdapter.this.viewDataManager.unzip(AppGridViewAdapter.this.mContext, bean, filePath, 1);
                                                return;
                                            }
                                            new AppBeanDao(AppGridViewAdapter.this.mContext).deleteUpdate(appBean.getAppId());
                                        }
                                    }
                                    AppGridViewAdapter.this.notifyDataSetChanged();
                                    AppGridViewAdapter.this.viewDataManager.launch(AppGridViewAdapter.this.mContext, appBean, 1);
                                    break;
                                }
                                LogUtils.logDebug(true, "\u5c1a\u672a\u4e0b\u8f7d\uff0c\u5f00\u59cb\u4e0b\u8f7d");
                                if (appsTaskList.isExistTask(appId, AppGridViewAdapter.this.mContext)) {
                                    return;
                                }
                                String[] result = AppDownLoadDb.getFilePathFromDownload(AppGridViewAdapter.this.mContext, appBean.getDownloadUrl());
                                if (result != null) {
                                    String path = result[0];
                                    String size = result[1];
                                    if (!TextUtils.isEmpty((CharSequence)path) && !TextUtils.isEmpty((CharSequence)size)) {
                                        int fileSize = Integer.parseInt(size);
                                        File file = new File(path);
                                        if (file.exists() && file.length() == (long)fileSize) {
                                            AppGridViewAdapter.this.viewDataManager.unzip(AppGridViewAdapter.this.mContext, appBean, path, 0);
                                            return;
                                        }
                                    }
                                }
                                AppGridViewAdapter.this.viewDataManager.launch(AppGridViewAdapter.this.mContext, appBean, 0);
                            }
                            default: {
                                break;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class OnLongClick
    implements View.OnLongClickListener {
        private int pos;

        public OnLongClick(int pos) {
            this.pos = pos;
        }

        public boolean onLongClick(View v) {
            if (!AppStoreOptionVO.isCanDelApp()) {
                LogUtils.logDebugO(true, "canDelAddAppIcon: do not allow del app icon");
                return false;
            }
            if (AppGridViewAdapter.this.isAddAppIcon(this.pos)) {
                return false;
            }
            if (!AppGridViewAdapter.this.isShowDeleteView) {
                AppGridViewAdapter.this.chengeViewStatus(true);
            }
            return true;
        }
    }

    public static class ViewHolder {
        public TextView tvLabel;
        public Arcs rbPercent;
        public ImageView ivIcon;
        public ImageView delIcon;
        public ImageView newAppIcon;
        public TextView pushIcon;
        public ImageView updateIcon;
    }
}

