/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.apptile;

import android.app.Dialog;
import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppListBaseView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.apptile.SubAppListMgrAdapter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppTaskList;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.DataParserUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.HttpURLConnectionUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreTokenUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ConstantUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.DialogView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.XExpandableListView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStatusVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class SubAppListMgrView
extends AppListBaseView
implements ConstantUtils {
    public static final String TAG = "SubAppListMgrActivity";
    private XExpandableListView mExpandableListView;
    private SubAppListMgrAdapter mAdapter;
    private Context mContext;
    private String indexIdDown;
    private boolean isTitleClick = false;
    private static SubAppListMgrView mSubAppListView = null;
    private static AppTaskList appsTaskList = new AppTaskList();
    private JSONObject searchAppListParams = new JSONObject();
    private WWidgetData mWgtData;
    private AsyncTask<Void, Void, ArrayList<AppBean>> asyncTask = null;
    private EUExAppStoreMgr mEuExAppStoreMgr;
    private AsyncTask<Void, Void, ArrayList<AppBean>> asyncTaskPullDown = null;
    private AsyncTask<Void, Void, ArrayList<AppBean>> asyncTaskPullUp = null;

    public SubAppListMgrView(Context context, EUExAppStoreMgr mAppStoreMgr, WWidgetData mWidgetData) {
        super(context);
        this.mContext = context;
        this.mEuExAppStoreMgr = mAppStoreMgr;
        View rootView = LayoutInflater.from((Context)this.mContext).inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_sub_apps_listview"), (ViewGroup)this, true);
        mSubAppListView = this;
        String softToken = AppStoreTokenUtils.getSoftToken(this.mContext);
        this.mExpandableListView = (XExpandableListView)rootView.findViewById(EUExUtil.getResIdID((String)"listView_sub_widget"));
        this.mExpandableListView.setPullLoadEnable(false);
        this.mExpandableListView.setPullRefreshEnable(false);
        this.mExpandableListView.setXListViewListener(new ListViewIXListViewListener());
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        String time = sdf.format(new Date());
        this.mExpandableListView.setRefreshTime(time);
        this.mWgtData = mWidgetData;
        try {
            this.searchAppListParams.put("softToken", (Object)softToken);
            this.searchAppListParams.put("pageSize", (Object)"10");
            this.searchAppListParams.put("iswantTiles", (Object)"F");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (this.mAdapter == null) {
            this.downloadAppList(this.searchAppListParams, "appList_prefs");
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (this.mEuExAppStoreMgr != null) {
            this.mEuExAppStoreMgr.closeSubAppMgr(new String[0]);
        }
        super.onDetachedFromWindow();
    }

    private void downloadAppList(final JSONObject appListParamsJson, final String cacheKey) {
        final String resCache = SharedPrefUtils.getString(this.mContext, "main_prefs", cacheKey, "");
        if (!NetworkUtils.isOnline(this.mContext) && TextUtils.isEmpty((CharSequence)resCache)) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            return;
        }
        if (this.asyncTask != null) {
            return;
        }
        this.asyncTask = new AsyncTask<Void, Void, ArrayList<AppBean>>(){
            Dialog progressDialog = null;

            protected void onPreExecute() {
                this.progressDialog = DialogView.showLoadingDialog(SubAppListMgrView.this.mContext, EUExUtil.getString((String)"plugin_appstore_load_app_list"));
                this.progressDialog.show();
            }

            protected ArrayList<AppBean> doInBackground(Void ... params) {
                ArrayList<AppBean> appList = null;
                try {
                    String response = HttpURLConnectionUtils.downLoadAppList(HttpURLConnectionUtils.getUrlSearchList(), SubAppListMgrView.this.mContext, SubAppListMgrView.this.mWgtData, appListParamsJson).getResult();
                    if (!TextUtils.isEmpty((CharSequence)response)) {
                        appList = DataParserUtils.parseAppListWithKey("appList", response);
                        SharedPrefUtils.putString(SubAppListMgrView.this.mContext, "main_prefs", cacheKey, response);
                    } else if (!AppStatusVO.isForceConnected() && !TextUtils.isEmpty((CharSequence)resCache)) {
                        appList = DataParserUtils.parseAppListWithKey("appList", resCache);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return appList;
            }

            protected void onPostExecute(ArrayList<AppBean> result) {
                if (this.isCancelled()) {
                    SubAppListMgrView.this.asyncTask = null;
                    return;
                }
                if (this.progressDialog != null) {
                    this.progressDialog.dismiss();
                }
                if (result == null || result.size() == 0) {
                    Toast.makeText((Context)SubAppListMgrView.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_data"), (int)0).show();
                    SubAppListMgrView.this.asyncTask = null;
                    return;
                }
                try {
                    int leng = result.size() - 1;
                    SubAppListMgrView.this.indexIdDown = result.get(leng).getIndexId();
                    if (SubAppListMgrView.this.mAdapter == null) {
                        SubAppListMgrView.this.mAdapter = new SubAppListMgrAdapter(SubAppListMgrView.this.mContext, SubAppListMgrView.this.mWgtData, result, SubAppListMgrView.this.mExpandableListView);
                        SubAppListMgrView.this.mExpandableListView.setAdapter(SubAppListMgrView.this.mAdapter);
                        SubAppListMgrView.this.downloadStateRcv.updateAdapter(SubAppListMgrView.this.mAdapter);
                    } else {
                        SubAppListMgrView.this.mAdapter.reload(result);
                    }
                }
                catch (Exception e) {
                    Toast.makeText((Context)SubAppListMgrView.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_data"), (int)0).show();
                    e.printStackTrace();
                }
                SubAppListMgrView.this.asyncTask = null;
            }
        };
        this.asyncTask.execute((Object[])new Void[0]);
    }

    public void refreshData(final JSONObject jsonParam) {
        if (!NetworkUtils.isOnline(this.mContext)) {
            Toast.makeText((Context)this.mContext, (CharSequence)"\u7f51\u7edc\u6545\u969c", (int)0).show();
            this.mExpandableListView.stopRefresh();
            return;
        }
        if (this.asyncTaskPullDown != null) {
            return;
        }
        this.asyncTaskPullDown = new AsyncTask<Void, Void, ArrayList<AppBean>>(){

            protected ArrayList<AppBean> doInBackground(Void ... params) {
                String response = HttpURLConnectionUtils.downLoadAppList(HttpURLConnectionUtils.getUrlSearchList(), SubAppListMgrView.this.mContext, SubAppListMgrView.this.mWgtData, jsonParam).getResult();
                ArrayList<AppBean> niceApps = DataParserUtils.parseAppListWithKey("appList", response);
                return niceApps;
            }

            protected void onPostExecute(ArrayList<AppBean> result) {
                if (this.isCancelled()) {
                    SubAppListMgrView.this.asyncTaskPullDown = null;
                    return;
                }
                if (result == null) {
                    SubAppListMgrView.this.mExpandableListView.stopRefresh();
                    Toast.makeText((Context)SubAppListMgrView.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_app_refresh_fail"), (int)0).show();
                    SubAppListMgrView.this.asyncTaskPullUp = null;
                    return;
                }
                if (SubAppListMgrView.this.mAdapter != null) {
                    SubAppListMgrView.this.mAdapter.reload(result);
                } else {
                    SubAppListMgrView.this.mAdapter = new SubAppListMgrAdapter(SubAppListMgrView.this.mContext, SubAppListMgrView.this.mWgtData, result, SubAppListMgrView.this.mExpandableListView);
                    SubAppListMgrView.this.mExpandableListView.setAdapter(SubAppListMgrView.this.mAdapter);
                    SubAppListMgrView.this.downloadStateRcv.updateAdapter(SubAppListMgrView.this.mAdapter);
                }
                SubAppListMgrView.this.mExpandableListView.stopRefresh();
                SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
                String time = sdf.format(new Date());
                SubAppListMgrView.this.mExpandableListView.setRefreshTime(time);
                SubAppListMgrView.this.asyncTaskPullDown = null;
            }
        };
        this.asyncTaskPullDown.execute((Object[])new Void[0]);
    }

    private void loadMoreData(final JSONObject jsonParams) {
        if (!NetworkUtils.isOnline(this.mContext)) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            this.mExpandableListView.stopLoadMore();
            return;
        }
        if (this.asyncTaskPullUp != null) {
            return;
        }
        this.asyncTaskPullUp = new AsyncTask<Void, Void, ArrayList<AppBean>>(){

            protected ArrayList<AppBean> doInBackground(Void ... params) {
                String response = HttpURLConnectionUtils.downLoadAppList(HttpURLConnectionUtils.getUrlSearchList(), SubAppListMgrView.this.mContext, SubAppListMgrView.this.mWgtData, jsonParams).getResult();
                ArrayList<AppBean> appList = DataParserUtils.parseAppListWithKey("appList", response);
                return appList;
            }

            protected void onPostExecute(ArrayList<AppBean> result) {
                if (this.isCancelled()) {
                    SubAppListMgrView.this.asyncTaskPullUp = null;
                    return;
                }
                if (result == null || result.size() == 0) {
                    SubAppListMgrView.this.mExpandableListView.stopLoadMore();
                    Toast.makeText((Context)SubAppListMgrView.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_more_data"), (int)0).show();
                    SubAppListMgrView.this.asyncTaskPullUp = null;
                    return;
                }
                int length = result.size() - 1;
                SubAppListMgrView.this.indexIdDown = result.get(length).getIndexId();
                if (SubAppListMgrView.this.mAdapter != null) {
                    SubAppListMgrView.this.mAdapter.addList(result);
                } else {
                    SubAppListMgrView.this.mAdapter = new SubAppListMgrAdapter(SubAppListMgrView.this.mContext, SubAppListMgrView.this.mWgtData, result, SubAppListMgrView.this.mExpandableListView);
                    SubAppListMgrView.this.mExpandableListView.setAdapter(SubAppListMgrView.this.mAdapter);
                    SubAppListMgrView.this.downloadStateRcv.updateAdapter(SubAppListMgrView.this.mAdapter);
                }
                SubAppListMgrView.this.mExpandableListView.stopLoadMore();
                SubAppListMgrView.this.asyncTaskPullUp = null;
            }
        };
        this.asyncTaskPullUp.execute((Object[])new Void[0]);
    }

    public static SubAppListMgrView getInstance() {
        return mSubAppListView;
    }

    public XExpandableListView getSubAppListGridView() {
        return this.mExpandableListView;
    }

    public boolean isTitleClick() {
        return this.isTitleClick;
    }

    public void setTitleClick(boolean isTitleClick) {
        this.isTitleClick = isTitleClick;
    }

    public AppTaskList getAppsTaskList() {
        return appsTaskList;
    }

    class ListViewIXListViewListener
    implements XExpandableListView.IXListViewListener {
        @Override
        public void onRefresh() {
            JSONObject jsonPullDownJson = SubAppListMgrView.this.searchAppListParams;
            try {
                jsonPullDownJson.put("action", (Object)"up");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            SubAppListMgrView.this.refreshData(jsonPullDownJson);
        }

        @Override
        public void onLoadMore() {
            JSONObject jsonUpDownJson = SubAppListMgrView.this.searchAppListParams;
            try {
                jsonUpDownJson.put("action", (Object)"down");
                jsonUpDownJson.put("indexId", (Object)SubAppListMgrView.this.indexIdDown);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            SubAppListMgrView.this.loadMoreData(jsonUpDownJson);
        }
    }
}

