/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.apptile;

import android.content.Context;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.ListAdapter;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.apptile.AppTileListAdapter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ConstantUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ViewUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.HeaderGridView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.XExpandableListView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppTileBean;

public class TileListMgrAdapter
extends BaseExpandableListAdapter
implements XExpandableListView.HeaderAdapter,
ConstantUtils {
    private Context mContext;
    private LayoutInflater mInflater;
    private List<AppBean> mAppBeanList = new ArrayList<AppBean>();
    private TileAppNameHolder mTileAppNameHolder = null;
    private XExpandableListView mExpandableListView;
    private AppTileListAdapter appsTileAdapter;
    private JSONObject json = new JSONObject();
    private SparseIntArray groupStatusMap = new SparseIntArray();

    public TileListMgrAdapter(Context con, List<AppBean> mAppBeanList, XExpandableListView listView) {
        this.mContext = con;
        this.mExpandableListView = listView;
        if (mAppBeanList != null) {
            this.mAppBeanList = mAppBeanList;
        }
        this.mInflater = LayoutInflater.from((Context)this.mContext);
        try {
            this.json.put("IS_HOME_PAGE", false);
            this.json.put("IS_SHOW_ADD_TILE_ICON", false);
            this.json.put("IS_ADD_TILE_ICON_FIRST", false);
            this.json.put("CAN_DEL_TILE", false);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.mExpandableListView.setClickable(false);
    }

    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        this.mTileAppNameHolder = new TileAppNameHolder();
        convertView = this.mInflater.inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_more_tile_app_name_item"), null);
        this.mTileAppNameHolder.appName = (TextView)convertView.findViewById(EUExUtil.getResIdID((String)"more_tile_app_name"));
        convertView.setTag((Object)this.mTileAppNameHolder);
        this.mTileAppNameHolder.appName.setText((CharSequence)this.mAppBeanList.get(groupPosition).getAppName());
        this.mExpandableListView.expandGroup(groupPosition);
        if (this.mAppBeanList.get(groupPosition).getTilesList().size() == 0) {
            this.mTileAppNameHolder.appName.setVisibility(8);
        }
        return convertView;
    }

    public Object getChild(int groupPosition, int childPosition) {
        return null;
    }

    public long getChildId(int groupPosition, int childPosition) {
        return 0L;
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        ViewHolder mViewHolder = null;
        convertView = this.mInflater.inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_tile_main_layout"), null);
        mViewHolder = new ViewHolder();
        mViewHolder.gridView = (HeaderGridView)convertView.findViewById(EUExUtil.getResIdID((String)"app_tile_headergridview"));
        ArrayList<AppTileBean> appTileList = this.mAppBeanList.get(groupPosition).getTilesList();
        ArrayList<AppTileBean> showList = new ArrayList<AppTileBean>();
        for (AppTileBean apptile : appTileList) {
            if (!"false".equals(apptile.getDefaultTab())) continue;
            showList.add(apptile);
        }
        if (showList == null || showList.size() == 0) {
            ViewUtils.showToast(this.mContext, String.valueOf(this.mAppBeanList.get(groupPosition).getAppName()) + " " + EUExUtil.getString((String)"plugin_appstore_hint_no_tile_data"), 0);
        }
        this.appsTileAdapter = new AppTileListAdapter(null, this.mContext, showList, mViewHolder.gridView, this.json);
        mViewHolder.gridView.setAdapter((ListAdapter)this.appsTileAdapter);
        XExpandableListView.setListViewHeightBasedOnChildren(mViewHolder.gridView);
        return convertView;
    }

    public int getChildrenCount(int groupPosition) {
        return 1;
    }

    public Object getGroup(int groupPosition) {
        return this.mAppBeanList.get(groupPosition);
    }

    public int getGroupCount() {
        return this.mAppBeanList.size();
    }

    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public boolean hasStableIds() {
        return true;
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    @Override
    public int getHeaderState(int groupPosition, int childPosition) {
        int childCount = this.getChildrenCount(groupPosition);
        if (childPosition == childCount - 1) {
            return 2;
        }
        if (childPosition == -1 && !this.mExpandableListView.isGroupExpanded(groupPosition)) {
            return 0;
        }
        return 1;
    }

    @Override
    public void configureHeader(View header, int groupPosition, int childPosition, int alpha) {
    }

    @Override
    public void setGroupClickStatus(int groupPosition, int status) {
        this.groupStatusMap.put(groupPosition, status);
    }

    @Override
    public int getGroupClickStatus(int groupPosition) {
        if (this.groupStatusMap.keyAt(groupPosition) >= 0) {
            return this.groupStatusMap.get(groupPosition);
        }
        return 0;
    }

    private class TileAppNameHolder {
        public TextView appName;

        private TileAppNameHolder() {
        }
    }

    class ViewHolder {
        HeaderGridView gridView;

        ViewHolder() {
        }
    }
}

