/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.data;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppCanDatabaseUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ConstantUtils;

public class AppDbHelper
extends SQLiteOpenHelper
implements ConstantUtils {
    private static final String CREATE_UPDATE = "CREATE TABLE IF NOT EXISTS update_info(_id INTEGER PRIMARY KEY AUTOINCREMENT,store_id TEXT,appId TEXT,app_name TEXT,app_ver TEXT,file_path TEXT,download_url TEXT)";
    private static final String CREATE_TILE_TABLE = "CREATE TABLE IF NOT EXISTS app_tile_list(_id INTEGER PRIMARY KEY AUTOINCREMENT, tile_json_str TEXT, tile_id TEXT, tile_app_id TEXT, tile_app_name TEXT, tile_name TEXT, tile_icon TEXT, tile_link_url TEXT, tile_start_page TEXT, tile_version TEXT, tile_add_home_page TEXT, defaultTab TEXT,tenantAccount TEXT,domainName TEXT,loginName TEXT)";

    public AppDbHelper(Context context) {
        super(context, "gdydappmarket.db", null, 4);
    }

    public void onCreate(SQLiteDatabase db) {
        this.createTable(db, "app_list");
        this.createTable(db, "t_apps");
        db.execSQL(CREATE_UPDATE);
        db.execSQL(CREATE_TILE_TABLE);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.onCreate(db);
        AppCanDatabaseUtils.addColumn(db, "app_list", "wgtAppId", "TEXT");
        AppCanDatabaseUtils.addColumn(db, "t_apps", "wgtAppId", "TEXT");
        AppCanDatabaseUtils.addColumn(db, "app_list", "default_app", "INTEGER");
        AppCanDatabaseUtils.addColumn(db, "app_list", "remain_app", "INTEGER");
        AppCanDatabaseUtils.addColumn(db, "t_apps", "default_app", "INTEGER");
        AppCanDatabaseUtils.addColumn(db, "t_apps", "remain_app", "INTEGER");
        AppCanDatabaseUtils.addColumn(db, "app_list", "new_app", "INTEGER");
        AppCanDatabaseUtils.addColumn(db, "app_list", "isOmmApp", "TEXT");
        AppCanDatabaseUtils.addColumn(db, "app_list", "tenantAccount", "TEXT");
        AppCanDatabaseUtils.addColumn(db, "app_list", "domainName", "TEXT");
        AppCanDatabaseUtils.addColumn(db, "app_list", "loginName", "TEXT");
        AppCanDatabaseUtils.addColumn(db, "app_list", "max_ver", "TEXT");
        AppCanDatabaseUtils.addColumn(db, "app_tile_list", "tile_json_str", "TEXT");
        AppCanDatabaseUtils.addColumn(db, "app_tile_list", "defaultTab", "TEXT");
        AppCanDatabaseUtils.addColumn(db, "app_tile_list", "tile_add_home_page", "TEXT");
        AppCanDatabaseUtils.addColumn(db, "app_tile_list", "tenantAccount", "TEXT");
        AppCanDatabaseUtils.addColumn(db, "app_tile_list", "domainName", "TEXT");
        AppCanDatabaseUtils.addColumn(db, "app_tile_list", "loginName", "TEXT");
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.onCreate(db);
        AppCanDatabaseUtils.addColumn(db, "app_list", "wgtAppId", "TEXT");
        AppCanDatabaseUtils.addColumn(db, "t_apps", "wgtAppId", "TEXT");
        AppCanDatabaseUtils.addColumn(db, "app_list", "default_app", "INTEGER");
        AppCanDatabaseUtils.addColumn(db, "app_list", "remain_app", "INTEGER");
        AppCanDatabaseUtils.addColumn(db, "t_apps", "default_app", "INTEGER");
        AppCanDatabaseUtils.addColumn(db, "t_apps", "remain_app", "INTEGER");
        AppCanDatabaseUtils.addColumn(db, "app_list", "new_app", "INTEGER");
        AppCanDatabaseUtils.addColumn(db, "app_tile_list", "tile_json_str", "TEXT");
    }

    private void createTable(SQLiteDatabase db, String table) {
        String sql = "CREATE TABLE IF NOT EXISTS " + table + "(_id INTEGER PRIMARY KEY AUTOINCREMENT," + "store_id" + " TEXT," + "app_key" + " TEXT," + "app_name" + " TEXT," + "type" + " INTEGER," + "download_url" + " TEXT," + "icon_url" + " TEXT," + "state" + " INTEGER," + "install_path" + " TEXT," + "mainApp" + " TEXT," + "app_ver" + " TEXT," + "max_ver" + " TEXT," + "certificates_path" + " TEXT," + "certificates_pwd" + " TEXT," + "package_name" + " TEXT," + "certificates_url" + " TEXT," + "appId" + " TEXT," + "wgtAppId" + " TEXT," + "default_app" + " INTEGER," + "remain_app" + " TEXT," + "app_size" + " TEXT," + "new_app" + " INTEGER," + "isOmmApp" + " TEXT," + "tenantAccount" + " TEXT," + "domainName" + " TEXT," + "loginName" + " TEXT)";
        db.execSQL(sql);
    }
}

