/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.data;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDownLoadDb;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.DataParserUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.HttpURLConnectionUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreTokenUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ConstantUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.FileUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.GetAppListVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.GetAppVersionVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class AppHttpDataManager
implements ConstantUtils {
    private static AsyncTask<Void, Void, Void> getAppListAsyncTask = null;

    public static boolean getAppList(Context mContext, String info, EUExAppStoreMgr mEUExAppStoreMgr, WWidgetData mWidgetData) {
        boolean flg = true;
        GetAppListVO mGetAppsListConfig = FileUtils.pareGetAppsListConfig(info);
        String type = mGetAppsListConfig.getAppListType();
        String url = "";
        boolean isInstall = false;
        int appSrc = 0;
        JSONObject jsonParams = new JSONObject();
        try {
            jsonParams.put("softToken", (Object)AppStoreTokenUtils.getSoftToken(mContext));
            if ("greatAppList".equals(type)) {
                url = HttpURLConnectionUtils.getUrlGreatAppList();
                jsonParams.put("pageSize", (Object)"10");
            } else if ("rankAppList".equals(type)) {
                url = HttpURLConnectionUtils.getUrlRankingList();
                jsonParams.put("pageSize", (Object)"20");
            } else if ("appTypeList".equals(type)) {
                String appType = "";
                try {
                    appType = URLEncoder.encode(mGetAppsListConfig.getAppListKey(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                url = HttpURLConnectionUtils.getUrlSearchList();
                jsonParams.put("pageSize", (Object)"10");
                jsonParams.put("appType", (Object)appType);
            } else if ("appList".equals(type)) {
                url = HttpURLConnectionUtils.getUrlSearchList();
                jsonParams.put("pageSize", (Object)"10");
            } else if ("installAppList".equals(type)) {
                url = HttpURLConnectionUtils.getUrlInstallAppList();
                isInstall = true;
                appSrc = 0;
            } else if ("installAppFromAllList".equals(type)) {
                url = HttpURLConnectionUtils.getUrlSearchList();
                isInstall = true;
                appSrc = 1;
            } else if ("searchAppList".equals(type)) {
                url = HttpURLConnectionUtils.getUrlSearchList();
                if (!TextUtils.isEmpty((CharSequence)mGetAppsListConfig.getAppListKey())) {
                    jsonParams.put("keyWords", (Object)mGetAppsListConfig.getAppListKey());
                }
            } else {
                flg = false;
            }
            if (!"".equals(url)) {
                AppHttpDataManager.downloadAppListInfo(mContext, url, mEUExAppStoreMgr, 0, "appList", isInstall, mWidgetData, jsonParams, appSrc);
            } else {
                LogUtils.logErrorO("Get appList url is null! Maybe not call open!");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return flg;
    }

    public static void getTiles(final Context mContext, final EUExAppStoreMgr mEUExAppStoreMgr, final WWidgetData mWidgetData) {
        new AsyncTask<Void, Void, String>(){
            JSONObject jsonParams = null;

            protected void onPreExecute() {
                this.jsonParams = DataParserUtils.changeSoftTokenToJson(mContext);
            }

            protected String doInBackground(Void ... params) {
                return HttpURLConnectionUtils.downLoadAppList(mContext, mWidgetData, HttpURLConnectionUtils.getUrlGetTiles(), this.jsonParams, "appList").getResult();
            }

            protected void onPostExecute(String params) {
                mEUExAppStoreMgr.cbGetTiles(params);
            }
        }.execute((Object[])new Void[0]);
    }

    public static void getCategoryList(Context mContext, EUExAppStoreMgr mEUExAppStoreMgr, WWidgetData mWidgetData) {
        JSONObject jsonParams = new JSONObject();
        AppHttpDataManager.downloadAppListInfo(mContext, HttpURLConnectionUtils.getUrlCategoryList(), mEUExAppStoreMgr, 1, "appTypeList", false, mWidgetData, jsonParams, 0);
    }

    private static boolean isAppFullPackageDownloading(Context mContext, String url) {
        boolean download = false;
        String[] res = AppDownLoadDb.selectTaskFromDB(mContext, url);
        if (res != null) {
            int fileSize = Integer.parseInt(res[1]);
            int downSize = Integer.parseInt(res[2]);
            String pkgType = res[4];
            download = fileSize != downSize && "upgrade".equals(pkgType);
        }
        return download;
    }

    private static void downloadAppListInfo(final Context mContext, final String url, final EUExAppStoreMgr mEUExAppStoreMgr, final int type, final String listKey, final boolean isInstall, final WWidgetData mWidgetData, final JSONObject jsonParams, final int appSrc) {
        if (!NetworkUtils.isOnline(mContext)) {
            AppHttpDataManager.getAppListInfoCallBack(mContext, mEUExAppStoreMgr, type, "fail", EUExUtil.getString((String)"plugin_appstore_hint_error_network"), isInstall);
            return;
        }
        int wait = 0;
        while (getAppListAsyncTask != null && wait < 10) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++wait;
        }
        if (wait >= 9) {
            return;
        }
        getAppListAsyncTask = new AsyncTask<Void, Void, Void>(){
            private int reportCount = 0;
            boolean isGetAgain = false;

            protected void onPreExecute() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doInBackground(Void ... params) {
                AsyncTask asyncTask = getAppListAsyncTask;
                synchronized (asyncTask) {
                    String response = "";
                    response = HttpURLConnectionUtils.downLoadAppList(url, mContext, mWidgetData, jsonParams).getResult();
                    String msg = "";
                    String status = "";
                    if (!TextUtils.isEmpty((CharSequence)response)) {
                        try {
                            JSONObject appListResultJson = new JSONObject(response);
                            status = appListResultJson.optString("status", "fail");
                            String key = "ok".equals(status) ? listKey : "info";
                            msg = appListResultJson.optString(key);
                            if (isInstall && "ok".equals(status)) {
                                JSONArray appListFromNet = new JSONArray(msg);
                                JSONArray appListToWeb = new JSONArray();
                                int i = 0;
                                while (i < appListFromNet.length()) {
                                    final JSONObject jsonItem = appListFromNet.getJSONObject(i);
                                    AppBean appBean = DataParserUtils.parseAppBean(jsonItem);
                                    if (appBean.getType() != -1) {
                                        boolean isAppInstall = AppUtils.isAppInstalled(mContext, appBean);
                                        if (isAppInstall || !isAppInstall && AppHttpDataManager.isAppFullPackageDownloading(mContext, appBean.getDownloadUrl())) {
                                            jsonItem.put("state", (Object)"1");
                                            appListToWeb.put((Object)jsonItem);
                                        } else if (appSrc == 0) {
                                            new AsyncTask<Object, Object, Object>(){

                                                protected void onPreExecute() {
                                                    2 v0 = this;
                                                    v0.reportCount = v0.reportCount + 1;
                                                }

                                                protected Object doInBackground(Object ... params) {
                                                    return AppHttpDataManager.appUninstallReport(mContext, mWidgetData, jsonItem.optString("appId"));
                                                }

                                                protected void onPostExecute(Object params) {
                                                    2 v0 = this;
                                                    v0.reportCount = v0.reportCount - 1;
                                                }
                                            }.execute(new Object[0]);
                                        }
                                    }
                                    ++i;
                                }
                                if (AppStoreUtils.isFirstGetInstallAppList(mContext) && appSrc == 0) {
                                    File[] files = FileUtils.getListFilesFromDir(AppStoreUtils.getWidgetSavePath());
                                    int i2 = 0;
                                    while (i2 < files.length) {
                                        boolean isNeedInstallReport = false;
                                        if (files[i2].isDirectory() && FileUtils.isExistConfigFile(files[i2])) {
                                            if (appListToWeb.length() == 0) {
                                                isNeedInstallReport = true;
                                            } else {
                                                int j = 0;
                                                while (j < appListToWeb.length()) {
                                                    String appId = appListToWeb.getJSONObject(j).optString("appId");
                                                    if (files[i2].getName().equals(appId)) break;
                                                    isNeedInstallReport = true;
                                                    ++j;
                                                }
                                            }
                                        }
                                        if (isNeedInstallReport) {
                                            new AsyncTask<Object, Object, Object>(){

                                                protected void onPreExecute() {
                                                    isGetAgain = true;
                                                    2 v0 = this;
                                                    v0.reportCount = v0.reportCount + 1;
                                                }

                                                protected Object doInBackground(Object ... params) {
                                                    AppBean appBean = AppBean.getInstallReportAppBeanByAppId((String)params[0]);
                                                    return AppHttpDataManager.appInstallReport(mContext, appBean, mWidgetData);
                                                }

                                                protected void onPostExecute(Object params) {
                                                    2 v0 = this;
                                                    v0.reportCount = v0.reportCount - 1;
                                                }
                                            }.execute(new Object[]{files[i2].getName()});
                                        }
                                        ++i2;
                                    }
                                    AppStoreUtils.setFirstGetInstallAppList(mContext, false);
                                    if (this.isGetAgain) {
                                        i2 = 0;
                                        while (this.reportCount != 0 && i2 < 10) {
                                            try {
                                                Thread.sleep(200L);
                                                ++i2;
                                            }
                                            catch (InterruptedException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                        response = HttpURLConnectionUtils.downLoadAppList(url, mContext, mWidgetData, jsonParams).getResult();
                                        JSONObject jsonObject = new JSONObject(response);
                                        status = jsonObject.optString("status", "fail");
                                        key = "ok".equals(status) ? listKey : "info";
                                        msg = jsonObject.optString(key);
                                        AppHttpDataManager.getAppListInfoCallBack(mContext, mEUExAppStoreMgr, type, "ok".equals(status) ? "ok" : "fail", msg, isInstall);
                                    }
                                }
                                msg = appListToWeb.toString();
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    } else {
                        status = "fail";
                        msg = EUExUtil.getString((String)"plugin_appstore_hint_error_network");
                    }
                    if (!this.isGetAgain) {
                        AppHttpDataManager.getAppListInfoCallBack(mContext, mEUExAppStoreMgr, type, "ok".equals(status) ? "ok" : "fail", msg, isInstall);
                    }
                    return null;
                }
            }

            protected void onPostExecute(Void params) {
                if (this.isCancelled()) {
                    getAppListAsyncTask = null;
                    return;
                }
                getAppListAsyncTask = null;
            }
        };
        getAppListAsyncTask.execute((Object[])new Void[0]);
    }

    private static void getAppListInfoCallBack(Context mContext, EUExAppStoreMgr mEUExAppStoreMgr, int cbType, String status, String info, boolean isGetInstallList) {
        JSONObject json = new JSONObject();
        try {
            json.put("status", (Object)status);
            if (info.startsWith("[")) {
                JSONArray appListArray = new JSONArray(info);
                if (!isGetInstallList && cbType == 0) {
                    int i = 0;
                    while (i < appListArray.length()) {
                        JSONObject jsonItem = appListArray.getJSONObject(i);
                        AppBean appBean = DataParserUtils.parseAppBean(jsonItem);
                        if (appBean.getType() != -1) {
                            boolean isAppInstall = AppUtils.isAppInstalled(mContext, appBean);
                            if (isAppInstall || !isAppInstall && AppHttpDataManager.isAppFullPackageDownloading(mContext, appBean.getDownloadUrl())) {
                                jsonItem.put("state", (Object)"1");
                            } else {
                                jsonItem.put("state", (Object)"0");
                            }
                        }
                        ++i;
                    }
                }
                json.put("info", (Object)appListArray);
            } else {
                json.put("info", (Object)info);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (cbType == 0) {
            mEUExAppStoreMgr.cbGetAppList(json.toString());
        } else {
            mEUExAppStoreMgr.cbGetCategoryList(json.toString());
        }
    }

    public static AppBean getAppDetialFormAppBean(String appId, Context mContext, WWidgetData mWidgetData) {
        String responseAppDetail = AppHttpDataManager.getAppDetail(appId, mContext, mWidgetData);
        return DataParserUtils.parseAppBeanWithKey("appDetail", responseAppDetail);
    }

    public static String getAppDetail(String appId, Context mContext, WWidgetData mWidgetData) {
        String url = HttpURLConnectionUtils.getUrlAppDetial();
        JSONObject jsonParams = new JSONObject();
        try {
            jsonParams.put("softToken", (Object)AppStoreTokenUtils.getSoftToken(mContext));
            url = String.valueOf(url) + "/" + appId;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String detailKey = "appList";
        String responseAppDetail = HttpURLConnectionUtils.downLoadAppList(mContext, mWidgetData, url, jsonParams, detailKey).getResult();
        return responseAppDetail;
    }

    public static String appInstallReport(Context mContext, AppBean appBean, WWidgetData mWidgetData) {
        String result = "";
        if (AppDownLoadDb.isInstallReport(mContext, appBean.getDownloadUrl())) {
            String url = HttpURLConnectionUtils.getUrlReportAppVersion();
            JSONObject json = new JSONObject();
            try {
                json.put("version", (Object)AppUtils.getAppInstallVersion(appBean));
                json.put("softToken", (Object)AppStoreTokenUtils.getSoftToken(mContext));
                json.put("subAppId", (Object)appBean.getAppId());
                result = HttpURLConnectionUtils.sendHttpRequestByPost(mContext, mWidgetData, url, DataParserUtils.parseJson2NameValuePairs(json.toString()), "application/x-www-form-urlencoded").getResult();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String appUninstallReport(Context mContext, WWidgetData mWidgetData, String appId) {
        JSONObject json = new JSONObject();
        String result = "";
        try {
            String url = HttpURLConnectionUtils.getUrlReportAppDel();
            json.put("subAppId", (Object)appId);
            result = HttpURLConnectionUtils.sendHttpRequestByPost(mContext, mWidgetData, url, DataParserUtils.parseJson2NameValuePairs(json.toString()), "application/x-www-form-urlencoded").getResult();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void getAppVersionInfo(final Context mContext, final EUExAppStoreMgr mEUExAppStoreMgr, final WWidgetData mWidgetData, GetAppVersionVO versionVO) {
        JSONObject jsonParams = new JSONObject();
        try {
            if (!TextUtils.isEmpty((CharSequence)versionVO.appId)) {
                jsonParams.put("appId", (Object)versionVO.appId);
            } else {
                jsonParams.put("appId", (Object)mWidgetData.m_appId);
            }
            jsonParams.put("tenantAccount", (Object)AppStoreUtils.getTenantAccount(mContext));
            jsonParams.put("platform", (Object)"android");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        final String url = String.valueOf(HttpURLConnectionUtils.getUrlGetAppVersionInfo()) + "?" + DataParserUtils.getJsonObj(jsonParams.toString());
        new AsyncTask<String, Void, String>(){

            protected void onPreExecute() {
            }

            protected String doInBackground(String ... params) {
                return DataParserUtils.changeToV3Result(HttpURLConnectionUtils.sendHttpRequestByGet(mContext, mWidgetData, url, null, "application/x-www-form-urlencoded"), "info").getResult();
            }

            protected void onPostExecute(String params) {
                mEUExAppStoreMgr.cbGetAppVersionInfo(params);
            }
        }.execute((Object[])new String[0]);
    }
}

