/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.data;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.widget.Toast;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppListBaseView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppStoreMainView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDownLoadDb;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDownTask;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppHttpDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppLocalDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppTaskList;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppTileBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.DataParserUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.MyAsyncTask;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.ViewDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.HttpURLConnectionUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.upgrade.GrayRelease;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreTokenUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ConstantUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ViewUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.DialogView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStoreOptionVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppTileBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.EMMStartUpVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class ViewDataManager2
extends ViewDataManager
implements ConstantUtils {
    private static ViewDataManager2 mViewDataManager2;
    private AppListBaseView mAppListView;
    private static boolean isInitData;

    static {
        isInitData = false;
    }

    public ViewDataManager2(Context context, WWidgetData mWidgetData, EUExAppStoreMgr mAppStoreMgr, AppListBaseView appListView) {
        super(context, mWidgetData);
        if (mViewDataManager2 == null) {
            EUExUtil.init((Context)context);
            mViewDataManager2 = this;
            this.mAppListView = appListView;
            this.mViewDataMgrCallBack = new ViewDataManager.ViewDataMgrCallBack(){

                @Override
                public void openWidget(Context context, AppBean appBean) {
                    AppUtils.openApp(context, appBean, null, true);
                }

                @Override
                public void downAppFail(Context context, AppBean appBean, EMMStartUpVO startUpInfo) {
                    ViewUtils.showToast(context, EUExUtil.getString((String)"plugin_appstore_download_fail"), 0);
                    new AppBeanDao(context).updateAppState(appBean.getAppId(), 0, null);
                    ArrayList<NameValuePair> valueList = new ArrayList<NameValuePair>();
                    valueList.add((NameValuePair)new BasicNameValuePair("plugin_appstore_download_btn_status", EUExUtil.getString((String)"plugin_appstore_not_install")));
                    Intent intent = AppStoreUtils.getIntent(context.getPackageName(), "plugin_appstore_notify_download_status", valueList);
                    context.sendBroadcast(intent);
                    GrayRelease.freeGrayReleaseVersion(context, appBean, startUpInfo);
                }

                @Override
                public void unzipPostExecute(Context context, AppBean appBean, String unzipResult, String filePath, Dialog dialog, int actionType, boolean isUpdate) {
                    new File(filePath).delete();
                    if (dialog != null) {
                        dialog.dismiss();
                    }
                    if (unzipResult == null) {
                        return;
                    }
                    ArrayList<NameValuePair> valueList = new ArrayList<NameValuePair>();
                    valueList.add((NameValuePair)new BasicNameValuePair("plugin_appstore_download_btn_status", EUExUtil.getString((String)"plugin_appstore_installed")));
                    valueList.add((NameValuePair)new BasicNameValuePair("plugin_appstore_notify_download_status_appId", appBean.getAppId()));
                    Intent intent = AppStoreUtils.getIntent(context.getPackageName(), "plugin_appstore_notify_download_status", valueList);
                    context.sendBroadcast(intent);
                    switch (actionType) {
                        case 0: {
                            ViewDataManager2.this.mAppListView.refreshLocalData();
                            break;
                        }
                        case 1: {
                            AppUtils.openApp(context, appBean, null, true);
                            break;
                        }
                    }
                }

                @Override
                public void unzipFail(Context context, AppBean appBean, EMMStartUpVO startUpInfo) {
                    LogUtils.logDebug(true, "unzip failed");
                    if (startUpInfo != null) {
                        GrayRelease.freeGrayReleaseVersion(context, appBean, startUpInfo);
                    }
                }
            };
        }
    }

    public static ViewDataManager2 getInstance() {
        return mViewDataManager2;
    }

    public static void performAsyncLoadMyAppListDataAction(final Context mContext, final WWidgetData mWData, final String appListDownloadUrl, final AppStoreDataCallback dataCallback, final boolean isMCMExist, final boolean isShowAdView, final boolean isWantTile) {
        if (!NetworkUtils.isOnline(mContext)) {
            dataCallback.callBackAllRes(null);
            ViewUtils.showToast(mContext, EUExUtil.getString((String)"plugin_appstore_not_force"), 0);
            return;
        }
        new AsyncTask<Object, Void, AppStoreData>(){
            Dialog progressDialog = null;

            protected void onPreExecute() {
                this.progressDialog = DialogView.showLoadingDialog(mContext, EUExUtil.getString((String)"plugin_appstore_load_app_list"));
                this.progressDialog.show();
            }

            protected AppStoreData doInBackground(Object ... params) {
                if (!NetworkUtils.isOnline(mContext)) {
                    LogUtils.logDebug(true, "No Network!");
                    return null;
                }
                JSONObject jsonParams = new JSONObject();
                if (AppStoreOptionVO.isShowAllAppsInMain()) {
                    try {
                        jsonParams.put("softToken", (Object)AppStoreTokenUtils.getSoftToken(mContext));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                String responseAppList = HttpURLConnectionUtils.downLoadAppList(appListDownloadUrl, mContext, mWData, jsonParams).getResult();
                ArrayList<AppBean> installedApps = DataParserUtils.parseAppListWithKey("appList", responseAppList);
                ArrayList<AppBean> mcmList = null;
                if (isMCMExist) {
                    String mcmUrl = String.valueOf(HttpURLConnectionUtils.getUrlMcmAd()) + AppStoreTokenUtils.getSoftToken(mContext);
                    String responseMCMList = HttpURLConnectionUtils.sendHttpRequestByGet(mContext, mWData, mcmUrl).getResult();
                    mcmList = DataParserUtils.parseMCMDocumentInfoJsonArray(responseMCMList);
                }
                ArrayList<AppBean> adsList = null;
                if (isShowAdView) {
                    String adUrl = HttpURLConnectionUtils.getUrlGreatAppList();
                    String responseAdList = HttpURLConnectionUtils.downLoadAppList(adUrl, mContext, mWData, DataParserUtils.changeSoftTokenToJson(mContext)).getResult();
                    adsList = DataParserUtils.parseAdJsonArray(responseAdList);
                }
                List<AppTileBean> tileList = null;
                if (isWantTile) {
                    JSONObject getTileJsonParams = new JSONObject();
                    try {
                        getTileJsonParams.put("softToken", (Object)AppStoreTokenUtils.getSoftToken(mContext));
                        getTileJsonParams.put("iswantTiles", (Object)"F");
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    String resultContainTile = HttpURLConnectionUtils.downLoadAppList(HttpURLConnectionUtils.getUrlSearchList(), mContext, mWData, getTileJsonParams).getResult();
                    ArrayList<AppBean> listContainTile = DataParserUtils.parseAppListWithKey("appList", resultContainTile);
                    List<AppBean> installListinstallList = AppBean.filterInstallApp(mContext, listContainTile);
                    tileList = AppTileBean.getTileListFromAppList(installListinstallList);
                }
                AppStoreData storeData = new AppStoreData(installedApps, adsList, mcmList, tileList);
                return storeData;
            }

            protected void onCancelled() {
                super.onCancelled();
                if (this.isCancelled()) {
                    dataCallback.callBackAllRes(null);
                    isInitData = true;
                }
            }

            protected void onPostExecute(AppStoreData storeData) {
                if (this.progressDialog != null) {
                    this.progressDialog.dismiss();
                }
                dataCallback.callBackAllRes(storeData);
                isInitData = true;
            }
        }.execute(new Object[0]);
    }

    public static void performLoadAppDetailDataAction(final Context context, final WWidgetData mWidgetData, final AppDetailDataCallback dataCallback, final String appId) {
        if (!NetworkUtils.isOnline(context)) {
            ViewUtils.showToast(context, EUExUtil.getString((String)"plugin_appstore_not_force"), 0);
            return;
        }
        new AsyncTask<Object, Void, AppBean>(){
            Dialog progressDialog = null;

            protected void onPreExecute() {
                this.progressDialog = DialogView.showLoadingDialog(context, "\u52a0\u8f7d\u5e94\u7528\u8be6\u60c5...");
                this.progressDialog.show();
            }

            protected AppBean doInBackground(Object ... params) {
                if (!NetworkUtils.isOnline(context)) {
                    LogUtils.logDebug(true, "No Network!");
                    return null;
                }
                String responseAppDetail = AppHttpDataManager.getAppDetail(appId, context, mWidgetData);
                AppBean appBean = DataParserUtils.parseAppBeanWithKey("appDetail", responseAppDetail);
                return appBean;
            }

            protected void onCancelled() {
                super.onCancelled();
                if (this.isCancelled()) {
                    Toast.makeText((Context)context, (CharSequence)"\u53d6\u6d88\u8bf7\u6c42", (int)0).show();
                }
            }

            protected void onPostExecute(AppBean appBean) {
                if (this.progressDialog != null) {
                    this.progressDialog.dismiss();
                }
                if (appBean == null) {
                    Toast.makeText((Context)context, (CharSequence)"\u7f51\u7edc\u6570\u636e\u5f02\u5e38", (int)0).show();
                    return;
                }
                dataCallback.callBackRes(appBean);
            }
        }.execute(new Object[0]);
    }

    public void launch(Context context, AppBean appBean, int type) {
        this.launch(context, appBean, type, false, "upgrade", null, true, this.mViewDataMgrCallBack);
    }

    public void unzip(Context context, AppBean appBean, String filePath, int type) {
        this.unzip(context, appBean, filePath, type, false, null, this.mViewDataMgrCallBack);
    }

    public static void autoDownloadApp(final Context mContext, final WWidgetData mWgtData, final boolean isWantTile) {
        new AsyncTask<Void, Void, List<AppBean>>(){

            protected List<AppBean> doInBackground(Void ... params) {
                JSONObject json = DataParserUtils.changeSoftTokenToJson(mContext);
                if (isWantTile) {
                    try {
                        json.put("iswantTiles", (Object)"F");
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                String appListResult = HttpURLConnectionUtils.downLoadAppList(HttpURLConnectionUtils.getUrlSearchList(), mContext, mWgtData, json).getResult();
                while (!isInitData) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return DataParserUtils.parseAppListWithKey("appList", appListResult);
            }

            protected void onPostExecute(List<AppBean> appList) {
                if (appList != null) {
                    for (AppBean app : appList) {
                        boolean isAppInstalled = AppUtils.isAppInstalled(mContext, app);
                        String appId = app.getAppId();
                        AppBean localAppBean = new AppBeanDao(mContext).getAppBean(appId);
                        ArrayList<AppTileBean> tileList = app.getTilesList();
                        if (localAppBean == null) {
                            new AppBeanDao(mContext).addAppBean("app_list", app);
                        }
                        new AppTileBeanDao(mContext).addTileList("app_tile_list", tileList);
                        if (isAppInstalled && (localAppBean == null || localAppBean.getNewApp() != 2) || ViewDataManager2.getAppTaskList().isExistTask(appId, mContext)) continue;
                        ViewDataManager2.downLoadApp(mContext, app, mWgtData);
                    }
                }
            }
        }.execute((Object[])new Void[0]);
    }

    private static void downLoadApp(Context mContext, final AppBean mAppBean, final WWidgetData mWidgetData) {
        if (!NetworkUtils.isOnline(mContext)) {
            return;
        }
        new AppBeanDao(mContext).updateAppState(mAppBean.getAppId(), 2, null);
        if (AppStoreMainView.isDownloadRunning(mAppBean.getAppId())) {
            LogUtils.logDebugO(true, "update downloadTask is Running: " + mAppBean.getAppId());
            return;
        }
        AppDownTask appDownTask = new AppDownTask(mContext, mAppBean, 0, true){

            @Override
            protected Object doInBackground(Object ... params) {
                Object result = null;
                AppHttpDataManager.appInstallReport(this.mContext, mAppBean, mWidgetData);
                result = super.doInBackground(mAppBean.getDownloadUrl(), "0", "upgrade");
                return result;
            }

            @Override
            public void handleOnCanceled(MyAsyncTask task) {
                super.handleOnCanceled(task);
                ViewDataManager2.getAppTaskList().removeTask(this);
                LogUtils.logDebug(true, "handleOnCanceled " + this.getStatus());
            }

            @Override
            public void handleOnCompleted(MyAsyncTask task, Object result) {
                super.handleOnCompleted(task, result);
                ViewDataManager2.getAppTaskList().removeTask(this);
                LogUtils.logDebug(true, "handleOnCompleted " + this.getStatus());
                if (result == null) {
                    ViewUtils.showToast(this.mContext, String.valueOf(mAppBean.getAppName()) + " " + EUExUtil.getString((String)"plugin_appstore_download_fail"), 1);
                    new AppBeanDao(this.mContext).updateAppState(mAppBean.getAppId(), 0, null);
                    AppDownLoadDb.deleteUpdateFromDb(this.mContext, this.appBean.getDownloadUrl());
                    return;
                }
                if (AppUtils.isNativeApp(this.appBean.getType())) {
                    File file;
                    if (result instanceof File && (file = (File)result) != null && file.exists()) {
                        new AppBeanDao(this.mContext).updateAppState(mAppBean.getAppId(), 1, null);
                        AppUtils.installApp(this.mContext, file);
                        AppLocalDataManager.saveApkPath(this.mContext, mAppBean.getAppId(), file.getAbsolutePath());
                        AppLocalDataManager.removeProgress(this.mContext, mAppBean.getAppId());
                    }
                } else if (result instanceof File) {
                    File file = (File)result;
                    new AppBeanDao(this.mContext).updateAppState(mAppBean.getAppId(), 1, null);
                    ViewDataManager2.getInstance().unzip(this.mContext, mAppBean, file.getAbsolutePath(), 0);
                }
            }
        };
        ViewDataManager2.getAppTaskList().addTask(appDownTask);
        appDownTask.execute(new Object[0]);
    }

    public static void removeTask(AppBean appBean) {
        AppTaskList appTaskList = ViewDataManager2.getAppTaskList();
        if (appTaskList != null) {
            int i = 0;
            int size = appTaskList.size();
            while (i < size) {
                AppDownTask task = appTaskList.getTask(i);
                if (task != null && appBean.getAppId().equals(task.getTaskId())) {
                    appTaskList.getTask(i).setWait(false);
                    appTaskList.getTask(i).cancel(true);
                }
                ++i;
            }
        }
    }

    public static interface AppDetailDataCallback {
        public void callBackRes(AppBean var1);
    }

    public static class AppStoreData {
        public List<AppBean> appList;
        public List<AppBean> adList;
        public List<AppBean> mcmTitleList;
        public List<AppTileBean> tileList;

        public AppStoreData(List<AppBean> appList, List<AppBean> adList, List<AppBean> mcmTitleList, List<AppTileBean> tileList) {
            this.appList = appList;
            this.adList = adList;
            this.mcmTitleList = mcmTitleList;
            this.tileList = tileList;
        }
    }

    public static interface AppStoreDataCallback {
        public void callBackAllRes(AppStoreData var1);
    }
}

