/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.data;

import android.app.Dialog;
import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDownLoadDb;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppHttpDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.ViewDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.upgrade.GrayRelease;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ConstantUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.EMMStartUpVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class ViewDataManager3
extends ViewDataManager
implements ConstantUtils {
    private static ViewDataManager3 mViewDataManager3;
    private static Map<String, AppBean> delNativeAppMap;
    private LinkedList<AsyncTask<Void, Void, Object>> unzipTaskList = new LinkedList();

    static {
        delNativeAppMap = new HashMap<String, AppBean>();
    }

    public static void addDelNativeAppMap(AppBean appBean) {
        String pkgName = appBean.getPackageName();
        if (!TextUtils.isEmpty((CharSequence)pkgName)) {
            delNativeAppMap.put(appBean.getPackageName(), appBean);
        }
    }

    public static AppBean getAppBeanFromDelNativeAppMap(String pkgName) {
        AppBean appBean = null;
        if (!TextUtils.isEmpty((CharSequence)pkgName)) {
            appBean = delNativeAppMap.get(pkgName);
        }
        return appBean;
    }

    public static void delDelNativeAppMap(String pkgName) {
        if (!TextUtils.isEmpty((CharSequence)pkgName)) {
            delNativeAppMap.remove(pkgName);
        }
    }

    public ViewDataManager3(Context context, WWidgetData mWData) {
        super(context, mWData);
        if (mViewDataManager3 == null) {
            mViewDataManager3 = this;
            EUExUtil.init((Context)context);
            this.mViewDataMgrCallBack = new ViewDataManager.ViewDataMgrCallBack(){

                @Override
                public void openWidget(Context context, AppBean appBean) {
                    switch (appBean.getType()) {
                        case 2: 
                        case 4: {
                            AppUtils.openApp(context, appBean, AppStoreUtils.getOpenSubAppInfo(context, appBean.getAppId()), true);
                            break;
                        }
                        case 3: {
                            EUExAppStoreMgr.cbLoadWidget(1, appBean, "");
                            break;
                        }
                        default: {
                            LogUtils.logErrorO("ViewDataManager3 lunch open app type error");
                        }
                    }
                }

                @Override
                public void downAppFail(Context context, AppBean appBean, EMMStartUpVO startUpInfo) {
                    EUExAppStoreMgr.cbLoadWidget(0, appBean, EUExUtil.getString((String)"plugin_appstore_download_fail"));
                    new AppBeanDao(context).updateAppState(appBean.getAppId(), 0, null);
                    GrayRelease.freeGrayReleaseVersion(context, appBean, startUpInfo);
                }

                @Override
                public void unzipPostExecute(Context context, AppBean appBean, String unzipResult, String filePath, Dialog dialog, int actionType, boolean isUpdate) {
                    new File(filePath).delete();
                    if (dialog != null) {
                        dialog.dismiss();
                    }
                    switch (actionType) {
                        case 0: {
                            if (unzipResult == null && !isUpdate) {
                                LogUtils.logError("TYPE_DOWNLOAD unZip error: " + unzipResult);
                                EUExAppStoreMgr.cbLoadWidget(0, appBean, "");
                                return;
                            }
                            if (isUpdate) {
                                EUExAppStoreMgr.cbLoadWidget(2, appBean, "");
                                break;
                            }
                            EUExAppStoreMgr.cbLoadWidget(1, appBean, "");
                            break;
                        }
                        case 1: {
                            if (unzipResult == null) {
                                LogUtils.logError("TYPE_OPEN unZip error: " + unzipResult);
                                return;
                            }
                            if (isUpdate) {
                                EUExAppStoreMgr.cbLoadWidget(2, appBean, "");
                                break;
                            }
                            EUExAppStoreMgr.cbLoadWidget(1, appBean, "");
                            break;
                        }
                    }
                }

                @Override
                public void unzipFail(Context context, AppBean appBean, EMMStartUpVO startUpInfo) {
                    LogUtils.logDebug(true, "unzip failed");
                    EUExAppStoreMgr.cbLoadWidget(0, appBean, EUExUtil.getString((String)"plugin_appstore_install_fail"));
                    if (startUpInfo != null) {
                        GrayRelease.freeGrayReleaseVersion(context, appBean, startUpInfo);
                    }
                }
            };
        }
    }

    public static ViewDataManager3 getInstance() {
        if (mViewDataManager3 == null) {
            mViewDataManager3 = new ViewDataManager3(EUExAppStoreMgr.getInstance().mBrowserContext, EUExAppStoreMgr.getRootWData());
        }
        return mViewDataManager3;
    }

    public void launch(Context context, AppBean appBean, int type, boolean isUpdate, String pakType) {
        this.launch(context, appBean, type, isUpdate, pakType, null, false, this.mViewDataMgrCallBack);
    }

    public void unzip(Context context, AppBean appBean, String filePath, int type, boolean isUpdate) {
        this.unzip(context, appBean, filePath, type, isUpdate, null, this.mViewDataMgrCallBack);
    }

    @Override
    void addTask(AsyncTask<Void, Void, Object> task) {
        this.unzipTaskList.size();
        this.unzipTaskList.add(task);
    }

    public static void loadWidget(Context context, WWidgetData mWData, AppBean appBean) {
        ViewDataManager3 viewDataManager = ViewDataManager3.getInstance();
        if (viewDataManager == null) {
            viewDataManager = new ViewDataManager3(context, mWData);
        }
        if (1 == appBean.getType()) {
            EUExAppStoreMgr.cbLoadWidget(1, appBean, "");
            viewDataManager.onWebAppClicked(context, mWData, appBean);
            return;
        }
        String appId = appBean.getAppId();
        if ((1 == appBean.getState() || 4 == appBean.getState()) && AppUtils.isAppInstalled(context, appBean)) {
            String[] updateInfo = new AppBeanDao(context).getUpdate(appBean.getAppId());
            if (updateInfo != null) {
                String filePath = updateInfo[0];
                String appVer = updateInfo[1];
                if (!TextUtils.isEmpty((CharSequence)filePath) && filePath.endsWith(".zip") && !TextUtils.isEmpty((CharSequence)appVer)) {
                    if (new File(filePath).exists()) {
                        AppBean bean = appBean;
                        bean.setInstallVersion(appVer);
                        viewDataManager.unzip(context, bean, filePath, 1, true);
                        return;
                    }
                    new AppBeanDao(context).deleteUpdate(appBean.getAppId());
                }
            }
            viewDataManager.launch(context, appBean, 1, false, "upgrade");
        } else {
            LogUtils.logDebug(true, "==============\u5c1a\u672a\u4e0b\u8f7d\uff0c\u5f00\u59cb\u4e0b\u8f7d");
            if (ViewDataManager3.getAppTaskList().isExistTask(appId, context)) {
                return;
            }
            AppBean appDetial = AppHttpDataManager.getAppDetialFormAppBean(appBean.getAppId(), context, mWData);
            appBean.setDownloadUrl(appDetial.getDownloadUrl());
            String[] result = AppDownLoadDb.getFilePathFromDownload(context, appBean.getDownloadUrl());
            if (result != null) {
                String path = result[0];
                String size = result[1];
                if (!TextUtils.isEmpty((CharSequence)path) && !TextUtils.isEmpty((CharSequence)size)) {
                    int fileSize = Integer.parseInt(size);
                    File file = new File(path);
                    if (file.exists() && file.length() == (long)fileSize) {
                        viewDataManager.unzip(context, appBean, path, 0, false);
                        return;
                    }
                }
            }
            viewDataManager.launch(context, appBean, 0, false, "upgrade");
        }
    }
}

