/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.http;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.EUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.DataParserUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.Http;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreTokenUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ConstantUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.InputStreamUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStoreOptionVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.HttpRequrstResultVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class HttpURLConnectionUtils
implements ConstantUtils {
    private static String URL_GREAT_APP_LIST = "";
    private static String URL_MCM_AD = "";
    private static String USERNAME = "";
    private static String PASSWORD = "";
    private static String URL_RANKING_LIST = "";
    private static String URL_CATEGORY_LIST = "";
    private static String URL_SEARCH_LIST = "";
    private static String URL_SUBMIT_APP_DISCUSS = "";
    private static String URL_GET_APP_EVALUTE = "";
    private static String URL_REPORT_APP_VERSION = "";
    private static String URL_REPORT_APP_DEL = "";
    private static String URL_INSTALL_APP_LIST = "";
    private static String CHECKUPDATE_URL = "";
    private static String URL_APPDETAIL = "";
    private static String URL_UPDATE_STRATEGY = "";
    public static String URL_GET_TILES = "";
    public static String URL_GET_APP_VERSION_INFO = "";

    public static void initUrls(String host, Context mContext, String appId) {
        URL_CATEGORY_LIST = String.valueOf(host) + "/store/appTypeList";
        URL_GREAT_APP_LIST = String.valueOf(host) + "/store/greatAppList";
        URL_RANKING_LIST = String.valueOf(host) + "/store/rankAppList";
        URL_SEARCH_LIST = String.valueOf(host) + "/store/searchAppList";
        URL_SUBMIT_APP_DISCUSS = String.valueOf(host) + "/store/submitAppEvalute";
        URL_GET_APP_EVALUTE = String.valueOf(host) + "/store/getAppEvalute";
        URL_REPORT_APP_VERSION = String.valueOf(host) + "/store/reportAppVersion";
        URL_GET_TILES = String.valueOf(host) + "/store/getTiles";
        String softToken = AppStoreTokenUtils.getSoftToken(mContext);
        URL_REPORT_APP_DEL = String.valueOf(host) + "/store/" + softToken + "/unInstall";
        URL_INSTALL_APP_LIST = !AppStoreOptionVO.isShowAllAppsInMain() ? String.valueOf(host) + "/store/" + softToken + "/installAppList" : String.valueOf(host) + "/store/searchAppList";
        CHECKUPDATE_URL = String.valueOf(host) + "/store/" + softToken + "/checkUpdate";
        URL_APPDETAIL = String.valueOf(host) + "/store/appDetail";
        String tempHost = host.replace("storeIn", "appIn");
        URL_UPDATE_STRATEGY = String.valueOf(tempHost) + "/updateStrategy/{strategyId}";
    }

    public static void setUserName(String userName) {
        USERNAME = userName;
    }

    public static String getUserName() {
        return USERNAME;
    }

    public static void setPassWord(String passWore) {
        PASSWORD = passWore;
    }

    public static String getPassWord() {
        return PASSWORD;
    }

    public static void setUrlMcmAd(String url) {
        URL_MCM_AD = url;
    }

    public static String getUrlMcmAd() {
        return URL_MCM_AD;
    }

    public static String getUrlSearchList() {
        return URL_SEARCH_LIST;
    }

    public static String getUrlGetAppEvalute() {
        return URL_GET_APP_EVALUTE;
    }

    public static String getUrlCategoryList() {
        return URL_CATEGORY_LIST;
    }

    public static String getUrlInstallAppList() {
        return URL_INSTALL_APP_LIST;
    }

    public static String getUrlGreatAppList() {
        return URL_GREAT_APP_LIST;
    }

    public static String getUrlRankingList() {
        return URL_RANKING_LIST;
    }

    public static String getUrlSubmitAppDiscuss() {
        return URL_SUBMIT_APP_DISCUSS;
    }

    public static String getUrlAppDetial() {
        return URL_APPDETAIL;
    }

    public static String getUrlReportAppVersion() {
        return URL_REPORT_APP_VERSION;
    }

    public static String getUrlReportAppDel() {
        return URL_REPORT_APP_DEL;
    }

    public static String getUrlUpgradeStrategy() {
        return URL_UPDATE_STRATEGY;
    }

    public static String getUrlGetTiles() {
        return URL_GET_TILES;
    }

    public static String getUrlGetAppVersionInfo() {
        return URL_GET_APP_VERSION_INFO;
    }

    private static void addHttpURLConnectionHeader(WWidgetData mWData, HttpURLConnection connection, String url, String contentType) {
        String cookie;
        connection.addRequestProperty("Accept", "*/*");
        if (mWData != null) {
            connection.setRequestProperty("channel", mWData.m_channelCode);
            connection.addRequestProperty("varifyApp", AppStoreUtils.getAppVerifyCode(mWData));
            connection.addRequestProperty("appverify", AppStoreUtils.getAppVerifyCode(mWData));
            connection.addRequestProperty("x-mas-app-id", mWData.m_appId);
        }
        if (!TextUtils.isEmpty((CharSequence)(cookie = HttpURLConnectionUtils.getCookie(url)))) {
            connection.setRequestProperty("Cookie", cookie);
        }
        if (!TextUtils.isEmpty((CharSequence)contentType)) {
            connection.setRequestProperty("Content-Type", contentType);
        }
    }

    public static HttpRequrstResultVO sendHttpRequest(Context mCtx, WWidgetData wData, String url, String data, String requestMethod, String contentType) {
        LogUtils.logDebugO(true, "sendHttpRequest url:" + url);
        HttpURLConnection httpConnection = HttpURLConnectionUtils.getHttpURLConnection(mCtx, url, 30000, 30000);
        HttpRequrstResultVO result = new HttpRequrstResultVO();
        if (httpConnection != null) {
            HttpURLConnectionUtils.addHttpURLConnectionHeader(wData, httpConnection, url, contentType);
            LogUtils.logDebugO(true, "httpRequest header:" + httpConnection.getRequestProperties().toString());
            LogUtils.logDebugO(true, "httpRequest data:" + data);
            String responseRes = "";
            int responseCode = -1;
            try {
                try {
                    httpConnection.setRequestMethod(requestMethod);
                    httpConnection.connect();
                    if (!TextUtils.isEmpty((CharSequence)data)) {
                        byte[] buffer = data.getBytes();
                        OutputStream os = httpConnection.getOutputStream();
                        os.write(buffer, 0, buffer.length);
                        os.flush();
                    }
                    responseCode = httpConnection.getResponseCode();
                    LogUtils.logDebugO(true, "responseCode = " + responseCode + " url:" + url);
                    responseRes = InputStreamUtils.InputStreamTOString(httpConnection.getInputStream());
                    HttpURLConnectionUtils.handleCookie(mCtx, url, httpConnection.getHeaderFields());
                    LogUtils.logDebugO(true, "res:" + responseRes + " url:" + url);
                }
                catch (Exception e) {
                    LogUtils.oe("sendHttpRequest Exception", e);
                    e.printStackTrace();
                    result.setResult(responseRes);
                    result.setStatusCode(responseCode);
                    try {
                        httpConnection.disconnect();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                result.setResult(responseRes);
                result.setStatusCode(responseCode);
                try {
                    httpConnection.disconnect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            LogUtils.logErrorO("sendHttpRequest get HttpRequrstResult error!");
        }
        return result;
    }

    public static HttpRequrstResultVO sendHttpRequest(Context mCtx, WWidgetData wData, String url, List<NameValuePair> nameValuePairs, String requestMethod, String contentType) {
        LogUtils.logDebugO(true, "sendHttpRequest url:" + url);
        HttpURLConnection httpConnection = HttpURLConnectionUtils.getHttpURLConnection(mCtx, url, 30000, 30000);
        HttpRequrstResultVO result = new HttpRequrstResultVO();
        if (httpConnection != null) {
            HttpURLConnectionUtils.addHttpURLConnectionHeader(wData, httpConnection, url, contentType);
            String data = DataParserUtils.NameValuePairList2Sting(nameValuePairs);
            LogUtils.logDebugO(true, "httpRequest header:" + httpConnection.getRequestProperties().toString());
            LogUtils.logDebugO(true, "httpRequest data:" + data);
            String responseRes = "";
            int responseCode = -1;
            try {
                try {
                    httpConnection.setRequestMethod(requestMethod);
                    httpConnection.connect();
                    if ("application/x-www-form-urlencoded".equals(contentType)) {
                        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nameValuePairs, "UTF-8");
                        InputStream in = entity.getContent();
                        byte[] buffer = new byte[8192];
                        OutputStream os = httpConnection.getOutputStream();
                        int len = 0;
                        while ((len = in.read(buffer)) >= 0) {
                            os.write(buffer, 0, len);
                            os.flush();
                        }
                    } else if (!TextUtils.isEmpty((CharSequence)data)) {
                        byte[] buffer = data.getBytes();
                        OutputStream os = httpConnection.getOutputStream();
                        os.write(buffer, 0, buffer.length);
                        os.flush();
                    }
                    responseCode = httpConnection.getResponseCode();
                    LogUtils.logDebugO(true, "responseCode = " + responseCode + " url:" + url);
                    responseRes = InputStreamUtils.InputStreamTOString(httpConnection.getInputStream());
                    HttpURLConnectionUtils.handleCookie(mCtx, url, httpConnection.getHeaderFields());
                    LogUtils.logDebugO(true, "res:" + responseRes + " url:" + url);
                }
                catch (Exception e) {
                    LogUtils.oe("sendHttpRequest Exception", e);
                    e.printStackTrace();
                    result.setResult(responseRes);
                    result.setStatusCode(responseCode);
                    try {
                        httpConnection.disconnect();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                result.setResult(responseRes);
                result.setStatusCode(responseCode);
                try {
                    httpConnection.disconnect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            LogUtils.logErrorO("sendHttpRequest get HttpRequrstResult error!");
        }
        return result;
    }

    public static HttpRequrstResultVO sendHttpRequestByGet(Context ctx, WWidgetData mWData, String url) {
        return HttpURLConnectionUtils.sendHttpRequest(ctx, mWData, url, "", "GET", null);
    }

    public static HttpRequrstResultVO sendHttpRequestByGet(Context ctx, WWidgetData mWData, String url, String data, String contentType) {
        return HttpURLConnectionUtils.sendHttpRequest(ctx, mWData, url, data, "GET", contentType);
    }

    public static HttpRequrstResultVO sendHttpRequestByPost(Context ctx, WWidgetData mWData, String url, String data, String contentType) {
        return HttpURLConnectionUtils.sendHttpRequest(ctx, mWData, url, data, "POST", contentType);
    }

    public static HttpRequrstResultVO sendHttpRequestByPost(Context ctx, WWidgetData mWData, String url, List<NameValuePair> nameValuePairs, String contentType) {
        return HttpURLConnectionUtils.sendHttpRequest(ctx, mWData, url, nameValuePairs, "POST", contentType);
    }

    private static void handleCookie(Context context, String url, Map<String, List<String>> headers) {
        if (headers != null) {
            List<String> Cookie2;
            List<String> Cookie;
            List<String> setCookies2;
            List<String> setCookies = headers.get("Set-Cookie");
            if (setCookies != null) {
                for (String v : setCookies) {
                    HttpURLConnectionUtils.setCookie(context, url, v);
                }
            }
            if ((setCookies2 = headers.get("Set-Cookie2")) != null) {
                for (String v : setCookies2) {
                    HttpURLConnectionUtils.setCookie(context, url, v);
                }
            }
            if ((Cookie = headers.get("Cookie")) != null) {
                for (String v : Cookie) {
                    HttpURLConnectionUtils.setCookie(context, url, v);
                }
            }
            if ((Cookie2 = headers.get("Cookie2")) != null) {
                for (String v : Cookie2) {
                    HttpURLConnectionUtils.setCookie(context, url, v);
                }
            }
        }
    }

    private static final void setCookie(Context context, String inUrl, String cookie) {
        if (cookie == null) {
            return;
        }
        CookieManager.getInstance().setCookie(inUrl, cookie);
        CookieSyncManager.createInstance((Context)context);
        CookieSyncManager.getInstance().sync();
    }

    private static final String getCookie(String inUrl) {
        return CookieManager.getInstance().getCookie(inUrl);
    }

    public static HttpURLConnection getHttpURLConnection(Context context, String urlStr, int connectTimeout, int readTimeout) {
        URLConnection httpConnection = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)urlStr)) {
                URL url = new URL(HttpURLConnectionUtils.urlEncode(urlStr));
                if (urlStr.startsWith("http://")) {
                    httpConnection = (HttpURLConnection)url.openConnection();
                } else {
                    String psw = EUtil.getCertificatePsw((Context)context, (String)AppStoreUtils.getMainAppId(context));
                    httpConnection = Http.getHttpsURLConnectionWithCert(url, psw, "file:///android_asset/widget/wgtRes/clientCertificate.p12", context);
                }
            } else {
                LogUtils.logErrorO("getHttpConnection url is null!");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (httpConnection != null) {
            httpConnection.setReadTimeout(readTimeout);
            httpConnection.setConnectTimeout(connectTimeout);
        }
        return httpConnection;
    }

    public static HttpRequrstResultVO downLoadCategoryList(Context mContext, WWidgetData mWgtData) {
        JSONObject jsonParams = new JSONObject();
        HttpRequrstResultVO result = HttpURLConnectionUtils.downLoadAppList(mContext, mWgtData, HttpURLConnectionUtils.getUrlCategoryList(), jsonParams, "appTypeList");
        return result;
    }

    public static HttpRequrstResultVO downLoadAppList(String baseUrl, Context mContext, WWidgetData mWgtData, JSONObject params) {
        return HttpURLConnectionUtils.downLoadAppList(mContext, mWgtData, baseUrl, params, "appList");
    }

    public static HttpRequrstResultVO downLoadAppList(Context mContext, WWidgetData mWgtData, String baseUrl, JSONObject params, String key) {
        HttpRequrstResultVO requrstResult = new HttpRequrstResultVO();
        String keyValueStr = DataParserUtils.jsonToNameValueString(params);
        String url = baseUrl;
        if (!TextUtils.isEmpty((CharSequence)keyValueStr)) {
            url = String.valueOf(url) + "?" + keyValueStr;
        }
        requrstResult = HttpURLConnectionUtils.sendHttpRequestByGet(mContext, mWgtData, url);
        return requrstResult;
    }

    private static String urlEncode(String url) {
        return Uri.encode((String)url, (String)"/?:=&#@+$");
    }
}

