/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.view;

import android.content.Context;
import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.WrapperListAdapter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;

public class HeaderGridView
extends GridView {
    public static final String TAG = "HeaderGridView";
    private ArrayList<FixedViewInfo> mHeaderViewInfos = new ArrayList();
    private ListAdapter mWrapedAdapter;

    private void initHeaderGridView() {
        super.setClipChildren(false);
    }

    public HeaderGridView(Context context) {
        super(context);
        this.initHeaderGridView();
    }

    public HeaderGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initHeaderGridView();
    }

    public HeaderGridView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initHeaderGridView();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        ListAdapter adapter = this.getAdapter();
        if (adapter != null && adapter instanceof HeaderViewGridAdapter) {
            ((HeaderViewGridAdapter)adapter).setNumColumns(this.getNumColumns());
        }
    }

    public void setClipChildren(boolean clipChildren) {
    }

    public void addHeaderView(View v, Object data, boolean isSelectable) {
        ListAdapter adapter = this.getAdapter();
        if (adapter != null && !(adapter instanceof HeaderViewGridAdapter)) {
            throw new IllegalStateException("Cannot add header view to grid -- setAdapter has already been called.");
        }
        FixedViewInfo info = new FixedViewInfo();
        FullWidthFixedViewLayout fl = new FullWidthFixedViewLayout(this.getContext());
        fl.addView(v);
        info.view = v;
        info.viewContainer = fl;
        info.data = data;
        info.isSelectable = isSelectable;
        this.mHeaderViewInfos.add(info);
        if (adapter != null) {
            ((HeaderViewGridAdapter)adapter).notifyDataSetChanged();
        }
    }

    public void addHeaderView(View v) {
        this.addHeaderView(v, null, true);
    }

    public int getHeaderViewCount() {
        return this.mHeaderViewInfos.size();
    }

    public boolean removeHeaderView(View v) {
        if (this.mHeaderViewInfos.size() > 0) {
            boolean result = false;
            ListAdapter adapter = this.getAdapter();
            if (adapter != null && ((HeaderViewGridAdapter)adapter).removeHeader(v)) {
                result = true;
            }
            this.removeFixedViewInfo(v, this.mHeaderViewInfos);
            return result;
        }
        return false;
    }

    private void removeFixedViewInfo(View v, ArrayList<FixedViewInfo> where) {
        int len = where.size();
        int i = 0;
        while (i < len) {
            FixedViewInfo info = where.get(i);
            if (info.view == v) {
                where.remove(i);
                break;
            }
            ++i;
        }
    }

    public void setAdapter(ListAdapter adapter) {
        this.setWrapedAdapter(adapter);
        if (this.mHeaderViewInfos.size() > 0) {
            HeaderViewGridAdapter hadapter = new HeaderViewGridAdapter(this.mHeaderViewInfos, adapter);
            int numColumns = this.getNumColumns();
            if (numColumns > 1) {
                hadapter.setNumColumns(numColumns);
            }
            super.setAdapter((ListAdapter)hadapter);
        } else {
            super.setAdapter(adapter);
        }
    }

    public int getNumColumns() {
        int numColumns = 0;
        int version = Build.VERSION.SDK_INT;
        if (version < 11) {
            try {
                Field mNumColumnsField = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("mNumColumns");
                mNumColumnsField.setAccessible(true);
                numColumns = mNumColumnsField.getInt((Object)this);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        } else {
            numColumns = super.getNumColumns();
        }
        return numColumns;
    }

    private void setWrapedAdapter(ListAdapter adapter) {
        this.mWrapedAdapter = adapter;
    }

    public ListAdapter getWrapedAdapter() {
        return this.mWrapedAdapter;
    }

    public int getHeaderViewGridCount() {
        HeaderViewGridAdapter headerGridAdapter = (HeaderViewGridAdapter)this.getAdapter();
        return headerGridAdapter != null ? headerGridAdapter.getHeadersGridCount() : 0;
    }

    public View getGridChildAt(int position) {
        LogUtils.i(TAG, "getGridChildAt: " + this.getHeaderViewGridCount() + " " + position);
        return this.getChildAt(this.getHeaderViewGridCount() + position);
    }

    private static class FixedViewInfo {
        public View view;
        public ViewGroup viewContainer;
        public Object data;
        public boolean isSelectable;

        private FixedViewInfo() {
        }
    }

    private class FullWidthFixedViewLayout
    extends FrameLayout {
        public FullWidthFixedViewLayout(Context context) {
            super(context);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int targetWidth = HeaderGridView.this.getMeasuredWidth() - HeaderGridView.this.getPaddingLeft() - HeaderGridView.this.getPaddingRight();
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)targetWidth, (int)View.MeasureSpec.getMode((int)widthMeasureSpec));
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private static class HeaderViewGridAdapter
    implements WrapperListAdapter,
    Filterable {
        private final DataSetObservable mDataSetObservable = new DataSetObservable();
        private final ListAdapter mAdapter;
        private int mNumColumns = 1;
        ArrayList<FixedViewInfo> mHeaderViewInfos;
        boolean mAreAllFixedViewsSelectable;
        private final boolean mIsFilterable;

        public HeaderViewGridAdapter(ArrayList<FixedViewInfo> headerViewInfos, ListAdapter adapter) {
            this.mAdapter = adapter;
            this.mIsFilterable = adapter instanceof Filterable;
            if (headerViewInfos == null) {
                throw new IllegalArgumentException("headerViewInfos cannot be null");
            }
            this.mHeaderViewInfos = headerViewInfos;
            this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos);
        }

        public int getHeadersCount() {
            return this.mHeaderViewInfos.size();
        }

        public int getHeadersGridCount() {
            return this.mHeaderViewInfos.size() * this.mNumColumns;
        }

        public boolean isEmpty() {
            return (this.mAdapter == null || this.mAdapter.isEmpty()) && this.getHeadersCount() == 0;
        }

        public void setNumColumns(int numColumns) {
            if (numColumns < 1) {
                throw new IllegalArgumentException("Number of columns must be 1 or more");
            }
            if (this.mNumColumns != numColumns) {
                this.mNumColumns = numColumns;
                this.notifyDataSetChanged();
            }
        }

        private boolean areAllListInfosSelectable(ArrayList<FixedViewInfo> infos) {
            if (infos != null) {
                for (FixedViewInfo info : infos) {
                    if (info.isSelectable) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean removeHeader(View v) {
            int i = 0;
            while (i < this.mHeaderViewInfos.size()) {
                FixedViewInfo info = this.mHeaderViewInfos.get(i);
                if (info.view == v) {
                    this.mHeaderViewInfos.remove(i);
                    this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos);
                    this.mDataSetObservable.notifyChanged();
                    return true;
                }
                ++i;
            }
            return false;
        }

        public int getCount() {
            int count = 0;
            count = this.mAdapter != null ? this.getHeadersCount() * this.mNumColumns + this.mAdapter.getCount() : this.getHeadersCount() * this.mNumColumns;
            return count;
        }

        public boolean areAllItemsEnabled() {
            if (this.mAdapter != null) {
                return this.mAreAllFixedViewsSelectable && this.mAdapter.areAllItemsEnabled();
            }
            return true;
        }

        public boolean isEnabled(int position) {
            int numHeadersAndPlaceholders = this.getHeadersCount() * this.mNumColumns;
            if (position < numHeadersAndPlaceholders) {
                return position % this.mNumColumns == 0 && this.mHeaderViewInfos.get((int)(position / this.mNumColumns)).isSelectable;
            }
            int adjPosition = position - numHeadersAndPlaceholders;
            int adapterCount = 0;
            if (this.mAdapter != null && adjPosition < (adapterCount = this.mAdapter.getCount())) {
                return this.mAdapter.isEnabled(adjPosition);
            }
            throw new ArrayIndexOutOfBoundsException(position);
        }

        public Object getItem(int position) {
            int numHeadersAndPlaceholders = this.getHeadersCount() * this.mNumColumns;
            if (position < numHeadersAndPlaceholders) {
                if (position % this.mNumColumns == 0) {
                    return this.mHeaderViewInfos.get((int)(position / this.mNumColumns)).data;
                }
                return null;
            }
            int adjPosition = position - numHeadersAndPlaceholders;
            int adapterCount = 0;
            if (this.mAdapter != null && adjPosition < (adapterCount = this.mAdapter.getCount())) {
                return this.mAdapter.getItem(adjPosition);
            }
            throw new ArrayIndexOutOfBoundsException(position);
        }

        public long getItemId(int position) {
            int adapterCount;
            int adjPosition;
            int numHeadersAndPlaceholders = this.getHeadersCount() * this.mNumColumns;
            if (this.mAdapter != null && position >= numHeadersAndPlaceholders && (adjPosition = position - numHeadersAndPlaceholders) < (adapterCount = this.mAdapter.getCount())) {
                return this.mAdapter.getItemId(adjPosition);
            }
            return -1L;
        }

        public boolean hasStableIds() {
            if (this.mAdapter != null) {
                return this.mAdapter.hasStableIds();
            }
            return false;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            int numHeadersAndPlaceholders = this.getHeadersCount() * this.mNumColumns;
            if (position < numHeadersAndPlaceholders) {
                ViewGroup headerViewContainer = this.mHeaderViewInfos.get((int)(position / this.mNumColumns)).viewContainer;
                if (position % this.mNumColumns == 0) {
                    return headerViewContainer;
                }
                if (convertView == null) {
                    convertView = new View(parent.getContext());
                }
                convertView.setVisibility(4);
                convertView.setMinimumHeight(headerViewContainer.getHeight());
                return convertView;
            }
            int adjPosition = position - numHeadersAndPlaceholders;
            int adapterCount = 0;
            if (this.mAdapter != null && adjPosition < (adapterCount = this.mAdapter.getCount())) {
                return this.mAdapter.getView(adjPosition, convertView, parent);
            }
            throw new ArrayIndexOutOfBoundsException(position);
        }

        public int getItemViewType(int position) {
            int adapterCount;
            int adjPosition;
            int numHeadersAndPlaceholders = this.getHeadersCount() * this.mNumColumns;
            if (position < numHeadersAndPlaceholders && position % this.mNumColumns != 0) {
                return this.mAdapter != null ? this.mAdapter.getViewTypeCount() : 1;
            }
            if (this.mAdapter != null && position >= numHeadersAndPlaceholders && (adjPosition = position - numHeadersAndPlaceholders) < (adapterCount = this.mAdapter.getCount())) {
                return this.mAdapter.getItemViewType(adjPosition);
            }
            return -2;
        }

        public int getViewTypeCount() {
            if (this.mAdapter != null) {
                return this.mAdapter.getViewTypeCount() + 1;
            }
            return 2;
        }

        public void registerDataSetObserver(DataSetObserver observer) {
            this.mDataSetObservable.registerObserver((Object)observer);
            if (this.mAdapter != null) {
                this.mAdapter.registerDataSetObserver(observer);
            }
        }

        public void unregisterDataSetObserver(DataSetObserver observer) {
            this.mDataSetObservable.unregisterObserver((Object)observer);
            if (this.mAdapter != null) {
                this.mAdapter.unregisterDataSetObserver(observer);
            }
        }

        public Filter getFilter() {
            if (this.mIsFilterable) {
                return ((Filterable)this.mAdapter).getFilter();
            }
            return null;
        }

        public ListAdapter getWrappedAdapter() {
            return this.mAdapter;
        }

        public void notifyDataSetChanged() {
            this.mDataSetObservable.notifyChanged();
        }
    }
}

